
<?php $__env->startSection('title','Bundle List | Mini Opex'); ?>
<?php $__env->startSection('add_css'); ?>
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="modal fade" id="adjustModal" tabindex="-1" role="dialog" aria-labelledby="adjustModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="adjustModalLabel">Cancellation</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" id="closebtn">
                    <span aria-hidden="true" >&times;</span>
                </button>
            </div>
            <form  id="item_adjust">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group " id="comment_div">
                        <label for="text-input" class=" form-control-label">Reason </label>
                        <textarea class="form-control" id="comments" name="comments" required></textarea>
                    </div>
                    
                    
                    
                    
                    <div class="form-group">
                        <div class="form-check" id="issued_div">
                            <div class="checkbox">
                                <label for="issued_po" class="form-check-label ">
                                    <input type="checkbox" id="issued_po" name="issued_po" value="YES" class="form-check-input"> PO Issued
                                </label>
                            </div>
                        </div>
                        
                        <div class="form-check" id="supplier_div">
                            <div class="checkbox">
                                <label for="supplier_order" class="form-check-label ">
                                    <input type="checkbox" id="supplier_order" name="supplier_order" value="YES" class="form-check-input">Cancel Supplier Orders
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group" id="given_div" style="display:none;">
                        <label for="text-input" class=" form-control-label">Given Qty </label>
                        <input type="number" class="form-control" id="new_given_qty" name="new_given_qty" pattern="^[0-9]*$" min="1"/>
                    </div>
                </div>
                
                
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" id="adjustBtn">Cancelled</button>
                
                </div>
            </form>
        </div>
    </div>
</div>
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Bundle </strong> List
                            <button type="button" id="export_excel" class="float-right btn btn-info btn-sm ml-1" style="display:none"><i class="fas fa-file-pdf"></i> Update Quantity</button>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('process-cancel')): ?>
                            <button type="button" id="cancellation_btn" class="btn btn-danger btn-sm ml-5" style="display:none"><i class="fas fa-close"></i> Cancellation</button>
                            <?php endif; ?>
                        </div>
                        <div class="card-body card-block">
                            <?php if(session('has_error')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session('has_error')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('has_success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('has_success')); ?>

                                </div>
                            <?php endif; ?>
                            <form id="pick_pdf" method="post" action="<?php echo e(route('shipment.picklist.pdf')); ?>" >
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id_list" id="id_list" />
                                <input type="hidden" name="store_id2" id="store_id2" />
                                <input type="hidden" name="shipment_type2" id="shipment_type2" />
                                
                            </form>
                            <div class="container custom_filter bg-light pt-3 pb-2 border  rounded mb-2">
                                <div class="row">
                                    <div class="col-12 col-md-6">
                                        <select name="store" id="store_id" class="form-control select2">
                                            <option value="">Select Store</option>
                                            <?php $__empty_1 = true; $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <option value="<?php echo e($store->id); ?>"><?php echo e($store->strong_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <select name="shipment_type" id="shipment_type" class="form-control select2">
                                            <option value="">Select Type</option>
                                            <option value="1">Air Cargo</option>
                                            <option value="2">Sea Cargo</option>
                                        </select>
                                    </div>
                                    
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" id="posts" cellspacing="0" width="100%">
                                    <thead>
                                        <tr class="thead-light">
                                            <th colspan="2" class="text-right">Total</th>
                                            <th id="instock_qty">0</th>
                                            <th colspan="2" id="approve_qty">0</th>
                                        </tr>
                                        <tr class="thead-dark">
                                            <th>Bundle Image</th>
                                            <th>Bundle Name</th>
                                            <th>Instock</th>
                                            <th>Approve QTY</th>
                                            <th>Supply QTY</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr class="thead-light">
                                            <th colspan="2" class="text-right">Total</th>
                                            <th>0</th>
                                            <th colspan="2">0</th>
                                        </tr>
                                       
                                    </tfoot>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>
<script>
     $('.single_image').featherlight({type: 'image',targetAttr: 'href'});
    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        "dataSrc": "",
        "ajax":{
                    "url": "<?php echo e(route('shipment.bundle.list')); ?>",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){ 
                        d._token= "<?php echo e(csrf_token()); ?>";
                        d.store= $('#store_id option:selected').val();
                        d.shipment_type=$('#shipment_type option:selected').val();
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [0,4] },
            { "searchable": false, "targets": [0,2] },
        ],
        "order": [[ 1, "desc" ]],
        bSort: false,
        "ordering": false,
        "columns":[
            { "data": "bundleImage","name":"bundleImage" },
            { "data": "bundleDetail","name":"bundleDetail" },
            { "data": "instock","name":"instock" },
            { "data": "orderqty","name":"orderqty" },
            { "data": "supply_qty","name":"supply_qty" },
            
            
        ],
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
 
            
 
            // converting to interger to find total
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            
                    
            var wedTotal = api
                .column( 2 )
                .data()
                .reduce( function (a, b) {
                    b = b.replace(/<\/?[^>]+(>|$)/g, "").split('Total InStock : ')[1];
                    // console.log(b);
                    return intVal(a) + intVal(b);
                }, 0 );
                
            var wedTotal1 = api
                .column( 2 )
                .data()
                .reduce( function (a, b) {
                    b = b.split('<hr>')[0];
                    b = b.replace(/<\/?[^>]+(>|$)/g, "").split('Available Bundle : ')[1];
                    console.log(b);
                    return intVal(a) + intVal(b);
                }, 0 );
                    
            var thuTotal = api
                .column( 3 )
                .data()
                .reduce( function (a, b) {
                    b = b.replace(/<\/?[^>]+(>|$)/g, "").split('Out from InStock : ')[1];
                    // b = b.replace('Order QTY : ', "");
                    console.log(b);
                    return intVal(a) + intVal(b);
                }, 0 );
                
                var thuTotal1 = api
                .column( 3 )
                .data()
                .reduce( function (a, b) {
                    b = b.split('<hr>')[0];
                    b = b.replace(/<\/?[^>]+(>|$)/g, "").split('Order Quantity : ')[1];
                    console.log(b);
                    return intVal(a) + intVal(b);
                }, 0 );
                
                var new_instock='Stock : '+wedTotal+' | Avg Bundle : '+wedTotal1;
                var new_approve='Out of Stock : '+thuTotal+' | Order QTY : '+thuTotal1;
                
                //Update footer by showing the total with the reference of the column index 
                $( api.column( 1 ).footer() ).html('Total');
                $('#instock_qty').text(new_instock);
                $('#approve_qty').text(new_approve);
                $( api.column( 2 ).footer() ).html(new_instock);
                $( api.column( 3 ).footer() ).html(new_approve);
        },
    });
    
    $('.select2').on('change',function(){
        var id=$(this).attr('id');
        // if($('#store_id option:selected').val() !='' && $('#shipment_type  option:selected').val() !=''){
            
        //     $('#export_excel').show();
        // }else{
        //     $('#export_excel').hide();
        // }
        $('#'+id+'2').val($('#'+id +' option:selected').val());
        $('#posts').DataTable().ajax.reload().draw();
    })
    
    $('#posts').on('input','tbody .supply_qty',function(){
      var id=$(this).attr('data-id');
      var val=parseInt($('#supply_qty_'+id).val().trim());
      var instock=parseInt($('#avail_'+id).text());
      var order_qty=parseInt($('#outstock_'+id).text());
      console.log(instock);
      if(!/^[0-9]+$/.test(val) || val ==0){
          
            $('#error_'+id).text('Receive Quantity Only Numbers And Not Equal to "0"');
            $('#error_'+id).show();
            $.toast({
                heading: 'Error',
                text: 'Receive Quantity Only Numbers And Not Equal to "0"',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });  
            $('#id_check_'+id).prop('checked',false);
            $('#export_excel').hide();
      }else if(val !=''){
          if(val<=instock && val <= order_qty){
              $('#error_'+id).hide();
              $('#id_check_'+id).prop('checked','checked');
              $('#export_excel').show();
          }else{
            $('#error_'+id).text('Receive Quantity Exceeded');
            $('#error_'+id).show();
            $.toast({
                heading: 'Error',
                text: 'Receive Quantity Exceeded',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            $('#id_check_'+id).prop('checked',false);
            $('#export_excel').hide();
          }
      }else{
         $('#error_'+id).hide(); 
      }
    });
    
    $('#export_excel').click(function(){
        var reqSupplier=$('.id_check').filter(':checked').length;
        if(reqSupplier ==0){
            return; 
        }
        
        var obj= {};
        var array=[];
        var id;
        var input_id=[];
        var value = $('.id_check').filter(':checked').filter(function () {
            id=$(this).attr('id').split("_")[2];
            input_id.push(id);
            console.log(id);
            
            obj.supply_qty=$('#supply_qty_'+id).val();
            obj.pr_id=$('#pr_id_'+id).val();
            obj.store_id=$('#store_id option:selected').val();
            obj.shipment_type=$('#shipment_type  option:selected').val();
            obj.order_qty=$('#outstock_'+id).text();
            obj.bundle_set_variation=$(this).val();
            obj.id=id;
            
            if(!/^[0-9]+$/.test($('#supply_qty_'+id).val()) || $('#supply_qty_'+id).val() ==0){
                $('#error_'+id).text('Receive Quantity Only Numbers And Not Equal to "0"');
                $('#error_'+id).show();
                $.toast({
                    heading: 'Error',
                    text: 'Receive Quantity Only Numbers And Not Equal to "0"',
                    showHideTransition: 'slide',
                    icon: 'error',
                    position: 'top-right',
                });  
                $('#id_check_'+id).prop('checked',false);
                array=[];
                obj={};
                return false;
            }else{
                array.push(obj);
                obj={};
            }

            
        });
        
        if(array.length !=0){
            $('#id_list').val(input_id.join(','));
            $.ajax({
                url:"<?php echo e(route('add.bundle.processed')); ?>",
                type:'POST',
                data:{
                    _token:"<?php echo e(csrf_token()); ?>",
                    array:array,
                },
                dataType:'JSON',
                success:function(data){
                    if(data.success){
                        $.toast({
                            heading: 'Success',
                            text: 'Bundle Processed Successfully',
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-right',
                        });
                        
                        $('#posts').DataTable().ajax.reload().draw();
                        // $('#pick_pdf').submit();
                        
                    }
                }
            })    
        }
        
    });
    
    $(document).on('change','.id_check2',function(){
       var self=$(this);
       var checked=self.filter(":checked").length;
        //   alert(self);
       
       if(checked>0){
           $('#cancellation_btn').show();
       }else{
           $('#cancellation_btn').hide();
       }
    });
    
    $('#cancellation_btn').click(function(){
        var self=$(this);
        if(confirm('Are you sure Want to Cancel ?')){
            $('#item_adjust').trigger("reset");
            $('#adjustModal').modal('show');
        }
    });
    
    $('#issued_po').click(function(){
        var self=$(this);
        if(self.is(':checked')){
            $('#given_div').show();
        }else{
            $('#given_div').hide();
        }
    })
    
    $('#item_adjust').on('submit',function(e){
        
        
        e.preventDefault();
        var formdata=$(this).serializeArray();
        
        var obj= {};
        var array=[];
        $('.id_check2').filter(':checked').filter(function(){
            var idSelf=$(this);
            
            obj.id=idSelf.data('id');
            obj.store_id=$('#store_id option:selected').val();
            obj.shipment_type=$('#shipment_type  option:selected').val();
            obj.variation_design=idSelf.val();
            obj.given_qty=idSelf.data('given_qty');
            obj.var_list=$('#bun_'+idSelf.val()).data('stock_bundle');
            
            array.push(obj);
            obj={};
        });
        formdata.push({ name: "variation_list", value: JSON.stringify(array) });
        
        console.log(formdata);
        
        $.ajax({
            url:"<?php echo e(route('shipment.cancel.bundle')); ?>",
            data:formdata,
            type:'POST',
            dataType:'JSON',
            success:function(data){
                if(data.code='200'){
                    $.toast({
                        heading: 'Success',
                        text: 'Product Cancelled Successfully',
                        showHideTransition: 'slide',
                        icon: 'success',
                        position: 'top-center',
                    });
                    $('#adjustModal').modal('hide');
                    $('#item_adjust').trigger("reset");
                    $('#cancellation_btn').hide();
                    $('#date_check').prop('checked',false);
                    $('#posts').DataTable().ajax.reload().draw();
                }
            }
        })
    });
</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/sampmini/resources/views/process_order/bundle_list.blade.php ENDPATH**/ ?>