
<?php $__env->startSection('title','Items Log | Mini Opex'); ?>
<?php $__env->startSection('add_css'); ?>
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Items Log </strong> List
                            
                        </div>
                        <div class="card-body card-block">
                            <?php if(session('has_error')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session('has_error')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('has_success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('has_success')); ?>

                                </div>
                            <?php endif; ?>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" id="posts" cellspacing="0" width="100%">
                                    <thead class="table-dark" style="color: white">
                                        <tr>
                                            <th>ID</th>
                                            <th>Product Detail</th>
                                            <th>Quantity</th>
                                            <th>Type Name</th>
                                            <th>Supplier Name</th>
                                            <th>Created By</th>
                                            <th>Created Date</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>
<script>
     $('.single_image').featherlight({type: 'image',targetAttr: 'href'});
    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        "dataSrc": "",
        "ajax":{
                    "url": "<?php echo e(route('log.item')); ?>",
                //  "dataType": "json",
                    "type": "POST",
                    "data":{ _token: "<?php echo e(csrf_token()); ?>"}
                },
        "columnDefs": [
            { "orderable": false, "targets": [] },
        ],
        "order": [[ 0, "desc" ]],
        bSort: false,
        "ordering": true,
        "columns":[
            { "data": "id","name":"item_log.id" },
            { "data": "productDetail","name":"productDetail" },
            { "data": "given_qty","name":"item_log.given_qty" },
            { "data": "type_name","name":"item_log.type_name" },
            { "data": "supplier_name","name":"supplier_name" },
            { "data": "name","name":"name" },
            { "data": "created_at","name":"created_at" },
            
        ],
        createdRow: (row, data, dataIndex, cells) => {
            $(cells[3]).html('<span class="text-primary text-sm">'+data.type_name+'</span>')
        },
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
    });
</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/sampmini/resources/views/log/index.blade.php ENDPATH**/ ?>