<!DOCTYPE html>
<html lang="en">
<head>
    <title>Gate Pass | Mini Opex</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="<?php echo e(asset('backend/vendor/bootstrap-4.1/bootstrap.min.css')); ?>" rel="stylesheet" media="all">
    <!-- Jquery JS-->
    <script src="<?php echo e(asset('backend/vendor/jquery-3.2.1.min.js')); ?>"></script>
    <!-- Bootstrap JS-->
    <script src="<?php echo e(asset('backend/vendor/bootstrap-4.1/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/vendor/bootstrap-4.1/bootstrap.min.js')); ?>"></script>
</head>
<body>
  
<div class="container">
  <h1>Gate Pass | Mini Opex</h1>
  <p>
      <span class="text-success">Supplier Name : <strong><?php echo e($supplier_name); ?></strong></span><br>
      <span class="text-dark">Report Date : <strong><?php echo e(date('d-m-Y')); ?></strong></span><br>
      <span class="text-danger">Report : <strong><?php echo e(date('d-F-Y',strtotime($start_date))); ?></strong> - <strong><?php echo e(date('d-F-Y',strtotime($end_date))); ?></strong></span><br>
      <span class="text-dark">Serial No : <strong><?php echo e($gate_pass_serial); ?></strong></span>
  </p>
</div>

<div class="table-responsive">
  <table class="table table-bordered table-striped">
        <thead class="thead-dark">
            <tr>
                <th>PR#</th>
                <th>Product Image</th>
                <th>Product Detail</th>
                <th>Receive QTY</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($record->pr_id); ?></td>
                    <td>
                        <?php if($record->product_url !=''): ?>
                            <img src="<?php echo e($record->product_url); ?>" class="rounded" alt="Cinque Terre" width="100" height="100">
                        <?php else: ?>
                            <img src="<?php echo e(asset('uploads/sku_images/'.$record->prod_img)); ?>" class="rounded" alt="Cinque Terre" width="100" height="100">
                        <?php endif; ?>
                    </td>
                    <td>
                        
                        <span class="text-success"><?php echo e($record->product_name); ?></span><br>
                        <span class="text-primary text-sm-left">SKU : <strong><?php echo e($record->variation_id); ?></strong></span><br>
                        <span class="text-info text-sm-left">Size : <strong><?php echo e($record->size); ?></strong></span>
                            
                    </td>
                    <td><?php echo e($record->receive_qtn); ?></td>
                    <td><?php echo e(date('d-F-Y',strtotime($record->created_date))); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5" class="text-center">No Record Found</td>
                </tr>
            <?php endif; ?>
        </tbody>
  </table>
</div>

</body>
</html>
<?php /**PATH /home/esireops/public_html/miniopextest/resources/views/pdf/gate_pass.blade.php ENDPATH**/ ?>