
<?php $__env->startSection('title','Supplier | Mini Opex'); ?>

<?php $__env->startSection('content'); ?>
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Update Supplier</strong> form
                        </div>
                        <div class="card-body card-block">
                            <?php if(session('has_error')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session('has_error')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('has_success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('has_success')); ?>

                                </div>
                            <?php endif; ?>
                            <form action="<?php echo e(route('supplier.edit',$supplier->id)); ?>" method="post" enctype="multipart/form-data" class="form-horizontal" id="form_id">
                                <?php echo csrf_field(); ?>
                                <div class="row form-group ">
                                    <div class="col col-md-3">
                                        <label for="text-input" class=" form-control-label">Supplier Name </label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <input type="text" id="supplier_name" name="supplier_name" value="<?php echo e($supplier->supplier_name); ?>" placeholder="add new supplier" class="form-control">
                                    </div>
                                </div>

                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="text-input" class=" form-control-label">Username </label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <input type="text" id="username" name="username" value="<?php echo e($supplier->username); ?>" placeholder="enter username" class="form-control">
                                        <span id="unameerror" class="text-danger" style="display: none">Username Already Exists</span>
                                    </div>
                                </div>
                                <div class="row form-group ">
                                    <div class="col col-md-3">
                                        <label for="contact_number" class=" form-control-label">Contact Number </label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <input type="text" id="contact_number" name="contact_number" value="<?php echo e($supplier->supplier_contact); ?>" placeholder="contact number " class="form-control">
                                    </div>
                                </div>
                                <div class="row form-group ">
                                    <div class="col col-md-3">
                                        <label for="supplier_email" class=" form-control-label">Supplier Email </label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <input type="email" id="supplier_email" name="supplier_email" value="<?php echo e($supplier->supplier_email); ?>" placeholder="supplier email" class="form-control">
                                    </div>
                                </div>
                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="text-input" class=" form-control-label">Address </label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <textarea name="supplier_address" id="supplier_address" rows="3" placeholder="Supplier address" class="form-control"><?php echo e($supplier->address); ?></textarea>
                                        
                                    </div>
                                </div>
                                
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary btn-sm">
                                    <i class="fa fa-dot-circle-o"></i> Submit
                                </button>
                                <button type="reset" class="btn btn-danger btn-sm">
                                     <i class="fa fa-ban"></i> Reset
                                </button>
                            </form>
                            </div>
                    </div>
                    
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<script src="<?php echo e(asset('backend/js/jquery.validate.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/js/additional-methods.min.js')); ?>"></script>


<script>
    $(document).ready(function() {
        

        $('#form_id').validate({
            errorClass:'text-danger',
            success:'text-success',
            rules:{
                supplier_name: {
                    required: true
                },
                username:{
                    required:true,
                },
                supplier_address:{
                    required:true
                },
                contact_number:{
                    required:true,
                    phone_number:true,
                },
                supplier_email:{
                    required:true,
                    email: true
                },
                password:{
                    required:true,
                    minlength:6
                },
                
                
            },
            messages:{
                supplier_name:{
                    required:"Supplier Name is required"
                },
                username:{
                    required:"Username is required",
                },
                supplier_address:{
                    required:"Supplier address is required"
                },
                contact_number:{
                    required:"Contact Number is required",
                    phone_number:"Please Enter Valid Phone Number"
                },
                supplier_email:{
                    required:"Supplier email is required",
                    email: "Email is not in good formate"
                },
                password:{
                    required:"password is required",
                    minlength:"Password length must be 6 to 8"
                },
                
            },
            highlight: function(element, errorClass, validClass) {
                $(element).closest('.form-control').addClass('has-warning');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).closest('.form-group').removeClass('has-error');
            },
            errorPlacement: function (error, element) {
                
                if(element.hasClass('select2') && element.next('.select2-container').length) {
                    error.insertAfter(element.next('.select2-container'));
                }else if(element.hasClass('radio') && element.next('label .form-check-label').length) {
                    error.insertAfter(element.next('label .form-check-label'));
                }else{
                    error.insertAfter(element);
                }
            },
            submitHandler: function (form) {
                console.log("Submitted!");
                form.submit();
            }

        });
        $.validator.addMethod('phone_number', function (value) { 
            return /^[\d\(\)\-+]+$/m.test(value); 
        }, 'Please Enter valid Phone Number');

        $('#username').blur(function(){
            var val=$('#username').val();
            if(val !=''){
                $.ajax({
                    url:"<?php echo e(route('supplier.check_username')); ?>",
                    type:'POST',
                    dataType: "html",
                    data:{
                        _token: "<?php echo e(csrf_token()); ?>",
                        username:val
                    },
                    success:function(data){
                        console.log(data);
                        if(data ==1){
                            $('#unameerror').show();
                            $('#submitbtn').hide();
                        }else{
                            $('#unameerror').hide();
                            $('#submitbtn').show();
                        }
                    }
                });
            }
        })

        $.validator.addMethod(
            "checkImageRadio", 
            function(value, element) {
                var val=$('.image_option').val();
                if(val=='image_upload'){
                    var fileName=document.getElementById("file-input");
                    var allowed_extensions = new Array("jpg","png","gif");
                    var file_extension = fileName.split('.').pop().toLowerCase();
                    if(document.getElementById("file-input").files.length == 0){
                        return false;
                    }
                    for(var i = 0; i <= allowed_extensions.length; i++){
                        if(allowed_extensions[i]==file_extension){
                            return true; // valid file extension
                        }
                    }
                    return false;
                }
            },
            "This field is required"
        );


    });
</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/miniopexpro/resources/views/supplier/edit.blade.php ENDPATH**/ ?>