
<?php $__env->startSection('title','Excel List | Mini Opex'); ?>
<?php $__env->startSection('add_css'); ?>
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Uploaded Excel </strong> List
                            
                        </div>
                        <div class="card-body card-block">
                            <?php if(session('has_error')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session('has_error')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('has_success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('has_success')); ?>

                                </div>
                            <?php endif; ?>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped table-earning" id="posts" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>File Name</th>
                                        <th>Type Name</th>
                                        <th>Uploaded Date</th>
                                        <th>Upload By</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                            </table>
                            </div>
                            
                    </div>
                    
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script>
    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "dataSrc": "",
        "ajax":{
                    "url": "<?php echo e(route('list.excel')); ?>",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){ 
                        d._token= "<?php echo e(csrf_token()); ?>";
                        d.type=$('#type option:selected').val();
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [5] },
        ],
        bSort: false,
        "ordering": true,
        "columns":[
            { "data": "id","name":"upload_excel.id" },
            { "data": "original_name","name":"upload_excel.original_name" },
            { "data": "type_name","name":"upload_excel.type_name" },
            { "data": "created_at","name":"created_at" },
            { "data": "name","name":"users.name" },
            { "data": "action","name":"action" },
        ],
        initComplete: function () {
            $('#posts_filter input').addClass('form-control-sm');
            $("#posts_filter").append(`
                <select class="float-right form-control-sm ml-1" name="type" id="type">
                    <option value="">Select Type</option>
                    <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key->type); ?>"><?php echo e($key->type_name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            `);
            
        },
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
    });

    $('#posts_filter').on('change','#type',function(e){
        e.preventDefault();
        $('#posts').DataTable().ajax.reload().draw();
    })
</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/testapp/sampmini/resources/views/upload_excel/index.blade.php ENDPATH**/ ?>