
<?php $__env->startSection('title','Sale Order | Mini Opex'); ?>
<?php $__env->startSection('add_css'); ?>
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <h3 class="title-5 m-b-35"><strong>Sale Orders</strong></h3>
            <?php if(session('has_error')): ?>
                <div class="alert alert-danger" role="alert">
                    <?php echo e(session('has_error')); ?>

                </div>
            <?php endif; ?>
            <?php if(session('has_success')): ?>
                <div class="alert alert-success" role="alert">
                    <?php echo e(session('has_success')); ?>

                </div>
            <?php endif; ?>
            <div class="row">
                <div class="col-lg-3 col-sm-3 col-md-3 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Sale Orders </strong> Upload
                        </div>
                        <div class="card-body card-block">
                            <form enctype="multipart/form-data" method="post" id="form_id" class="text-sm">
                                <div class="row form-group">
                                    <div class="col-4 col-md-4 col-sm-4 col-lg-4">
                                        <label for="file_upload" class=" form-control-label text-info text-sm">Upload Excel</label>
                                    </div>
                                    <div class="col-12 col-md-8 ">
                                        <input type="file" id="file_upload" name="file_upload"  placeholder="add new role" class="form-control form-control-sm mt-2" onchange="ValidateSingleInput(this)">
                                        <span class="text-danger text-sm" id="errortxt" style="display: none">Please Upload file in correct format eg excel</span>
                                        
                                    </div>
                                </div>
                                <div class="row form-group">
                                    <div class="col-4 col-md-4 col-sm-4 col-lg-4">
                                        <label for="store_selection" class=" form-control-label text-info">Store Selection</label>
                                    </div>
                                    <div class="col-12 col-md-8 mt-2">
                                        <select name="store_selection" id="store_selection" class="form-control select2">
                                            <option value="">Please select</option>
                                            <?php $__empty_1 = true; $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <option value="<?php echo e($store->id); ?>"><?php echo e($store->strong_name); ?></option> 
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="row form-group">
                                    <div class="col-4 col-md-4 col-sm-4 col-lg-4">
                                        <label class=" form-control-label text-info">Cargo Selection</label>
                                    </div>
                                    <div class="col-12 col-md-8">
                                        <div class="form-check">
                                            <div class="radio">
                                                <label for="air_cargo" class="form-check-label ">
                                                    <input type="radio" id="air_cargo" name="cargo_select" value="1" class="form-check-input form-control-sm cargo_select">Air Cargo
                                                </label>
                                            </div>
                                            <div class="radio">
                                                <label for="ship_cargo" class="form-check-label ">
                                                     <input type="radio" id="ship_cargo" name="cargo_select" value="2" class="form-check-input form-control-sm  cargo_select">Ship Cargo
                                                </label>
                                                
                                             </div>
                                             <span class="span-next"></span>    
                                        </div>   
                                    </div>
                                </div>
                                <div class="row form-group">
                                    <div class="col-4 col-md-4 col-sm-4 col-lg-4">
                                        <label for="shippment_id" class=" form-control-label text-info ">Shippment</label>
                                    </div>
                                    <div class="col-12 col-md-8">
                                        <input type="text" id="shippment_id" name="shippment_id" placeholder="shippment id" class="form-control form-control-sm">
                                    </div>
                                </div>
                                <div class="row form-group">
                                    <div class="col-4 col-md-4 col-sm-4 col-lg-4">
                                        <label for="comment_box" class=" form-control-label text-info">Comment box </label>
                                    </div>
                                    <div class="col-12 col-md-8">
                                        <textarea name="comment_box" id="comment_box" rows="2" placeholder="Supplier address" class="form-control form-control-sm"></textarea>
                                    </div>
                                </div>
                                <button type="button" name="form_submit" id="form_submit" class="btn btn-primary btn-sm btn-block"><i class="fas fa-upload"></i> Upload</button>
                            </form>
                        </div>
                            
                            
                            
                    </div>
                </div>
                <div class="col-lg-9 col-sm-9 col-md-9 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Sale Orders </strong> Preview
                            <a href="javascript:;" class="btn btn-danger btn-sm float-right ml-1 show-btn" id="cancel" data-id=""><i class="fas fa-window-close"></i> Cancel</a>
                            <a href="javascript:;" class="btn btn-info btn-sm float-right ml-1 show-btn" id="pending" data-id=""><i class="fas fa-clock-o"></i> Pending </a>&nbsp;
                            <a href="javascript:;" class="btn btn-success btn-sm float-right show-btn" id="approve" data-id=""><i class="fas fa-check"></i> Approve</a>
                        </div>
                        <div class="card-body card-block">
                            <div class="table-responsive-sm">
                                <table class="table table-bordered table-striped table-sm" id="posts" data-id="">
                                    <thead class="table-dark" style="color:white">
                                        <tr>
                                            <th>Product Image</th>
                                            <th>Product Name</th>
                                            <th>SKU</th>
                                            <th>Sale Order QTY</th>
                                            <th>In Stock</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<script src="<?php echo e(asset('backend/js/jquery.validate.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/js/additional-methods.min.js')); ?>"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>




<script>
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});

    var validator=$('#form_id').validate({
            errorClass:'text-danger',
            success:'text-success',
            errorElement: 'span',
            rules:{
                file_upload:{
                    required:true,
                    extension: "xlsx|xls|csv",
                    accept: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-excel,text/csv,application/csv"
                },
                store_selection:{
                    required:true
                },
                cargo_select:{
                    required:true
                },
                comment_box:{
                    required:true
                },
                shippment_id:{
                    required:true
                }
                
                
                
            },
            messages:{
                file_upload:{
                    required:"File Upload is required",
                    extension:"Only Excel file accepted",
                    accept:"Only Excel file accepted"  
                },
                store_selection:{
                    required:"Store is required"
                },
                
                cargo_select:{
                    required:"Cargo Select is required"
                },
                shippment_id:{
                    required:"Shippment id is required"
                },
                
                comment_box:{
                    required:"Comment Box is required"
                },
            },
            highlight: function(element, errorClass, validClass) {
                $(element).closest('.form-control').addClass('has-warning');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).closest('.form-group').removeClass('has-error');
            },
            errorPlacement: function (error, element) {
                
                if(element.hasClass('select2') && element.next('.select2-container').length) {
                    error.insertAfter(element.next('.select2-container'));
                }else if(element.attr("name") == "cargo_select"){
                    error.insertAfter(".span-next");
                }else{
                    error.insertAfter(element);
                }
            },
        });

    var table=$('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        responsive: true,
        "dataSrc": "",
        "ajax":{
                    "url": "<?php echo e(route('sale.orders.id')); ?>",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){
                        d._token="<?php echo e(csrf_token()); ?>";
                        d.id=$('#posts').attr('data-id');
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [0,3] },
        ],
        bSort: false,
        "ordering": true,
        "columns":[
            { "data": "product_img","name":"product_img" },
            { "data": "product_name","name":"product_info.product_name" },
            { "data": "variation_id","name":"sale_order_list.variation_id" },
            { "data": "sale_order_id","name":"sale_order_id" },
            { "data": "Quantity","name":"product_info.Quantity" },
        ],
        "drawCallback": function( settings ) {
            loader('#posts',0);
            var count=$('#posts').DataTable().rows().count();
            if(count==0){
                $('.show-btn').hide();
            }else{
                if($('.btn_adjust')[0]){
                    $('.show-btn').hide();
                }else{
                    $('.show-btn').show(); 
                }
            }
            
            
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
            var count=$('#posts').DataTable().rows().count();
            if(count==0){
                $('.show-btn').hide();
            }
            
        },
    });
    
    var count=$('#posts').DataTable().rows().count();
    if(count==0){
        
        $('.show-btn').hide();
    }
    
   

    function ValidateSingleInput(oInput) {
        var _validFileExtensions = [".csv", ".xlsx", ".xls"];
        if (oInput.type == "file") {
            var sFileName = oInput.value;
            if (sFileName.length > 0) {
                var blnValid = false;
                for (var j = 0; j < _validFileExtensions.length; j++) {
                    var sCurExtension = _validFileExtensions[j];
                    if (sFileName.substr(sFileName.length - sCurExtension.length, sCurExtension.length).toLowerCase() == sCurExtension.toLowerCase()) {
                        blnValid = true;
                        break;
                    }
                }
                
                if (!blnValid) {
                    $('#errortxt').show();
                    $('#form_submit').hide();
                    $.toast({
                        heading: 'Error',
                        text: 'Invalid file,allowed only excel file eg '+_validFileExtensions.join(", "),
                        showHideTransition: 'slide',
                        icon: 'error',
                        position: 'top-right',
                    });
                    // alert("Sorry, " + sFileName + " is invalid, allowed extensions are: " + _validFileExtensions.join(", "));
                    oInput.value = "";
                    return false;
                }else{
                    $('#errortxt').hide();
                    $('#form_submit').show();
                    return true; 
                }
            }
        }
        return true;
    }
    $('.show-btn').hide();


    $('#form_submit').click(function(){
        var file_data = $("#file_upload").prop("files")[0]; // Getting the properties of file from file field
        var form_data = new FormData();
        // console.log(file_data);return;
        if($('#form_id').valid()){
             // Creating object of FormData class
            form_data.append("file_upload", file_data); // Appending parameter named file with properties of file_field to form_data
            form_data.append("_token", "<?php echo e(csrf_token()); ?>");
            form_data.append("store_selection",$('#store_selection').val());
            form_data.append("shippment_id",$('#shippment_id').val());
            form_data.append("cargo_select",$(".cargo_select:checked").val());//input[name=cargo_select]:checked
            form_data.append("comment_box",$('#comment_box').val());
            // console.log(form_data);return;
            // $('#errortxt').hide();
            $('#form_submit').prop('disabled',true);
            loader('#form_id');
            $.ajax({
                url:"<?php echo e(route('sale.orders')); ?>",
                type:'POST',
                dataType: 'json',
                cache: false,
                contentType: false,
                processData: false,
                data: form_data,
                success:function(data){
                    loader('#form_id',0);
                    if(data.error != '1'){
                        $.toast({
                            heading: 'Success',
                            text: data.error_msg,
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-right',
                        });
                        $('#posts').attr('data-id',data.sale_id);
                        $('#cancel').attr('data-id',data.sale_id);
                        $('#approve').attr('data-id',data.sale_id);
                        $('#pending').attr('data-id',data.sale_id);
                        $('#posts').DataTable().ajax.reload().draw();
                        $("#store_selection").select2("val", "");
                        $('#form_id').trigger("reset");
                        if($('.btn_adjust')[0]){
                            $('.show-btn').hide();
                        }else{
                            $('.show-btn').show(); 
                        }
                        

                        

                    }else{
                        $.toast({
                            heading: 'Error',
                            text: data.error_msg,
                            showHideTransition: 'slide',
                            icon: 'error',
                            position: 'top-right',
                        });
                    }
                    $('#form_submit').prop('disabled',false);
                }
            })

        }else{
            $.toast({
                heading: 'Error',
                text: 'All fields are required',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
        }
    });
    table.on('click', 'tbody .btn_adjust', function () {
        var data_row=table.row($(this).closest('tr')).data();
        
        $.ajax({
            url:"<?php echo e(route('sale.adjust')); ?>",
            type:"POST",
            data:{
                id:data_row.id,
                sale_order_qty:data_row.sale_order_qty,
                quantity:data_row.Quantity,
                _token:"<?php echo e(csrf_token()); ?>"
            },
            success:function(data){
                $.toast({
                    heading: 'Success',
                    text: "Order Adjusted Successfully",
                    showHideTransition: 'slide',
                    icon: 'success',
                    position: 'top-right',
                });
                
                $('#posts').DataTable().ajax.reload().draw();
            }
        })
    });

    $('#cancel').click(function(){
        if(confirm('Are Sure Want to Cancel because All data are remove')){
            $.ajax({
                url:"<?php echo e(route('sale.update')); ?>",
                type:"POST",
                data:{
                    id:$('#cancel').attr('data-id'),
                    _token:"<?php echo e(csrf_token()); ?>",
                    type:'1'
                },
                success:function(data){
                    $.toast({
                        heading: 'Success',
                        text: "Order Cancel Successfully",
                        showHideTransition: 'slide',
                        icon: 'success',
                        position: 'top-right',
                    });
                    $('#posts').DataTable().ajax.reload().draw();
                }
            })
        }
        
    });

    $('#approve').click(function(){
        $.ajax({
            url:"<?php echo e(route('sale.update')); ?>",
            type:"POST",
            data:{
                id:$('#approve').attr('data-id'),
                _token:"<?php echo e(csrf_token()); ?>",
                type:'2'
            },
            success:function(data){
                $.toast({
                    heading: 'Success',
                    text: "Order Approve Successfully",
                    showHideTransition: 'slide',
                    icon: 'success',
                    position: 'top-right',
                });
                $('#posts').attr('data-id','');
                $('#posts').DataTable().ajax.reload().draw();
            }
        })

    })
    $('#pending').click(function(){
        $.ajax({
            url:"<?php echo e(route('sale.update')); ?>",
            type:"POST",
            data:{
                id:$('#pending').attr('data-id'),
                _token:"<?php echo e(csrf_token()); ?>",
                type:'3'
            },
            success:function(data){
                $.toast({
                    heading: 'Success',
                    text: "Order Pending Successfully",
                    showHideTransition: 'slide',
                    icon: 'success',
                    position: 'top-right',
                });
                $('#posts').attr('data-id','');
                $('#posts').DataTable().ajax.reload().draw();
            }
        })

    })

</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/testapp/sampmini/resources/views/sale_order/index.blade.php ENDPATH**/ ?>