
<?php $__env->startSection('title',($string =='return')?'Return Item List | Mini Opex':'Alteration Item List | Mini Opex'); ?>
<?php $__env->startSection('add_css'); ?>
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <?php
                                if($string=='return'){
                                    $title='Return Items List';
                                    $link=route('supplier.items.list','alteration');
                                    $link_text='Alteration Items List';
                                }else if($string=='alteration'){
                                    $title='Alteration Items List';
                                    $link=route('supplier.items.list','return');
                                    $link_text='Return Items List';

                                }
                                
                            ?>
                            <strong>
                                <?php echo e($title); ?>

                            </strong>
                            <a href="<?php echo e($link); ?>" class="btn btn-info btn-sm float-right"><i class="fas fa-table"></i> <?php echo e($link_text); ?></a>
                        </div>
                        <div class="card-body card-block">
                            <?php if(session('has_error')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session('has_error')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('has_success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('has_success')); ?>

                                </div>
                            <?php endif; ?>
                            <div class="table-responsive">
                                <table class="table  table-bordered  table-striped table-earning" id="posts" cellspacing="0" width="100%">
                                    <thead>
                                        <tr>
                                            <th>Product Detail</th>
                                            <th>Quantity</th>
                                            <th>Type</th>
                                            
                                            <th>Created By</th>
                                            <th>Created Date</th>
                                            
    
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<script src="<?php echo e(asset('backend/js/jquery.validate.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/js/additional-methods.min.js')); ?>"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<!--<script src="//code.jquery.com/jquery-latest.js"></script>-->
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>


<script>
    var string="<?php echo e($string); ?>";
    var type;
    if(string=='return'){
        type=1;
    }else{
        type=2;
    }
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});
    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        "dataSrc": "",
        "ajax":{
                    "url": "<?php echo e(route('supplier.items.list',$string)); ?>",
                //  "dataType": "json",
                    "type": "POST",
                    data:function(d){
                        d._token= "<?php echo e(csrf_token()); ?>";
                        d.type=type;
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [] },
        ],
        "order": [[ 0, "desc" ]],
        bSort: false,
        "ordering": true,
        "columns":[
            { "data": "productDetail","name":"productDetail" },
            { "data": "quantity","name":"item_return.quantity" },
            { "data": "return_check","name":"item_return.return_check" },
            // { "data": "supplier_name","name":"suppliers.supplier_name" },
            { "data": "name","name":"users.name" },
            { "data": "created_at","name":"created_at" },
            
        ],
        createdRow: (row, data, dataIndex, cells) => {
            var status;
            if(data.return_check=='1'){
                status='Return';
            }else if(data.return_check=='2'){
                status='Alteration'
            }
            $(cells[2]).html('<span class="text-primary text-sm">'+status+'</span>')
        },
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
    });

        
    

    
</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/miniopex/resources/views/item_alter/return.blade.php ENDPATH**/ ?>