
<?php $__env->startSection('title','Process Orders | Mini Opex'); ?>
<?php $__env->startSection('add_css'); ?>
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="modal fade" id="adjustModal" tabindex="-1" role="dialog" aria-labelledby="adjustModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="adjustModalLabel">Cancellation</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" id="closebtn">
                    <span aria-hidden="true" >&times;</span>
                </button>
            </div>
            <form  id="item_adjust">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group " id="comment_div">
                        <label for="text-input" class=" form-control-label">Reason </label>
                        <textarea class="form-control" id="comments" name="comments" required></textarea>
                    </div>
                    
                    
                    
                    
                    <div class="form-group">
                        <div class="form-check" id="issued_div">
                            <div class="checkbox">
                                <label for="issued_po" class="form-check-label ">
                                    <input type="checkbox" id="issued_po" name="issued_po" value="YES" class="form-check-input"> PO Issued
                                </label>
                            </div>
                        </div>
                        
                        <div class="form-check" id="supplier_div">
                            <div class="checkbox">
                                <label for="supplier_order" class="form-check-label ">
                                    <input type="checkbox" id="supplier_order" name="supplier_order" value="YES" class="form-check-input">Cancel Supplier Orders
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group" id="given_div" style="display:none;">
                        <label for="text-input" class=" form-control-label">Given Qty </label>
                        <input type="number" class="form-control" id="new_given_qty" name="new_given_qty" pattern="^[0-9]*$" min="1"/>
                    </div>
                </div>
                
                
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" id="adjustBtn">Cancelled</button>
                
                </div>
            </form>
        </div>
    </div>
</div>
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Process Order </strong> List
                            <a href="javascript:;" id="assign_qty" class="float-right btn btn-success btn-sm ml-1 assign_qty" style="display:none"><i class="fas fa-check"></i> Update Quantity</a>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('process-cancel')): ?>
                            <button type="button" id="cancellation_btn" class="btn btn-danger btn-sm ml-5" style="display:none"><i class="fas fa-close"></i> Cancellation</button>
                            <?php endif; ?>
                        </div>
                        <div class="card-body card-block">
                            <?php if(session('has_error')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session('has_error')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('has_success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('has_success')); ?>

                                </div>
                            <?php endif; ?>
                            
                            <div id="showAlert"></div>
                            <div class="container custom_filter bg-light pt-3 pb-3 border  rounded">
                                <div class="row">
                                    <div class="col-12 col-md-5">
                                        <select name="store" id="store" class="form-control select2">
                                            <option value="">Select Store</option>
                                            <?php $__empty_1 = true; $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <option value="<?php echo e($store->id); ?>"><?php echo e($store->strong_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                    <div class="col-12 col-md-5">
                                        <select name="shipment_type" id="shipment_type" class="form-control select2">
                                            <option value="">Select Type</option>
                                            <option value="1">Air Cargo</option>
                                            <option value="2">Sea Cargo</option>
                                        </select>
                                    </div>
                                    <div class="col-12 col-md-2" style="display:none" id="download_div">
                                        <a href="javascript:;" id="download_po_excel" class="btn btn-info btn-sm "><i class="fas fa-file-excel"></i> Download Excel</a>
                                    </div>
                                    <!--<div class="col-12 col-md-4">-->
                                    <!--    <select name="status" id="status" class="form-control select2">-->
                                    <!--        <option value="">Select Status</option>-->
                                    <!--        <option value="1">Urgent</option>-->
                                    <!--        <option value="2">Normal</option>-->
                                    <!--    </select>-->
                                    <!--</div>-->
                                </div>
                            </div>
                            <form method="POST" id="assign_form" class="mt-3">
                                <?php echo csrf_field(); ?>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped" id="posts" cellspacing="0" width="100%">
                                        <thead >
                                            <tr class="thead-light">
                                                
                                                <th colspan="4" class="text-right">Total</th>
                                                <th id="instock_total"></th>
                                                <th id="order_total" colspan="2"></th>
                                            </tr>
                                            <tr class="thead-dark">
                                                <th>
                                                
                                                    Starting Date/Time
                                                </th>
                                                <th>Product Image</th>
                                                <th>Product Name</th>
                                                <th>Size</th>
                                                <th>In Stock</th>
                                                <th>Order Quantity</th>
                                                <th>Supply</th>
                                            </tr>
                                        </thead>
                                        <tfoot>
                                            <tr>
                                                
                                                <th colspan="4" class="text-right"></th>
                                                <th></th>
                                                <th colspan="2"></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                                
                            </form>
                            <hr>
                            <a href="javascript:;" id="assign_qty2" class="float-right btn btn-success btn-sm ml-1 mt-1 assign_qty" style="display:none"><i class="fas fa-check"></i> Update Quantity</a>
                    </div>
                    
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript" src="<?php echo e(asset('/backend/toast/jquery.toast.min.js')); ?>"charset="utf8"></script>


<script>
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});

    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        
        "dataSrc": "",
        "ajax":{
                    "url": "<?php echo e(route('shipment.process.order')); ?>",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){ 
                        d._token= "<?php echo e(csrf_token()); ?>";
                        d.store= $('#store option:selected').val();
                        d.shipment_type=$('#shipment_type option:selected').val();
                        d.status=$('#status option:selected').val();
                        
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [0,1,6] },
            { "width": "10%", "targets": [] },
            { "width": "5%", "targets": [] },
        ],
        bSort: false,
        "ordering": false,
        stateSave: true,
        fixedHeader: {
            header: true
        },
        "columns":[
            { "data": "created_at","name":"created_at" },
            { "data": "product_img","name":"product_img" },
            { "data": "product_name","name":"product_name" },
            { "data": "size","name":"size" },
            { "data": "instock","name":"instock" },
            { "data": "given_qty","name":"given_qty" },
            { "data": "receiving_input","name":"receiving_input" },
        ],
        // createdRow: (row, data, dataIndex, cells) => {
        //     var status='';
        //     if(data.shipment_type =='1'){
        //         status='<span class="text-primary text-sm">Air Cargo</span>';
        //     }else if(data.shipment_type =='2'){
        //       status='<span class="text-primary text-sm">Sea Cargo</span>'; 
        //     }
        //     $(cells[5]).html(status);
        //     $(cells[4]).addClass('text-success font-weight-bold');
        // },
        "drawCallback": function( settings ) {
            loader('#posts',0);
            
            var info = $('#posts').DataTable().page.info();
            tot = info.recordsTotal;
                
            if (tot > 0) {
                $('#download_div').show();   
            } else {
                $('#download_div').hide();    
            }
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
            
            var info = $('#posts').DataTable().page.info();
            tot = info.recordsTotal;
                
            if (tot > 0) {
                $('#download_div').show();   
            } else {
                $('#download_div').hide();    
            }
        },
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
 
            // converting to interger to find total
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            
                    
            var wedTotal = api
                .column( 4 )
                .data()
                .reduce( function (a, b) {
                    b = b.replace(/<\/?[^>]+(>|$)/g, "");
                    return intVal(a) + intVal(b);
                }, 0 );
                    
            var thuTotal = api
                .column( 5 )
                .data()
                .reduce( function (a, b) {
                    b = b.replace(/<\/?[^>]+(>|$)/g, "");
                    // b = b.replace('Order QTY : ', "");
                    return intVal(a) + intVal(b);
                }, 0 );
                
                // Update footer by showing the total with the reference of the column index 
                $( api.column( 3 ).footer() ).html('Total');
                $('#instock_total').text(wedTotal);
                $('#order_total').text(thuTotal);
                $( api.column( 4 ).footer() ).html(wedTotal);
                $( api.column( 5 ).footer() ).html(thuTotal);
        },
    });
    
    $('.select2').on('change',function(){
        $('#posts').DataTable().ajax.reload().draw();
    })
    
    
    // $('#posts').on('click','tbody .assign_qty',function(){
    //     var id=$(this).attr('data-id');
    //     $.ajax({
    //         url:"<?php echo e(route('shipment.send.process')); ?>",
    //         type:"POST",
    //         data:{
    //             pr_id:$('#pr_id_'+id).val(),
    //             store_id:$('#store_id_'+id).val(),
    //             shipment_type:$('#shipment_type_'+id).val(),
    //             urgent_status:$('#urgent_status_'+id).val(),
    //             instock:$('#instock_'+id).val(),
    //             variation_id:$('#variation_id_'+id).val(),
    //             variation_design:$('#variation_design_'+id).val(),
    //             filled_qty:$('#filled_qty_'+id).val(),
    //             approve_qty:$('#approve_qty_'+id).val(),
    //             _token: "<?php echo e(csrf_token()); ?>"
    //         },
    //         success:function(data){
    //             if(data){
    //                 $.toast({
    //                     heading: 'Success',
    //                     text: 'Assign Quantity Successfully',
    //                     showHideTransition: 'slide',
    //                     icon: 'success',
    //                     position: 'top-center',
    //                 });
    //                 $('#posts').DataTable().ajax.reload().draw();
    //                 $('#date_check').prop('checked',false);
    //             }else{
    //                 $.toast({
    //                     heading: 'Error',
    //                     text: 'Error in Assign Quantity',
    //                     showHideTransition: 'slide',
    //                     icon: 'error',
    //                     position: 'top-center',
    //                 });
    //             }
    //         }
    //     })
        
    // });
    $('#assign_qty').click(function(){
        var reqSupplier=$('.id_check').filter(':checked').length;
        if(reqSupplier ==0){
            row = $('#posts_wrapper tbody tr:first-child');
            $(row).addClass('table-warning');
            $.toast({
                heading: 'Error',
                text: 'Please Enter the Supply',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-center',
            });
            return; 
        }
        var obj= {};
        var array=[];
        var id;
        var value = $('.id_check').filter(':checked').filter(function () {
            id=$(this).attr('id').split("_")[2];
            console.log(id);
            obj.store_id=$('#store_id_'+id).val();
            obj.shipment_type=$('#shipment_type_'+id).val();
            obj.instock=$('#instock2_'+id).text();
            obj.variation_id=$('#variation_id_'+id).val();
            obj.variation_design=$('#variation_design_'+id).val();
            obj.filled_qty=$('#filled_qty_'+id).val();
            obj.approve_qty=$('#approve_qty_'+id).val();
            if($('#checkbox_'+id).is(':checked')==true){
                obj.checkbox=$('#checkbox_'+id).val();
            }else{
                obj.checkbox=0;
            }
            
            obj.id=id;

            array.push(obj);
            obj={};
            
        });
        // return;
        // console.log(array);return;
        // console.log(value.length +'==='+reqSupplier);
        // if (value.length>=0 && (value.length !== reqSupplier)) {
        //     $.toast({
        //         heading: 'Error',
        //         text: 'Please Enter the Supply',
        //         showHideTransition: 'slide',
        //         icon: 'error',
        //         position: 'top-center',
        //     });
        // } else {
            $.ajax({
                url:"<?php echo e(route('shipment.send.process')); ?>",
                type:"POST",
                data:{
                    array:array,
                    _token: "<?php echo e(csrf_token()); ?>"
                },
                success:function(data){
                    if(data){
                        $.toast({
                            heading: 'Success',
                            text: 'Assign Quantity Successfully',
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-center',
                        });
                        $('#posts').DataTable().ajax.reload().draw();
                        $('.assign_qty').hide();
                        $('#date_check').prop('checked',false);
                    }else{
                        $.toast({
                            heading: 'Error',
                            text: 'Error in Assign Quantity',
                            showHideTransition: 'slide',
                            icon: 'error',
                            position: 'top-center',
                        });
                    }
                }
            })
        // }
        
        
    });
    
    $('#posts').on('input','tbody .input_filled',function(){
        var id=$(this).attr('data-id');
        var instock=parseInt($('#instock2_'+id).text());
        console.log(instock);
        var rec_qty=parseInt($('#filled_qty_'+id).val().trim());
        
        if(rec_qty ==0){
            $('#error_'+id).text('Receive Quantity Only Numbers');
            $('#error_'+id).show();
            $.toast({
                heading: 'Error',
                text: 'Receive Quantity Only Numbers',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            $('#id_check_'+id).prop('checked',false);
            $('#assign_qty_'+id).hide();
            $('.assign_qty').hide();
            
            return false;
        }
        if(!/^[0-9]+$/.test(rec_qty) && rec_qty !=0){
            $('#error_'+id).text('Receive Quantity Only Numbers');
            $('#error_'+id).show();
            $.toast({
                heading: 'Error',
                text: 'Receive Quantity Only Numbers',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            $('#id_check_'+id).prop('checked',false);
            $('#assign_qty_'+id).hide();
            $('.assign_qty').hide();
        }else{
            if(rec_qty<=instock){
                $('#id_check_'+id).prop('checked','checked');
                $('#error_'+id).hide();
                $('#assign_qty_'+id).show();
                $('.assign_qty').show();
            }else{
                $('#error_'+id).text('Receive Quantity Exceed from InStock');
                $('#error_'+id).show();
                $('#id_check_'+id).prop('checked',false);
                $('#assign_qty_'+id).hide();
                $('.assign_qty').hide();
                $.toast({
                    heading: 'Error',
                    text: 'Receive Quantity Exceed from InStock',
                    showHideTransition: 'slide',
                    icon: 'error',
                    position: 'top-right',
                }); 
                return;
            }
        }
    });
    
    
    
    $('#assign_qty2').click(function(){
        $('#assign_qty').click();
    })
    
    $('#download_po_excel').click(function(){
        var store=$('#store option:selected').val();
        var shipment_type=$('#shipment_type option:selected').val();
        var url = '<?php echo e(route("excel.process.order", [":store_id",":shipment_type"])); ?>';
        url = url.replace(':store_id',store);
        url = url.replace(':shipment_type',shipment_type);
        
        window.location.href=url;
    });
    
    $(document).on('click','.urgent_btn',function(){
        var id=$(this).attr('data-id');
        // alert(id);
        
        if(confirm('Are you Sure to Mark as Urgent?')){
            $.ajax({
                url:"<?php echo e(route('shippment.mark_as_urgent')); ?>",
                type:'POST',
                data:{
                    _token: "<?php echo e(csrf_token()); ?>",
                    id:id
                },
                dataType:'JSON',
                success:function(data){
                    if(data.success=='1'){
                        $.toast({
                            heading: 'Success',
                            text: 'Urgent Status Updated Successfully',
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-right',
                        }); 
                        $('#posts').DataTable().ajax.reload().draw();
                    }
                }
            });
        }
        
        
        
    });
    
    $(document).on('change','.id_check2',function(){
       var self=$(this);
       var checked=self.filter(":checked").length;
        //   alert(self);
       
       if(checked>0){
           $('#cancellation_btn').show();
       }else{
           $('#cancellation_btn').hide();
       }
    });
    
    $('#cancellation_btn').click(function(){
        var self=$(this);
        if(confirm('Are you sure Want to Cancel ?')){
            $('#item_adjust').trigger("reset");
            $('#adjustModal').modal('show');
        }
    });
    
    $('#issued_po').click(function(){
        var self=$(this);
        if(self.is(':checked')){
            $('#given_div').show();
        }else{
            $('#given_div').hide();
        }
    })
    
    $('#item_adjust').on('submit',function(e){
        
        
        e.preventDefault();
        var formdata=$(this).serializeArray();
        
        var obj= {};
        var array=[];
        $('.id_check2').filter(':checked').filter(function(){
            var idSelf=$(this);
            
            obj.id=idSelf.data('id');
            obj.store_id=$('#store option:selected').val();
            obj.wh_qty=$('#instock2_'+idSelf.data('id')).text();
            obj.shipment_type=$('#shipment_type  option:selected').val();
            obj.variation_design=idSelf.val();
            obj.given_qty=idSelf.data('given_qty');
            
            array.push(obj);
            obj={};
        });
        formdata.push({ name: "variation_list", value: JSON.stringify(array) });
        
        console.log(formdata);
        // return;
        
        $.ajax({
            url:"<?php echo e(route('shipment.cancel.process')); ?>",
            data:formdata,
            type:'POST',
            dataType:'JSON',
            success:function(data){
                if(data.code='200'){
                    $.toast({
                        heading: 'Success',
                        text: 'Product Cancelled Successfully',
                        showHideTransition: 'slide',
                        icon: 'success',
                        position: 'top-center',
                    });
                    $('#adjustModal').modal('hide');
                    $('#item_adjust').trigger("reset");
                    $('#cancellation_btn').hide();
                    $('#date_check').prop('checked',false);
                    $('#posts').DataTable().ajax.reload().draw();
                }
            }
        })
    });

    

    

    
    
</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/sampmini/resources/views/process_order/index.blade.php ENDPATH**/ ?>