
<?php $__env->startSection('title','Raw SKU | Mini Opex'); ?>
<?php $__env->startSection('add_css'); ?>
<style>
    .strikeOut{
        text-decoration:line-through !important;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- modal Design -->
<div class="modal fade" id="unitCategoryModal" tabindex="-1" role="dialog" aria-labelledby="articleModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="unitCategoryLabel">Add New Unit</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="unitCatoryForm">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group ">
                        <label for="design_name" class=" form-control-label" id="unitCategoryName">Unit Name</label>
                        <input type="text" id="name" name="name" placeholder="KGs" class="form-control">
                        <input type="hidden" id="table_name" name="table_name" placeholder="KGs" class="form-control">
                        
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" id="designBtn">Add</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Create New</strong> Raw SKU
                            <a href="javascript:;" class="btn btn-info btn-sm float-right ml-1" id="addNewCategory"> Add New Category </a>&nbsp;
                            <a href="javascript:;" class="btn btn-success btn-sm float-right" id="addNewUnit"> Add New unit</a>
                             </div>
                        <div class="card-body card-block">
                            <?php if(session('has_error')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session('has_error')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('has_success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('has_success')); ?>

                                </div>
                            <?php endif; ?>
                            <form method="post" enctype="multipart/form-data" class="form-horizontal" id="form_id">
                                <?php echo csrf_field(); ?>
                                <div class="row form-group ">
                                    <div class="col col-md-3">
                                        <label for="text-input" class=" form-control-label mt-1">Title </label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <input type="text" id="product_name" name="product_name" placeholder="product name" class="form-control form-control-sm">
                                    </div>
                                </div>
                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="select" class=" form-control-label mt-1">Category</label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <select name="category" id="category" class="form-control select2 tac">
                                            <option value="">Please select</option>
                                            <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <option value="<?php echo e($category->id); ?>-<?php echo e($category->raw_category); ?>"><?php echo e($category->raw_category); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                
                                            <?php endif; ?>
                                            
                                        </select>
                                    </div>
                                </div>
                                
                                
                                
                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="select" class=" form-control-label mt-1">Unit</label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <select name="unit" id="unit" class="form-control select2 color tac">
                                            <option value="">Please select</option>
                                            <?php $__empty_1 = true; $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <option value="<?php echo e($unit->id); ?>-<?php echo e($unit->raw_unit); ?>"><?php echo e($unit->raw_unit); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="row form-group" id="image_upload">
                                    <div class="col col-md-3">
                                        <label for="file-input" class=" form-control-label mt-1">Image Upload</label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <input type="file" id="file-input" name="file_img" class="form-control-file">
                                    </div>
                                </div>
                                
                                <div class="row form-group ">
                                    <div class="col col-md-3">
                                        <label for="text-input" class=" form-control-label mt-1">Quantity </label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <input type="number" id="quantity" min="0" value="0" name="quantity" placeholder="0" class="form-control form-control-sm">
                                    </div>
                                </div>
                                
                                </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary btn-sm" id="submit_Btn">
                                    <i class="fa fa-dot-circle-o"></i> Submit
                                </button>
                                <button type="reset" class="btn btn-danger btn-sm" id="reset">
                                     <i class="fa fa-ban"></i> Reset
                                </button>
                            </form>
                            
                            </div>
                    </div>
                    
                   
                    
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<script src="<?php echo e(asset('backend/js/jquery.validate.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/js/additional-methods.min.js')); ?>"></script>




<script>
    // $(document).ready(function() {
        $('.select2').select2();

        $('#reset').click(function(){
            $( "#form_id" ).validate().resetForm();
            $(".select2").val('').trigger('change');
        });

        
        $('#addNewUnit').click(function(){
            $('#unitCategoryLabel').text('Add New Unit');
            $('#unitCategoryName').text('Unit Name');
            $('#name').attr('placeholder','KGS');
            $('#table_name').val('raw_unit');
            $('#unitCategoryModal').modal('show');
        }); 
        
        $('#addNewCategory').click(function(){
            $('#unitCategoryLabel').text('Add New Category');
            $('#unitCategoryName').text('Category Name');
            $('#name').attr('placeholder','Puffer Fabrics');
            $('#table_name').val('raw_category');
            $('#unitCategoryModal').modal('show');
        });

        

        $('#form_id').validate({
            errorClass:'text-danger',
            success:'text-success',
            errorElement: 'span',
            rules:{
                product_name: {
                    required: true
                },
                category:{
                    required:true
                },
                unit:{
                    required:true
                },
                file_img:{
                    required:true,
                    accept: "image/jpeg, image/pjpeg,image/png"
                },
                quantity:{
                    required:true
                },
                
                
            },
            messages:{
                product_name:{
                    required:"Product Name is required"
                },
                category:{
                    required:"Category is required"
                },
                unit:{
                    required:"Unit is required"
                },
                file_img:{
                    required:"File Upload is required",
                    accept:"Only Images Upload"
                    
                },
                quantity:{
                    required:"Initial Quantity is required"
                },
                
            },
            highlight: function(element, errorClass, validClass) {
                $(element).closest('.form-control').addClass('has-warning');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).closest('.form-group').removeClass('has-error');
            },
            errorPlacement: function (error, element) {
                
                if(element.hasClass('select2') && element.next('.select2-container').length) {
                    error.insertAfter(element.next('.select2-container'));
                }else if(element.attr("name") == "variation_option"){
                    error.insertAfter(".new");
                }else if(element.attr("name") == "image_option"){
                    error.insertAfter(".span-next");
                }else{
                    error.insertAfter(element);
                }
            },
            submitHandler: function (form) {
                console.log("Submitted!");
                var formData = new FormData(form);
                $.ajax({
                    type:'POST',
                    url: "<?php echo e(route('add_sku')); ?>",
                    data:formData,
                    cache:false,
                    contentType: false,
                    processData: false,
                    success:function(data){
                        if(data.code==200){
                           if(data.code=='200'){
                                $.toast({
                                    heading: 'Success',
                                    text: 'Raw SKU Added Successfully',
                                    showHideTransition: 'slide',
                                    icon: 'success',
                                    position: 'top-right',
                                }); 
                                
                                $("#form_id").trigger('reset');
                                $(document).find('#reset').click();
                               
                           }else{
                                $.toast({
                                    heading: 'Error',
                                    text: 'Error Try Again!',
                                    showHideTransition: 'slide',
                                    icon: 'error',
                                    position: 'top-right',
                                });  
                           }     
                        }
                        
                    }
                });
            }

        });
    // });
    
    
    $(document).on('submit','#unitCatoryForm',function(e){
       e.preventDefault();
       var self=$(this);
       var formData=self.serializeArray();
       
       var name=$('#name').val();
       var table_name=$('#table_name').val();
       
       var uName='category';
       if(table_name=='raw_unit'){
           uName='unit'; 
       }
       if(name !=''){
           $.ajax({
               url:"<?php echo e(route('add_unit_category')); ?>",
               type:'POST',
               data:formData,
               success:function(data){
                   if(data.code=='200'){
                       $.toast({
                            heading: 'Success',
                            text: 'Added in '+uName+' Successfully',
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-right',
                        }); 
                        $('#unitCategoryModal').modal('hide');
                        $('#'+uName).html(data.html);
                        self.trigger('reset');
                       
                   }else{
                       $.toast({
                            heading: 'Error',
                            text: 'Error Try Again!',
                            showHideTransition: 'slide',
                            icon: 'error',
                            position: 'top-right',
                        });  
                   }
               }
               
           })
       }
        
        
    });

    function ValidateSingleInput(oInput) {
        var _validFileExtensions = [".jpg", ".png", ".jpeg"];
        if (oInput.type == "file") {
            var sFileName = oInput.value;
            if (sFileName.length > 0) {
                var blnValid = false;
                for (var j = 0; j < _validFileExtensions.length; j++) {
                    var sCurExtension = _validFileExtensions[j];
                    if (sFileName.substr(sFileName.length - sCurExtension.length, sCurExtension.length).toLowerCase() == sCurExtension.toLowerCase()) {
                        blnValid = true;
                        break;
                    }
                }
                
                if (!blnValid) {
                    // console.log($('#designModal').hasClass('show'));
                    if($('#designModal').hasClass('show')){
                        $('#derrortxt').show();
                        $('#designBtn').hide();
                    }else{
                        $('#errortxt').show();
                        $('#typeBtn').hide();
                    }
                    
                    $.toast({
                        heading: 'Error',
                        text: 'Invalid file,allowed only excel file eg '+_validFileExtensions.join(", "),
                        showHideTransition: 'slide',
                        icon: 'error',
                        position: 'top-right',
                    });
                    // alert("Sorry, " + sFileName + " is invalid, allowed extensions are: " + _validFileExtensions.join(", "));
                    oInput.value = "";
                    return false;
                }else{
                    if($('#designModal').hasClass('show')){
                        $('#derrortxt').hide();
                        $('#designBtn').show();
                    }else{
                        $('#errortxt').hide();
                        $('#typeBtn').show();
                    }
                    
                    return true; 
                }
            }
        }
        return true;
    }
</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/testapp/sampmini/resources/views/raw/add_sku.blade.php ENDPATH**/ ?>