<?php
    if($string =='decrum'){
        $text="Decrum";
        $inhouse="Urban";
        
        $selectOption=['urban','safetyStock'];
    }else if($string =='urban'){
        $text="Urban Crest";
        $inhouse="Decrum";
        
        $selectOption=['decrum','safetyStock'];
        
    }else if($string =='safetyStock'){
        $text="Safety Stock";
        $inhouse="Decrum";
        
        $selectOption=['decrum','urban'];
        
    }
?>


<?php $__env->startSection('title','Inventory Summary '.$text.' | Mini Opex'); ?>
<?php $__env->startSection('add_css'); ?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">
<?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.datatable-js','data' => ['type' => 'css']]); ?>
<?php $component->withName('datatable-js'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['type' => 'css']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<style>
    .pointer_none{'pointer-events':'none'}
    
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="modal fade" id="adjustModal" tabindex="-1" role="dialog" aria-labelledby="adjustModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="adjustModalLabel">Item Adjustment</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" id="closebtn">
                    <span aria-hidden="true" >&times;</span>
                </button>
            </div>
            <form  id="item_adjust">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div id="data_reason">
                        
                    </div>
                    <div class="form-group ">
                        <label for="text-input" class=" form-control-label">Size </label>
                        <select name="product_size" id="product_size" class="form-control" required>
                        </select>
                    </div>
                    <div class="form-group ">
                        <label for="text-input" class=" form-control-label">Reason Name </label>
                        <select name="reason_id" id="reason_id" class="form-control" required>
                            <option value="">Please select</option>
                            <?php $__empty_1 = true; $__currentLoopData = $reasons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reason): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php if($reason->id !=4 && $reason->id !=9): ?>
                                <option value="<?php echo e($reason->id); ?>"><?php echo e($reason->reason_name); ?></option>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                
                            <?php endif; ?>
                        </select>
                    </div>
                    
                    <div class="form-group " style="display:none" id="stock_div">
                        <label for="text-input" class=" form-control-label">Stock Type </label>
                        <select name="stock_type" id="stock_type" class="form-control" required>
                            <option value="">Please select</option>
                            <option value="Add">Add</option>
                            <option value="Minus">Minus</option>
                        </select>
                    </div>
                    
                    <div class="form-group " id="comment_div">
                        <label for="text-input" class=" form-control-label">Comments </label>
                        <textarea class="form-control" id="comments" name="comments" required></textarea>
                    </div>
                    
                    <div class="form-group ">
                        <label for="article_name" class=" form-control-label">Item Adjust</label>
                        <input type="number" id="item_adjust2" name="item_adjust" placeholder="Item Adjust" class="form-control" required pattern="^[0-9]*$" min="1">
                    </div>
                    
                </div>
                
                
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" id="adjustBtn">Adjust</button>
                
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="switchStockModal" tabindex="-1" role="dialog" aria-labelledby="switchStockModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="switchStockModalLabel">Switch Stock</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" id="closebtn">
                    <span aria-hidden="true" >&times;</span>
                </button>
            </div>
            <form  id="switch_stock">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div id="data_switch">
                        
                    </div>
                    <div class="form-group ">
                        <label for="text-input" class=" form-control-label">Size </label>
                        <select name="product_size" id="product_size_n" class="form-control" required>
                        </select>
                    </div>
                    
                    <div class="form-group " id="comment_div">
                        <label for="text-input" class=" form-control-label">Comments </label>
                        <textarea class="form-control" id="comments" name="comments" required></textarea>
                    </div>
                    
                    <div class="form-group ">
                        <label for="article_name" class=" form-control-label">Stock Adjust</label>
                        <input type="number" id="stock_adjust" name="stock_adjust" placeholder="stock Adjust" class="form-control" required pattern="^[0-9]*$" min="1">
                    </div>
                    
                    
                    <div class="form-group ">
                        <label for="text-input" class=" form-control-label">Select Warehouse </label>
                        <select name="select_warehouse" id="select_warehouse" class="form-control" required>
                            <option value="">Please select</option>
                            
                            <?php $__empty_1 = true; $__currentLoopData = $selectOption; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $so): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <option value="<?php echo e($so); ?>"><?php echo e(ucfirst($so)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    
                    
                </div>
                
                
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" id="switchBtn">Switch</button>
                
                </div>
            </form>
        </div>
    </div>
</div>
<div class="modal fade" id="excelModal" tabindex="-1" role="dialog" aria-labelledby="excelModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="excelModalLabel">Upload Excel File</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="opening_stock_form" action="<?php echo e(route('opening.download')); ?>">
                    <?php echo csrf_field(); ?>
                    <label for="text-input" class=" form-control-label">Download File</label>
                    <button type="submit" class="btn btn-secondary float-right"><i class="fa fa-download"></i></button>
                </form>
                <hr>
                <i class="fa fa-spinner fa-spin fa-2x fa-fw " id="loadingspining" style="display: none"></i>

                <div class="form-group ">
                    <label for="text-input" class=" form-control-label">Excel </label>
                    <input type="file" id="file_img" name="file_img"  class="form-control" onchange="ValidateSingleInput(this)">
                    <input type="hidden" id="store_string" name="store_string"  class="form-control" value="<?php echo e($string); ?>">
                    <span class="text-danger text-sm" id="errortxt" style="display: none">Please Upload file in correct format eg excel</span>
                    
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="fileBtn">Add</button>
                
                
            </div>
        </div>
    </div>
</div>
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row ml-2 mr-2 mb-2">
                <div class="col-lg-4 col-md-4 col-sm-4 col-12 mt-1">
                    <div class="statistic__item border_grey bg-grey">
                        <h2 class="number text-white"><span id="urban_inventory">0</span></h2>
                        <span class="desc text-white">Urban Inventory</span>
                        <div class="icon text-white">
                            <i class="fas fa-warehouse"></i>
                        </div>
                    </div>
                    
                </div>
                <div class="col-lg-4 col-md-4 col-sm-4 col-12 mt-1">
                    <div class="statistic__item border_orange bg-orange">
                        <h2 class="number text-dark"><span id="decrum_inventory">0</span></h2>
                        <span class="desc text-dark">Decrum Inventory</span>
                        <div class="icon text-white">
                            <i class="fas fa-warehouse"></i>
                        </div>
                    </div>
                    
                </div>
                
                <div class="col-lg-4 col-md-4 col-sm-4 col-12 mt-1">
                    <div class="statistic__item border_grey bg-grey">
                        <h2 class="number text-white"><span id="safetyStock_inventory">0</span></h2>
                        <span class="desc text-white">Safety Stock Inventory</span>
                        <div class="icon text-white">
                            <i class="fas fa-warehouse"></i>
                        </div>
                    </div>
                    
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Inventory Summary</strong> <?php echo e($text); ?>

                            <a href="javascript:;" id="upload_Excel" class="float-right btn btn-info btn-sm d-none" data-toggle="modal" data-target="#excelModal"><i class="fas fa-file-excel"></i> Upload Excel</a>
                            
                            <div class="form-check float-right">
                                <input class="form-check-input" id="discarded_sku" name="discarded_sku" type="checkbox" value="yes"/>
                                <label class="form-check-label" for="discarded_sku">Show Discarded SKU</label>
                            </div>                           
                            
                                   
                        </div>
                        <div class="card-body card-block">
                            <?php if(session('has_error')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session('has_error')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('has_success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('has_success')); ?>

                                </div>
                            <?php endif; ?>
                            <div id="showAlert"></div>
                            <a href="javascript:;" id="download_inv_excel" class="btn btn-success btn-sm mx-1 float-right mb-1 d-none"><i class="fas fa-download"></i> Download Excel (V)</a>
                            <div class="table-responsive">
                                <table class="table  table-bordered  table-striped" cellspacing="0" width="100%" id="posts" data-id='' data-start='' data-end='' data-supplier-name=''>
                                    
                                    <thead>
                                        <tr class="thead-light">
                                            <th colspan="4" class="text-right">Total</th>
                                            <?php $count=4; ?>
                                            <?php $__empty_1 = true; $__currentLoopData = $product_sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <th id="s_<?php echo e($count); ?>"><?php echo e($s->size); ?></th>
                                                <?php $count++; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <?php endif; ?>
                                            <th id="s_<?php echo e($count); ?>">Total</th>
                                        </tr>
                                        <tr class="thead-dark">
                                            <th class="notexport">Image</th>
                                            <th>SKU</th>
                                            <th>Title</th>
                                            <th class="notexport">Options</th>
                                            <?php $__empty_1 = true; $__currentLoopData = $product_sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <th><?php echo e($s->size); ?></th>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <?php endif; ?>
                                            <th>Total</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                            <th colspan="4" class="text-right"></th>
                                             <?php $__empty_1 = true; $__currentLoopData = $product_sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <th></th>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <?php endif; ?>
                                            <th>Total</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
            </div>
    </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.datatable-js','data' => ['type' => 'js']]); ?>
<?php $component->withName('datatable-js'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['type' => 'js']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

<script>

    $('#download_inv_excel').click(function(){
        var url = '<?php echo e(route("ExportNewInventory",$string)); ?>';
        window.location.href=url;
    });

    var today = new Date().toLocaleDateString();
    var product_size=<?php echo json_encode($product_sizes); ?>;
    var obj= {};
    var array=[
        {data:'image',name:'image'},
        {data:'sku',name:'sku'},
        {data:'product_name',name:'product_name'},
        {data:'options',name:'options'},
    ];
    
    var countArr=[0,1,2,3];
    
    var count=4;
    $.each(product_size,function(index,e){
        obj.data=e.size;
        obj.name=e.size;
        array.push(obj);
        obj={};
        
        countArr.push(count);
        count++;
    })
    
    obj.data='total';
    obj.name='total';
    array.push(obj);
    countArr.push(count);
    console.log(array);
    console.log(countArr);
    
    var table =$('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 100,
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "language": {
            "search": "Product:"
        },
        "ajax":{
                    "url": "<?php echo e(route('inventory.summary',$string)); ?>",
                    "type": "POST",
                    "dataType":"JSON",
                    data:function(d){
                        d._token= "<?php echo e(csrf_token()); ?>";
                        d.is_discarded = $('#discarded_sku:checked').val();
                    },
                },
        "columnDefs": [
            {"searchable":false,"targets":countArr},
        ],
        bSort: false,
        "ordering": false,
        "columns": array,
        dom: 'lBfrtip',
        buttons: [
            {   
                extend: 'excelHtml5', 
                className: 'btn btn-dark btn-sm ml-5',
                text: '<i class="fas fa-file-excel"></i> Excel',
                footer: true,
                header:true,
                download: 'open',
                exportOptions: {
                    modifier: {
                        search: 'none'
                    },
                    columns: ':not(.notexport)'
                },
            },
            {
                className: 'btn bg-orange btn-sm text-dark ml-1 clpdf',
                text: '<i class="fas fa-file-excel"></i> Excel (V)',
                action: function ( e, dt, node, config ) {
                    $('#download_inv_excel').click();
                }
            },
        ],
        
        "dataSrc": "",
        "drawCallback": function(settings ) {
            loader('#posts',0);
            
            $('#urban_inventory').text(settings.json.urban_inventory);
            $('#decrum_inventory').text(settings.json.decrum_inventory);
            $('#safetyStock_inventory').text(settings.json.safetyStock_inventory);
            
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
        initComplete: function (data) {
            $('.buttons-excel').html('<i class="fas fa-file-excel"></i> Excel').removeClass('dt-button').addClass('btn btn-dark btn-sm ml-5');
            $('.clpdf').removeClass('dt-button');
            $('#posts_filter input').addClass('form-control-sm');
            $("#posts_filter").append(`
                <select class="float-right form-control-sm ml-1" name="type" id="type">
                    <option value="1">ALL</option>
                    <option value="2">AV Stock</option>
                </select>
            `);
            
            
            
        },
        rowCallback: function( row, data, index ) {
            var b=data.total;
            // console.log($("#type option:selected").val());
            if (b == '0' && $(document).find('#type').val()=='2') {
                console.log('zero stock');
                $(row).hide();
            }
        },
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
            // console.log(data);
            
            // converting to interger to find total
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
            
            var count=array.length;
            console.log(count);
            $( api.column( 0 ).footer() ).html('<span class="float-right">Total</span>');
            for(var j=4;j<count;j++){
                
                $('#s_'+j).html(api
                .column( j )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 ));
                $( api.column( j ).footer() ).html(
                        api
                .column( j )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 )
                );
            }
            
            
            
        }
    });
    
    $('#posts_filter').on('change','#type',function(e){
        e.preventDefault();
        $('#posts').DataTable().ajax.reload().draw();
    });
    
    function ValidateSingleInput(oInput) {
        var _validFileExtensions = [".csv", ".xlsx", ".xls"];
        if (oInput.type == "file") {
            var sFileName = oInput.value;
            if (sFileName.length > 0) {
                var blnValid = false;
                for (var j = 0; j < _validFileExtensions.length; j++) {
                    var sCurExtension = _validFileExtensions[j];
                    if (sFileName.substr(sFileName.length - sCurExtension.length, sCurExtension.length).toLowerCase() == sCurExtension.toLowerCase()) {
                        blnValid = true;
                        break;
                    }
                }
                
                if (!blnValid) {
                    $('#errortxt').show();
                    $('#fileBtn').hide();
                    $.toast({
                        heading: 'Error',
                        text: 'Invalid file,allowed only excel file eg '+_validFileExtensions.join(", "),
                        showHideTransition: 'slide',
                        icon: 'error',
                        position: 'top-right',
                    });
                    // alert("Sorry, " + sFileName + " is invalid, allowed extensions are: " + _validFileExtensions.join(", "));
                    oInput.value = "";
                    return false;
                }else{
                    $('#errortxt').hide();
                    $('#fileBtn').show();
                    return true; 
                }
            }
        }
        return true;
    }
    
    $('#fileBtn').click(function(){
        var file_data = $("#file_img").prop("files")[0]; // Getting the properties of file from file field
        var form_data = new FormData(); // Creating object of FormData class
        form_data.append("file_img", file_data) // Appending parameter named file with properties of file_field to form_data
        form_data.append("_token", "<?php echo e(csrf_token()); ?>") // Adding extra parameters to form_data
        form_data.append('store_id',$('#store option:selected').val());
        form_data.append('shipment_type',$('#shipment_type option:selected').val());
        form_data.append("store_string","<?php echo e($string); ?>");
        // console.log(form_data);return;
        // ValidateSingleInput($("#file_img"));
        if( $("#file_img")[0].files.length == 0){
            $.toast({
                heading: 'Error',
                text: 'All fields are Required',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            return;
        }else{
            $('#loadingspining').show();
            $.ajax({
                url:"<?php echo e(route('upload.opening')); ?>",
                type:"POST",
                dataType: 'json',
                cache: false,
                contentType: false,
                processData: false,
                data: form_data, // Setting the data attribute of ajax with file_data
                success:function(data){
                    $('#excelModal').modal('hide');
                    $('#loadingspining').hide();
                    $('#file_img').val('');
                    if(data.error=='1'){
                        $.toast({
                            heading: 'Error',
                            text: data.message,
                            showHideTransition: 'slide',
                            icon: 'error',
                            position: 'top-right',
                        });
                        $('#showAlert').html(`
                        <div class="alert alert-danger">
                          ${data.message}
                        </div>`);
                    }else{
                        $.toast({
                            heading: 'Success',
                            text: data.message,
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-right',
                        });
                        $('#showAlert').html('');
                        location.reload();
                        
                       
                    }
                    
                    // $('#posts').DataTable().ajax.reload().draw();
                    
                }
            });
        }
        
    });
    
    $(document).on('click','.item_adjust',function(){
        var group_id=$(this).attr('data-group_id');
        
        $.ajax({
            url:"<?php echo e(route('inventory.sku.detail')); ?>",
            data:{
                group_id:group_id,
                string:"<?php echo e($string); ?>",
                _token:'<?php echo e(csrf_token()); ?>',
            },
            type:'POST',
            dataType:'json',
            success:function(data){
                if(data.success =='1'){
                    $('#data_reason').html(data.html);
                    $('#product_size').html(data.select_html);
                    $("#store").val('').trigger('change');
                    $("#shipment_type").val('').trigger('change');
                    // $('.select2').removeAttr('required');
                    $('#store_display').hide();
                    $('#adjustModal').modal('show');
                }
            }
        })
    })
    
    
    
    $('#reason_id').change(function(){
       var val=$(this).val();
       
       if(inArray(val,[1,2,3,5,8])){
        //   $('#stock_type').val('Minus');
            $('#stock_type option[value=Add]').removeAttr('selected');
            $('#stock_type option[value=Minus]').attr('selected','selected');
            $('#stock_div').hide();
            
            $('#issued_div').show();
            $('#received_div').hide();
       }else if(inArray(val,[4,6])){
            $('#stock_type option[value=Add]').removeAttr('selected');
            $('#stock_type option[value=Minus]').removeAttr('selected');
            $('#stock_div').show();
            
            $('#received_div').hide();
            $('#issued_div').hide();
       }else if(inArray(val,[7])){
            $('#stock_type').val('Add');
            $('#stock_type option[value=Add]').attr('selected','selected');
            $('#stock_type option[value=Minus]').removeAttr('selected');
            $('#stock_div').hide();
            
            $('#received_div').hide();
            $('#issued_div').hide();
       }
       
    //   if(val==6){
    //       $('#comment_div').show();
    //   }else{
    //       $('#comment_div').hide();
    //   }
    });
    
    $('#stock_type').change(function(){
        var self=$(this);
        
        if(self.find(':selected').val()=='Add'){
            if($('#reason_id option:selected').val()=='7'){
                $('#received_div').hide();
                $('#issued_div').hide();
            }else{
                $('#received_div').show();
                $('#issued_div').hide();
            }
            
        }else{
            $('#issued_div').show();
            $('#received_div').hide();
        }
    });
    
    // $('#issued_po').click(function(){
    //     var self=$(this);
    //     if(self.is(':checked')){
    //         $('#store_display').show();
    //         $('.select2').attr('required','required');
    //     }else{
    //         $('#store_display').hide();
    //         $('.select2').removeAttr('required');
    //     }
    // })
    
    function inArray(needle, haystack) {
        var length = haystack.length;
        for(var i = 0; i < length; i++) {
            if(haystack[i] == needle) return true;
        }
        return false;
    }
    
    
    $('#item_adjust').on('submit',function(e){
        e.preventDefault();
        var formdata=$(this).serializeArray();
        var size_quantity=parseInt($('#product_size option:selected').attr('data-Quantity'));
        var item_adjust=parseInt($('#item_adjust2').val());
        var stock_type= $('#stock_type option:selected').val();
        var reason_name=$('#reason_id option:selected').text();
        
        formdata.push({ name: "reason_name", value: reason_name });
        formdata.push({ name: "store_string", value: "<?php echo e($string); ?>" });
        // console.log(stock_type+'=='+size_quantity+'==='+item_adjust);
        
        if(item_adjust>size_quantity && stock_type=='Minus'){
            console.log('nice');
            $.toast({
                heading: 'Error',
                text: 'Item Adjust Greater than actual QTY',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            return false;
        }
        
        $.ajax({
                url:"<?php echo e(route('inventory.item.adjust')); ?>",
                data:formdata,
                dataType:'json',
                type:'post',
                success:function(data){
                    if(data.success=='1'){
                        $.toast({
                            heading: 'Success',
                            text: data.message,
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-right',
                        });
                        $('#adjustModal').modal('hide');
                        $('#item_adjust').trigger("reset");
                        $("#store").val('').trigger('change');
                        $("#shipment_type").val('').trigger('change');
                        $('#store_display').hide();
                        $('#posts').DataTable().ajax.reload().draw();
                        // $('#showAlert').html('');
                        // location.reload();
                    }
                }
            })
        
        
        
    })
    
    $(document).on('click','.stock_switch',function(){
        var group_id=$(this).attr('data-group_id');
        
        $.ajax({
            url:"<?php echo e(route('inventory.sku.detail')); ?>",
            data:{
                group_id:group_id,
                string:"<?php echo e($string); ?>",
                _token:'<?php echo e(csrf_token()); ?>',
            },
            type:'POST',
            dataType:'json',
            success:function(data){
                if(data.success =='1'){
                    $('#data_switch').html(data.html);
                    $('#product_size_n').html(data.select_html);
                    $('#switchStockModal').modal('show');
                }
            }
        })
    })
    
    $(document).on('change','#select_warehouse',function(){
        let self=$(this);
        let val=self.val();
        $('#inhousetext').text(val);
    })
    
    $('#switch_stock').on('submit',function(e){
        e.preventDefault();
        var formdata=$(this).serializeArray();
        var size_quantity=parseInt($('#product_size_n option:selected').attr('data-Quantity'));
        var item_adjust=parseInt($('#stock_adjust').val());
        
        let store_string=$('#select_warehouse option:selected').val();
        formdata.push({ name: "store_string", value: store_string });
        formdata.push({ name: "stringType", value: "<?php echo e($string); ?>" });
        
        
        if(item_adjust>size_quantity){
            console.log('nice');
            $.toast({
                heading: 'Error',
                text: 'Stock Adjust Greater than actual QTY',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            return false;
        }
        
        $.ajax({
                url:"<?php echo e(route('inventory.stock.switch')); ?>",
                data:formdata,
                dataType:'json',
                type:'post',
                success:function(data){
                    if(data.success=='1'){
                        $.toast({
                            heading: 'Success',
                            text: data.message,
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-right',
                        });
                        $('#switch_stock').trigger("reset")
                        $('#switchStockModal').modal('hide');
                        // $('#stock_adjust').trigger("reset");
                        $('#posts').DataTable().ajax.reload().draw();
                    }
                }
            })
        
        
        
    })
    
    $(document).on('change','#product_size',function(){
        var self=$(this);
        
        var variation_id=self.val();
        if(variation_id !=''){
            $.ajax({
                url:"<?php echo e(route('inventory.item.check')); ?>",
                type:'POST',
                data:{
                    _token:'<?php echo e(csrf_token()); ?>',
                    variation_id:variation_id
                },
                dataType:'JSON',
                success:function(data){
                    if(data.code=='200'){
                        if(data.checked=='1'){
                            $('#issued_po').attr('checked','checked').addClass('pointer_none');
                        }else{
                            $('#issued_po').removeAttr('checked').removeClass('pointer_none');
                        }
                    }
                }
            })
        }
    })
    
    $('#discarded_sku').click(function(){
        $('#posts').DataTable().ajax.reload().draw();
    });
    
    

</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/miniopexpro/resources/views/inventory/index.blade.php ENDPATH**/ ?>