
<?php $__env->startSection('title','Processed Orders | Mini Opex'); ?>
<?php $__env->startSection('add_css'); ?>
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Processed Order </strong> List
                            <!--<a href="javascript:;" id="assign_qty" class="float-right btn btn-success btn-sm ml-1"><i class="fas fa-check"></i> Update Quantity</a>-->
                            
                                <button type="button" id="export_excel" class="float-right btn btn-info btn-sm ml-1" style="display:none"><i class="fas fa-file-excel-o"></i> Export Excel</button>
                            
                        </div>
                        <div class="card-body card-block">
                            <?php if(session('has_error')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session('has_error')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('has_success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('has_success')); ?>

                                </div>
                            <?php endif; ?>
                            
                            <div id="showAlert"></div>
                            <form action="<?php echo e(route('shipment.export.order')); ?>" method="post" id="excel_format">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" id="start_date" name="start_date" value=""/>
                                <input type="hidden" id="end_date" name="end_date" value=""/>
                                <input type="hidden" id="shipment_type2" name="shipment_type2" value=""/>
                                <input type="hidden" id="store_id2" name="store_id2" value=""/>
                                <input type="hidden" id="variation_list" name="variation_list" value=""/>
                            </form>
                            <div class="container custom_filter bg-light pt-3 pb-2 border  rounded">
                                <div class="row">
                                    <div class="col-12 col-md-4">
                                        <select name="store" id="store_id" class="form-control select2">
                                            <option value="">Select Store</option>
                                            <?php $__empty_1 = true; $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <option value="<?php echo e($store->id); ?>"><?php echo e($store->strong_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                    <div class="col-12 col-md-4">
                                        <select name="shipment_type" id="shipment_type" class="form-control select2">
                                            <option value="">Select Type</option>
                                            <option value="1">Air Cargo</option>
                                            <option value="2">Sea Cargo</option>
                                        </select>
                                    </div>
                                    <div class="col-12 col-md-4">
                                        <select name="status" id="status" class="form-control select2">
                                            <option value="">Select Status</option>
                                            <option value="1">Urgent</option>
                                            <option value="2">Normal</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-center mt-3">
                                    <div class="form-group form-inline">
                                        <label for="date_picker" class="form-control-label mr-3">Select Date</label>
                                        <input type="text" id="date_picker" name="date_picker" placeholder="Date Picker" class="form-control form-control-sm">
                                        <a href="javascript:;" class="btn btn-success btn-sm ml-1" id="search_change"><i class="fas fa-search" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                            </div>
                            
                            <form method="POST" id="assign_form" class="mt-3">
                                <?php echo csrf_field(); ?>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped" id="posts" cellspacing="0" width="100%" data-start='' data-end=''>
                                        <thead class="thead-dark">
                                            <tr>
                                                <th>
                                                    <input type="checkbox" id="date_check"class="ml-2 date_check">&nbsp;
                                                    Date
                                                </th>
                                                <th>Product Image</th>
                                                <th>Product Name</th>
                                                <th>Size</th>
                                                <th>Store</th>
                                                <th>Instock</th>
                                                <th>Shipment Type</th>
                                                <th>Order Quantity</th>
                                                <th>Given Quantity</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                                
                            </form>
                            <hr>
                            <!--<a href="javascript:;" id="assign_qty2" class="float-right btn btn-success btn-sm ml-1 mt-1"><i class="fas fa-check"></i> Update Quantity</a>-->
                    </div>
                    
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript" src="<?php echo e(asset('/backend/toast/jquery.toast.min.js')); ?>"charset="utf8"></script>
<script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<script>
    var start = moment().subtract(29, 'days');
    var end = moment();
    var today = new Date().toLocaleDateString();


    function cb(start, end) {
        $('#date_picker span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        $("#posts").attr("data-start",start.format('YYYY-MM-DD'));
        $("#posts").attr("data-end",end.format('YYYY-MM-DD'));
        $("#start_date").val(start.format('YYYY-MM-DD'));
        $("#end_date").val(end.format('YYYY-MM-DD'));
    }

    $('#date_picker').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
        'Today': [moment(), moment()],
        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
        'This Month': [moment().startOf('month'), moment().endOf('month')],
        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    }, cb);

    cb(start, end);
    
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});

    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        
        "dataSrc": "",
        "ajax":{
                    "url": "<?php echo e(route('shipment.processed.order')); ?>",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){ 
                        d._token= "<?php echo e(csrf_token()); ?>";
                        d.store= $('#store_id option:selected').val();
                        d.shipment_type=$('#shipment_type option:selected').val();
                        d.status=$('#status option:selected').val();
                        d.start_date=$("#posts").attr("data-start");
                        d.end_date=$("#posts").attr("data-end");
                        
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [0,1,6,5,7,8] },
            { "width": "5%", "targets": [7] },
        ],
        bSort: false,
        "ordering": true,
        "columns":[
            { "data": "created_at","name":"created_at" },
            { "data": "product_img","name":"product_img" },
            { "data": "product_name","name":"product_name" },
            { "data": "size","name":"product_size.size" },
            { "data": "strong_name","name":"store.strong_name" },
            { "data": "instock","name":"instock" },
            { "data": "shipment_type","name":"processed_orders.shipment_type" },
            { "data": "approve_qty","name":"approve_qty" },
            { "data": "filled_qty","name":"filled_qty" },
        ],
        createdRow: (row, data, dataIndex, cells) => {
            var status='';
            if(data.shipment_type =='1'){
                status='<span class="text-primary text-sm">Air Cargo</span>';
            }else if(data.shipment_type =='2'){
               status='<span class="text-primary text-sm">Sea Cargo</span>'; 
            }
            $(cells[6]).html(status);
            $(cells[4]).addClass('text-success font-weight-bold');
        },
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
    });
    
    $('.select2').on('change',function(){
        var id=$(this).attr('id');
        if($('#store_id option:selected').val() !='' && $('#shipment_type  option:selected').val() !=''){
            
            $('#export_excel').show();
        }else{
            $('#export_excel').hide();
        }
        $('#'+id+'2').val($('#'+id +' option:selected').val());
        $('#posts').DataTable().ajax.reload().draw();
    })
    
    $('#date_check').click(function(){
        if($('#date_check').is(':checked')){
            $('.id_check').prop('checked',true);
            check_variation_design()
        }else{
            $('.id_check').prop('checked',false);
            $('#variation_list').val('');
        }
    });
    
    $('#search_change').click(function(){
        $('#posts').DataTable().ajax.reload().draw();
    });
    function check_variation_design(){
        var array=[];
        $('.id_check').filter(':checked').filter(function () {
            array.push($(this).val());
        });
        console.log(array.join(","));
        $('#variation_list').val(array.join(","));
    }
    
    $('#posts').on('click','tbody .id_check',function(){
        check_variation_design();
    })
    
    
    $('#posts').on('click','tbody .assign_qty',function(){
        var id=$(this).attr('data-id');
        $.ajax({
            url:"<?php echo e(route('shipment.send.process')); ?>",
            type:"POST",
            data:{
                pr_id:$('#pr_id_'+id).val(),
                store_id:$('#store_id_'+id).val(),
                shipment_type:$('#shipment_type_'+id).val(),
                urgent_status:$('#urgent_status_'+id).val(),
                instock:$('#instock_'+id).val(),
                variation_id:$('#variation_id_'+id).val(),
                variation_design:$('#variation_design_'+id).val(),
                filled_qty:$('#filled_qty_'+id).val(),
                approve_qty:$('#approve_qty_'+id).val(),
                _token: "<?php echo e(csrf_token()); ?>"
            },
            success:function(data){
                if(data){
                    $.toast({
                        heading: 'Success',
                        text: 'Assign Quantity Successfully',
                        showHideTransition: 'slide',
                        icon: 'success',
                        position: 'top-center',
                    });
                    $('#posts').DataTable().ajax.reload().draw();
                    $('#date_check').prop('checked',false);
                }else{
                    $.toast({
                        heading: 'Error',
                        text: 'Error in Assign Quantity',
                        showHideTransition: 'slide',
                        icon: 'error',
                        position: 'top-center',
                    });
                }
            }
        })
        
    });
    // $('#assign_qty').click(function(){
    //     var reqSupplier=$('.id_check').filter(':checked').length;
    //     if(reqSupplier ==0){
    //         row = $('#posts_wrapper tbody tr:first-child');
    //         $(row).addClass('table-warning');
    //         $.toast({
    //             heading: 'Error',
    //             text: 'Please Enter the Supply',
    //             showHideTransition: 'slide',
    //             icon: 'error',
    //             position: 'top-center',
    //         });
    //         return; 
    //     }
    //     var obj= {};
    //     var array=[];
    //     var id;
    //     var value = $('.id_check').filter(':checked').filter(function () {
    //         id=$(this).attr('id').split("_")[2];
    //         console.log(id);
    //         obj.pr_id=$('#pr_id_'+id).val();
    //         obj.store_id=$('#store_id_'+id).val();
    //         obj.shipment_type=$('#shipment_type_'+id).val();
    //         obj.urgent_status=$('#urgent_status_'+id).val();
    //         obj.instock=$('#instock_'+id).val();
    //         obj.variation_id=$('#variation_id_'+id).val();
    //         obj.variation_design=$('#variation_design_'+id).val();
    //         obj.filled_qty=$('#filled_qty_'+id).val();
    //         obj.approve_qty=$('#approve_qty_'+id).val();
    //         if($('#checkbox_'+id).is(':checked')==true){
    //             obj.checkbox=$('#checkbox_'+id).val();
    //         }else{
    //             obj.checkbox=0;
    //         }
            
    //         obj.id=id;

    //         array.push(obj);
    //         obj={};
            
            
    //         if($('#options_'+id).val() == ''){
    //             $('#error_'+id).show();
                
    //         }else{
    //             $('#error_'+id).hide();
                
                
    //         }
    //         return $('#options_'+id).val() != '';
    //     });
    //     return;
    //     // console.log(array);return;
    //     if (value.length>=0 && (value.length !== reqSupplier)) {
    //         $.toast({
    //             heading: 'Error',
    //             text: 'Please Enter the Supply',
    //             showHideTransition: 'slide',
    //             icon: 'error',
    //             position: 'top-center',
    //         });
    //     } else {
    //         $.ajax({
    //             url:"<?php echo e(route('shipment.send.process')); ?>",
    //             type:"POST",
    //             data:{
    //                 array:array,
    //                 _token: "<?php echo e(csrf_token()); ?>"
    //             },
    //             success:function(data){
    //                 if(data){
    //                     $.toast({
    //                         heading: 'Success',
    //                         text: 'Assign Quantity Successfully',
    //                         showHideTransition: 'slide',
    //                         icon: 'success',
    //                         position: 'top-center',
    //                     });
    //                     $('#posts').DataTable().ajax.reload().draw();
    //                     $('#date_check').prop('checked',false);
    //                 }else{
    //                     $.toast({
    //                         heading: 'Error',
    //                         text: 'Error in Assign Quantity',
    //                         showHideTransition: 'slide',
    //                         icon: 'error',
    //                         position: 'top-center',
    //                     });
    //                 }
    //             }
    //         })
    //     }
        
        
    // });
    
    $('#posts').on('input','tbody .input_filled',function(){
        var id=$(this).attr('data-id');
        var instock=parseInt($('#instock2_'+id).text());
        console.log(instock);
        var rec_qty=parseInt($('#filled_qty_'+id).val().trim());
        if(!/^[0-9]+$/.test(rec_qty)){
            $('#error_'+id).text('Receive Quantity Only Numbers');
            $('#error_'+id).show();
            $.toast({
                heading: 'Error',
                text: 'Receive Quantity Only Numbers',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            $('#id_check_'+id).prop('checked',false);
            $('#assign_qty_'+id).hide();
        }else{
            if(rec_qty<=instock){
                $('#id_check_'+id).prop('checked','checked');
                $('#error_'+id).hide();
                $('#assign_qty_'+id).show();
            }else{
                $('#error_'+id).text('Receive Quantity Exceed from InStock');
                $('#error_'+id).show();
                $('#id_check_'+id).prop('checked',false);
                $('#assign_qty_'+id).hide();
                $.toast({
                    heading: 'Error',
                    text: 'Receive Quantity Exceed from InStock',
                    showHideTransition: 'slide',
                    icon: 'error',
                    position: 'top-right',
                }); 
                return;
            }
        }
    });
    
    
    
    $('#assign_qty2').click(function(){
        $('#assign_qty').click();
    })
    
    $('#export_excel').click(function(){
        $("#excel_format").submit();
    })

    

    

    
    
</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/miniopex_pro/resources/views/process_order/processed_order.blade.php ENDPATH**/ ?>