
<?php $__env->startSection('title','Ready to Shipment | Mini Opex'); ?>
<?php $__env->startSection('add_css'); ?>
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="modal fade" id="adjustModal" tabindex="-1" role="dialog" aria-labelledby="adjustModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="adjustModalLabel">Cancellation</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" id="closebtn">
                    <span aria-hidden="true" >&times;</span>
                </button>
            </div>
            <form  id="item_adjust">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group " id="comment_div">
                        <label for="text-input" class=" form-control-label">Reason </label>
                        <textarea class="form-control" id="comments" name="comments" required></textarea>
                    </div>
                    
                    
                    <div class="form-group">
                        <div class="form-check" id="issued_div">
                            <div class="checkbox">
                                <label for="bulk_po" class="form-check-label ">
                                    <input type="checkbox" id="issued_po" name="issued_po" value="YES" class="form-check-input"> PO Issued
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
                
                
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" id="adjustBtn">Cancelled</button>
                
                </div>
            </form>
        </div>
    </div>
</div>
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row ml-2 mr-2 mb-2">
                <div class="col-lg-3 col-md-3 col-sm-6 col-12 mt-1">
                    <div class="statistic__item border_grey bg-grey">
                        <h2 class="number text-white"><span id="total_pending_single">0</span></h2>
                        <span class="desc text-white">Total RTS Single</span>
                        <div class="icon text-white">
                            <i class="fas fa-dolly"></i>
                        </div>
                    </div>
                    
                </div>
                <div class="col-lg-3 col-md-3 col-sm-6 col-12 mt-1">
                    <div class="statistic__item border_orange bg-orange">
                        <h2 class="number text-dark"><span id="total_pending_bundle">0</span></h2>
                        <span class="desc text-dark">Total RTS Bundle</span>
                        <div class="icon text-white">
                            <i class="fas fa-dolly"></i>
                        </div>
                    </div>
                    
                </div>
                <div class="col-lg-6 col-md-6 col-sm-12 col-12 mt-1">
                    <div class="row custom_filter pt-4 pb-3 border  rounded">
                        <div class="col-lg-4 col-md-4 col-sm-4 col-6 mt-1">
                            <select name="store" id="store_id" class="form-control select2">
                                <option value="">Select Store</option>
                                <?php $__empty_1 = true; $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <option value="<?php echo e($store->id); ?>"><?php echo e($store->strong_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    
                                <?php endif; ?>
                            </select>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-4 col-6 mt-1">
                            <select name="shipment_type" id="shipment_type" class="form-control select2">
                                <option value="">Select Type</option>
                                <option value="1">Air Cargo</option>
                                <option value="2">Sea Cargo</option>
                            </select>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-4 col-6 mt-1">
                            <div style="display:none" id="download_div" class="">
                                 <!--<a href="javascript:;" id="download_rts_excel" class="btn bg-orange text-dark btn-sm"><i class="fas fa-file-excel"></i> Excel</a>-->
                                 <a href="javascript:;" id="export_excel" class="btn bg-orange text-dark btn-sm ml-1" ><i class="fas fa-file-excel"></i> Excel</a>
                            </div> 
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Ready to Shipment</strong>
                            <!--<a href="javascript:;" id="assign_qty" class="float-right btn btn-success btn-sm ml-1"><i class="fas fa-check"></i> Update Quantity</a>-->
                            
                                
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('process-cancel')): ?>
                                <button type="button" id="cancellation_btn" class="btn btn-danger btn-sm ml-5" style="display:none"><i class="fas fa-close"></i> Cancellation</button>
                                <?php endif; ?>
                        </div>
                        <div class="card-body card-block">
                            <?php if(session('has_error')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session('has_error')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('has_success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('has_success')); ?>

                                </div> 
                            <?php endif; ?>
                            <form action="<?php echo e(route('shipment.export.order')); ?>" method="post" id="excel_format">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" id="start_date" name="start_date" value=""/>
                                <input type="hidden" id="end_date" name="end_date" value=""/>
                                <input type="hidden" id="shipment_type2" name="shipment_type2" value=""/>
                                <input type="hidden" id="store_id2" name="store_id2" value=""/>
                                <input type="hidden" id="variation_list" name="variation_list" value=""/>
                            </form>
                            
                            <form method="POST" id="assign_form" class="mt-3">
                                <?php echo csrf_field(); ?>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped" id="posts" cellspacing="0" width="100%" data-start='' data-end=''>
                                        <thead >
                                            <tr class="thead-light">
                                                <th colspan="4" class="text-right">TOTAL</th>
                                                <th id="order_qty">0</th>
                                            </tr>
                                            <tr class="thead-dark">
                                                <th>
                                                    <input type="checkbox" id="date_check"class="ml-2 date_check">&nbsp;
                                                    Starting Date/Time
                                                </th>
                                                <th>Product Image</th>
                                                <th>Product Name</th>
                                                <th>Size</th>
                                                <th>Given Quantity</th>
                                            </tr>
                                        </thead>
                                        <tfoot>
                                            <tr>
                                                <th colspan="4" class="text-right">TOTAL</th>
                                                <th>0</th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                                
                            </form>
                            <hr>
                            <!--<a href="javascript:;" id="assign_qty2" class="float-right btn btn-success btn-sm ml-1 mt-1"><i class="fas fa-check"></i> Update Quantity</a>-->
                    </div>
                    
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript" src="<?php echo e(asset('/backend/toast/jquery.toast.min.js')); ?>"charset="utf8"></script>
<script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<script>
    var start = moment().subtract(29, 'days');
    var end = moment();
    var today = new Date().toLocaleDateString();


    function cb(start, end) {
        $('#date_picker span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        $("#posts").attr("data-start",start.format('YYYY-MM-DD'));
        $("#posts").attr("data-end",end.format('YYYY-MM-DD'));
        $("#start_date").val(start.format('YYYY-MM-DD'));
        $("#end_date").val(end.format('YYYY-MM-DD'));
    }

    $('#date_picker').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
        'Today': [moment(), moment()],
        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
        'This Month': [moment().startOf('month'), moment().endOf('month')],
        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    }, cb);

    cb(start, end);
    
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});

    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        lengthMenu: [
            [10, 25, 50,100,500],
            [10, 25, 50,100,500],
        ],
        fixedColumns: true,
        fixedHeader: true,
        scrollX: true,
        "dataSrc": "",
        "ajax":{
                    "url": "<?php echo e(route('shipment.processed.order')); ?>",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){ 
                        d._token= "<?php echo e(csrf_token()); ?>";
                        d.store= $('#store_id option:selected').val();
                        d.shipment_type=$('#shipment_type option:selected').val();
                        d.status=$('#status option:selected').val();
                        d.start_date=$("#posts").attr("data-start");
                        d.end_date=$("#posts").attr("data-end");
                        
                        
                        
                        get_ready_count($('#store_id option:selected').val(),$('#shipment_type option:selected').val())
                        
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [0,1] },
            // { "width": "5%", "targets": [0] },
        ],
        bSort: false,
        "ordering": false,
        "columns":[
            { "data": "created_at","name":"created_at" },
            { "data": "product_img","name":"product_img" },
            { "data": "product_name","name":"product_name" },
            { "data": "size","name":"size" },
            { "data": "filled_qty","name":"filled_qty" },
        ],
        // createdRow: (row, data, dataIndex, cells) => {
        //     var status='';
        //     if(data.shipment_type =='1'){
        //         status='<span class="text-primary text-sm">Air Cargo</span>';
        //     }else if(data.shipment_type =='2'){
        //       status='<span class="text-primary text-sm">Sea Cargo</span>'; 
        //     }
        //     $(cells[6]).html(status);
        //     $(cells[4]).addClass('text-success font-weight-bold');
        // },
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
            
            var info = $('#posts').DataTable().page.info();
            tot = info.recordsTotal;
                
            if (tot > 0) {
                $('#export_excel').show();
                $('#download_div').show();
            } else {
                $('#export_excel').hide();
                $('#download_div').hide();
            }
        },
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
 
            // converting to interger to find total
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            
                    
            var wedTotal = api
                .column( 4 )
                .data()
                .reduce( function (a, b) {
                    b = b.replace(/<\/?[^>]+(>|$)/g, "");
                    return intVal(a) + intVal(b);
                }, 0 );
                    
                $( api.column( 3 ).footer() ).html('TOTAL');
                $('#order_qty').text(wedTotal);
                $( api.column( 4 ).footer() ).html(wedTotal);
        },
    });
    
    $('.select2').on('change',function(){
        var id=$(this).attr('id');
        if($('#store_id option:selected').val() !='' && $('#shipment_type  option:selected').val() !=''){
            
            $('#export_excel').show();
        }else{
            $('#export_excel').hide();
        }
        $('#'+id+'2').val($('#'+id +' option:selected').val());
        $('#posts').DataTable().ajax.reload().draw();
    })
    
    $('#date_check').click(function(){
        if($('#date_check').is(':checked')){
            $('.id_check').prop('checked',true);
            $('#cancellation_btn').show();
            check_variation_design()
        }else{
            $('.id_check').prop('checked',false);
            $('#variation_list').val('');
            $('#cancellation_btn').hide();
        }
    });
    
    $('#search_change').click(function(){
        $('#posts').DataTable().ajax.reload().draw();
    });
    function check_variation_design(){
        var array=[];
        $('.id_check').filter(':checked').filter(function () {
            array.push($(this).val());
        });
        console.log(array.join(","));
        $('#variation_list').val(array.join(","));
    }
    
    $('#posts').on('click','tbody .id_check',function(){
        check_variation_design();
    })
    
    
    $('#posts').on('click','tbody .assign_qty',function(){
        var id=$(this).attr('data-id');
        $.ajax({
            url:"<?php echo e(route('shipment.send.process')); ?>",
            type:"POST",
            data:{
                pr_id:$('#pr_id_'+id).val(),
                store_id:$('#store_id_'+id).val(),
                shipment_type:$('#shipment_type_'+id).val(),
                urgent_status:$('#urgent_status_'+id).val(),
                instock:$('#instock_'+id).val(),
                variation_id:$('#variation_id_'+id).val(),
                variation_design:$('#variation_design_'+id).val(),
                filled_qty:$('#filled_qty_'+id).val(),
                approve_qty:$('#approve_qty_'+id).val(),
                _token: "<?php echo e(csrf_token()); ?>"
            },
            success:function(data){
                if(data){
                    $.toast({
                        heading: 'Success',
                        text: 'Assign Quantity Successfully',
                        showHideTransition: 'slide',
                        icon: 'success',
                        position: 'top-center',
                    });
                    $('#posts').DataTable().ajax.reload().draw();
                    $('#date_check').prop('checked',false);
                }else{
                    $.toast({
                        heading: 'Error',
                        text: 'Error in Assign Quantity',
                        showHideTransition: 'slide',
                        icon: 'error',
                        position: 'top-center',
                    });
                }
            }
        })
        
    });
    
    
    $('#posts').on('input','tbody .input_filled',function(){
        var id=$(this).attr('data-id');
        var instock=parseInt($('#instock2_'+id).text());
        console.log(instock);
        var rec_qty=parseInt($('#filled_qty_'+id).val().trim());
        if(!/^[0-9]+$/.test(rec_qty)){
            $('#error_'+id).text('Receive Quantity Only Numbers');
            $('#error_'+id).show();
            $.toast({
                heading: 'Error',
                text: 'Receive Quantity Only Numbers',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            $('#id_check_'+id).prop('checked',false);
            $('#assign_qty_'+id).hide();
        }else{
            if(rec_qty<=instock){
                $('#id_check_'+id).prop('checked','checked');
                $('#error_'+id).hide();
                $('#assign_qty_'+id).show();
            }else{
                $('#error_'+id).text('Receive Quantity Exceed from InStock');
                $('#error_'+id).show();
                $('#id_check_'+id).prop('checked',false);
                $('#assign_qty_'+id).hide();
                $.toast({
                    heading: 'Error',
                    text: 'Receive Quantity Exceed from InStock',
                    showHideTransition: 'slide',
                    icon: 'error',
                    position: 'top-right',
                }); 
                return;
            }
        }
    });
    
    
    
    $('#assign_qty2').click(function(){
        $('#assign_qty').click();
    })
    
    $('#export_excel').click(function(){
        $("#excel_format").submit();
    })
    
    $('#download_rts_excel').click(function(){
        var store=$('#store_id option:selected').val();
        var shipment_type=$('#shipment_type option:selected').val();
        var url = '<?php echo e(route("excel.shipment.ready.order", [":store_id",":shipment_type"])); ?>';
        url = url.replace(':store_id',store);
        url = url.replace(':shipment_type',shipment_type);
        
        window.location.href=url;
    });
    
    $(document).on('change','.id_check',function(){
       var self=$(this);
       var checked=self.filter(":checked").length;
    //   alert(self);
       
       if(checked>0){
           $('#cancellation_btn').show();
       }else{
           $('#cancellation_btn').hide();
       }
    });
    
    $('#cancellation_btn').click(function(){
        var self=$(this);
        if(confirm('Are you sure Want to Cancel ?')){
            $('#item_adjust').trigger("reset");
            $('#adjustModal').modal('show');
        }
    });
    
    $('#item_adjust').on('submit',function(e){
        
        
        e.preventDefault();
        var formdata=$(this).serializeArray();
        
        var obj= {};
        var array=[];
        $('.id_check').filter(':checked').filter(function(){
            var idSelf=$(this);
            
            obj.id=idSelf.data('id');
            obj.store_id=$('#store_id option:selected').val();
            obj.shipment_type=$('#shipment_type  option:selected').val();
            obj.variation_design=idSelf.val();
            obj.given_qty=idSelf.data('given_qty');
            
            array.push(obj);
            obj={};
        });
        formdata.push({ name: "variation_list", value: JSON.stringify(array) });
        
        console.log(formdata);
        
        $.ajax({
            url:"<?php echo e(route('shipment.cancel.ready_to_shipment')); ?>",
            data:formdata,
            type:'POST',
            dataType:'JSON',
            success:function(data){
                if(data.code='200'){
                    $.toast({
                        heading: 'Success',
                        text: 'Product Cancelled Successfully',
                        showHideTransition: 'slide',
                        icon: 'success',
                        position: 'top-center',
                    });
                    $('#adjustModal').modal('hide');
                    $('#item_adjust').trigger("reset");
                    $('#cancellation_btn').hide();
                    $('#date_check').prop('checked',false);
                    $('#posts').DataTable().ajax.reload().draw();
                }
            }
        })
    });
    
    function get_ready_count($store_id,$shipment_id){
        $.ajax({
            url:"<?php echo e(route('get_ready_count')); ?>",
            data:{
                store_id:$store_id,
                shipment_type:$shipment_id,
                _token:"<?php echo e(csrf_token()); ?>"
            },
            type:'POST',
            dataType:'JSON',
            success:function(data){
                $('#total_pending_single').text(data.single_pending);
                $('#total_pending_bundle').text(data.bundle_pending);
            }
        })
    }

    

    

    
    
</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/testapp/sampmini/resources/views/process_order/processed_order.blade.php ENDPATH**/ ?>