
<?php $__env->startSection('title','Print Labels | Mini Opex'); ?>
<?php $__env->startSection('add_css'); ?>
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">




    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- modal color -->
<div class="modal fade" id="blisterModal" tabindex="-1" role="dialog" aria-labelledby="blisterModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="blisterModalLabel">Add Blister Quantity</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <span class="text-success col-md-6 mt-2">Receiving Qty:</span>
                    <h1 class="text-lg col-md-6" id="last_rec"></h1>  
                </div>
                <hr>
                <div class="form-group ">
                    <label for="text-input" class=" form-control-label">Enter Blister QTY</label>
                    <input type="text" id="blister_qty" name="blister_qty" placeholder="blister_qty" class="form-control">
                    <input type="hidden" id="actual_qty" name="actual_qty" placeholder="blister_qty" class="form-control" readonly>
                    <input type="hidden" id="data_id" name="data_id" placeholder="data_id" class="form-control">
                </div>
                <div class="form-group ">
                    <label for="text-input" class=" form-control-label">No of Labels</label>
                    <input type="text" id="no_of_label" name="no_of_label" placeholder="no_of_label" class="form-control" value="1">
                    <span class="text_danger" id="label_err"></span>
                </div>
                <div class="form-check" id="first_check" style="display: none">
                    <div class="checkbox">
                        <label for="first_agreed_Status" class="form-check-label ">
                            <input type="checkbox" id="first_agreed_Status" name="first_agreed_Status" value="option1" class="form-check-input" value="1">Agreed
                        </label>
                    </div>
                </div>
                
                
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="blisterBtn">Print Label</button>
                
                
            </div>
        </div>
    </div>
</div>
<!-- end modal blister -->
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>
                                
                                Print Label
                                
                            </strong> 
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pending-orders')): ?>
                            <a href="<?php echo e(route('supplier.retrive')); ?>" class="btn btn-info btn-sm float-right">Pending Orders</a>
                                
                            <?php endif; ?>
                            
                        </div>
                        <div class="card-body card-block">
                            <?php if(session('has_error')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session('has_error')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('has_success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('has_success')); ?>

                                </div>
                            <?php endif; ?>
                            
                                <div class="row form-group mb-5">
                                    <div class="col-md-2">
                                        <label for="exampleInputName2" class="pr-1  form-control-label">Supplier Name</label>
                                    </div>
                                    <div class="col-md-3">
                                        <select name="supplier" id="supplier" class="form-control select2" style="width: 50%">
                                            <option value="">Please select</option>
                                            <?php $__empty_1 = true; $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <option value="<?php echo e($supplier->id); ?>"><?php echo e($supplier->supplier_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                </div>
                               
                            
                            <hr>
                            <div class="table-responsive">
                                <table class="table  table-bordered  table-striped table-earning" id="posts" cellspacing="0" width="100%">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Product Detail</th>
                                            <th>Received QTY</th>
                                            <th>Supplier Name</th>
                                            <th>Receive By</th>
                                            <th>Label Status</th>
                                            <th>Action</th>
    
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<script src="<?php echo e(asset('backend/js/jquery.validate.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/js/additional-methods.min.js')); ?>"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript" src="<?php echo e(asset('backend/toast/jquery.toast.min.js')); ?>"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script>
    $('.select2').select2({
        width:'resolve'
    });
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});

    
    var table =$('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "dataSrc": "",
        "pageLength": 50,
        "ajax":{
                    "url": "<?php echo e(route('supplier.label.list')); ?>",
                //  "dataType": "json",
                    "type": "POST",
                    data:function(d){
                    d._token= "<?php echo e(csrf_token()); ?>";
                    d.supplier_id=$('#supplier').val();
                },
                },
        "columnDefs": [
            { "orderable": false, "targets": [2,5,6] },
            { "width": "100%", "targets": [1] },
            { "searchable": false, "targets": [0,2,3,4,5,6] }
        ],
        bSort: false,
        "order": [[ 0, "desc" ]],
        "ordering": true,
        "columns": [
            { "data": "id","name":"product_receiving.id" },
            { "data": "productDetail","name":"productDetail" },
            { "data": "receiving","name":"receiving" },//Order QTY
            { "data": "supplier_name","name":"suppliers.supplier_name" },//Received QTY
            { "data": "name","name":"users.name" },//Received QTY
            { "data": "barcode_id","name":"product_receiving.barcode_id" },//Received QTY
            { "data": "action","name":"action" }
        ],
        createdRow: (row, data, dataIndex, cells) => {
            var status;
            if(data.barcode_id=='0'){
                status='Not Barcode Generated';
            }else{
                status='Barcode Generated';
            }
            $(cells[5]).html('<span class="text-primary text-sm">'+status+'</span>')
        },
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
    });

    

    $('#supplier').on('change',function(){
        $('#posts').DataTable().ajax.reload().draw();
    });


    $('#posts').on('click', 'tbody .blister_btn', function () {
        var data_row=table.row($(this).closest('tr')).data();

        $.ajax({
            url:"<?php echo e(route('supplier.last_receiving')); ?>",
            type:'POST',
            dataType:'JSON',
            data:{
                _token: "<?php echo e(csrf_token()); ?>",
                'receiving_id' : data_row.id,
            },
            success:function(data){
                console.log(data);
                if(data.barcode_id =='0'){
                    $('#blister_qty').val(data.last_receiving);
                    $('#no_of_label').val(1);
                    $('#last_rec').text(data.last_receiving);
                    $('#data_id').val(data_row.id);
                    $('#blisterModal').modal('show');
                }else{
                    $('#blister_qty').val($('#b_qty_'+data_row.id).text());
                    $('#no_of_label').val($('#label_'+data_row.id).text());
                    $('#last_rec').text(data.last_receiving);
                    $('#data_id').val(data_row.id);
                    $('#blisterModal').modal('show');
                    // print_label2(data_row.id)
                }
                
            }
        });
    });

    function print_label2(id){
        $.ajax({
            url:"<?php echo e(route('supplier.view.label')); ?>",
            type:'POST',
            cache: false,
            datatype: 'json',
            data:{
                id:id,
                _token: "<?php echo e(csrf_token()); ?>"
            },
            async: false,
            success:function(data){
                
                if(data.success==true){
                    var w = window.open('about:blank','pos_popup', 'width=900,height=600,menubar=yes,scrollbars=yes,status=no,resizable=yes,screenx=0,screeny=0');
                    w.document.open();
                    w.document.write(data.html);
                    w.document.close();
                    w.print();
                    $('#no_of_label').val('');
                    $('#blister_qty').val('');
                    $('#blisterModal').modal('hide');
                    
                    // $('<html>').html(data.html).print(); 
                }
            }
        });
    }

    $('#blisterBtn').click(function(){
        var id=$('#data_id').val();
        if($('#blister_qty').val() !='' && $('#no_of_label').val() !=''){
            if($('#no_of_label').val() !=''){
                $('#no_of_label').css({'border-color':''});
            } 

            if($('#blister_qty').val() !=''){
                $('#blister_qty').css({'border-color':''});
            }
            
            loader('.modal-body');
            
            $.ajax({
                url:"<?php echo e(route('supplier.check.label')); ?>",
                type:'POST',
                dataType:'JSON',
                data:{
                  id:id,
                  b_qty:$('#blister_qty').val(),
                  no_of_label:$('#no_of_label').val(),
                  _token: "<?php echo e(csrf_token()); ?>"
                },
                success:function(data){
                    loader('.modal-body',0);
                    if(data.same=='1' && data.type=='same'){
                        print_label2(id);
                    }else if(data.same=='0' && data.type=='change'){
                        print_label(id);
                    }
                }
            })
            
        }else{
            $.toast({
                heading: 'Error',
                text: 'All Fields are required',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            if($('#no_of_label').val() ==''){
                $('#no_of_label').css({'border-color':'red'});
            } 

            if($('#blister_qty').val() ==''){
                $('#blister_qty').css({'border-color':'red'});
            }

        }
        
    });
    
    function isNumber(evt) {
        evt = (evt) ? evt : window.event;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode > 31 && (charCode < 48 || charCode > 57)) {
            return false;
        }
        return true;
    }

    function print_label(id){
        
        var val=$('#blister_qty').val();
        var url = '<?php echo e(route("supplier.print.label", ":id")); ?>';
        url = url.replace(':id',id);
        $.ajax({
            url:url,
            type:'POST',
            cache: false,
            datatype: 'json',
            data:{
                receive_qty:val,
                no_of_label:$('#no_of_label').val(),
                type:'printing',
                _token: "<?php echo e(csrf_token()); ?>"
            },
            async: false,
            success:function(data){
                $('#posts').DataTable().ajax.reload().draw();
                if(data.success==true){
                    var w = window.open('about:blank','pos_popup', 'width=900,height=600,menubar=yes,scrollbars=yes,status=no,resizable=yes,screenx=0,screeny=0');
                    
                    w.document.open();
                    w.document.write(data.html);
                    w.document.close();
                    w.print();
                    $('#no_of_label').val('');
                    $('#blister_qty').val('');
                    $('#blisterModal').modal('hide');
                    
                    // $('<html>').html(data.html).print(); 
                }
            }
        });
    }

     
      
</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/miniopex/resources/views/supplier/printing.blade.php ENDPATH**/ ?>