<?php
?>

<?php if($htmlType==1): ?>
<div class="modal fade" id="skuReturnView" tabindex="-1" role="dialog" aria-labelledby="bulkStatusModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="excelModalLabel">SKU Return Comments</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="single_group_id" />
                <div class="table-responsive mt-2 table-responsive-data2">
                    <table class="table  table-bordered  table-striped" id="postsReturn" cellspacing="0" width="100%">
                        <thead class="table-dark" style="color: white">
                            <tr>
                                <th>Variation ID</th>
                                <th>Product Name</th>
                                <th>Reason</th>
                                <th>Customer Comments</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php elseif($htmlType==2): ?>



$(document).on('click','.viewReturnSku',function(){
    let self=$(this);
    let sku =self.data('sku');
    
    $('#single_group_id').val(sku);
    setTimeout(function () {
      $('#postsReturn').DataTable().ajax.reload().draw();
    }, 100);
    
    $('#skuReturnView').modal('show');
});

$('#postsReturn').DataTable({
    processing: true,
    serverSide: true,
    pageLength: 10,
    ajax: {
        url: "<?php echo e(route('sku.returnComments')); ?>",
        type: "POST",
        data: function(d) {
            d._token = "<?php echo e(csrf_token()); ?>";
            d.group_id = $('#single_group_id').val();
            d.child_sku = $('#child_sku:checked').val();
            d.start_date = $("#date_picker").attr("data-start");
            d.end_date = $("#date_picker").attr("data-end");
        },
    },
    columns: [
        { data: "variation_design", name: "variation_design" },
        { data: "name", name: "name" },
        { data: "reason", name: "reason" },
        { data: "customer_comments", name: "customer_comments" }
    ],
    order: [[1, "asc"]],
    ordering: false,
    bSort: false,
    columnDefs: [],
    initComplete: function() {
        // Optional: Custom logic after initialization
    },
    preDrawCallback: function(settings) {
        loader('#postsReturn');
    },
    drawCallback: function(settings) {
        loader('#postsReturn', 0);
    }
});



<?php endif; ?>
<?php /**PATH /home/esireops/public_html/testapp/sampmini/resources/views/sku/skuReturnModal.blade.php ENDPATH**/ ?>