<?php $__env->startSection('title','Bundle List | Mini Opex'); ?>
<?php $__env->startSection('add_css'); ?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- modal color -->
<div class="modal fade" id="bulkStatusModal" tabindex="-1" role="dialog" aria-labelledby="bulkStatusModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="excelModalLabel">Update Status</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label for="text-input" class=" form-control-label">Status </label>
                    <select name="shipment_type" id="shipment_type" class="form-control select2">
                        <option value="">Select Status</option>
                        <option value="1">Active</option>
                        <option value="2">Deactive</option>
                    </select>
                    <input type="hidden" name="bulk_list" id="bulk_list" />
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="updateStatusBtn">Update</button>
            </div>
        </div>
    </div>
</div>
<!-- end modal color -->

<?php echo $__env->make('sku.skuViewModal',['htmlType' => '1','page' => 'bundle'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Bundle </strong> List
                            <div class="float-right">
                                <a href="javascript:;" class="btn btn-dark btn-sm ml-1 bulk_show" id="bulk_update" style="display:none">Update Status</a>&nbsp;
                                <a href="javascript:;" class="btn bg-orange text-dark btn-sm bulk_show" id="bulk_edit" style="display:none">Bulk Edit</a>
                                <a href="javascript:;" class="btn btn-dark btn-sm mr-1 bulk_show" id="bulk_delete" style="display:none">Bulk Delete</a>
                            </div>
                            
                        </div>
                        <div class="card-body card-block">
                            <?php if(session('has_error')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session('has_error')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('has_success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('has_success')); ?>

                                </div>
                            <?php endif; ?>
                            
                            <div class="container custom_filter pt-3 pb-3 border rounded mb-2" id="custom_div">
                                <form action="<?php echo e(route('get_bundle_excel')); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label for="date_picker" class="form-control-label mr-3">Date Picker</label>
                                            <input type="text" id="date_picker" name="date_picker" data-start="" data-end="" placeholder="Date Picker" class="form-control form-control-sm date_picker"> 
                                        </div>
                                    </div>
                                    
                                    <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                        <label  class="form-control-label mr-3">&nbsp;</label>
                                        <div class="form-check">
                                            <input class="form-check-input" id="child_sku" name="child_sku" type="checkbox" value="yes"/>
                                            <label class="form-check-label" for="child_sku">Child SKU Base Sale</label>
                                        </div>
                                    </div>
                            
                                    <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                        <label  class="form-control-label mr-3">&nbsp;</label>
                                        <div class="form-check">
                                            <input class="form-check-input" id="discarded_sku" name="discarded_sku" type="checkbox" value="yes"/>
                                            <label class="form-check-label" for="discarded_sku">With Discarded SKU</label>
                                        </div>
                                    </div>
                                    
                                    <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                                        <label  class="form-control-label mr-3">&nbsp;</label><br>
                                        <button type="button" class="btn btn-dark btn-sm" id="SearchBtn">Search</button>
                                        <button type="submit" class="btn btn-dark btn-sm" id="btn_excel" style="display:none">Download Excel</button>
                                    </div>
                                    <div class="col-md-12 mt-2 ">
                                        <p class="fw-bold text-danger  fs--1">Note : This action will take Atleast 2-3 minutes to complete.</p>
                                    </div>
                                </div>
                                </form>
                            </div>
                            
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" id="posts" cellspacing="0" width="100%">
                                    <thead class="table-dark" style="color: white">
                                        <tr>
                                            <th><input type="checkbox" id="date_check"class="ml-2 date_check bulk_show" style="display:none">&nbsp;Bundle Image</th>
                                            <th>Bundle SKU</th>
                                            <th>Bundle Name</th>
                                            <th>Grade</th>
                                            <th>Total Sale</th>
                                            <th>Decrum InStock</th>
                                            <th>Decrum InBound</th>
                                            <th>Decrum Reserved</th>
                                            <th>Created By</th>
                                            <th>Created Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script>
    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        "dataSrc": "",
        "ajax":{
                    "url": "<?php echo e(route('sku.bundle.list')); ?>",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){
                        d._token= "<?php echo e(csrf_token()); ?>";
                        d.start_date = $("#date_picker").attr("data-start");
                	    d.end_date = $("#date_picker").attr("data-end");
                	    d.child_sku = $('#child_sku:checked').val();
                        d.is_discarded = $('#discarded_sku:checked').val();
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [0] },
            { "searchable": false, "targets": [0,1,2,3,4,5,6,7,8,9] },
        ],
        "order": [[ 1, "desc" ]],
        bSort: false,
        "ordering": false,
        "columns":[
            { "data": "bundleImage","name":"bundleImage" },
            { "data": "bundle_variation","name":"bundle_variation" },
            { "data": "bundleDetail","name":"bundleDetail" },
            { "data": "grade","name":"grade" },
            { "data": "total_sale","name":"total_sale" },
            { "data": "decrum_instock","name":"decrum_instock" },
            { "data": "decrum_inbound","name":"decrum_inbound" },
            { "data": "decrum_reserved","name":"decrum_reserved" },
            { "data": "created_by","name":"created_by" },
            { "data": "created_at","name":"created_at" },
            { "data": "action","name":"action" },
            
        ],
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
    });
    
    ////Bulk Code
    $('#date_check').click(function(){
        if($('#date_check').is(':checked')){
            $('.bulk_id').prop('checked',true);
        }else{
            $('.bulk_id').prop('checked',false);
        }
    });
    
    $('#bulk_update').click(function(){
        var array=[];
        var array_two=[];
        if(confirm('Are you sure want to update status ?')){
            var count=0;
            $('.bulk_id').filter(':checked').filter(function () {
                var selfid=$(this);
                var str=selfid.data('variation');
                var val=selfid.val();
                str = str.substring(0, str.length - 1);
                array.push(str);
                array_two.push(val);
                count=1;
            });
            
            if(count ==0){
                $.toast({
                    heading: 'Error',
                    text: 'Select One Bundle',
                    showHideTransition: 'slide',
                    icon: 'error',
                    position: 'top-center',
                });
                $(document).find('.bulk_id').prop('checked', false);
                return;
            }
            
            if(!AllTheSame(array)){
                $.toast({
                    heading: 'Error',
                    text: 'All Bundle Variations are not same',
                    showHideTransition: 'slide',
                    icon: 'error',
                    position: 'top-center',
                });
                $(document).find('.bulk_id').prop('checked', false);
                return;
            }
            $('#bulk_list').val(array_two.join(';'));
            $('#bulkStatusModal').modal('show');
        }
        
        
        
    });
    
    $('#updateStatusBtn').click(function(){
        var status=$('#shipment_type option:selected').val();
        var id_list=$('#bulk_list').val();
        
        if(status ==''){
            $.toast({
                heading: 'Error',
                text: 'Status is required',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-center',
            });
            return;
        }
        
        $.ajax({
            url:"<?php echo e(route('bulk.bundle.update.status')); ?>",
            type:'POST',
            data:{
                _token: "<?php echo e(csrf_token()); ?>",
                id_list:id_list,
                status: status
            },
            dataType:'JSON',
            success:function(data){
                if(data.code=='200'){
                    $.toast({
                        heading: 'Success',
                        text: 'Bulk Status are updated successfully',
                        showHideTransition: 'slide',
                        icon: 'success',
                        position: 'top-center',
                    });
                    $('#bulkStatusModal').modal('hide');
                    $('#posts').DataTable().ajax.reload().draw();
                    $('#date_check').prop('checked',false);
                }
            }
        })
        
        
    })
    
    
    function AllTheSame(array) {
        var first = array[0];
        return array.every(function(element) {
            return element === first;
        });
    }
    
    $('#SearchBtn').click(function(){
        var start = $("#date_picker").attr("data-start");
        var end = $("#date_picker").attr("data-end");
        var child_sku=$('#child_sku:checked').val();
        
        $('#btn_excel').hide();
        $.ajax({
            "url": "<?php echo e(route('get.sku.sale')); ?>",
            "dataType": "json",
            "type": "POST",
            "data":{
        	    start_date :start,
        	    end_date : end,
        	    child_sku : child_sku,
        	    _token: "<?php echo e(csrf_token()); ?>",
        	    page:'bundleSale'
            },
            success:function(data){
                if(data.code == 200){
                    if($('#child_sku').is(':checked')){
                        $('.bulk_show').show();
                    }else{
                        $('.bulk_show').hide();
                    }
                    
                    $('#posts').DataTable().ajax.reload().draw();
                    $('#btn_excel').show();
                }
            }
        });
        
        
        
    })
    
    $(document).on('click','.active_deactive',function(){
        var self=$(this);
        var sku =self.data('sku');
        var type =self.data('type');
        
        $.ajax({
              url:"<?php echo e(route('sku.bundle.deactive')); ?>",
              type:"POST",
              data:{ 
                _token: "<?php echo e(csrf_token()); ?>",
                  id:sku,
                  type:type
              },
              success:function(data){
                  if(data){
                        $.toast({
                            heading: 'Success',
                            text: 'Status Updated Successfully',
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-center',
                        }); 
                        $('#posts').DataTable().ajax.reload().draw(); 
                  }
              }
          })
        
    });
    
    <?php echo $__env->make('sku.skuViewModal',['htmlType' => '2','page' => 'bundle'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/miniopexpro/resources/views/sku/bundle_list.blade.php ENDPATH**/ ?>