
<?php $__env->startSection('title','Bundle List | Mini Opex'); ?>
<?php $__env->startSection('add_css'); ?>
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- modal color -->
<div class="modal fade" id="bulkStatusModal" tabindex="-1" role="dialog" aria-labelledby="bulkStatusModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="excelModalLabel">Update Status</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label for="text-input" class=" form-control-label">Status </label>
                    <select name="shipment_type" id="shipment_type" class="form-control select2">
                        <option value="">Select Status</option>
                        <option value="1">Active</option>
                        <option value="2">Deactive</option>
                    </select>
                    <input type="hidden" name="bulk_list" id="bulk_list" />
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="updateStatusBtn">Update</button>
            </div>
        </div>
    </div>
</div>
<!-- end modal color -->
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Bundle </strong> List
                            <div class="float-right">
                                <a href="javascript:;" class="btn btn-success btn-sm ml-1" id="bulk_update">Update Status</a>&nbsp;
                                <a href="javascript:;" class="btn btn-info btn-sm" id="bulk_edit">Bulk Edit</a>
                                <a href="javascript:;" class="btn btn-danger btn-sm mr-1" id="bulk_delete">Bulk Delete</a>
                            </div>
                            
                        </div>
                        <div class="card-body card-block">
                            <?php if(session('has_error')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session('has_error')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('has_success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('has_success')); ?>

                                </div>
                            <?php endif; ?>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" id="posts" cellspacing="0" width="100%">
                                    <thead class="table-dark" style="color: white">
                                        <tr>
                                            <th><input type="checkbox" id="date_check"class="ml-2 date_check">&nbsp;Bundle Image</th>
                                            <th>Bundle Name</th>
                                            <th>Variation</th>
                                            <th>Created By</th>
                                            <th>Created Date</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>
<script>
     $('.single_image').featherlight({type: 'image',targetAttr: 'href'});
    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        "dataSrc": "",
        "ajax":{
                    "url": "<?php echo e(route('sku.bundle.list')); ?>",
                //  "dataType": "json",
                    "type": "POST",
                    "data":{ _token: "<?php echo e(csrf_token()); ?>"}
                },
        "columnDefs": [
            { "orderable": false, "targets": [0] },
            { "searchable": false, "targets": [0,2,3,4] },
        ],
        "order": [[ 1, "desc" ]],
        bSort: false,
        "ordering": false,
        "columns":[
            { "data": "bundleImage","name":"bundleImage" },
            { "data": "bundleDetail","name":"bundleDetail" },
            { "data": "variation_qty","name":"bundle.variation_qty" },
            { "data": "name","name":"users.name" },
            { "data": "created_at","name":"created_at" },
            
        ],
        createdRow: (row, data, dataIndex, cells) => {
            $(cells[2]).html('<span class="text-primary text-sm">'+data.variation_qty+'</span>')
        },
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
    });
    
    ////Bulk Code
    $('#date_check').click(function(){
        if($('#date_check').is(':checked')){
            $('.bulk_id').prop('checked',true);
        }else{
            $('.bulk_id').prop('checked',false);
        }
    });
    
    $('#bulk_update').click(function(){
        var array=[];
        var array_two=[];
        if(confirm('Are you sure want to update status ?')){
            var count=0;
            $('.bulk_id').filter(':checked').filter(function () {
                var selfid=$(this);
                var str=selfid.data('variation');
                var val=selfid.val();
                str = str.substring(0, str.length - 1);
                array.push(str);
                array_two.push(val);
                count=1;
            });
            
            if(count ==0){
                $.toast({
                    heading: 'Error',
                    text: 'Select One Bundle',
                    showHideTransition: 'slide',
                    icon: 'error',
                    position: 'top-center',
                });
                $(document).find('.bulk_id').prop('checked', false);
                return;
            }
            
            if(!AllTheSame(array)){
                $.toast({
                    heading: 'Error',
                    text: 'All Bundle Variations are not same',
                    showHideTransition: 'slide',
                    icon: 'error',
                    position: 'top-center',
                });
                $(document).find('.bulk_id').prop('checked', false);
                return;
            }
            $('#bulk_list').val(array_two.join(';'));
            $('#bulkStatusModal').modal('show');
        }
        
        
        
    });
    
    $('#updateStatusBtn').click(function(){
        var status=$('#shipment_type option:selected').val();
        var id_list=$('#bulk_list').val();
        
        if(status ==''){
            $.toast({
                heading: 'Error',
                text: 'Status is required',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-center',
            });
            return;
        }
        
        $.ajax({
            url:"<?php echo e(route('bulk.bundle.update.status')); ?>",
            type:'POST',
            data:{
                _token: "<?php echo e(csrf_token()); ?>",
                id_list:id_list,
                status: status
            },
            dataType:'JSON',
            success:function(data){
                if(data.code=='200'){
                    $.toast({
                        heading: 'Success',
                        text: 'Bulk Status are updated successfully',
                        showHideTransition: 'slide',
                        icon: 'success',
                        position: 'top-center',
                    });
                    $('#bulkStatusModal').modal('hide');
                    $('#posts').DataTable().ajax.reload().draw();
                    $('#date_check').prop('checked',false);
                }
            }
        })
        
        
    })
    
    
    function AllTheSame(array) {
        var first = array[0];
        return array.every(function(element) {
            return element === first;
        });
    }
    
</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/sampmini/resources/views/sku/bundle_list.blade.php ENDPATH**/ ?>