<?php
    $storeList=collect($stores)->pluck('strong_name','id')->toArray();
    
?>


<?php $__env->startSection('title','Process Supplier | Mini Opex'); ?>
<?php $__env->startSection('add_css'); ?>
<?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.datatable-js','data' => ['type' => 'css']]); ?>
<?php $component->withName('datatable-js'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['type' => 'css']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="modal fade" id="adjustModal" tabindex="-1" role="dialog" aria-labelledby="adjustModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="adjustModalLabel">Cancellation</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" id="closebtn">
                    <span aria-hidden="true" >&times;</span>
                </button>
            </div>
            <form  id="item_adjust">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group " id="comment_div">
                        <label for="text-input" class=" form-control-label">Reason </label>
                        <textarea class="form-control" id="comments" name="comments" required></textarea>
                    </div>
                </div>
                
                
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" id="adjustBtn">Cancelled</button>
                
                </div>
            </form>
        </div>
    </div>
</div>
<!-- modal color -->
<div class="modal fade" id="excelModal" tabindex="-1" role="dialog" aria-labelledby="excelModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="excelModalLabel">Create MO Order</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                Download Template: <a href="<?php echo e(asset('backend/purchase_order_format.xlsx')); ?>" download="purchase_order_format.xlsx" class="btn btn-dark btn-sm float-right"><i class="fa fa-download"></i></a>
                <hr>
                <i class="fa fa-spinner fa-spin fa-2x fa-fw " id="loadingspining" style="display: none"></i>

                <div class="form-group ">
                    <label for="text-input" class=" form-control-label">Excel </label>
                    <input type="file" id="file_img" name="file_img"  class="form-control" onchange="ValidateSingleInput(this)">
                    <span class="text-danger text-sm" id="errortxt" style="display: none">Please Upload file in correct format eg excel</span>
                    
                </div>
                <div class="form-group">
                    <label for="text-input" class=" form-control-label">Store </label>
                    <select name="store" id="store" class="form-control select2">
                        <option value="">Select Store</option>
                        <?php $__empty_1 = true; $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <option value="<?php echo e($store->id); ?>"><?php echo e($store->strong_name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            
                        <?php endif; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="text-input" class=" form-control-label">Shipment Type </label>
                    <select name="shipment_type" id="shipment_type" class="form-control select2">
                        <option value="">Select Type</option>
                        <option value="1">Air Cargo</option>
                        <option value="2">Sea Cargo</option>
                    </select>
                </div>
                <div class="form-check">
                    <div class="checkbox">
                        <label for="bulk_po" class="form-check-label ">
                            <input type="checkbox" id="bulk_po" name="bulk_po" value="bulk" class="form-check-input"> BULK
                        </label>
                    </div>
                </div>
                
                <div class="form-check">
                    <div class="checkbox">
                        <label for="awd_po" class="form-check-label ">
                            <input type="checkbox" id="awd_po" name="awd_po" value="bulk" class="form-check-input"> AWD Shipment
                        </label>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-dark btn-sm" id="fileBtn">Add</button>
                
            </div>
        </div>
    </div>
</div>
<!-- end modal color -->
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row ml-2 mr-2 mb-2">
                <div class="col-lg-4 col-md-4 col-sm-12 col-12 mt-1">
                    <div class="statistic__item border_grey bg-grey">
                        <h2 class="number text-white"><span id="total_pending_ex">0</span></h2>
                        <span class="desc text-white">Total Pending</span>
                        <div class="icon text-white">
                            <i class="fas fa-clock-o"></i>
                        </div>
                    </div>
                </div>
                <div class="col-lg-8 col-md-8 col-sm-12 col-12 mt-1">
                    <div class="row custom_filter pt-4 pb-1 border  rounded">
                        <div class="col-lg-6 col-md-6 col-sm-6 col-6">
                            <div class="form-group">
                                <select class="float-right form-control form-control-sm select2" name="pr_list" id="pr_list">
                                    <option value="">Select Mo List</option>
                                    <?php $__currentLoopData = $pr_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $bulk='BULK';
                                            if(preg_match("/{$bulk}/i", strtolower($pr->pr_id))) {
                                                $type="BULK";
                                            }else{
                                                $type=($pr->s_type==1)?'Air Cargo' : 'Sea Cargo';
                                            }
                                            
                                            if(isset($storeList[$pr->store_id])){
                                                $store_text='Store : '.$storeList[$pr->store_id].'&nbsp;&nbsp;|&nbsp;&nbsp;';
                                            }else{
                                                $store_text='';
                                            }
                                            
                                            
                                        ?>
                                        <option value="<?php echo e($pr->pr_id); ?>" >MO: <?php echo e($pr->pr_id); ?>&nbsp;&nbsp;|&nbsp;&nbsp;<?php echo $store_text; ?>Type: <?php echo e($type); ?>&nbsp;&nbsp;|&nbsp;&nbsp;Date: <?php echo e($pr->d_date); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                
                        <div class="col-lg-3 col-md-3 col-sm-6 col-6">
                            <div style="display:none" id="download_div" class="">
                                <a href="javascript:;" id="download_mo_excel" class="btn btn-dark btn-sm"><i class="fas fa-file-excel"></i> Excel</a>
                            </div>
                        </div>
                        
                        <div class="col-lg-3 col-md-3 col-sm-6 col-6">
                            <a href="javascript:;" id="upload_Excel" class="btn bg-orange text-dark btn-sm " data-toggle="modal" data-target="#excelModal"><i class="fas fa-upload"></i> Upload MO</a>
                        </div>
            
                    </div>
                </div>
                
            </div>
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Process Supplier </strong> List
                            <a href="javascript:;" id="assign_qty" class="float-right btn btn-dark btn-sm ml-1 assign_qtn" style="display:none;"><i class="fas fa-check"></i> Assign Quantity</a>
                            
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('process-cancel')): ?>
                            <button type="button" id="cancellation_btn" class="btn btn-danger btn-dark btn-sm ml-5" style="display:none"><i class="fas fa-close"></i> Cancellation</button>
                            <?php endif; ?>
                        </div>
                        <div class="card-body card-block">
                            <?php if(session('has_error')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session('has_error')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('has_success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('has_success')); ?>

                                </div>
                            <?php endif; ?>
                            <form method="POST" id="assign_form">
                                <?php echo csrf_field(); ?>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped" id="posts" cellspacing="0" width="100%">
                                        <thead>
                                            <tr class="thead-light">
                                                <th colspan="6" class="text-right">Total</th>
                                                <th id="instock_total"></th>
                                                <th id="order_total" colspan="2"></th>
                                            </tr>
                                            <tr class="thead-dark">
                                                <th><input type="checkbox" id="date_check2"class="ml-2 date_check2"></th>
                                                <th>Date</th>
                                                <th>Product Image</th>
                                                <th>Product SKU</th>
                                                <th>Product Name</th>
                                                <th>Size</th>
                                                <th>Warehouse Stock</th>
                                                <th>Order Quantity</th>
                                                <th>Select Suppliers</th>
                                            </tr>
                                        </thead>
                                        <tfoot>
                                            <tr><th colspan="6" class="text-right"></th>
                                                <th></th>
                                                <th colspan="2"></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                                
                            </form>
                            <hr>
                            <a href="javascript:;" id="assign_qty2" class="float-right btn btn-dark btn-sm ml-1 mt-1 assign_qtn" style="display:none;"><i class="fas fa-check"></i> Assign Quantity</a>
                    </div>
                    
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
            </div>
    </div>
</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.datatable-js','data' => ['type' => 'js']]); ?>
<?php $component->withName('datatable-js'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['type' => 'js']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

<script>
    var table=$('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        "dataSrc": "",
        fixedHeader: {
            header: true,
            footer: true
        },
        // "deferRender": true,
        "ajax":{
                    "url": "<?php echo e(route('proccess_supplier')); ?>",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){ 
                        d._token= "<?php echo e(csrf_token()); ?>";
                        d.pr_id= $('#pr_list option:selected').val();
                        
                        get_process_count($('#pr_list option:selected').val())
                    }
                },
        "columnDefs": [
            <?php if(!auth()->user()->can('process-cancel')): ?>
                { "targets": [0],visible: false}
            <?php endif; ?>
        ],
        bSort: false,
        "ordering": false,
        "fixedHeader": { 
            "header": true, 
            "footer": true 
        },
        "columns":[
            { "data": "created_at","name":"created_at" },
            { "data": "created_at","name":"created_at" },
            { "data": "created_at","name":"created_at" },
            { "data": "product_img","name":"product_img" },
            { "data": "product_name","name":"product_name" },
            { "data": "size","name":"product_size.size" },
            { "data": "quantity","name":"quantity" },
            { "data": "approve_qtn","name":"approve_qtn" },
            { "data": "options","name":"options" },
        ],
        initComplete: function () {
            $('#posts_filter input').html('form-control');
            
            $('.select2').select2();
            
        },
        "drawCallback": function( settings ) {
            $('.select2').select2();
            loader('#posts',0);
            
            // var info = $('#posts').DataTable().page.info();
            // tot = info.recordsTotal;
            
            // if(tot > 0){
            //     $('#upload_Excel').hide();  
            // }else{
            //     $('#upload_Excel').show();
            // }
            
            var reqSupplier=$('.id_check').filter(':checked').length;
            // console.log(reqSupplier);
            if(reqSupplier >0){
                $('.assign_qtn').show();
            }else{
                $('.assign_qtn').hide();
            }
            
            
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
        
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
 
            
 
            // converting to interger to find total
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            
                    
            var wedTotal = api
                .column( 4 )
                .data()
                .reduce( function (a, b) {
                    b = b.replace(/<\/?[^>]+(>|$)/g, "");
                    return intVal(a) + intVal(b);
                }, 0 );
                    
            var thuTotal = api
                .column( 5 )
                .data()
                .reduce( function (a, b) {
                    b = b.replace(/<\/?[^>]+(>|$)/g, "");
                    b = b.replace('Order QTY : ', "");
                    return intVal(a) + intVal(b);
                }, 0 );
                
                // Update footer by showing the total with the reference of the column index 
                $( api.column( 3 ).footer() ).html('Total');
                $('#instock_total').text(wedTotal);
                $('#order_total').text(thuTotal);
                $("#SelectedOrderQty").text(thuTotal);
                $( api.column( 4 ).footer() ).html(wedTotal);
                $( api.column( 5 ).footer() ).html(thuTotal);
        },
    });
    
    // $('#posts').DataTable().column(0).visible(false);
    // new $.fn.dataTable.FixedHeader( table );
    $('#date_check').click(function(){
        if($('#date_check').is(':checked')){
            $('.id_check').prop('checked',true);
        }else{
            $('.id_check').prop('checked',false);
        }
    })
    
    
    $('#assign_qty').click(function(){
        var reqSupplier=$('.id_check').filter(':checked').length;
        if(reqSupplier ==0){
            row = $('#posts_wrapper tbody tr:first-child');
            $(row).addClass('table-warning');
            $.toast({
                heading: 'Error',
                text: 'Please Select the Supplier',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-center',
            });
            return; 
        }
        var obj= {};
        var array=[];
        var id;
        var count1=1;
        var value = $('.id_check').filter(':checked').filter(function () {
            
            id=$(this).attr('id').split("_")[2];
            count1=check_assign_qty(id);
            obj.pr_id=$('#pr_id_'+id).val();
            obj.assign_qty=$('#assign_qty_'+id).val();
            obj.options=$('#options_'+id).val();
            obj.order_qty=$('#order_qty_'+id).val();
            obj.quantity=$('#quantity_'+id).val();
            obj.variation_id=$('#variation_id_'+id).val();
            if($('#checkbox_'+id).is(':checked')==true){
                obj.checkbox=$('#checkbox_'+id).val();
            }else{
                obj.checkbox=0;
            }
            
            obj.id=id;

            array.push(obj);
            obj={};
            

            if($('#options_'+id).val() == ''){
                $('#error_'+id).show();
                
            }else{
                $('#error_'+id).hide();
                
                
            }
            return $('#options_'+id).val() != '';
        });
        console.log(value.length +'==='+reqSupplier);
        if (value.length>=0 && (value.length !== reqSupplier)) {
            $.toast({
                heading: 'Error',
                text: 'Please Select Supplier',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-center',
            });
        } else if(count1 !=0){
            $.ajax({
                url:"<?php echo e(route('order.assign.quantity')); ?>",
                type:"POST",
                data:{
                    array:array,
                    _token: "<?php echo e(csrf_token()); ?>"
                },
                dataType:'JSON',
                success:function(data){
                    if(data.code=='200'){
                        $.toast({
                            heading: 'Success',
                            text: 'Assign Quantity Successfully',
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-center',
                        });
                        
                        if(data.reload=='YES'){
                            location.reload();
                        }
                        
                        $('#posts').DataTable().ajax.reload().draw();
                        $('#date_check').prop('checked',false);
                    }else{
                        $.toast({
                            heading: 'Error',
                            text: 'Error in Assign Quantity',
                            showHideTransition: 'slide',
                            icon: 'error',
                            position: 'top-center',
                        });
                    }
                }
            })
        }
        
        
    });
    
    $('#posts').on('change','tbody .options',function(){
        var id=$(this).attr('id').split("_")[1];
        var supplier_id=$('#options_'+id+' option:selected').val();
        
        if(supplier_id !=""){
            $('#assign_qty_'+id).show().val('');
            auto_sup_value_assign(id);
            check_assign_qty(id);
        }else{
            if($('.id_check').filter(':checked').length>0){
                $('.assign_qtn').show();
            }else{
                $('.assign_qtn').hide();
            }
            $('#assign_qty_'+id).hide().val(''); 
            $('#error_'+id).hide();
            $('#id_check_'+id).prop('checked',false);
        }
        
        
    })
    
    $('#posts').on('input','tbody .input_order',function(){
        var id=$(this).attr('data-id');
        check_assign_qty(id);
    })
    
    $('#upload_Excel').click(function(){
        $('#file_img').val("");
        $('#store').val("").trigger('change');
        $('#shipment_type').val("").trigger('change');
    })
    
    function auto_sup_value_assign(id){
        var supplier_id=$('#options_'+id+' option:selected').val();
        var instock=parseInt($('#quantity_'+id).val());
        var order_qty=parseInt($('#order_'+id).text());
        var assign_qty=parseInt($('#assign_qty_'+id).val().trim());
        if(supplier_id =='1'){
            if(instock>order_qty){
                $('#assign_qty_'+id).val(order_qty);
            }else if(instock<=order_qty){
                $('#assign_qty_'+id).val(instock);
            }
             //added by sufian 21-2-24
            var store_id=$('#SelectedStore').text();
            if(store_id !='Urban Crest'){
                $('#assign_qty_'+id).prop('readonly',true);
            }
            
            
        }else{
            $('#assign_qty_'+id).val(order_qty);
            $('#assign_qty_'+id).prop('readonly',false);
        }
    }
    
    
    function check_assign_qty(id){
        var supplier_id=$('#options_'+id+' option:selected').val();
        var instock=parseInt($('#quantity_'+id).val());
        var order_qty=parseInt($('#order_'+id).text());
        var assign_qty=parseInt($('#assign_qty_'+id).val().trim());
        
        if(!/^[0-9]+$/.test($('#assign_qty_'+id).val().trim()) || assign_qty ==0){
            $('#error_'+id).text('Assign Quantity  Only Numbers');
            $('#error_'+id).show();
            $.toast({
                heading: 'Error',
                text: 'Assign Quantity Only Numbers',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            $('#id_check_'+id).prop('checked',false);
            $('.assign_qtn').hide();
        }else{
            var qty1=0;
            if(supplier_id =='1'){
                if(assign_qty>instock){
                    $('#error_'+id).text('Assign Quantity is greater than InStock');
                    $('#error_'+id).show();
                    $('.assign_qtn').hide();
                    $.toast({
                        heading: 'Error',
                        text: 'Assign Quantity is greater than InStock',
                        showHideTransition: 'slide',
                        icon: 'error',
                        position: 'top-right',
                    });
                    $('#id_check_'+id).prop('checked',false); 
                    return 0;
                }else{
                    $('#id_check_'+id).prop('checked','checked');
                    $('#error_'+id).hide();
                    $('.assign_qtn').show();
                    return 1;
                }
                
                
            }else{
                if(assign_qty <=order_qty){
                    $('#id_check_'+id).prop('checked','checked');
                    $('#error_'+id).hide();
                    $('.assign_qtn').show();
                    return 1;
                }else{
                    $('#error_'+id).text('Assign Quantity is greater than Order Quantity');
                    $('#error_'+id).show();
                    $('.assign_qtn').hide();
                    $.toast({
                        heading: 'Error',
                        text: 'Assign Quantity is greater than Order Quantity',
                        showHideTransition: 'slide',
                        icon: 'error',
                        position: 'top-right',
                    });
                    $('#id_check_'+id).prop('checked',false); 
                    return 0;
                }  
            }
        }
    }
    
    
    $('#assign_qty2').click(function(){
        $('#assign_qty').click();
    })

    function ValidateSingleInput(oInput) {
        var _validFileExtensions = [".csv", ".xlsx", ".xls"];
        if (oInput.type == "file") {
            var sFileName = oInput.value;
            if (sFileName.length > 0) {
                var blnValid = false;
                for (var j = 0; j < _validFileExtensions.length; j++) {
                    var sCurExtension = _validFileExtensions[j];
                    if (sFileName.substr(sFileName.length - sCurExtension.length, sCurExtension.length).toLowerCase() == sCurExtension.toLowerCase()) {
                        blnValid = true;
                        break;
                    }
                }
                
                if (!blnValid) {
                    $('#errortxt').show();
                    $('#fileBtn').hide();
                    $.toast({
                        heading: 'Error',
                        text: 'Invalid file,allowed only excel file eg '+_validFileExtensions.join(", "),
                        showHideTransition: 'slide',
                        icon: 'error',
                        position: 'top-right',
                    });
                    // alert("Sorry, " + sFileName + " is invalid, allowed extensions are: " + _validFileExtensions.join(", "));
                    oInput.value = "";
                    return false;
                }else{
                    $('#errortxt').hide();
                    $('#fileBtn').show();
                    return true; 
                }
            }
        }
        return true;
    }
    
    $('#bulk_po').click(function(){
        if($('#bulk_po').is(":checked")){
            $("#shipment_type").attr("readonly", "readonly");
        }else{
            $("#shipment_type").removeAttr("readonly");
        }
    });

    $('#fileBtn').click(function(){
        var file_data = $("#file_img").prop("files")[0]; // Getting the properties of file from file field
        var form_data = new FormData(); // Creating object of FormData class
        form_data.append("file_img", file_data) // Appending parameter named file with properties of file_field to form_data
        form_data.append("_token", "<?php echo e(csrf_token()); ?>") // Adding extra parameters to form_data
        form_data.append('store_id',$('#store option:selected').val());
        form_data.append('shipment_type',$('#shipment_type option:selected').val());
        if($('#bulk_po').is(":checked")){
            form_data.append('bulk_po',$('#bulk_po:checked').val());
            form_data.append('shipment_type','1');
        }else{
            form_data.append('bulk_po','NO');
            form_data.append('shipment_type',$('#shipment_type option:selected').val());
        }
        
        
        
        if($('#store option:selected').val() ==''){
            $.toast({
                heading: 'Error',
                text: 'Store are Required',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            return;
        }
        
        if($('#shipment_type option:selected').val() =='' && !$('#bulk_po').is(":checked")){
            $.toast({
                heading: 'Error',
                text: 'Shipment Type are Required',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            return;
        }
        // console.log(form_data);return;
        // ValidateSingleInput($("#file_img"));
        if( $("#file_img")[0].files.length == 0  && $('#store option:selected').val() =='' && $('#shipment_type option:selected').val() ==''){
            // console.log('hello');   
            $.toast({
                        heading: 'Error',
                        text: 'All fields are Required',
                        showHideTransition: 'slide',
                        icon: 'error',
                        position: 'top-right',
                    });
                    return;
        }else{
            $('#loadingspining').show();
            $.ajax({
                url:"<?php echo e(route('order.upload')); ?>",
                type:"POST",
                dataType: 'json',
                cache: false,
                contentType: false,
                processData: false,
                data: form_data, // Setting the data attribute of ajax with file_data
                success:function(data){
                    if(data.error=='1'){
                        $.toast({
                            heading: 'Error',
                            text: data.message,
                            showHideTransition: 'slide',
                            icon: 'error',
                            position: 'top-right',
                        });
                        $('#showAlert').html(`
                        <div class="alert alert-danger">
                          ${data.message}
                        </div>`);
                    }else{
                        $.toast({
                            heading: 'Success',
                            text: data.message,
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-right',
                        });
                        $('#showAlert').html('');
                        
                        
                       
                    }
                    $('#excelModal').modal('hide');
                    $('#loadingspining').hide();
                    $('#file_img').val('');
                    // $('#posts').DataTable().ajax.reload().draw();
                    location.reload();
                }
            });
        }
        
    });

    function checked_approve(id){
        if($('#checkbox_'+id).is(':checked')){
            $('#show_'+id).show();
            $('#warehouse_qtn_'+id).val($('#war_'+id).text());
            $('#supplier_qtn_'+id).val($('#sup_'+id).text());
        }else{
            $('#show_'+id).hide();
            $('#warehouse_qtn_'+id).val(0);
            $('#supplier_qtn_'+id).val($('#approve_'+id).text());

        }
    }
    function loader(id,show=1){
        if(show){
            $(id).css({
                'position':'relative',
            });
            $('<div>',{
                class:'loaderShow bg-info'
            }).css({
                'z-index': '1000','position':'absolute','font-size': '12px',
                'top':'5%','left':'50%','padding':'10px','border-radius':'10px'
            }).prependTo(id)
            .html('<i class="fas fa-spinner fa-pulse fa-3x fa-spin" style="color:white"></i><span class="sr-only">Loading...</span>');
        }else{
            $(id+' .loaderShow').remove();
        }
    }
    
    $('#download_mo_excel').click(function(){
        var mo_id=$('#pr_list option:selected').val();
        var url = '<?php echo e(route("mo.excel", ":id")); ?>';
        url = url.replace(':id',mo_id);
        
        window.location.href=url;
    });
    
    $('#date_check2').click(function(){
        if($('#date_check2').is(':checked')){
            $('.id_check2').prop('checked',true);
            $('#cancellation_btn').show();
            // check_variation_design()
        }else{
            $('.id_check2').prop('checked',false);
            // $('#variation_list').val('');
            $('#cancellation_btn').hide();
        }
    });
    
    $(document).on('change','.id_check2',function(){
       var self=$(this);
       var checked=self.filter(":checked").length;
        //   alert(self);
       
       if(checked>0){
           $('#cancellation_btn').show();
       }else{
           $('#cancellation_btn').hide();
       }
    });
    
    $('#cancellation_btn').click(function(){
        var self=$(this);
        if(confirm('Are you sure Want to Cancel ?')){
            $('#item_adjust').trigger("reset");
            $('#adjustModal').modal('show');
        }
    });
    
    $('#item_adjust').on('submit',function(e){
        
        
        e.preventDefault();
        var formdata=$(this).serializeArray();
        var array=[];
        $('.id_check2').filter(':checked').filter(function(){
            var idSelf=$(this);
            array.push(idSelf.val());
        });
        formdata.push({ name: "id_list", value: array });
        
        console.log(formdata);
        // return;
        
        $.ajax({
            url:"<?php echo e(route('bulk.order.cancellation')); ?>",
            data:formdata,
            type:'POST',
            dataType:'JSON',
            success:function(data){
                if(data.code='200'){
                    $.toast({
                        heading: 'Success',
                        text: 'Product Cancelled Successfully',
                        showHideTransition: 'slide',
                        icon: 'success',
                        position: 'top-center',
                    });
                    $('#adjustModal').modal('hide');
                    $('#item_adjust').trigger("reset");
                    $('#cancellation_btn').hide();
                    $('#date_check2').prop('checked',false);
                    $('#posts').DataTable().ajax.reload().draw();
                }
            }
        })
    });
    
    function get_process_count($pr_id){
        $.ajax({
            url:"<?php echo e(route('get_process_supplier_count')); ?>",
            data:{
                pr_id:$pr_id,
                _token: "<?php echo e(csrf_token()); ?>"
            },
            type:'POST',
            dataType:'JSON',
            success:function(data){
                $('#total_pending_ex').text(data.total_pending);
            }
        })
    }
</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/miniopexpro/resources/views/purchase_order/process_supplier.blade.php ENDPATH**/ ?>