
<?php $__env->startSection('title','Items Log | Mini Opex'); ?>
<?php $__env->startSection('add_css'); ?>
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Items Log </strong> List
                            
                        </div>
                        <div class="card-body card-block">
                            <?php if(session('has_error')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session('has_error')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('has_success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('has_success')); ?>

                                </div>
                            <?php endif; ?>
                            
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="search_variation" class="form-control-label mr-3">Search Variation</label>
                                        <input type="text" id="search_variation" name="search_variation" placeholder="Search Variation" class="form-control form-control-sm"> 
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group float-right">
                                        <label for="search_variation" class="form-control-label mr-3">-</label><br>
                                        <div class="checkbox">
                                            <label for="checkbox1" class="form-check-label ">
                                                <input type="checkbox" id="check_own" name="check_own" value="yes" class="form-check-input" >Check Own
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <label for="date_picker" class="form-control-label mr-3">-</label><br>
                                    <a href="javascript:;" class="btn btn-success btn-sm" id="search_change"><i class="fas fa-search" aria-hidden="true"></i> Search</a>
                                </div>
                                
                                
                            </div>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" id="posts" cellspacing="0" width="100%">
                                    <thead class="table-dark" style="color: white">
                                        <tr>
                                            <th>Product SKU</th>
                                            <th>Product Image</th>
                                            <th>Product Name</th>
                                            <th>Log Detail</th>
                                            <th>Created Date</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>
<script>
     $('.single_image').featherlight({type: 'image',targetAttr: 'href'});
    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        "dataSrc": "",
        "ajax":{
                    "url": "<?php echo e(route('log.item')); ?>",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){ 
                        d._token= "<?php echo e(csrf_token()); ?>";
                        d.variation_design=$('#search_variation').val();
                        
                        if($('#check_own').is(':checked')){
                            d.check_own=1;
                        }else{
                            d.check_own=0;
                        }
                        
                        
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [] },
        ],
        "order": [[ 0, "desc" ]],
        bSort: false,
        "ordering": false,
        "searching": false,
        "columns":[
            { "data": "variation_id","name":"variation_id","width":"10%" },
            { "data": "product_image","name":"product_image","width":"10%" },
            { "data": "product_name","name":"product_name","width":"20%" },
            { "data": "log_detail","name":"log_detail","width":"50%" },
            { "data": "created_date","name":"created_date" },
            
        ],
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
    });
    
    $('#search_change').on('click',function(){
        
        $('#posts').DataTable().ajax.reload().draw();
    });
</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/miniopexpro/resources/views/log/index.blade.php ENDPATH**/ ?>