<!DOCTYPE html>
<html lang="en">
<head>
    <title>Pending Orders | Mini Opex</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="<?php echo e(asset('backend/vendor/bootstrap-4.1/bootstrap.min.css')); ?>" rel="stylesheet" media="all">
    <!-- Jquery JS-->
    <script src="<?php echo e(asset('backend/vendor/jquery-3.2.1.min.js')); ?>"></script>
    <!-- Bootstrap JS-->
    <script src="<?php echo e(asset('backend/vendor/bootstrap-4.1/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/vendor/bootstrap-4.1/bootstrap.min.js')); ?>"></script>
</head>
<body>
  
<div class="container">
  <h1>Pending Orders | Mini Opex</h1>
  <p>
      <span class="text-success">Supplier Name : <strong><?php echo e($supplier_name); ?></strong></span><br>
      <span class="text-dark">Report Date : <strong><?php echo e(date('d-F-Y')); ?></strong></span>
  </p>
</div>

<div class="table-responsive">
  <table class="table table-bordered table-striped">
        <thead class="thead-dark">
            <tr>
                <th>S#</th>
                <th>Assign Date</th>
                <th>Product Image</th>
                <th>Product Detail</th>
                <th>Product Size</th>
                <th>Order QTY</th>
                <th>Receive QTY</th>
                <th>Remaining QTY</th>
                
            </tr>
        </thead>
        <tbody>
            <?php
                $count=1;
                $rec_count=0;
                $recving_count=0;
                $remain_count=0;
            ?>
            <?php $__empty_1 = true; $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($count); ?></td>
                    <td><?php echo e(date('d-F-Y',strtotime($record->assign_date))); ?></td>
                    <td>
                        <?php if($record->product_url !=''): ?>
                            <img src="<?php echo e($record->product_url); ?>" class="rounded" alt="Cinque Terre" width="100" height="100">
                        <?php else: ?>
                            <img src="<?php echo e(asset('uploads/sku_images/'.$record->prod_img)); ?>" class="rounded" alt="Cinque Terre" width="100" height="100">
                        <?php endif; ?>
                    </td>
                    <td>
                        
                        <span class="text-success tdbreak"><?php echo e($record->product_name); ?></span><br>
                        <span class="text-primary text-sm-left">SKU : <strong><?php echo e($record->variation_id); ?></strong></span>
                            
                    </td>
                    <td><?php echo e($record->size); ?></td>
                    <td><?php echo e($record->receive_qty); ?></td>
                    <td><?php echo e($record->receiving_qty); ?></td>
                    <td>
                        <?php
                            $sub=(int)$record->receive_qty-(int)$record->receiving_qty;
                            echo $sub;
                        ?>
                    </td>
                    
                </tr>
                <?php
                    $count++;
                    $rec_count+=$record->receive_qty;
                    $recving_count+=$record->receiving_qty;
                    $remain_count+=$sub;
                ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="8" class="text-center">No Record Found</td>
                </tr>
            <?php endif; ?>
        </tbody>
        <tfoot>
            <tr>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th>Total</th>
                <th><?php echo e($rec_count); ?></th>
                <th><?php echo e($recving_count); ?></th>
                <th><?php echo e($remain_count); ?></th>
            </tr>
        </tfoot>
  </table>
</div>

</body>
</html>
<?php /**PATH /home/esireops/public_html/miniopextest/resources/views/pdf/pending_orders.blade.php ENDPATH**/ ?>