<?php
?>

<?php if($htmlType==1): ?>
<div class="modal fade" id="designModal" tabindex="-1" role="dialog" aria-labelledby="articleModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="designModalLabel">Add New Design</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>
                    <div class="form-group ">
                        <label for="design_name" class=" form-control-label">Design Name </label>
                        <input type="text" id="design_name" name="design_name" placeholder="design_name" class="form-control">
                        <input type="hidden" id="design_id" name="design_id" placeholder="design image id" class="form-control">
                        
                    </div>
                    <div class="form-group ">
                        <label for="dfile_img" class=" form-control-label">Design Image </label>
                        <input type="file" id="dfile_img" name="dfile_img"  class="form-control">
                        <span class="text-danger text-sm" id="derrortxt" style="display: none">Please Upload file in correct format eg Image</span>

                    </div>
                </p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="designBtn">Add</button>
                <button type="button" class="btn btn-primary" id="dupdateBtn" style="display: none">Update</button>
            </div>
        </div>
    </div>
</div>

<!-- modal color -->
<div class="modal fade" id="colorModal" tabindex="-1" role="dialog" aria-labelledby="colorModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="colorModalLabel">Add new Color</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group ">
                    <label for="text-input" class=" form-control-label">Color Name </label>
                    <input type="text" id="color_name" name="color_name" placeholder="color_name" class="form-control">
                    <input type="hidden" id="color_id" name="color_id" placeholder="color image id" class="form-control">

                    
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="colorBtn">Add</button>
                <button type="button" class="btn btn-primary" id="updateBtn" style="display: none">Update</button>
                
                
            </div>
        </div>
    </div>
</div>
<!-- end modal color -->

<!-- modal Segment -->
<div class="modal fade" id="segmentModal" tabindex="-1" role="dialog" aria-labelledby="segmentModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="segmentModalLabel">Add new Segment</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group ">
                    <label for="text-input" class=" form-control-label">Segment Name </label>
                    <input type="text" id="segment_name" name="segment_name" placeholder="segment_name" class="form-control">
                    <input type="hidden" id="segment_id" name="segment_id" placeholder="color image id" class="form-control">

                    
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="segmentBtn">Add</button>
                <button type="button" class="btn btn-primary" id="updateSegmentBtn" style="display: none">Update</button>
            </div>
        </div>
    </div>
</div>
<!-- end modal Segment -->

<!-- modal Segment -->
<div class="modal fade" id="articleModal"  role="dialog" aria-labelledby="article2ModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="article2ModalLabel">Add new Article</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group ">
                    <label for="text-input" class=" form-control-label">Article Name </label>
                    <input type="text" id="article_name" name="article_name" placeholder="article_name" class="form-control">
                    <input type="hidden" id="article_id" name="article_id" placeholder="color image id" class="form-control">

                    
                </div>
                
                <div class="form-group">
                    <label for="select" class=" form-control-label mt-1">Segment Name<span class="text-danger">*</span></label>
                    <select name="segment_id_article" id="segment_id_article" class="form-control select2">
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="articleBtn">Add</button>
                <button type="button" class="btn btn-primary" id="updateArticleBtn" style="display: none">Update</button>
            </div>
        </div>
    </div>
</div>
<!-- end modal Segment -->

<?php elseif($htmlType==2): ?>
$('#dupdateBtn').click(function(){
    var color_name=$('#design_name').val();
    var file_data = $("#dfile_img").prop("files")[0];
    var form_data = new FormData();
    var isalpha = /[^a-zA-Z]/.test(color_name);
    form_data.append("dfile_img", file_data);
    form_data.append("_token", "<?php echo e(csrf_token()); ?>");
    form_data.append("design_name", color_name);
    form_data.append("id", $('#design_id').val());
    $.ajax({
        url:"<?php echo e(route('sku.design.edit')); ?>",
        type:'POST',
        cache: false,
        contentType: false,
        processData: false,
        data:form_data,
        success:function(data){
            $('#posts').DataTable().ajax.reload().draw();
            toastMsg('Design Updated Successfully');
            $('#designModal').modal('hide');
        }
    })
});
    
function modalDesignRefresh(add=1,data={}){
    $('#derrortxt').hide();
    $('#dfile_img').val('');
    
    if(add){
        $('#designModalLabel').text('Add new Design');
        $('#design_name').val('');
        $('#derrortxt').hide();
        $('#dupdateBtn').hide();
        $('#designBtn').show();
    }else{
        $('#designModalLabel').text('Update Design');
        $('#design_name').val(data.design_title);
        $('#design_id').val(data.id);
        $('#dupdateBtn').show();
        $('#designBtn').hide();
    }
    
}

$('#designBtn').click(function(){
    var file_data = $("#dfile_img").prop("files")[0];
    var form_data = new FormData();
    var isalpha = /[^a-zA-Z]/.test($('#design_name').val());
    form_data.append("dfile_img", file_data);
    form_data.append("_token", "<?php echo e(csrf_token()); ?>");
    form_data.append("input", $('#design_name').val());
    if($('#design_name').val()!=''){
        $.ajax({
            url:"<?php echo e(route('add.design')); ?>",
            type:'POST',
            cache: false,
            contentType: false,
            processData: false,
            dataType:'JSON',
            data: form_data,
            success:function(data){
                if(data.error !='1'){
                    toastMsg(data.msg);
                    
                    $("#design").append("<option value='"+data.id+"' selected>"+data.text+"</option>");
                    $('#design').trigger('change');
                    
                    modalDesignRefresh();
                    $('#designModal').modal('hide');  
                }else{
                    toastMsg(data.msg,2);
                }
            }
            
        })
    }else{
        toastMsg('Accepts Only Alphabats',2);
    }
    
})

$('#showDesign').click(function(){
    modalDesignRefresh()
    $('#designModal').modal('show');  
});

$(document).on('change','#dfile_img',function(){
    var self=$(this);
    var label=$('#designModalLabel').text();
    
    var btn='#designBtn';
    if(label =='Update Design'){
        btn='#dupdateBtn';
    }
    ValidateSingleInput(this,'#errortxt',btn,'jpg,png,jpeg');
})

///Color Add
$('#colorBtn').click(function(){
    var color_name=$('#color_name').val();
    var form_data = new FormData();
    // var isalpha = /^[a-zA-Z ]{2,30}$/.test(color_name);
    var isalpha = 1;
    console.log(isalpha);
    form_data.append("_token", "<?php echo e(csrf_token()); ?>");
    form_data.append("input", color_name);
    form_data.append("id", $('#color_id').val());
    form_data.append("type", 1);
    if(isalpha && color_name!=''){
        $.ajax({
            url:"<?php echo e(route('sku.add.new')); ?>",
            type:"POST",
            cache: false,
            contentType: false,
            processData: false,
            data: form_data,
            success:function(data){
                if(data !='0'){
                    toastMsg('Added in Color Success Successfully');
                    $('#colorModal').modal('hide'); 
                    
                    modalColorRefresh();
                    $("#color").append("<option value='"+data+"' selected>"+color_name+"</option>");
                    $('#color').trigger('change');
                }else{
                    toastMsg('Already Exist in Color',2);
                }
            }
        })
    }else{
        toastMsg('Accepts Only Alphabats',2);
    }
    
});

function modalColorRefresh(add=1,data={}){
    if(add){
        $('#colorModalLabel').text('Add new Color');
        $('#color_name').val('');
        $('#updateBtn').hide();
        $('#colorBtn').show();
    }else{
        $('#colorModalLabel').text('Update Color');
        $('#color_name').val(data.color);
        $('#color_id').val(data.id);
        $('#updateBtn').show();
        $('#colorBtn').hide();
    }
    
}


$('#showColor').click(function(){
    modalColorRefresh();
    $('#colorModal').modal('show');
})

$('#updateBtn').click(function(){
    var color_name=$('#color_name').val();
    var form_data = new FormData();
    var isalpha = /[^a-zA-Z]/.test(color_name);
    form_data.append("_token", "<?php echo e(csrf_token()); ?>");
    form_data.append("color_name", color_name);
    form_data.append("id", $('#color_id').val());
    
    if(color_name!=''){
        $.ajax({
            url:"<?php echo e(route('sku.color.edit')); ?>",
            type:'POST',
            cache: false,
            contentType: false,
            processData: false,
            data:form_data,
            success:function(data){
                toastMsg('Color Updated Successfully');
                $('#colorModal').modal('hide');
                $('#posts').DataTable().ajax.reload().draw(); 
            }
        })
    }else{
        toastMsg('Accepts Only Alphabats And Max length 20',2);
    }
 
});

function modalSegmentRefresh(add=1,data={}){
    if(add){
        $('#segmentModalLabel').text('Add new Segment');
        $('#segment_name').val('');
        $('#updateSegmentBtn').hide();
        $('#segmentBtn').show();
    }else{
        $('#segmentModalLabel').text('Update Segment');
        $('#segment_name').val(data.name);
        $('#segment_id').val(data.id);
        $('#updateSegmentBtn').show();
        $('#segmentBtn').hide();
    }
    
}


$('#showSegment').click(function(){
    modalSegmentRefresh();
    $('#segmentModal').modal('show');
})

$('#segmentBtn').click(function(){
    var segment_name=$('#segment_name').val();
    var form_data = new FormData();
    // var isalpha = /^[a-zA-Z ]{2,30}$/.test(segment_name);
    var isalpha = 1;
    form_data.append("_token", "<?php echo e(csrf_token()); ?>");
    form_data.append("segment_name", segment_name);
    form_data.append("segment_id", 0);
    form_data.append("type", 1);
    if(isalpha && segment_name!=''){
        $.ajax({
            url:"<?php echo e(route('sku.add_new_segment')); ?>",
            type:"POST",
            cache: false,
            contentType: false,
            processData: false,
            data: form_data,
            dataType:'JSON',
            success:function(data){
                if(data.code =='200'){
                    toastMsg(data.message);
                    $('#segmentModal').modal('hide'); 
                    
                    modalSegmentRefresh();
                    $("#segment").append("<option value='"+data.id+"' selected>"+segment_name+"</option>");
                    $('#segment').trigger('change');
                }else{
                    toastMsg(data.message,2);
                }
            }
        })
    }else{
        toastMsg('Accepts Only Alphabats',2);
    }
    
});

function modalArticleRefresh(add=1,data={}){
    getSegment()
    if(add){
        $('#article2ModalLabel').text('Add new Article');
        $('#article_name').val('');
        $('#updateArticleBtn').hide();
        $('#articleBtn').show();
    }else{
        $('#article2ModalLabel').text('Update Article');
        $('#article_name').val(data.name);
        $('#article_id').val(data.id);
        $('#updateArticleBtn').show();
        $('#articleBtn').hide();
    }
    
}

function getSegment(){
    $.ajax({
        url:"<?php echo e(route('sku.add_new_articles')); ?>",
        type:"POST",
        data: {
            _token:"<?php echo e(csrf_token()); ?>",
            type:'3',
        },
        dataType:'JSON',
        success:function(data){
            if(data.code =='200'){
                $('#segment_id_article').html(data.id);
                $('#segment_id_article').trigger('change.select2');
            }else{
                toastMsg(data.message,2);
            }
        }
    })
    
}


$('#showArticle').click(function(){
    modalArticleRefresh();
    $('#articleModal').modal('show');
})

$('#articleBtn').click(function(){
    var article_name=$('#article_name').val();
    var segment_id=$('#segment_id_article').val();
    var form_data = new FormData();
    // var isalpha = /^[a-zA-Z ]{2,30}$/.test(article_name);
    var isalpha = 1;
    form_data.append("_token", "<?php echo e(csrf_token()); ?>");
    form_data.append("article_name", article_name);
    form_data.append("article_id", 0);
    form_data.append("segment_id", segment_id);
    form_data.append("type", 1);
    if(isalpha && article_name!=''){
        $.ajax({
            url:"<?php echo e(route('sku.add_new_articles')); ?>",
            type:"POST",
            cache: false,
            contentType: false,
            processData: false,
            data: form_data,
            dataType:'JSON',
            success:function(data){
                if(data.code =='200'){
                    toastMsg(data.message);
                    $('#articleModal').modal('hide'); 
                    
                    modalArticleRefresh();
                    $("#article").append("<option value='"+data.id+"' selected>"+article_name+"</option>");
                    $('#article').trigger('change');
                    
                    $('#segment').val(segment_id).trigger('change');
                }else{
                    toastMsg(data.message,2);
                }
            }
        })
    }else{
        toastMsg('Accepts Only Alphabats',2);
    }
    
});

<?php endif; ?>
<?php /**PATH /home/esireops/public_html/miniopexpro/resources/views/sku/allModal.blade.php ENDPATH**/ ?>