
<?php $__env->startSection('title','Users | Mini Opex'); ?>
<?php $__env->startSection('add_css'); ?>
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">
<style>
    .select2-container--default {
        z-index: 99999 !important;
    }
    
    /* Fix positioning inside modal */
    .modal .select2-container--default .select2-dropdown {
        z-index: 99999 !important;
    }
</style>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="modal fade" id="articleModal"  role="dialog" aria-labelledby="articleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="articleModalLabel">Add New User</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?php echo e(route('sku.store')); ?>" method="post" enctype="multipart/form-data" class="form-horizontal" id="form_id">
            <div class="modal-body">
                <form  method="post" class="form-horizontal" id="form_id">
                    <?php echo csrf_field(); ?>
                    <p>
                        <div class="form-group ">
                            <label for="user_name" class=" form-control-label">User Name</label>
                            <input type="hidden" id="user_id" name="user_id"  class="form-control">

                            <input type="text" id="user_name" name="user_name" placeholder="enter your name" class="form-control">
                            
                        </div>
                        <div class="form-group ">
                            <label for="user_email" class=" form-control-label">User Email</label>
                            <input type="email" id="user_email" name="user_email" placeholder="enter your email" class="form-control">
                            <label id="unameerror" class="text-danger" style="display: none">Email Already Exists</label>
                        </div>
                        <div class="form-group ">
                            <label for="password" class=" form-control-label">Password</label>
                            <input type="password" id="password" name="password" placeholder="......." class="form-control">
                        </div>
                        <div class="form-group ">
                            <label for="confirm_password" class=" form-control-label">Confirm Password</label>
                            <input type="password" id="confirm_password" name="confirm_password" placeholder="......." class="form-control">
                        </div>
                        <div class="form-group">
                            <label for="role_name" class="  form-control-label">User Role</label>
                            <select name="role_name" id="role_name" class="form-control select2">
                                <option value="">Please select</option>
                                <?php $__empty_1 = true; $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <option value="<?php echo e($name); ?>"><?php echo e($name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    
                                <?php endif; ?>
                            </select>
                            
                        </div>
                    </p>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="typeBtn">Add</button>
                <button type="button" class="btn btn-primary" id="updateBtn" style="display: none">Update</button>

                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                
            </div>
        </div>
    </div>
</div>
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Users </strong> List
                            <a href="javascript:;" class="btn btn-info btn-sm float-right" data-toggle="modal" data-target="#articleModal" id="showArticle"><i class="fas fa-plus"></i> Add New User</a>
                        </div>
                        <div class="card-body card-block">
                            <?php if(session('has_error')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session('has_error')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('has_success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('has_success')); ?>

                                </div>
                            <?php endif; ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-earning table-bordered" id="posts" cellspacing="0" width="100%">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Role</th>
                                            <th>Created Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                    </div>
                    
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<script src="<?php echo e(asset('backend/js/jquery.validate.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/js/additional-methods.min.js')); ?>"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<!--<script src="//code.jquery.com/jquery-latest.js"></script>-->
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>


<script>
     var validate=$('#form_id').validate({
        errorClass:'text-danger',
        success:'text-success',
        errorElement: 'span',
        ignore: ".ignore",
        rules:{
            user_name: {
                required: true,
                lettersonly:true
            },
            user_email:{
                required:true,
                email:true
            },
            password:{
                required:true,
                minlength: 6
            },
            confirm_password:{
                required:true,
                minlength: 6,
                equalTo:"#password"
            },
            role_name:{
                required:true
            },
            
            
        },
        messages:{
            user_name:{
                required:"User Name is required",
                lettersonly:"User Name accepts only Alphabats"
            },
            user_email:{
                required:"User Email is required",
                email: "Email is not in good formate"
            },
            password:{
                required:"Password is required",
                minlength:"Password minimum length is 6"
            },
            confirm_password:{
                required:"Confirm Password is required",
                minlength:"Confirm Password minimum length is 6",
                equalTo:"Password Does not Match"
            },
            role_name:{
                required:"User Role is required"
            },
        },
        highlight: function(element, errorClass, validClass) {
            $(element).closest('.form-control').addClass('has-warning');
        },
        unhighlight: function(element, errorClass, validClass) {
            $(element).closest('.form-group').removeClass('has-error');
        },
        errorPlacement: function (error, element) {
            
            if(element.hasClass('select2') && element.next('.select2-container').length) {
                error.insertAfter(element.next('.select2-container'));
            }else{
                error.insertAfter(element);
            }
        },
    });
    
    jQuery.validator.addMethod("lettersonly", function(value, element) {
          return this.optional(element) || /^[a-zA-Z]+(([',. -][a-zA-Z ])?[a-zA-Z]*)*$/i.test(value);
        }, "Letters only please");
    
    $('#user_email').blur(function(){
            var val=$('#user_email').val();
            var data;
            if($('#user_id').val() !=''){
                data={
                   _token: "<?php echo e(csrf_token()); ?>",
                    email:val,
                    id:$('#user_id').val()
                };
            }else{
                data={
                   _token: "<?php echo e(csrf_token()); ?>",
                    email:val
                };
            }
            if(val !=''){
                $.ajax({
                    url:"<?php echo e(route('users.check_email')); ?>",
                    type:'POST',
                    dataType: "html",
                    data:data,
                    success:function(data){
                        console.log(data);
                        if(data ==1){
                            $('#unameerror').show();
                            if($('#user_id').val() !=''){
                                $('#updateBtn').hide();
                            }else{
                                $('#typeBtn').hide();
                            }
                            
                        }else{
                            $('#unameerror').hide();
                            if($('#user_id').val() !=''){
                                $('#updateBtn').show();
                            }else{
                                $('#typeBtn').show();
                            }
                        }
                    }
                });
            }
        })
    
    
    
    $('#typeBtn').click(function(){
        if($('#form_id').valid()){
            $.ajax({
                url:"<?php echo e(route('users.store')); ?>",
                type:'POST',
                data:$('#form_id').serialize(),
                success:function(data){
                    if(data==1){
                        $.toast({
                            heading: 'Success',
                            text: "User Added Successfully",
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-right',
                        });
                        $('#form_id').trigger("reset");
                        $('#articleModal').modal('hide');
                        $('#posts').DataTable().ajax.reload().draw();
                    }
                }

            })
        }else{
            $.toast({
                heading: 'Error',
                text: 'All fields are required',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
        }
    });
    

    $('#posts').on('click', 'tbody .delete_btn', function () {
        if(confirm('Are You Sure Want to delete?')){
            var data_row = table.row($(this).closest('tr')).data();
            var url="<?php echo e(route('users.destroy',':id')); ?>",
            url = url.replace(':id', data_row.id);
            $.ajax({
                url:url,
                type:'POST',
                data:{
                    _token: "<?php echo e(csrf_token()); ?>"
                },
                success:function(data){
                    if(data==1){
                        $.toast({
                            heading: 'Success',
                            text: "User Deleted Successfully",
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-right',
                        });
                        $('#posts').DataTable().ajax.reload().draw();
                    }
                },
            })

        }
    });

    $('#showArticle').click(function(){
        $('#articleModalLabel').text('Add new User');
        $('#user_name').val('');
        $('#user_email').val('');
        $('#form_id').trigger("reset");
        validate.resetForm();
        $('#password').removeClass('ignore');
        $('#confirm_password').removeClass('ignore');
        $('#user_id').val('');
        $('#role_name').val('');
        $('#typeBtn').show();
        $('#updateBtn').hide();
        $('#articleModal').modal('show');
        
    })

    $('#posts').on('click', 'tbody .edit_btn', function () {
        var data_row = table.row($(this).closest('tr')).data();
        $('#form_id').trigger("reset");
        validate.resetForm();
        $('#articleModalLabel').text('Edit User');
        $('#user_name').val(data_row.name);
        $('#user_email').val(data_row.email);
        var ret = data_row.role_name.replace('<label class=\"badge badge-success\">','');
        var ret=ret.replace('</label>','');
        $('#password').addClass('ignore');
        $('#confirm_password').addClass('ignore');
        $('#user_id').val(data_row.id);
        $('#role_name').val(ret).trigger('change');
        $('#typeBtn').hide();
        $('#updateBtn').show();
        $('#articleModal').modal('show');
                
    });

    $('#updateBtn').click(function(){
        var val=$('#user_id').val();
        var url="<?php echo e(route('users.edit',':id')); ?>",
        url = url.replace(':id', val);
        if($('#form_id').valid()){
            $.ajax({
                url:url,
                type:'POST',
                data:$('#form_id').serialize(),
                success:function(data){
                    if(data==1){
                        $.toast({
                            heading: 'Success',
                            text: "User updated Successfully",
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-right',
                        });
                        $('#form_id').trigger("reset");
                        $('#articleModal').modal('hide');
                        $('#posts').DataTable().ajax.reload().draw();
                    }
                }

            })
        }else{
            $.toast({
                heading: 'Error',
                text: 'All fields are required',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
        }
    });



    $.fn.dataTable.ext.errMode = 'none';
   var table =$('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        "dataSrc": "",
        "ajax":{
                    "url": "<?php echo e(route('users')); ?>",
                //  "dataType": "json",
                    "type": "POST",
                    data:function(d){
                    d._token= "<?php echo e(csrf_token()); ?>";
                },
                },
        "columnDefs": [
            { "orderable": false, "targets": [0,2,3] },
            { "orderable": true, "targets": [1] },
            {"searchable":false,"targets":[4,5]}
        ],
        bSort: false,
        "ordering": false,
        "columns": [
            { "data": "id","name":"id" },
            { "data": "name","name":"name" },
            { "data": "email","name":"email" },
            { "data": "role_name","name":"role_name" },//Order QTY
            { "data": "created_at","name":"created_at" },//Received QTY
            { "data": "action","name":"action" },//Remaining QTY
        ],
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
    });

    function loader(id,show=1){
        if(show){
            $(id).css({
                'position':'relative',
            });
            $('<div>',{
                class:'loaderShow bg-info'
            }).css({
                'z-index': '1000','position':'absolute','font-size': '12px',
                'top':'5%','left':'50%','padding':'10px','border-radius':'10px'
            }).prependTo(id)
            .html('<i class="fas fa-spinner fa-pulse fa-3x fa-spin" style="color:white"></i><span class="sr-only">Loading...</span>');
        }else{
            $(id+' .loaderShow').remove();
        }
    }

    

        
    

    
</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/miniopexpro/resources/views/users/index.blade.php ENDPATH**/ ?>