<?php

$qc_type=[
    1 => 'Intial QC',
    2 => 'Final QC'
];

$qtype=json_encode($qc_type,true);

$variation_type=[
    1 => 'Tshirts / Legging',
    2 => 'Varsity',
    3 => 'Print'
];

$vtype=json_encode($variation_type,true);

$slist=collect($suppliers)->pluck('supplier_name','id')->toArray();
$slist=json_encode($slist,true);

?>


<?php $__env->startSection('title','QC ScoreCard | Mini Opex'); ?>
<?php $__env->startSection('add_css'); ?>
    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.datatable-js','data' => ['type' => 'css']]); ?>
<?php $component->withName('datatable-js'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['type' => 'css']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- modal color -->
<div class="modal fade" id="addQCListModal" tabindex="-1" role="dialog" aria-labelledby="addQCListModalLabel" aria-hidden="true" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addQCListModalLabel">Add QC Checking</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="addQCListForm">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-6 col-6">
                                    <div class="form-group">
                                        <label for="date_picker2" class="form-control-label mr-3">Date Picker</label>
                                        <input type="date" id="date_picker2" name="date_picker" placeholder="Date Picker" class="form-control form-control-sm" value="<?php echo e(date('Y-m-d')); ?>" required> 
                                    </div>
                                </div>
                                
                                <div class="col-lg-4 col-md-4 col-sm-6 col-6">
                                    <div class="form-group">
                                        <label for="qc_type" class="form-control-label" >QC Type</label>
                                        <select name="qc_type" id="qc_type" class="form-control form-control-sm select2" style="width: 100% !important" required>
                                            <option value="">Select QC Type</option>
                                            <?php $__empty_1 = true; $__currentLoopData = $qc_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $qt => $q): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <option value="<?php echo e($qt); ?>"><?php echo e($q); ?></option>
                                                
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <?php endif; ?>
                                            
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-4 col-md-4 col-sm-6 col-6">
                                    <div class="form-group">
                                        <label for="variation_type" class="form-control-label" >Variation Type</label>
                                        <select name="variation_type" id="variation_type" class="form-control form-control-sm select2" style="width: 100% !important" required>
                                            <option value="">Select Variation Type</option>
                                            
                                            <?php $__empty_1 = true; $__currentLoopData = $variation_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vt => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <option value="<?php echo e($vt); ?>"><?php echo e($v); ?></option>
                                                
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <?php endif; ?>
                                            
                                            
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-4 col-md-4 col-sm-6 col-6">
                                    <div class="form-group">
                                        <label for="qc_id" class="form-control-label" >QC Person</label>
                                        <select name="qc_id" id="qc_id" class="form-control form-control-sm select2" style="width: 100% !important" required>
                                            <option value="">Please select</option>
                                            <?php $__empty_1 = true; $__currentLoopData = $qc_person; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $qc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <option value="<?php echo e($qc->id); ?>"><?php echo e($qc->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        
                        <div class="col-lg-12 col-md-12 col-sm-12 col-12" id="supShow" style="display:none">
                            <hr>
                            <div class="form-group">
                                <label for="supplier" class="form-control-label" >Supplier Name</label>
                                <select name="supplier" id="supplier" class="form-control form-control-sm select2" style="width: 100% !important">
                                    <option value="">Please select</option>
                                    <?php $__empty_1 = true; $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <option value="<?php echo e($supplier->id); ?>"><?php echo e($supplier->supplier_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-lg-4 col-md-4 col-sm-6 col-6">
                            <div class="form-group">
                                <label for="ok_stock" class="form-control-label mr-3">OK Stock</label>
                                <input type="text" id="ok_stock" name="ok_stock" placeholder="74" class="form-control form-control-sm stock_total" value="0"> 
                            </div>
                        </div>
                        
                        <div class="col-lg-4 col-md-4 col-sm-6 col-6">
                            <div class="form-group">
                                <label for="alter_stock" class="form-control-label mr-3">Alter Stock</label>
                                <input type="text" id="alter_stock" name="alter_stock" placeholder="74" class="form-control form-control-sm stock_total" value="0"> 
                            </div>
                        </div>
                        
                        <div class="col-lg-4 col-md-4 col-sm-6 col-6">
                            <div class="form-group">
                                <label for="total_stock" class="form-control-label mr-3">Total</label>
                                <input type="text" id="total_stock" name="total_stock" placeholder="74" class="form-control form-control-sm" readonly value="0"> 
                            </div>
                        </div>
                        
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-dark btn-sm" id="update">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- end modal color -->

<div class="modal fade" id="qcListModal" tabindex="-1" role="dialog" aria-labelledby="qcListModalLabel" aria-hidden="true" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="qcListModalLabel">QC Date List</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            
            <div class="modal-body">
                <div id="tblHtml"></div>
            </div>
            
        </div>
    </div>
</div>

<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>QC</strong> ScoreCard
                            <a href="javascript:;" id="updateQc" class="btn bg-orange text-dark btn-sm float-right" data-toggle="modal" data-target="#addQCListModal"> Update QC Check</a>
                        </div>
                        <div class="card-body card-block">
                            <?php if(session('has_error')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session('has_error')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('has_success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('has_success')); ?>

                                </div>
                            <?php endif; ?>
                            
                            <div class="row">
                                <div class="col-lg-3 col-md-3 col-sm-6 col-6">
                                    <div class="form-group">
                                        <label for="date_picker" class="form-control-label mr-3">Date Picker</label>
                                        <input type="text" id="date_picker" name="date_picker" placeholder="Date Picker" class="form-control form-control-sm dpicker" data-start='' data-end=''> 
                                    </div>
                                </div>
                                
                                <div class="col-md-2">
                                    <label for="date_picker" class="form-control-label mr-3">&nbsp;</label><br>
                                    <a href="javascript:;" class="btn btn-dark btn-sm" id="search_change"><i class="fas fa-search" aria-hidden="true"></i> Search</a>
                                </div>
                            </div>
                            <hr>
                            <div id="data_html"></div>
                    </div>
                    
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.datatable-js','data' => ['type' => 'js']]); ?>
<?php $component->withName('datatable-js'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['type' => 'js']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<script>
    // var start = moment().subtract(29, 'days');
   
    var start = moment();
    var end = moment();
    var date_options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
    var today = new Date().toLocaleDateString('en-UK',date_options);


    function cb(start, end) {
        $('.dpicker span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        $("#date_picker").attr("data-start",start.format('YYYY-MM-DD'));
        $("#date_picker").attr("data-end",end.format('YYYY-MM-DD'));
    }

    $('.dpicker').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
        'Today': [moment(), moment()],
        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
        'This Month': [moment().startOf('month'), moment().endOf('month')],
        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    }, cb);

    cb(start, end);
    

    $('.select2').select2({
        width: '100%',
        dropdownParent: $("#addQCListModal")
    });
    
    $('#qc_type').change(function(){
        var self=$(this);
        
        var val=self.val();
        
        if(val ==1){
            $('#supShow').show();
        }else{
            $('#supShow').hide();
        }
    })
    
    $(document).on('input', '.stock_total', function () {
        var total = 0;
    
        $('.stock_total').each(function () {
            var value = parseInt($(this).val());
            if (!isNaN(value)) {
                total += value;
            }
        });
    
        $('#total_stock').val(total);
    });
    
    $(document).on('submit','#addQCListForm',function(e){
        e.preventDefault();
        
        var self=$(this);
        var total=$('#total_stock').val();
        
        var qc_type=$('#qc_type').val();
        var supplier=$('#supplier').val();
        if(qc_type==1 && supplier ==''){
            toastMsg('Please Select Supplier',2)
            return false;
        }
        
        if(total !='0'){
            $.ajax({
                url:"<?php echo e(route('addQcCheckList')); ?>",
                type:'PoST',
                data:self.serialize(),
                dataType:'JSON',
                success:function(data){
                    if(data.code=='200'){
                        self.trigger('reset');
                        $(".select2").val('').trigger('change');
                        $('#supShow').hide();
                        toastMsg('QC Checking Added Successfully');
                        // $('#addQCListModal').modal('hide');
                    }
                }
            })
            
            // console.log(self.serialize());
        }else{
            toastMsg('Total QC Checked Stock is Zero Please Update',2)
            return false;
        }
    });
    
    $(document).on('click','#search_change',function(){
        var start_date=$('#date_picker').attr('data-start');
        var end_date=$('#date_picker').attr('data-end');
        
        $.ajax({
            url:"<?php echo e(route('qcScoreCard')); ?>",
            type:"POST",
            data:{
                start_date:start_date,
                end_date:end_date,
                _token:"<?php echo e(csrf_token()); ?>",
            },
            dataType:'JSON',
            success:function(data){
                if(data.code=='200'){
                    stats(data.list.totalCount,data.list.ListTbl)
                }
            }
        })
        
    });
    
    $(document).on('click','.qcDate',function(){
        var self=$(this);
        var qc_date=self.attr('data-qc_date');
        var qc_id=self.attr('data-qc_id');
        var qc_name=self.attr('data-qc_name');
        
        $.ajax({
            url:"<?php echo e(route('getDateData')); ?>",
            type:"POST",
            data:{
                qc_date:qc_date,
                qc_id:qc_id,
                _token:"<?php echo e(csrf_token()); ?>",
            },
            dataType:'JSON',
            success:function(data){
                var html='';
                if(data.code =='200'){
                    html=specific_date(data.data,qc_name);
                }else{
                    html=`<div class="alert alert-danger">No Record Found</div>`;
                }
                
                $('#tblHtml').html(html);
                $('#qcListModal').modal('show');
            }
        })
        
    });
    
    var isset = function(variable){
        return typeof(variable) !== "undefined" && variable !== null && variable !== '';
    }
    
    function specific_date(list,qc_name){
        var qtype=<?php echo $qtype; ?>;
        var vtype=<?php echo $vtype; ?>;
        var slist=<?php echo $slist; ?>;
                    
        var tr='';
        list.forEach((tbl) => {
            var t='';
            if(isset(vtype[tbl.variation_type])){
                t=vtype[tbl.variation_type];
            }
            var s='';
            if(isset(slist[tbl.supplier_id])){
                s=slist[tbl.supplier_id];
            }
            
            
            
            tr += `<tr>
                    <td>${tbl.qc_date}</td>
                    <td>${qtype[tbl.qc_type]}</td>
                    <td>${t}</td>
                    <td>${s}</td>
                    <td>${tbl.ok_stock}</td>
                    <td>${tbl.alter_stock}</td>
                    <td>${tbl.total_stock}</td>
                </tr>`;
        })
                    
                    
                    
                    
                    
        var table=`<div class="table-responsive">
                    <table class="table table-striped table-bordered mb-0">
                        <thead class="table-dark">
                            <tr>
                                <th colspan="7"><span class="text-white fw-bold text-center">${qc_name}'s Date Wise</span></th>
                            </tr>
                            <tr>
                                <th>Date</th>
                                <th>QC Type</th>
                                <th>Variation Type</th>
                                <th>Supplier</th>
                                <th>OK Stock</th>
                                <th>Alter Stock</th>
                                <th>Total Stock</th>
                            </tr>
                        </thead>
                        <tbody>
                            ${tr}
                        </tbody>
                    </table>
                </div>`;
        
        return table;
    }
    
    function stats(dataCount,ListTbl){
        var stats='';
        var textArr=['text-white','text-dark'];
        var bgArr=['border_grey bg-grey','border_orange bg-orange'];
        
        var count=1;
        var tr=table='';
        Object.entries(dataCount).forEach(([k, v]) => {
            var t=0;
            if(count%2==0){
                t=1;
            }
            
            stats += `<div class="col-lg-3 col-md-3 col-sm-6 col-12 mt-1">
                <div class="statistic__item ${bgArr[t]}">
                    <h2 class="number ${textArr[t]}"><span>${v}</span></h2>
                    <span class="desc ${textArr[t]}">${k}</span>
                    <div class="icon ${textArr[t]}">
                        <i class="fas fa-calculator"></i>
                    </div>
                </div>
                
            </div>`;
            
            tr='';
                
            if (ListTbl[k]) {
                ListTbl[k].forEach(tbl => {
                    tr += `<tr>
                                <td><a href="javascript:;" class="qcDate" data-qc_name="${k}" data-qc_id="${tbl.qc_id}" data-qc_date="${tbl.qc_date}">${tbl.qc_date}</a></td>
                                <td>${tbl.ok_stock}</td>
                                <td>${tbl.alter_stock}</td>
                                <td>${tbl.total_stock}</td>
                            </tr>`;
                });
            }
            
            table+=`<div class="col-lg-3 col-md-3 col-sm-6 col-12 mb-3 mt-1">
                            <div class="table-responsive">
                                <table class="table table-striped table-bordered mb-0">
                                    <thead class="table-dark">
                                        <tr>
                                            <th colspan="4"><span class="text-white fw-bold text-center">${k}'s Stats</span></th>
                                        </tr>
                                        <tr>
                                            <th>Date</th>
                                            <th>OK Stock</th>
                                            <th>Alter Stock</th>
                                            <th>Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        ${tr}
                                    </tbody>
                                </table>
                            </div>
                                
                        </div>`;
            count++;
        });
        
        $('#data_html').html(`<div class="row ml-2 mr-2 mb-2">
                                ${stats}
                                </div>
                                <div class="row ml-2 mr-2 mb-2">
                                ${table}
                                </div>
                            `);
        
    }
    
</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/testapp/sampmini/resources/views/scorecard/index.blade.php ENDPATH**/ ?>