
<?php $__env->startSection('title','Bundle List | Mini Opex'); ?>
<?php $__env->startSection('add_css'); ?>
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Bundle </strong> List
                            <button type="button" id="export_excel" class="float-right btn btn-info btn-sm ml-1" style="display:none"><i class="fas fa-file-pdf"></i> PickList Download</button>
                        </div>
                        <div class="card-body card-block">
                            <?php if(session('has_error')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session('has_error')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('has_success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('has_success')); ?>

                                </div>
                            <?php endif; ?>
                            <form id="pick_pdf" method="post" action="<?php echo e(route('shipment.picklist.pdf')); ?>" >
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id_list" id="id_list" />
                                <input type="hidden" name="store_id2" id="store_id2" />
                                <input type="hidden" name="shipment_type2" id="shipment_type2" />
                                
                            </form>
                            <div class="container custom_filter bg-light pt-3 pb-2 border  rounded mb-2">
                                <div class="row">
                                    <div class="col-12 col-md-6">
                                        <select name="store" id="store_id" class="form-control select2">
                                            <option value="">Select Store</option>
                                            <?php $__empty_1 = true; $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <option value="<?php echo e($store->id); ?>"><?php echo e($store->strong_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <select name="shipment_type" id="shipment_type" class="form-control select2">
                                            <option value="">Select Type</option>
                                            <option value="1">Air Cargo</option>
                                            <option value="2">Sea Cargo</option>
                                        </select>
                                    </div>
                                    
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" id="posts" cellspacing="0" width="100%">
                                    <thead class="table-dark" style="color: white">
                                        <tr>
                                            <th>Bundle Image</th>
                                            <th>Bundle Name</th>
                                            <th>Instock</th>
                                            <th>Approve QTY</th>
                                            <th>Supply QTY</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>
<script>
     $('.single_image').featherlight({type: 'image',targetAttr: 'href'});
    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        "dataSrc": "",
        "ajax":{
                    "url": "<?php echo e(route('shipment.bundle.list')); ?>",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){ 
                        d._token= "<?php echo e(csrf_token()); ?>";
                        d.store= $('#store_id option:selected').val();
                        d.shipment_type=$('#shipment_type option:selected').val();
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [0,4] },
            { "searchable": false, "targets": [0,2] },
        ],
        "order": [[ 1, "desc" ]],
        bSort: false,
        "ordering": true,
        "columns":[
            { "data": "bundleImage","name":"bundleImage" },
            { "data": "bundleDetail","name":"bundleDetail" },
            { "data": "instock","name":"instock" },
            { "data": "orderqty","name":"orderqty" },
            { "data": "supply_qty","name":"supply_qty" },
            
            
        ],
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
    });
    
    $('.select2').on('change',function(){
        var id=$(this).attr('id');
        if($('#store_id option:selected').val() !='' && $('#shipment_type  option:selected').val() !=''){
            
            $('#export_excel').show();
        }else{
            $('#export_excel').hide();
        }
        $('#'+id+'2').val($('#'+id +' option:selected').val());
        $('#posts').DataTable().ajax.reload().draw();
    })
    
    $('#posts').on('input','tbody .supply_qty',function(){
      var id=$(this).attr('data-id');
      var val=parseInt($('#supply_qty_'+id).val().trim());
      var instock=parseInt($('#avail_'+id).text());
      var order_qty=parseInt($('#outstock_'+id).text());
      console.log(instock);
      if(!/^[0-9]+$/.test(val) || val ==0){
          
            $('#error_'+id).text('Receive Quantity Only Numbers And Not Equal to "0"');
            $('#error_'+id).show();
            $.toast({
                heading: 'Error',
                text: 'Receive Quantity Only Numbers And Not Equal to "0"',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });  
            $('#id_check_'+id).prop('checked',false);
      }else if(val !=''){
          if(val<=instock && val <= order_qty){
              $('#error_'+id).hide();
              $('#id_check_'+id).prop('checked','checked');
          }else{
            $('#error_'+id).text('Receive Quantity Exceeded');
            $('#error_'+id).show();
            $.toast({
                heading: 'Error',
                text: 'Receive Quantity Exceeded',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            $('#id_check_'+id).prop('checked',false);
          }
      }else{
         $('#error_'+id).hide(); 
      }
    });
    
    $('#export_excel').click(function(){
        var reqSupplier=$('.id_check').filter(':checked').length;
        if(reqSupplier ==0){
            return; 
        }
        
        var obj= {};
        var array=[];
        var id;
        var input_id=[];
        var value = $('.id_check').filter(':checked').filter(function () {
            id=$(this).attr('id').split("_")[2];
            input_id.push(id);
            console.log(id);
            
            obj.supply_qty=$('#supply_qty_'+id).val();
            obj.pr_id=$('#pr_id_'+id).val();
            obj.store_id=$('#store_id option:selected').val();
            obj.shipment_type=$('#shipment_type  option:selected').val();
            obj.order_qty=$('#outstock_'+id).text();
            obj.bundle_set_variation=$(this).val();
            obj.id=id;
            
            if(!/^[0-9]+$/.test($('#supply_qty_'+id).val()) || $('#supply_qty_'+id).val() ==0){
                $('#error_'+id).text('Receive Quantity Only Numbers And Not Equal to "0"');
                $('#error_'+id).show();
                $.toast({
                    heading: 'Error',
                    text: 'Receive Quantity Only Numbers And Not Equal to "0"',
                    showHideTransition: 'slide',
                    icon: 'error',
                    position: 'top-right',
                });  
                $('#id_check_'+id).prop('checked',false);
                array=[];
                obj={};
                return false;
            }else{
                array.push(obj);
                obj={};
            }

            
        });
        
        if(array.length !=0){
            $('#id_list').val(input_id.join(','));
            $.ajax({
                url:"<?php echo e(route('add.bundle.processed')); ?>",
                type:'POST',
                data:{
                    _token:"<?php echo e(csrf_token()); ?>",
                    array:array,
                },
                dataType:'JSON',
                success:function(data){
                    if(data.success){
                        $.toast({
                            heading: 'Success',
                            text: 'Bundle Processed Successfully',
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-right',
                        });
                        
                        $('#posts').DataTable().ajax.reload().draw();
                        $('#pick_pdf').submit();
                        
                    }
                }
            })    
        }
        
    });
</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/miniopex_pro/resources/views/process_order/bundle_list.blade.php ENDPATH**/ ?>