
<?php $__env->startSection('title',($string=='alteration')?'Item Alteration | Mini Opex':'Item Return | Mini Opex'); ?>
<?php $__env->startSection('add_css'); ?>
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Item <?php echo e($string=='alteration' ? 'Alteration' : 'Return'); ?></strong> List
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('item-alteration-add')): ?>
                                <a href="<?php echo e(route('items.alteration.add')); ?>" class="btn btn-info btn-sm float-right"><i class="fas fa-plus"></i> Add New Item Alteration</a>
                            <?php endif; ?>
                        </div>
                        <div class="card-body card-block">
                            <?php if(session('has_error')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session('has_error')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('has_success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('has_success')); ?>

                                </div>
                            <?php endif; ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-earning table-bordered" id="posts" cellspacing="0" width="100%">
                                    <thead>
                                        <tr>
                                            <th>Product Detail</th>
                                            <th>Quantity</th>
                                            <th>Type</th>
                                            <th>Supplier Name</th>
                                            <th>Created By</th>
                                            <th>Created Date</th>
    
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<script src="<?php echo e(asset('backend/js/jquery.validate.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/js/additional-methods.min.js')); ?>"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<!--<script src="//code.jquery.com/jquery-latest.js"></script>-->
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>


<script>
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});
    var string="<?php echo e($string); ?>";
    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        "dataSrc": "",
        "ajax":{
                    "url": "<?php echo e(route('items.alteration.list','return')); ?>",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){
                         d._token= "<?php echo e(csrf_token()); ?>";
                         if(string =='alteration'){
                             d.type=2;
                         }else{
                             d.type=1;
                         }
                        //  d.type=$('#type option:selected').val();
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [] },
        ],
        "order": [[ 5, "desc" ]],
        bSort: false,
        "ordering": true,
        "columns":[
            { "data": "productDetail","name":"productDetail" },
            { "data": "quantity","name":"item_return.quantity" },
            { "data": "return_check","name":"item_return.return_check" },
            { "data": "supplier_name","name":"suppliers.supplier_name" },
            { "data": "name","name":"users.name" },
            { "data": "created_at","name":"created_at" },
            
        ],
        initComplete: function () {
            $('#posts_filter input').addClass('form-control-sm');
            // $("#posts_filter").append(`
            //     <select class="float-right form-control-sm ml-1" name="type" id="type">
            //         <option value="">Select Type</option>
            //         <option value="1">Return</option>
            //         <option value="2">Alteration</option>
            //     </select>
            // `);
            
        },
        createdRow: (row, data, dataIndex, cells) => {
            var status;
            if(data.return_check=='1'){
                status='Return';
            }else if(data.return_check=='2'){
                status='Alteration'
            }
            $(cells[2]).html('<span class="text-primary text-sm">'+status+'</span>')
        },
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
    });

    $('#posts_filter').on('change','#type',function(e){
        e.preventDefault();
        $('#posts').DataTable().ajax.reload().draw();
    })

        
    

    
</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/miniopex/resources/views/item_alter/index.blade.php ENDPATH**/ ?>