
<?php $__env->startSection('title','Alteration Item Received | Mini Opex'); ?>
<?php $__env->startSection('add_css'); ?>
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>
                                Alteration Item Received
                            </strong>
                            <a href="<?php echo e(route('items.alteration.add')); ?>" class="btn btn-info btn-sm float-right"><i class="fas fa-plus"></i> Add New Item Alteration</a>

                        </div>
                        <div class="card-body card-block">
                            <?php if(session('has_error')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session('has_error')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('has_success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session('has_success')); ?>

                                </div>
                            <?php endif; ?>
                            <div class="row form-group mb-5">
                                <div class="col-md-2">
                                    <label for="exampleInputName2" class="pr-1  form-control-label">Supplier Name</label>
                                </div>
                                <div class="col-md-3">
                                    <select name="supplier" id="supplier" class="form-control select2" style="width: 50%">
                                        <option value="">Please select</option>
                                        <?php $__empty_1 = true; $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <option value="<?php echo e($supplier->id); ?>"><?php echo e($supplier->supplier_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div><hr>
                            <div class="table-responsive">
                                <table class="table  table-bordered  table-striped" id="posts" cellspacing="0" width="100%">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th>Product Detail</th>
                                            <th>IN Stock</th>
                                            <th>Type</th>
                                            <th>Supplier Name</th>
                                            <th>Created By</th>
                                            <th>Created Date</th>
                                            <th>Receive Qty</th>
                                            <th>Receiving Qty</th>
                                            <th>Remaining Qty</th>
                                            <th>Receiving Input</th>
                                            <th>Action</th>
                                            
                                        </tr>
                                    </thead>
                                </table>
                                
                            </div>
                        </div>    
                    </div>
                </div>   
            </div>
            <?php echo $__env->make('partials.copyrights', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('add_js'); ?>
<script src="<?php echo e(asset('backend/js/jquery.validate.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/js/additional-methods.min.js')); ?>"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<!--<script src="//code.jquery.com/jquery-latest.js"></script>-->
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>


<script>
    var type;
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});
    var table=$('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        "dataSrc": "",
        "ajax":{
                    "url": "<?php echo e(route('alteration.item.received')); ?>",
                //  "dataType": "json",
                    "type": "POST",
                    data:function(d){
                        d._token= "<?php echo e(csrf_token()); ?>";
                        d.type=2;
                        d.supplier_id=$('#supplier').val();
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [8,9,10] },
            { "width": "100%", "targets": [0] }
        ],
        "order": [[ 0, "desc" ]],
        bSort: false,
        "ordering": true,
        "columns":[
            { "data": "productDetail","name":"productDetail" },
            { "data": "Quantity","name":"product_info.Quantity" },
            { "data": "return_check","name":"item_return.return_check" },
            { "data": "supplier_name","name":"suppliers.supplier_name" },
            { "data": "name","name":"users.name" },
            { "data": "created_at","name":"created_at" },
            { "data": "receive_qty","name":"alteration_item_received.receive_qty" },
            { "data": "receiving_qty","name":"alteration_item_received.receiving_qty" },
            { "data": "remaining","name":"remaining" },
            { "data": "receiving_input","name":"receiving_input" },
            { "data": "action","name":"action" }
            
        ],
        createdRow: (row, data, dataIndex, cells) => {
            var status;
            if(data.return_check=='1'){
                status='Return';
            }else if(data.return_check=='2'){
                status='Alteration'
            }
            $(cells[2]).html('<span class="text-primary text-sm">'+status+'</span>')
        },
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
    });

    $('#supplier').on('change',function(){        
        $('#posts').DataTable().ajax.reload().draw();
    });

    $('#posts').on('click', 'tbody .received_btn', function () {
        var data_row = table.row($(this).closest('tr')).data();
        // console.log(data_row);return;
        var val=$('#receiving_qty_'+data_row.id).val();
        var rece_qty;

        if(!/^[0-9]+$/.test(val)){
            $('#error_'+data_row.id).text('Input Receive Only Numbers');
            $('#error_'+data_row.id).show();
            $.toast({
                heading: 'Error',
                text: 'Input Receive Only Numbers',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-center',
            });
        }else{
            // console.log(rece_qty);return;
            if(val>data_row.remaining){
                $('#error_'+data_row.id).text('Number Exceed from Order Qty');
                $('#error_'+data_row.id).show();
                $.toast({
                    heading: 'Error',
                    text: 'Number Exceed from Order Qty',
                    showHideTransition: 'slide',
                    icon: 'error',
                    position: 'top-center',
                }); 
                return;
            }else{
                $('#error_'+data_row.id).hide();
                loader('#posts');
                $.ajax({
                    url:"<?php echo e(route('alter.receive')); ?>",
                    type:"POST",
                    data:{
                        receive_qty:val,
                        id:data_row.id,
                        alter_id:data_row.alteration_item_id,
                        old_rec:data_row.receiving_qty,
                        variation_id:$('#variation_id_'+data_row.id).val(),
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    success:function(data){
                        loader('#posts',0);
                        if(data=='1'){
                            $.toast({
                                heading: 'Success',
                                text: 'Received Added Successfully',
                                showHideTransition: 'slide',
                                icon: 'success',
                                position: 'top-center',
                            }); 
                            
                            $('#posts').DataTable().ajax.reload().draw();
                            // print_label(data_row);   
                        }else{
                            $.toast({
                                heading: 'Success',
                                text: 'Received Added Successfully',
                                showHideTransition: 'slide',
                                icon: 'success',
                                position: 'top-center',
                            }); 
                            $('#posts').DataTable().ajax.reload().draw(); 
                        }
                    }
                });
            }
            
        }

    });

        
    

    
</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/esireops/public_html/miniopex/resources/views/item_alter/received.blade.php ENDPATH**/ ?>