<?php

use App\Models\Sku;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ExtraController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\Admin\LogController;
use App\Http\Controllers\Admin\SkuController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\UploadExcelController;
use App\Http\Controllers\Admin\GatePassController;
use App\Http\Controllers\Admin\SupplierController;
use App\Http\Controllers\Admin\SaleOrderController;
use App\Http\Controllers\Admin\ItemAlterationController;
use App\Http\Controllers\Admin\ShippmentController;
use App\Http\Controllers\Admin\InventoryController;
use App\Http\Controllers\Admin\ReportInventoryController;
use App\Http\Controllers\Admin\ProcessOrderController;
use App\Http\Controllers\Admin\OrderReportController;

//added date 7-9-22
use App\Http\Controllers\AdminShippmentController;
use App\Http\Controllers\Admin\HistoryController;


///added by sufian 13-06-24
use App\Http\Controllers\Admin\AWDController;


use App\Http\Controllers\Admin\ScoreCardController;
use App\Http\Controllers\Admin\TrendController;
use App\Http\Controllers\Admin\StockDashboardController;

use App\Http\Controllers\Admin\ReportUploaderController;
use App\Http\Controllers\Admin\POController;
use App\Http\Controllers\Admin\UploadController;
use App\Http\Controllers\Admin\ReturnController;

////added by sufian 08-07-25
use App\Http\Controllers\Admin\RawController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/clear', function() {
    Artisan::call('cache:clear');
    Artisan::call('config:clear');
    Artisan::call('config:cache');
    Artisan::call('view:clear');
   return "Cleared!";
});

//login Controller 
Route::get('/checksup',function(){
    $suppliers=\DB::table('suppliers')->where('status','1')->where('id','!=','1')->where('id','!=','2')->get();
        
    foreach($suppliers as $sup){
        $assign_data=\DB::table('assign_quantity')
                    ->orderBy('id', 'desc')
                    ->where('supplier_id',$sup->id)->first();
        if($assign_data !=null){
            $po_id=$assign_data->po_id;
            // dd($po_id);
            $tmp=explode('-', $po_id);
            $lastElement = end($tmp);
            
            $number=preg_replace('/[^0-9]/', '', $lastElement);
        
            $sup_update=['sup_po_no' => (int)$number+1];
            // dd($sup_update);
            \DB::table('suppliers')->where('id',$sup->id)->update($sup_update);
        }
                    
        
        
    }
    
    return response()->json(['code' => 200,'message' => 'Success']);
});
Route::get('/', [LoginController::class,'index'])->name('home');
Route::post('login', [LoginController::class,'store'])->name('store');
Route::post('logout', [LoginController::class,'logout'])->name('logout');

Route::get('/login/supplier',[LoginController::class,'supplier'])->name('login.supplier');
Route::post('/login/supplier',[LoginController::class,'supplierLogin']);


//dashboard
Route::get('dashboard', [DashboardController::class,'index'])->name('dashboard');
Route::get('dashboard/operational', [DashboardController::class,'operational_dashboard'])->name('operational.dashboard');
Route::get('dashboard/supplierPending', [DashboardController::class,'supplier_pending_dashboard'])->name('supplierPending.dashboard');
Route::get('storeWise/{store_id}/{shipment_type}/excel', [DashboardController::class,'excel_store'])->name('excel_store');
Route::get('supplierWiseExcel/{store_id}/excel', [DashboardController::class,'supplier_excel'])->name('supplier_excel');
Route::get('storeWiseUrgent/{store_id}/excel', [DashboardController::class,'excel_store_urgent'])->name('storeWiseUrgent');
Route::get('supplierWisePending/{store_id}/{supplier_id}/excel', [DashboardController::class,'skuWise_pending'])->name('skuWise_pending');

//Roles
Route::resource('roles', RoleController::class);

//Users
Route::any('users',[UserController::class,'index'])->name('users');
Route::post('users/store', [UserController::class,'store'])->name('users.store');
Route::post('users/{id}/destory', [UserController::class,'destroy'])->name('users.destroy');
Route::post('users/{id}/edit', [UserController::class,'update'])->name('users.edit');
Route::post('users/email', [UserController::class,'check_email'])->name('users.check_email');




//sku
Route::get('sku/cron/resp', [SkuController::class,'GetCronData'])->name('GetCronData');
Route::get('sku/create', [SkuController::class,'create'])->name('create');
Route::post('sku/store', [SkuController::class,'store'])->name('sku.store');
Route::post('sku/{id}/delete', [SkuController::class,'delete'])->name('sku.delete');
Route::get('inventory/sku/wise', [SkuController::class,'index'])->name('show');
Route::post('sku/allposts', [SkuController::class,'get_products'] )->name('allposts');


Route::post('sku/add_new', [SkuController::class,'add_color_articles'])->name('sku.add.new');
Route::any('sku/articles',[SkuController::class,'articles'])->name('supplier.articles');
Route::any('sku/colors',[SkuController::class,'colors'])->name('supplier.colors');
Route::any('sku/articles/{id}/{type}/deactive',[SkuController::class,'article_deactive'])->name('sku.article.deactive');
Route::any('sku/colors/{id}/{type}/deactive',[SkuController::class,'color_deactive'])->name('sku.color.deactive');
Route::any('sku/articles/edit',[SkuController::class,'edit_article'])->name('sku.article.edit');
Route::any('sku/colors/edit',[SkuController::class,'edit_color'])->name('sku.color.edit');
Route::any('sku/item/adjust_update',[SkuController::class,'item_adjust_update'])->name('item.adjust.update');
Route::any('sku/item/adjust',[SkuController::class,'item_adjust'])->name('item.adjust');
Route::any('sku/add/design',[SkuController::class,'add_design'])->name('add.design');
Route::any('sku/add/bundle',[SkuController::class,'add_new_bundle'])->name('add.new.bundle');
Route::any('sku/select/list',[SkuController::class,'sku_list'])->name('sku.select.list');
Route::any('sku/get/set_no',[SkuController::class,'get_set_no'])->name('sku.get.set_no');
Route::any('sku/bundle/list',[SkuController::class,'bundle_list'])->name('sku.bundle.list');
Route::any('sku/designs',[SkuController::class,'designs'])->name('supplier.designs');
Route::any('sku/images',[SkuController::class,'type_images'])->name('supplier.images');
Route::any('sku/with/design',[SkuController::class,'get_products_with'])->name('sku.with.design');
Route::any('sku/check/variation',[SkuController::class,'check_variation_id'])->name('sku.check.variation');


///added by sufian 21-5-24
Route::post('get/sku/sale', [SkuController::class,'get_sku_sale'])->name('get.sku.sale');
Route::post('get/bundle/excel', [SkuController::class,'get_bundle_excel'])->name('get_bundle_excel');
Route::post('get/single/excel', [SkuController::class,'get_single_excel'])->name('get_single_excel');
Route::post('get/product/excel', [SkuController::class,'get_products_excel'])->name('get_products_excel');
Route::post('get/sku/list', [SkuController::class,'get_sku_list'])->name('get_sku_list');

//bulk added by sufian 01-02-23
Route::any('bulk/bundle/update_status',[SkuController::class,'bulk_bundle_update_status'])->name('bulk.bundle.update.status');
Route::any('bulk/{id}/bundle/edit',[SkuController::class,'bulk_edit_bundle'])->name('bulk.edit.bundle');

//order
Route::get('order', [OrderController::class,'index'])->name('order.show');
Route::post('order/allOrder', [OrderController::class,'allOrders'])->name('order.all');
Route::post('order/assign', [OrderController::class,'assign_quantity'])->name('order.assign.quantity');
Route::post('order/upload', [OrderController::class,'upload_excel'])->name('order.upload');
Route::post('order/check_warehouse', [OrderController::class,'check_warehouse_assign'])->name('order.check.warehouse');
// Route::get('order/test', [OrderController::class,'testx'])->name('order.show');

//Supplier
Route::get('supplier', [SupplierController::class,'index'])->name('supplier.show');
Route::get('supplier/add', [SupplierController::class,'add'])->name('supplier.add');
Route::post('supplier/add', [SupplierController::class,'store']);
Route::post('supplier/all', [SupplierController::class,'allSuppliers'])->name('supplier.all');
Route::get('supplier/{id}/edit', [SupplierController::class,'edit'])->name('supplier.edit');
Route::post('supplier/{id}/edit', [SupplierController::class,'update']);
Route::post('supplier/{id}/delete', [SupplierController::class,'destroy'])->name('supplier.delete');
Route::post('supplier/username', [SupplierController::class,'check_username'])->name('supplier.check_username');
Route::post('supplier/receive_input', [SupplierController::class,'receive_input'])->name('supplier.receive_input');
Route::any('order/pending',[SupplierController::class,'retrived_quantity'])->name('supplier.retrive');
Route::any('orders/{string}',[SupplierController::class,'status'])->name('supplier.receiving.add');
Route::any('supplier/{string}/orders',[SupplierController::class,'status'])->name('supplier.complete.orders');
Route::any('supplier/quantity',[SupplierController::class,'supplier_quantity'])->name('supplier.quantity');
Route::any('supplier/print/{id}/labels',[SupplierController::class,'print_label'])->name('supplier.print.label');

Route::any('supplier/last_receiving',[SupplierController::class,'last_receiving'])->name('supplier.last_receiving');
Route::any('order/label/list',[SupplierController::class,'print_label_list'])->name('supplier.label.list');
Route::any('supplier/view/labels',[SupplierController::class,'print_label2'])->name('supplier.view.label');
Route::any('supplier/check/labels',[SupplierController::class,'check_label'])->name('supplier.check.label');
Route::any('supplier/pdf/pending',[SupplierController::class,'make_pending_pdf'])->name('pdf.pending.orders');

//added by sufian 05-03-24
Route::post('supplier/skuWise/pending',[SupplierController::class,'skuWise_pending'])->name('skuWise.pending');

Route::any('supplier/po_list',[SupplierController::class,'po_list'])->name('supplier.po_list');
//supplier order cancellation added by sufian 17-01-23
Route::any('supplier/cancel/order',[SupplierController::class,'cancellation_supplier'])->name('supplier.order.cancellation');

//Gatepass
Route::get('order/gatepass',[GatePassController::class,'index'])->name('gatepass.index');
Route::post('gatepass/get_all',[GatePassController::class,'getall'])->name('gatepass.get_all');
Route::any('supplier/statistics',[GatePassController::class,'statistics'])->name('order.statistics');
Route::any('order/get_pr_data',[GatePassController::class,'get_pr_data'])->name('order.prs');
Route::any('order/pdf/gate_pass',[GatePassController::class,'make_gate_pass_pdf'])->name('pdf.gate.pass');
Route::any('order/get/gate_pass_serial',[GatePassController::class,'gate_pass_serial'])->name('gate.pass.serial');
Route::any('order/get/po_list_gatepass_serial',[GatePassController::class,'po_list_gatepass_serial'])->name('gate.po_list_gatepass_serial');
Route::any('order/get/gate_pass_po_list',[GatePassController::class,'gate_pass_po_list'])->name('gate.gate_pass_po_list');
Route::any('order/gatepass/reverse',[GatePassController::class,'reverse_gatepass'])->name('gate.reverse_gatepass');



//Sale Order
Route::any('sale/orders',[SaleOrderController::class,'index'])->name('sale.orders');
Route::any('sale/sale_order',[SaleOrderController::class,'sale_order'])->name('sale.orders.id');
Route::post('sale/adjust',[SaleOrderController::class,'adjust'])->name('sale.adjust');
Route::post('sale/update_status',[SaleOrderController::class,'update_status'])->name('sale.update');
Route::any('sale/{string}',[SaleOrderController::class,'sale_select'])->name('approve.sale.orders');

//Item Log
Route::any('log/items',[LogController::class,'index'])->name('log.item');
Route::any('log/return/log',[LogController::class,'return'])->name('log.item.return');
Route::any('log/barcodes/change',[LogController::class,'barcode_change'])->name('barcode.change.log');

//Excel
Route::any('log/list/excel',[UploadExcelController::class,'index'])->name('list.excel');


//Item Alteration
Route::any('items/alteration/add', [ItemAlterationController::class,'add'])->name('items.alteration.add');
Route::any('item/{string}/list', [ItemAlterationController::class,'index'])->name('items.alteration.list');
Route::get('items/suppliers/list', [ItemAlterationController::class,'supplier_list'])->name('item.supplier.list');
Route::any('items/skus/list', [ItemAlterationController::class,'sku_list'])->name('item.sku.list');
Route::any('supplier/{string}/items', [ItemAlterationController::class,'supplier_return'])->name('supplier.items.list');
Route::any('items/alteration/statistics',[ItemAlterationController::class,'statistics'])->name('alteration.supplier.statistics');
Route::any('items/supplier/statistics',[ItemAlterationController::class,'get_supplier_wise_data'])->name('supplier.wise.statistics');
Route::any('items/alteration/received',[ItemAlterationController::class,'alteration_received'])->name('alteration.item.received');
Route::any('items/alter/receive',[ItemAlterationController::class,'alter_receive'])->name('alter.receive');

//Shippment
Route::any('shipment/upload',[ShippmentController::class,'index'])->name('upload.shippment');
Route::any('shipment/{id}/download',[ShippmentController::class,'download_file'])->name('upload.shippment.download');
Route::any('shipment/{string}/scan/download',[ShippmentController::class,'shipment_export'])->name('shippment.scan.download');
Route::any('shipment/{string}/view/scan',[ShippmentController::class,'view_scan_list'])->name('shippment.view.scan');
Route::any('shipment/shipment/list',[ShippmentController::class,'shippment_list'])->name('shippment.list');
Route::get('shipment/start/scaning/{string}',[ShippmentController::class,'start_scan'])->name('shippment.start.scan');
Route::any('shipment/add/box',[ShippmentController::class,'add_box'])->name('add.box');
Route::any('shipment/box/info',[ShippmentController::class,'get_all_boxes_info'])->name('box.info');
Route::any('shipment/box/weight',[ShippmentController::class,'get_box_weight_info'])->name('box.weight');
Route::any('shipment/fnsku/scan',[ShippmentController::class,'get_product_img_by_fnsku'])->name('fnsku.scan');
Route::any('shipment/fnsku/scan/add',[ShippmentController::class,'add_qty_inbox'])->name('fnsku.add.scan');
Route::any('shipment/cart/data',[ShippmentController::class,'get_cart_table_data'])->name('get.cart.data');
Route::any('shipment/cart/delete',[ShippmentController::class,'delete_cart_item'])->name('delete.cart.item');
Route::any('shipment/all/data',[ShippmentController::class,'get_all_shipment_data'])->name('shipped.all.data');
Route::any('shipment/{string}/print/label',[ShippmentController::class,'shipment_print_label'])->name('shippment.print.label');
Route::any('shipment/view/label',[ShippmentController::class,'show_print_label'])->name('shippment.view.label');

//Inventory
Route::any('inventory/summary/{string}',[InventoryController::class,'index'])->name('inventory.summary');
Route::any('inventory/opening',[InventoryController::class,'export_opening_stock'])->name('opening.download');
Route::any('inventory/upload/opening',[InventoryController::class,'upload_opening'])->name('upload.opening');
Route::any('inventory/sku/detail',[InventoryController::class,'sku_detail_on'])->name('inventory.sku.detail');
Route::any('inventory/item/adjust',[InventoryController::class,'item_adjust'])->name('inventory.item.adjust');
Route::any('inventory/item/check',[InventoryController::class,'variation_process_order'])->name('inventory.item.check');
Route::any('inventory/switch/stock',[InventoryController::class,'stock_adjust'])->name('inventory.stock.switch');


Route::get('ExportNewInventory/{string}',[InventoryController::class,'ExportNewInventory'])->name('ExportNewInventory');
//ReportInventory
//   


//ProcessOrder
Route::any('shipment/process/orders',[ProcessOrderController::class,'index'])->name('shipment.process.order');
Route::any('shipment/send/process',[ProcessOrderController::class,'send_to_process'])->name('shipment.send.process');
Route::any('shipment/processed/orders',[ProcessOrderController::class,'processed_order'])->name('shipment.processed.order');
Route::any('shipment/import/orders',[ProcessOrderController::class,'import_processed_order'])->name('shipment.import.order');
Route::any('shipment/export/processed',[ProcessOrderController::class,'export_processed_order_for_ship'])->name('shipment.export.order');
//added by sufian 14-11-22
Route::any('shipment/mark_as_urgent',[ProcessOrderController::class,'mark_as_urgent'])->name('shippment.mark_as_urgent');
//added by sufian 17-01-23
Route::any('shipment/cancel/ready/ship/orders',[ProcessOrderController::class,'cancel_ready_to_shipment'])->name('shipment.cancel.ready_to_shipment');
Route::any('shipment/cancel/bundle/orders',[ProcessOrderController::class,'bundle_cancelled_processed'])->name('shipment.cancel.bundle');
Route::any('shipment/cancel/process/orders',[ProcessOrderController::class,'processed_order_cancelled'])->name('shipment.cancel.process');


//extra
Route::any('extra/db/reset',[ExtraController::class,'db_reset'])->name('extra.db.reset');
Route::any('extra/test/excel',[ExtraController::class,'get_excel']);
Route::any('extra/test/mail',[ExtraController::class,'test_mail']);



////////Added by Sufian
Route::any('shipment/bundle/list',[ProcessOrderController::class,'bundle_list'])->name('shipment.bundle.list');
Route::any('shipment/add/bundle/list',[ProcessOrderController::class,'add_bundle_processed'])->name('add.bundle.processed');
Route::any('shipment/picklist/pdf',[ProcessOrderController::class,'picklist_pdf'])->name('shipment.picklist.pdf');
Route::any('shipment/complete/status',[ShippmentController::class,'complete_status'])->name('shipment.complete.status');
Route::any('shipment/upload/box_label',[ShippmentController::class,'upload_box_label'])->name('shipment.upload.box_label');
Route::any('shipment/freeze/check',[ShippmentController::class,'shipment_freeze'])->name('shipment.freeze.check');

////added date 12-9-22
Route::any('shipment/id/delete',[ShippmentController::class,'delete_shipment'])->name('shipment.id.delete');

Route::any('sku/bulk/edit',[SkuController::class,'sku_bulk_edit'])->name('sku.bulk.edit');



/////new 
Route::any('stores/orders/report',[OrderReportController::class,'report_list'])->name('stores.orders.report');


///added date 7-9-22
/////Excel 
Route::get('order/{mod_id}/excel', [OrderController::class,'download_mo_excel'])->name('mo.excel');
Route::get('process/{store_id}/{shipment_type}/list',[ProcessOrderController::class,'excel_process_order'])->name('excel.process.order');
Route::get('ready/{store_id}/{shipment_type}/list',[ProcessOrderController::class,'excel_shipment_ready_order'])->name('excel.shipment.ready.order');


///cron email
Route::get('today/drop/in', [AdminShippmentController::class,'today_drop_in'])->name('today.drop.in');
Route::get('today/ready/shipment', [AdminShippmentController::class,'today_ready_shipment'])->name('today.ready.shipment');
Route::get('pr/data', [AdminShippmentController::class,'pr_data'])->name('pr.data');

///history Controller
Route::any('mo/history',[HistoryController::class,'index'])->name('mo.history');

///added date 23-12-22
Route::any('mo/list',[HistoryController::class,'mo_list'])->name('mo.mo_list');
Route::any('mo/supplier/detail',[HistoryController::class,'supplier_po_issued_detail'])->name('mo.supplier.detail');
Route::any('mo/new/list',[HistoryController::class,'mo_new_list'])->name('mo.list');
Route::any('sku/history/list',[HistoryController::class,'sku_list'])->name('mo.sku.list');
Route::any('storewise/sku/list',[HistoryController::class,'sku_list_storewise'])->name('mo.sku.storewise.list');


///Switch Supplier 
Route::any('switch/supplier',[SupplierController::class,'switch_supplier'])->name('switch.supplier');

////added date 21-2-23
Route::any('shipped/list',[ShippmentController::class,'shipped_list'])->name('shipped.list');
Route::any('get/shippment/id',[ShippmentController::class,'get_shipment_id'])->name('get.shippment.id');

Route::any('bulk/{id}/sku/edit',[SkuController::class,'bulk_edit_sku'])->name('bulk.edit.sku');
Route::any('bulk/{id}/sku/update',[SkuController::class,'bulk_update'])->name('bulk.update.sku');

//added by sufian 08-04-23
Route::get('process/bundle/{store_id}/{shipment_type}/list',[ProcessOrderController::class,'excel_process_bundle_order'])->name('excel.process.bundle.order');

///added by sufian 05-05-23
Route::any('supplier/store_wise/statistics',[GatePassController::class,'storewise_statistics'])->name('order.storewise_statistics');

///added by sufian 12-5-12-23
Route::any('log/sku/ship/info',[HistoryController::class,'shipped_order'])->name('sku.ship.info');

///added by sufian 6-2-24
Route::post('bulk/order/cancellation',[OrderController::class,'bulk_order_cancellation'])->name('bulk.order.cancellation');

Route::get('test/ship/log',[ShippmentController::class,'test_log']);


////added by sufian 05-06-24
Route::post('get/process/count',[ProcessOrderController::class,'get_process_count'])->name('get_process_count');
Route::post('get/ready/count',[ProcessOrderController::class,'get_ready_count'])->name('get_ready_count');


//New Drop In 08-06-24
Route::get('order/dropIn',[SupplierController::class,'dropInOrder'])->name('dropInOrder');
Route::post('order/dropIn',[SupplierController::class,'dropInOrder']);
Route::post('get/pending/count',[SupplierController::class,'get_supplier_pending'])->name('get_supplier_pending');
Route::post('supplier/receive_input/new', [SupplierController::class,'receive_input_new'])->name('supplier.receive_input_new');


///New Process Supplier 11-06-24
Route::get('order/processSupplier', [OrderController::class,'proccess_supplier'])->name('proccess_supplier');
Route::post('order/processSupplier', [OrderController::class,'proccess_supplier']);
Route::post('get/ProcessSupplier/count',[OrderController::class,'get_process_supplier_count'])->name('get_process_supplier_count');


///segment_articles 13-6-24
Route::post('sku/segment/segment',[SkuController::class,'segment_article'])->name('sku.segment_article');



////Print Label AWD 13-6-24
Route::get('awd/printLabel', [AWDController::class,'printLabel'])->name('awd.printLabel');
Route::post('awd/printLabel', [AWDController::class,'printLabel']);
Route::post('awd/uploadFNSKU', [AWDController::class,'upload_fnsku'])->name('awd.uploadFNSKU');
Route::any('awd/fnsku/print/label',[AWDController::class,'show_print_label'])->name('awd.showPrintLabel');
Route::post('awd/sentToReadyCasePack',[AWDController::class,'send_to_case_pack_ready'])->name('awd.sentToReadyCasePack');
Route::get('awd/Ready/CasePack',[AWDController::class,'casePack_ready'])->name('awd.ReadyCasePack');
Route::post('awd/Ready/CasePack',[AWDController::class,'casePack_ready']);
Route::post('awd/Ready/CasePack/count',[AWDController::class,'get_readyCase_count'])->name('awd.get_readyCase_count');

Route::post('awd/pending/CasePack/count',[AWDController::class,'pending_CasePack_count'])->name('awd.pending_CasePack_count');

///excel Ready 24-6-24
Route::post('ready/casePack/excel',[AWDController::class,'excel_case_pack_ready'])->name('awd.excel_case_pack_ready');

 

///added by sufian 21-6-24
Route::any('extra/fn',[ExtraController::class,'extraFunction']);

Route::any('shipment/awd/fnsku/scan',[ShippmentController::class,'get_product_img_by_fnsku_awd'])->name('fnsku.scan.awd');
Route::any('shipment/awd/fnsku/scan/add',[ShippmentController::class,'add_qty_inbox_awd'])->name('fnsku.add.scan.awd');
Route::any('shipment/awd/cart/data',[ShippmentController::class,'get_cart_table_data_awd'])->name('get.cart.data.awd');
Route::any('shipment/awd/cart/delete',[ShippmentController::class,'delete_cart_item_awd'])->name('delete.cart.item.awd');


///added by sufian 21-6-24
Route::any('extra/fn',[ExtraController::class,'extraFunction']);



///sku added by sufian 27-6-24
Route::any('sku/design/edit',[SkuController::class,'edit_design'])->name('sku.design.edit');
Route::any('sku/design/{id}/{type}/deactive',[SkuController::class,'design_deactive'])->name('sku.design.deactive');
Route::any('sku/bundle/deactive',[SkuController::class,'bundle_deactive'])->name('sku.bundle.deactive');
Route::any('sku/sku/deactive',[SkuController::class,'single_deactive'])->name('sku.single.deactive');


//create SKU added by sufian 05-07-24
Route::post('sku/check_sku',[SkuController::class,'check_sku'])->name('sku.check_sku');
Route::post('sku/generate_sku',[SkuController::class,'generate_sku'])->name('sku.generate_sku');

Route::any('sku/single/single_occasional',[SkuController::class,'single_occasional'])->name('sku.single.single_occasional');
Route::any('sku/bundle/bundle_occasional',[SkuController::class,'bundle_occasional'])->name('sku.bundle.bundle_occasional');


///added by sufian 23-8-24
Route::get('scoreCard/qc', [ScoreCardController::class,'qcScoreCard'])->name('qcScoreCard');
Route::post('scoreCard/qc', [ScoreCardController::class,'qcScoreCard']);

Route::post('scoreCard/add/qc/checkList', [ScoreCardController::class,'addQcCheckList'])->name('addQcCheckList');
Route::post('scoreCard/check/qc/checkList', [ScoreCardController::class,'getDateData'])->name('getDateData');

Route::get('/dashboard/sales', [TrendController::class, 'index'])->name('DateWiseFilter');
Route::post('/dashboard/sales', [TrendController::class, 'index']);
Route::post('/trendsSaleOrders/ajaxDatatable', [TrendController::class, 'ajax_datatable'])->name('trendsSaleOrders.ajaxDatatable');
Route::post('/trendsSaleOrders/excelDownload', [TrendController::class, 'get_excel'])->name('trendsSaleOrders.excelDownload');
Route::post('/trendsSaleOrders/clearFilter', [TrendController::class, 'clearFilter'])->name('trendsSaleOrders.clearFilter');

Route::post('search/sku',[SkuController::class,'search_sku'])->name('search_sku');


Route::post('generate/Chart', [DashboardController::class,'shipment_receiving_stats'])->name('generate_chart');

Route::get('/dashboard/stockDashboard', [StockDashboardController::class, 'stockDashboard'])->name('stockDashboard');
Route::post('/dashboard/stockDashboard', [StockDashboardController::class, 'stockDashboard']);

Route::post('/stockDashboard/ajaxDatatable', [StockDashboardController::class, 'ajax_datatable'])->name('stockDashboard.ajaxDatatable');
Route::post('/stockDashboard/excelDownload', [StockDashboardController::class, 'get_excel'])->name('stockDashboard.excelDownload');


Route::prefix('report/inventory')->name('report.inventory.')->group(function () {
    Route::any('/upload',[ReportUploaderController::class,'index'])->name('upload');
    Route::any('/list',[ReportUploaderController::class,'report_list'])->name('list');
});


///added by sufian 11-2-25
Route::post('sku/addNewSegments',[SkuController::class,'add_new_segment'])->name('sku.add_new_segment');
Route::post('sku/addNewArticles',[SkuController::class,'add_new_articles'])->name('sku.add_new_articles');


///added by sufian 07-05-25
Route::get('/dashboard/poDashboard', [POController::class, 'index'])->name('poDashboard');
Route::post('/dashboard/poDashboard', [POController::class, 'index']);

Route::post('/poDashboard/ajaxDatatable', [POController::class, 'ajax_datatable'])->name('poDashboard.ajaxDatatable');
Route::post('/poDashboard/excelDownload', [POController::class, 'get_excel'])->name('poDashboard.excelDownload');


///added by sufian 13-5-25
Route::get('shipment/urgentMark/uploader',[UploadController::class,'index'])->name('shipment.urgentMark.uploader');
Route::post('shipment/urgentMark/uploader',[UploadController::class,'index']);

Route::post('sku/returnComments',[SkuController::class,'returnComments'])->name('sku.returnComments');

Route::get('/dashboard/returnDashboard', [ReturnController::class, 'index'])->name('returnDashboard');
Route::post('/dashboard/returnDashboard', [ReturnController::class, 'index']);

Route::post('/returnDashboard/ajaxDatatable', [ReturnController::class, 'ajax_datatable'])->name('returnDashboard.ajaxDatatable');

///added by sufian 30-5-24
Route::get('raw/add/sku', [RawController::class,'add_sku'])->name('add_sku');
Route::post('raw/add/sku', [RawController::class,'add_sku']);
Route::get('editRawSku/{id}', [RawController::class,'editRawSku'])->name('editRawSku');
Route::post('updateRawSku', [RawController::class,'updateRawSku'])->name('updateRawSku');
Route::get('deleteRawSku/{id}', [RawController::class,'deleteRawSku'])->name('deleteRawSku');
Route::post('raw/add/unitCategory', [RawController::class,'add_unit_category'])->name('add_unit_category');
Route::get('raw/sku/list', [RawController::class,'raw_list'])->name('raw_list');
Route::post('raw/sku/list', [RawController::class,'raw_list']);
Route::get('raw/orders/{string}', [RawController::class,'checkType'])->name('checkType');
Route::post('raw/orders/{string}', [RawController::class,'checkType']);
Route::any('raw/skus/list', [RawController::class,'sku_list'])->name('raw.sku.list');
Route::get('raw/gatepass', [RawController::class,'gatepass'])->name('raw.gatepass');
Route::post('raw/gatepass', [RawController::class,'gatepass']);
Route::post('raw/view/gatepass', [RawController::class,'make_gate_pass_pdf'])->name('raw.view.gatepass');





























