<?php

use App\Models\Sku;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ExtraController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\Admin\LogController;
use App\Http\Controllers\Admin\SkuController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\UploadExcelController;
use App\Http\Controllers\Admin\GatePassController;
use App\Http\Controllers\Admin\SupplierController;
use App\Http\Controllers\Admin\SaleOrderController;
use App\Http\Controllers\Admin\ItemAlterationController;
use App\Http\Controllers\Admin\ShippmentController;
use App\Http\Controllers\Admin\InventoryController;
use App\Http\Controllers\Admin\ReportInventoryController;
use App\Http\Controllers\Admin\ProcessOrderController;
use App\Http\Controllers\Admin\OrderReportController;

//added date 7-9-22
use App\Http\Controllers\AdminShippmentController;
use App\Http\Controllers\Admin\HistoryController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

//login Controller 
Route::get('/checksup',function(){
    $suppliers=\DB::table('suppliers')->where('status','1')->where('id','!=','1')->where('id','!=','2')->get();
        
    foreach($suppliers as $sup){
        $assign_data=\DB::table('assign_quantity')
                    ->orderBy('id', 'desc')
                    ->where('supplier_id',$sup->id)->first();
        if($assign_data !=null){
            $po_id=$assign_data->po_id;
            // dd($po_id);
            $tmp=explode('-', $po_id);
            $lastElement = end($tmp);
            
            $number=preg_replace('/[^0-9]/', '', $lastElement);
        
            $sup_update=['sup_po_no' => (int)$number+1];
            // dd($sup_update);
            \DB::table('suppliers')->where('id',$sup->id)->update($sup_update);
        }
                    
        
        
    }
    
    return response()->json(['code' => 200,'message' => 'Success']);
});
Route::get('/', [LoginController::class,'index'])->name('home');
Route::post('login', [LoginController::class,'store'])->name('store');
Route::post('logout', [LoginController::class,'logout'])->name('logout');

Route::get('/login/supplier',[LoginController::class,'supplier'])->name('login.supplier');
Route::post('/login/supplier',[LoginController::class,'supplierLogin']);


//dashboard
Route::get('dashboard', [DashboardController::class,'index'])->name('dashboard');

//Roles
Route::resource('roles', RoleController::class);

//Users
Route::any('users',[UserController::class,'index'])->name('users');
Route::post('users/store', [UserController::class,'store'])->name('users.store');
Route::post('users/{id}/destory', [UserController::class,'destroy'])->name('users.destroy');
Route::post('users/{id}/edit', [UserController::class,'update'])->name('users.edit');
Route::post('users/email', [UserController::class,'check_email'])->name('users.check_email');




//sku
Route::get('sku/create', [SkuController::class,'create'])->name('create');
Route::post('sku/store', [SkuController::class,'store'])->name('sku.store');
Route::post('sku/{id}/delete', [SkuController::class,'delete'])->name('sku.delete');
Route::get('sku', [SkuController::class,'index'])->name('show');
Route::post('sku/allposts', [SkuController::class,'get_products'] )->name('allposts');
Route::get('sku/{id}/edit', [SkuController::class,'show'])->name('sku.edit');
Route::post('sku/{id}/update', [SkuController::class,'edit'] )->name('sku.update');
Route::get('sku/readJson',function(){
    $jsonString = file_get_contents(asset('product_info_new.json'));
    $array=json_decode($jsonString);
    dd($array);
    foreach ($array[0]->data as $key => $value) {
        if($value->prod_type<10){
            $type='0'.$value->prod_type;
        }else{
            $type=$value->prod_type;
        }
        $group_id='4'.$value->prod_status.$value->prod_gender.$type.$value->prod_color;

        $new=[
            'product_name' => $value->product_name,
            'variation_id' => '4'.$value->prod_variation,
            'user_id' => auth()->id(),
            'group_id' => $group_id,
            'prod_status' => $value->prod_status,
            'prod_gender' => $value->prod_gender,
            'prod_type'   => $value->prod_type,
            'prod_color' => $value->prod_color,
            'prod_size' => $value->prod_size,
            'Quantity' => '0',
            'prod_variation' => '',
            'prod_design' =>0,
            'product_url'=>$value->prod_img,
            'prod_img' => '',
            'created_at' => date('Y-m-d')
        ];

        // Sku::create($new);
    }
    echo "Done"; 
});

Route::get('sku/quantity', function () {
    $records=DB::table('product_info_design')
                ->groupBy('group_id')
                ->join('type_images','type_images.code','=','product_info_design.group_id')
                ->get();
                
    $product_size=DB::table('product_size')->where('status',1)->get();
    
    foreach($records as $record){
        $array = substr(strstr($record->group_id,"4"), 1);
        $spl=str_split($array, 2);
        $type=$spl[1];
        if($type<10){
            $type=str_replace("0","",$type);
        }
                        
        $color=$spl[2];
        if($color<10){
            $color=str_replace("0","",$color);
        }
        $t=DB::table('product_type')->where('id',$type)->first();
        $c=DB::table('product_color')->where('id',$color)->first();
        
        foreach($product_size as $ps){
            $insert=[
                'user_id'=> auth()->user()->id,
                'variation_id' => $record->group_id.$ps->id,
                'group_id' => $record->group_id,
                'product_name' => $t->product_type.' | '.$c->color.', '.$ps->size,
                'prod_status' => 1,
                'prod_gender' => $record->prod_gender,
                'prod_type' => $record->prod_type,
                'prod_color' => $record->prod_color,
                'prod_size' => $ps->id,
                'prod_img' => '',
                'product_url' => $record->image,
                'prod_variation' => $record->prod_variation,
                'prod_design' => 1,
                'Quantity' => 0,
                'created_at' => date('Y-m-d'),
                'team' => 4,
                'decrum_instock' => 0,
                'decrum_inbound' => 0,
                'axfashion_instock' => 0,
                'axfashion_inbound' => 0,
                'variation_design' => '',
                'prod_asin' => ''
            ];
            Sku::create($insert);
        }
        
    }
    echo "done";
});

Route::post('sku/add_new', [SkuController::class,'add_color_articles'])->name('sku.add.new');
Route::any('sku/articles',[SkuController::class,'articles'])->name('supplier.articles');
Route::any('sku/colors',[SkuController::class,'colors'])->name('supplier.colors');
Route::any('sku/articles/{id}/{type}/deactive',[SkuController::class,'article_deactive'])->name('sku.article.deactive');
Route::any('sku/colors/{id}/{type}/deactive',[SkuController::class,'color_deactive'])->name('sku.color.deactive');
Route::any('sku/articles/edit',[SkuController::class,'edit_article'])->name('sku.article.edit');
Route::any('sku/colors/edit',[SkuController::class,'edit_color'])->name('sku.color.edit');
Route::any('sku/item/adjust_update',[SkuController::class,'item_adjust_update'])->name('item.adjust.update');
Route::any('sku/item/adjust',[SkuController::class,'item_adjust'])->name('item.adjust');
Route::any('sku/add/design',[SkuController::class,'add_design'])->name('add.design');
Route::any('sku/add/bundle',[SkuController::class,'add_new_bundle'])->name('add.new.bundle');
Route::any('sku/select/list',[SkuController::class,'sku_list'])->name('sku.select.list');
Route::any('sku/get/set_no',[SkuController::class,'get_set_no'])->name('sku.get.set_no');
Route::any('sku/bundle/list',[SkuController::class,'bundle_list'])->name('sku.bundle.list');
Route::any('sku/designs',[SkuController::class,'designs'])->name('supplier.designs');
Route::any('sku/images',[SkuController::class,'type_images'])->name('supplier.images');
Route::any('sku/with/design',[SkuController::class,'get_products_with'])->name('sku.with.design');


//order
Route::get('order', [OrderController::class,'index'])->name('order.show');
Route::post('order/allOrder', [OrderController::class,'allOrders'])->name('order.all');
Route::post('order/assign', [OrderController::class,'assign_quantity'])->name('order.assign.quantity');
Route::post('order/upload', [OrderController::class,'upload_excel'])->name('order.upload');
Route::post('order/check_warehouse', [OrderController::class,'check_warehouse_assign'])->name('order.check.warehouse');


//Supplier
Route::get('supplier', [SupplierController::class,'index'])->name('supplier.show');
Route::get('supplier/add', [SupplierController::class,'add'])->name('supplier.add');
Route::post('supplier/add', [SupplierController::class,'store']);
Route::post('supplier/all', [SupplierController::class,'allSuppliers'])->name('supplier.all');
Route::get('supplier/{id}/edit', [SupplierController::class,'edit'])->name('supplier.edit');
Route::post('supplier/{id}/edit', [SupplierController::class,'update']);
Route::post('supplier/{id}/delete', [SupplierController::class,'destroy'])->name('supplier.delete');
Route::post('supplier/username', [SupplierController::class,'check_username'])->name('supplier.check_username');
Route::post('supplier/receive_input', [SupplierController::class,'receive_input'])->name('supplier.receive_input');
Route::any('order/pending',[SupplierController::class,'retrived_quantity'])->name('supplier.retrive');
Route::any('orders/{string}',[SupplierController::class,'status'])->name('supplier.receiving.add');
Route::any('supplier/quantity',[SupplierController::class,'supplier_quantity'])->name('supplier.quantity');
Route::any('supplier/print/{id}/labels',[SupplierController::class,'print_label'])->name('supplier.print.label');

Route::any('supplier/last_receiving',[SupplierController::class,'last_receiving'])->name('supplier.last_receiving');
Route::any('order/label/list',[SupplierController::class,'print_label_list'])->name('supplier.label.list');
Route::any('supplier/view/labels',[SupplierController::class,'print_label2'])->name('supplier.view.label');
Route::any('supplier/check/labels',[SupplierController::class,'check_label'])->name('supplier.check.label');
Route::any('supplier/pdf/pending',[SupplierController::class,'make_pending_pdf'])->name('pdf.pending.orders');

Route::any('supplier/po_list',[SupplierController::class,'po_list'])->name('supplier.po_list');

//Gatepass
Route::get('order/gatepass',[GatePassController::class,'index'])->name('gatepass.index');
Route::post('gatepass/get_all',[GatePassController::class,'getall'])->name('gatepass.get_all');
Route::any('order/statistics',[GatePassController::class,'statistics'])->name('order.statistics');
Route::any('order/get_pr_data',[GatePassController::class,'get_pr_data'])->name('order.prs');
Route::any('order/pdf/gate_pass',[GatePassController::class,'make_gate_pass_pdf'])->name('pdf.gate.pass');
Route::any('order/get/gate_pass_serial',[GatePassController::class,'gate_pass_serial'])->name('gate.pass.serial');
Route::any('order/get/po_list_gatepass_serial',[GatePassController::class,'po_list_gatepass_serial'])->name('gate.po_list_gatepass_serial');
Route::any('order/get/gate_pass_po_list',[GatePassController::class,'gate_pass_po_list'])->name('gate.gate_pass_po_list');
Route::any('order/gatepass/reverse',[GatePassController::class,'reverse_gatepass'])->name('gate.reverse_gatepass');

//Excel
Route::any('list/excel',[UploadExcelController::class,'index'])->name('list.excel');

//Sale Order
Route::any('sale/orders',[SaleOrderController::class,'index'])->name('sale.orders');
Route::any('sale/sale_order',[SaleOrderController::class,'sale_order'])->name('sale.orders.id');
Route::post('sale/adjust',[SaleOrderController::class,'adjust'])->name('sale.adjust');
Route::post('sale/update_status',[SaleOrderController::class,'update_status'])->name('sale.update');
Route::any('sale/{string}',[SaleOrderController::class,'sale_select'])->name('approve.sale.orders');

//Item Log
Route::any('log/items',[LogController::class,'index'])->name('log.item');
Route::any('log/return/log',[LogController::class,'return'])->name('log.item.return');
Route::any('log/barcodes/change',[LogController::class,'barcode_change'])->name('barcode.change.log');


//Item Alteration
Route::any('items/alteration/add', [ItemAlterationController::class,'add'])->name('items.alteration.add');
Route::any('item/{string}/list', [ItemAlterationController::class,'index'])->name('items.alteration.list');
Route::get('items/suppliers/list', [ItemAlterationController::class,'supplier_list'])->name('item.supplier.list');
Route::any('items/skus/list', [ItemAlterationController::class,'sku_list'])->name('item.sku.list');
Route::any('supplier/{string}/items', [ItemAlterationController::class,'supplier_return'])->name('supplier.items.list');
Route::any('items/alteration/statistics',[ItemAlterationController::class,'statistics'])->name('alteration.supplier.statistics');
Route::any('items/supplier/statistics',[ItemAlterationController::class,'get_supplier_wise_data'])->name('supplier.wise.statistics');
Route::any('items/alteration/received',[ItemAlterationController::class,'alteration_received'])->name('alteration.item.received');
Route::any('items/alter/receive',[ItemAlterationController::class,'alter_receive'])->name('alter.receive');

//Shippment
Route::any('shipment/upload',[ShippmentController::class,'index'])->name('upload.shippment');
Route::any('shipment/{id}/download',[ShippmentController::class,'download_file'])->name('upload.shippment.download');
Route::any('shipment/{string}/scan/download',[ShippmentController::class,'shipment_export'])->name('shippment.scan.download');
Route::any('shipment/{string}/view/scan',[ShippmentController::class,'view_scan_list'])->name('shippment.view.scan');
Route::any('shipment/shipment/list',[ShippmentController::class,'shippment_list'])->name('shippment.list');
Route::get('shipment/start/scaning/{string}',[ShippmentController::class,'start_scan'])->name('shippment.start.scan');
Route::any('shipment/add/box',[ShippmentController::class,'add_box'])->name('add.box');
Route::any('shipment/box/info',[ShippmentController::class,'get_all_boxes_info'])->name('box.info');
Route::any('shipment/box/weight',[ShippmentController::class,'get_box_weight_info'])->name('box.weight');
Route::any('shipment/fnsku/scan',[ShippmentController::class,'get_product_img_by_fnsku'])->name('fnsku.scan');
Route::any('shipment/fnsku/scan/add',[ShippmentController::class,'add_qty_inbox'])->name('fnsku.add.scan');
Route::any('shipment/cart/data',[ShippmentController::class,'get_cart_table_data'])->name('get.cart.data');
Route::any('shipment/cart/delete',[ShippmentController::class,'delete_cart_item'])->name('delete.cart.item');
Route::any('shipment/all/data',[ShippmentController::class,'get_all_shipment_data'])->name('shipped.all.data');
Route::any('shipment/{string}/print/label',[ShippmentController::class,'shipment_print_label'])->name('shippment.print.label');
Route::any('shipment/view/label',[ShippmentController::class,'show_print_label'])->name('shippment.view.label');

//Inventory
Route::any('inventory/summary',[InventoryController::class,'index'])->name('inventory.summary');
Route::any('inventory/opening',[InventoryController::class,'export_opening_stock'])->name('opening.download');
Route::any('inventory/upload/opening',[InventoryController::class,'upload_opening'])->name('upload.opening');
Route::any('inventory/sku/detail',[InventoryController::class,'sku_detail_on'])->name('inventory.sku.detail');
Route::any('inventory/item/adjust',[InventoryController::class,'item_adjust'])->name('inventory.item.adjust');

//ReportInventory
Route::prefix('report/inventory')->name('report.inventory.')->group(function () {
    Route::any('/upload',[ReportInventoryController::class,'index'])->name('upload');
    Route::any('/list',[ReportInventoryController::class,'report_list'])->name('list');
    // Route::get('/import',[ReportInventoryController::class,'import_txt']);
});


//ProcessOrder
Route::any('shipment/process/orders',[ProcessOrderController::class,'index'])->name('shipment.process.order');
Route::any('shipment/send/process',[ProcessOrderController::class,'send_to_process'])->name('shipment.send.process');
Route::any('shipment/processed/orders',[ProcessOrderController::class,'processed_order'])->name('shipment.processed.order');
Route::any('shipment/import/orders',[ProcessOrderController::class,'import_processed_order'])->name('shipment.import.order');
Route::any('shipment/export/processed',[ProcessOrderController::class,'export_processed_order_for_ship'])->name('shipment.export.order');


//extra
Route::any('extra/db/reset',[ExtraController::class,'db_reset'])->name('extra.db.reset');
Route::any('extra/test/excel',[ExtraController::class,'get_excel']);
Route::any('extra/test/mail',[ExtraController::class,'test_mail']);



////////Added by Sufian
Route::any('shipment/bundle/list',[ProcessOrderController::class,'bundle_list'])->name('shipment.bundle.list');
Route::any('shipment/add/bundle/list',[ProcessOrderController::class,'add_bundle_processed'])->name('add.bundle.processed');
Route::any('shipment/picklist/pdf',[ProcessOrderController::class,'picklist_pdf'])->name('shipment.picklist.pdf');
Route::any('shipment/complete/status',[ShippmentController::class,'complete_status'])->name('shipment.complete.status');
Route::any('shipment/upload/box_label',[ShippmentController::class,'upload_box_label'])->name('shipment.upload.box_label');
Route::any('shipment/freeze/check',[ShippmentController::class,'shipment_freeze'])->name('shipment.freeze.check');

Route::any('sku/bulk/edit',[SkuController::class,'sku_bulk_edit'])->name('sku.bulk.edit');



/////new 
Route::any('stores/orders/report',[OrderReportController::class,'report_list'])->name('stores.orders.report');


///added date 7-9-22
/////Excel 
Route::get('order/{mod_id}/excel', [OrderController::class,'download_mo_excel'])->name('mo.excel');
Route::get('process/{store_id}/{shipment_type}/list',[ProcessOrderController::class,'excel_process_order'])->name('excel.process.order');
Route::get('ready/{store_id}/{shipment_type}/list',[ProcessOrderController::class,'excel_shipment_ready_order'])->name('excel.shipment.ready.order');


///cron email
Route::get('today/drop/in', [AdminShippmentController::class,'today_drop_in'])->name('today.drop.in');
Route::get('today/ready/shipment', [AdminShippmentController::class,'today_ready_shipment'])->name('today.ready.shipment');
Route::get('pr/data', [AdminShippmentController::class,'pr_data'])->name('pr.data');

///history Controller
Route::any('mo/history',[HistoryController::class,'index'])->name('mo.history');
































