<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\AXFashionOrderController;
use App\Http\Controllers\SPReportController;
use App\Http\Controllers\AssignWHController;
use App\Http\Controllers\DashboardAPIController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

//added by sufian 15-5-24
Route::get('get/{string}/decrumInventoryReport', [SPReportController::class,'get_decrum_inventory']);
Route::get('get/decrumOrderReport', [SPReportController::class,'get_decrum_orders']);
Route::get('get/decrumReturnReport', [SPReportController::class,'get_decrum_returns']);

//added by sufian 21-6-24
Route::get('assign/{string}/inventory', [AssignWHController::class,'assign_wh_qty'])->name('assign_wh_qty');

Route::get('addingGrade', [AssignWHController::class,'addingGrade'])->name('addingGrade');
Route::get('getDashboardStats', [DashboardAPIController::class,'getDashboardStats'])->name('getDashboardStats');


//order report Axfashion
Route::get('axfashion/order/send_request', [AXFashionOrderController::class,'send_request']);
Route::get('axfashion/order/start_process', [AXFashionOrderController::class,'start_process']);
Route::get('axfashion/order/data_save', [AXFashionOrderController::class,'data_save']);


Route::post('order/store', [OrderController::class,'store']);
Route::get('sku/{variation_id}',function(Request $request,$variation_id){
    $where=['variation_design' => $variation_id];
    
    $product_info_design=\DB::table('product_info_design')->where($where)->first();
    if($product_info_design !=NULL){
        
        if($product_info_design->product_url !=''){
            $url=$product_info_design->product_url;
        }else{
            $url=asset('uploads/sku_images/'.$product_info_design->prod_img);
        }
        $img_url=$url;
        
         return response()->json(['code' => 200,'image_url' => $img_url]);
    }else{
        $where=['variation_id' => $variation_id];
        $product_info=\DB::table('product_info')->where($where)->first();
        if($product_info !=''){
            if($product_info->product_url !=''){
                $url=$product_info->product_url;
            }else{
                $url=asset('uploads/sku_images/'.$product_info->prod_img);
            }
            $img_url=$url;
        
            return response()->json(['code' => 200,'image_url' => $img_url]); 
        }else{
            $where=['group_id' => $variation_id];
            $product_info=\DB::table('product_info')->where($where)->first(); 
            if($product_info !=''){
                if($product_info->product_url !=''){
                    $url=$product_info->product_url;
                }else{
                    $url=asset('uploads/sku_images/'.$product_info->prod_img);
                }
                $img_url=$url;
                return response()->json(['code' => 200,'image_url' => $img_url]); 
            }else{
                return response()->json(['code' => 200,'data' => 'No Record Found']);
            }
        }
        
    }
    
    
    
   
});

Route::get('active/latest_sku_list',function(Request $request){
    $product_list=\DB::table('product_info')->where('prod_status',1)->where('is_deleted',0)->select(['group_id','product_name','product_url','prod_img','prod_design','variation_id'])->get();
    if($product_list->count()>0){
        $array=[];
        foreach($product_list as $ms){
            $new=[];
            $array['group_id']=$ms->group_id;
            
            if($ms->product_url !=''){
                $url=$ms->product_url;
            }else{
                $url=asset('uploads/sku_images/'.$ms->prod_img);
            }
            
            $img_url=$url;
            $new['img_url']=$img_url;
            $new['variation_id']=$ms->variation_id;
            $new['product_url']=$ms->product_name;
            $array[]=$new;
            
        }
    }
    return response()->json($array);
});

Route::get('active/sku_list',function(Request $request){
    $product_list=\DB::table('product_info')->where('prod_status',1)->groupBy('group_id')->select(['group_id','product_name','product_url','prod_img','prod_design'])->get();
    
    $array=array();
    if($product_list->count()>0){
        $new=[];
        foreach($product_list as $ms){
            $new['group_id']=$ms->group_id;
            
            $exp=explode(',',$ms->product_name);
            $new['product_title']=$exp[0];
            
            if($ms->product_url !=''){
                $url=$ms->product_url;
            }else{
                $url=asset('uploads/sku_images/'.$ms->prod_img);
            }
            $img_url=$url;
            $new['img_url']=$img_url;
            
            $child_list=\DB::table('product_info')
                            ->where('prod_status',1)
                            ->where('group_id',$ms->group_id)
                            ->select(['variation_id','product_name','product_url','prod_img'])
                            ->get();
            $arr2=[];
            foreach($child_list as $cs){
                $new2=[];
                $new2['variation_id']=$cs->variation_id;
                $new2['product_name']=$cs->product_name;
                
                if($cs->product_url !=''){
                    $url=$cs->product_url;
                }else{
                    $url=asset('uploads/sku_images/'.$cs->prod_img);
                }
                $img_url=$url;
                $new2['img_url']=$img_url;
                $arr2[]=$new2;
            }
            
            $new['child_sku']=$arr2;
            $arr3=[];
            if($ms->prod_design==1){
                $design_list=\DB::table('product_info_design')
                            ->where('prod_status',1)
                            ->where('group_id',$ms->group_id)
                            ->select(['variation_design','product_name','product_url','prod_img'])
                           ->get();
                
                foreach($design_list as $ds){
                    $new3=[];
                    $new3['variation_design']=$ds->variation_design;
                    $new3['product_name']=$ds->product_name;
                
                    if($ds->product_url !=''){
                        $url=$ds->product_url;
                    }else{
                        $url=asset('uploads/sku_images/'.$ds->prod_img);
                    }
                    $img_url=$url;
                    $new3['img_url']=$img_url;
                    $arr3[]=$new3;
                    }
            }
            $new['design_sku']=$arr3;
            
            $array[]=$new;
        }
        
    }
    
    // echo "<pre>";print_r($array);
    
    return response()->json($array);
});

