@extends('layouts.app')
@section('title','Excel List | Mini Opex')
@section('add_css')
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

@endsection

@section('content')

<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Uploaded Excel </strong> List
                            
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped table-earning" id="posts" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>File Name</th>
                                        <th>Type Name</th>
                                        <th>Uploaded Date</th>
                                        <th>Upload By</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                            </table>
                            </div>
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script>
    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "dataSrc": "",
        "ajax":{
                    "url": "{{ route('list.excel') }}",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){ 
                        d._token= "{{csrf_token()}}";
                        d.type=$('#type option:selected').val();
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [5] },
        ],
        bSort: false,
        "ordering": true,
        "columns":[
            { "data": "id","name":"upload_excel.id" },
            { "data": "original_name","name":"upload_excel.original_name" },
            { "data": "type_name","name":"upload_excel.type_name" },
            { "data": "created_at","name":"created_at" },
            { "data": "name","name":"users.name" },
            { "data": "action","name":"action" },
        ],
        initComplete: function () {
            $('#posts_filter input').addClass('form-control-sm');
            $("#posts_filter").append(`
                <select class="float-right form-control-sm ml-1" name="type" id="type">
                    <option value="">Select Type</option>
                    @foreach($list as $key)
                        <option value="{{ $key->type }}">{{ $key->type_name }}</option>
                    @endforeach
                </select>
            `);
            
        },
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
    });

    $('#posts_filter').on('change','#type',function(e){
        e.preventDefault();
        $('#posts').DataTable().ajax.reload().draw();
    })
</script>

    
@endsection