@extends('layouts.app')
@section('title','Urgent Upload | Mini Opex')
@section('add_css')
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.6.5/css/buttons.dataTables.min.css"/>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<x-datatable-js type="css"/>

<style>
.margin{
    margin-left:15%;
}
</style>


    
@endsection

@section('content')
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Upload Urgent Mark</strong> SKUs
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <div class="row">
                                <div class="col-md-4 pb-2 border">
                                    <h2 style="text-align: center;" class="mt-2">Upload</h2>
                                    Download Template: <a href="{{asset('backend/mark_urgent_sample.xlsx')}}" download="mark_urgent_sample.xlsx" class="btn btn-dark btn-sm float-right"><i class="fa fa-download"></i></a>
                <hr>
                                    <form enctype="multipart/form-data" method="post" id="form_id" class="text-sm">
                                <div class="row form-group">
                                    <div class="col-4 col-md-4 col-sm-4 col-lg-4 mt-2">
                                        <label for="file_upload" class=" form-control-label text-info text-sm mt-1">Upload Excel</label>
                                    </div>
                                    <div class="col-12 col-md-8 ">
                                        <input type="file" id="file_upload" name="file_upload"  placeholder="add new role" class="form-control form-control-sm mt-2" onchange="ValidateSingleInput(this,'#errortxt','#form_submit')">
                                        <span class="text-danger text-sm" id="errortxt" style="display: none">Please Upload file in correct format eg excel</span>
                                        
                                    </div>
                                </div>
                                <div class="row form-group">
                                    <div class="col-4 col-md-4 col-sm-4 col-lg-4 mt-2">
                                        <label for="store_selection" class=" form-control-label text-info">Store Selection</label>
                                    </div>
                                    <div class="col-12 col-md-8 mt-2">
                                        <select name="store_selection" id="store_selection" class="form-control select2">
                                            <option value="">Please select</option>
                                            @forelse ($stores as $store)
                                            <option value="{{ $store->id  }}">{{ $store->strong_name }}</option> 
                                            @empty
                                                
                                            @endforelse
                                        </select>
                                    </div>
                                </div>
                                <div class="row form-group">
                                    <div class="col-4 col-md-4 col-sm-4 col-lg-4 mt-2">
                                        <label for="store_selection" class=" form-control-label text-info">Shipment Type</label>
                                    </div>
                                    <div class="col-12 col-md-8 mt-2">
                                        <select name="report_type" id="report_type" class="form-control select2">
                                            <option value="">Please select</option>
                                            <option value="1">Air Cargo</option>
                                            <option value="2">Sea Cargo</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="row form-group">
                                    <div class="col-4 col-md-4 col-sm-4 col-lg-4 mt-2">
                                        <label for="store_selection" class=" form-control-label text-info">Marking Type</label>
                                    </div>
                                    <div class="col-12 col-md-8 mt-2">
                                        <select name="marking_type" id="marking_type" class="form-control select2">
                                            <option value="">Please select</option>
                                            <option value="1">Urgent Mark</option>
                                            <option value="2">Remove Urgent Tag</option>
                                        </select>
                                    </div>
                                </div>
                                <button type="button" name="form_submit" id="form_submit" class="btn btn-primary btn-sm btn-block"><i class="fas fa-upload"></i> Upload</button>
                            </form>
                                    
                                    
                                    
                                </div>
                            </div>
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>


<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<x-datatable-js type="js"/>

<script>
    

    
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});

    let validator=$('#form_id').validate({
            errorClass:'text-danger',
            success:'text-success',
            errorElement: 'span',
            rules:{
                file_upload:{
                    required:true,
                },
                store_selection:{
                    required:true
                },
                shipment_type:{
                    required:true
                },
                marking_type:{
                    required:true
                },
            },
            messages:{
                file_upload:{
                    required:"File Upload is required",
                },
                store_selection:{
                    required:"Store is required"
                },
                shipment_type:{
                    required:"Report Type is required"
                },
                marking_type:{
                    required:"Report Type is required"
                },
            },
            highlight: function(element, errorClass, validClass) {
                $(element).closest('.form-control').addClass('has-warning');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).closest('.form-group').removeClass('has-error');
            },
            errorPlacement: function (error, element) {
                
                if(element.hasClass('select2') && element.next('.select2-container').length) {
                    error.insertAfter(element.next('.select2-container'));
                }else if(element.attr("name") == "cargo_select"){
                    error.insertAfter(".span-next");
                }else{
                    error.insertAfter(element);
                }
            },
        });
        
        jQuery.validator.addMethod("lettersonly", function(value, element) {
          return this.optional(element) || /^[a-z]+$/i.test(value);
        }, "Letters only please");
        
    
    
    
    
    $('#form_submit').click(function(){
        var file_data = $("#file_upload").prop("files")[0]; // Getting the properties of file from file field
        var form_data = new FormData();
        // console.log(file_data);return;
        if($('#form_id').valid()){
             // Creating object of FormData class
            form_data.append("file_upload", file_data); // Appending parameter named file with properties of file_field to form_data
            form_data.append("_token", "{{csrf_token()}}");
            form_data.append("store_selection",$('#store_selection').val());
            form_data.append("shipment_type",$('#report_type').val());
            form_data.append("marking_type",$('#marking_type').val());
            $('#form_submit').prop('disabled',true);
            loader('#form_id');
            $.ajax({
                url:"{{ route('shipment.urgentMark.uploader') }}",
                type:'POST',
                dataType: 'json',
                cache: false,
                contentType: false,
                processData: false,
                data: form_data,
                success:function(data){
                    loader('#form_id',0);
                    if(data.code =='200'){
                        toastMsg(data.message);
                        location.reload();
                        
                        $("#store_selection").val("").triger();
                        $('#form_id').trigger("reset");
                    }else{
                        toastMsg(data.message,2);
                    }
                    $('#form_submit').prop('disabled',false);
                }
            })

        }else{
            toastMsg(data.message,2);
        }
    });
</script>

    
@endsection