@extends('layouts.app')
@section('title','View Orders | Mini Opex')
@section('add_css')
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

<x-datatable-js type="css"/>

    
@endsection

@section('content')
<!-- modal color -->
<div class="modal fade" id="blisterModal" tabindex="-1" role="dialog" aria-labelledby="blisterModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="blisterModalLabel">Switch Supplier</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="switchSupplierForm">
                @csrf
            <div class="modal-body">
                <div id="data_reason"></div>
                <hr>
                <div class="row">
                    <span class="text-success col-md-6 mt-2">Remaining Qty:</span>
                    <h1 class="text-lg col-md-6" id="last_rec"></h1>  
                </div>
                
                <hr>
                <div class="form-group ">
                    <label for="text-input" class=" form-control-label">Enter Assign QTY</label>
                    <input type="number" id="assign_qty" name="assign_qty" placeholder="enter the assign qty....." class="form-control" pattern="^[0-9]*$" min="1"  required>
                    <input type="hidden" id="actual_qty" name="actual_qty" placeholder="blister_qty" class="form-control" readonly>
                    <input type="hidden" id="assign_id" name="assign_id" placeholder="assign_id" class="form-control" readonly>
                </div>
                <div class="form-group">
                    <label for="switch_supplier_id" class="pr-1  form-control-label">Supplier Name</label>
                    <select name="switch_supplier_id" id="switch_supplier_id" class="form-control " required>
                        <option value="">Select Supplier</option>
                        @forelse ($suppliers as $supplier)
                            <option value="{{ $supplier->id }}" class="sup_option" id="sup_option_{{ $supplier->id }}" data-supplier_id="{{ $supplier->id }}">{{ $supplier->supplier_name }}</option>
                        @empty
                            
                        @endforelse
                    </select>
                </div>
                
                <div class="form-group ">
                    <label for="text-input" class=" form-control-label">Comments </label>
                    <textarea class="form-control" id="comments" name="comments" required></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary" id="blisterBtn">Switch</button>
                
                
            </div>
            </form>
        </div>
    </div>
</div>
<!-- end modal blister -->
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>View Orders </strong>
                            @can('supplier-create')
                                <a href="{{ route('supplier.add')}}" class="btn btn-info btn-sm float-right">Add New Supplier</a>
                                <!--<a href="javascript:;" id="custom_pdf" class="btn btn-info btn-sm float-right">Custom PDF</a>-->
                                
                            @endcan
                            
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            {{-- <div class="container mb-5" style="border-radius:1px;background-color:#FFF8DC"> --}}
                            <div class="row mb-2">
                                <div class="col-md-4 form-group">
                                    <label for="exampleInputName2" class="pr-1  form-control-label">Supplier Name</label>
                                    <select name="supplier" id="supplier" class="form-control select2" style="width: 50%">
                                        <option value="">ALL</option>
                                        @forelse ($suppliers as $supplier)
                                            <option value="{{ $supplier->id }}">{{ $supplier->supplier_name }}</option>
                                        @empty
                                            
                                        @endforelse
                                    </select>
                                    <input type="hidden"  id="supplier_name" value="ALL">
                                </div>
                                <div class="col-md-4 form-group">
                                    <label for="exampleInputName2" class="pr-1  form-control-label">PO List</label>
                                    <select name="po_id" id="po_id" class="form-control form-control-sm select2" multiple style="width: 50%">
                                        <option value="">ALL</option>
                                        @forelse ($po_list as $po)
                                            <option value="{{ $po->po_id }}">PO Id: {{ $po->po_id }}&nbsp;&nbsp;|&nbsp;&nbsp;Supplier: {{$po->supplier_name}}&nbsp;&nbsp;|&nbsp;&nbsp;Date: {{$po->assign_date}}&nbsp;&nbsp;|&nbsp;&nbsp;Store: {{$po->strong_name}}&nbsp;&nbsp;|&nbsp;&nbsp;Type: {{$po->supplier_name==1 ? "Air Cargo" : "Sea Cargo"}}</option>
                                        @empty
                                            
                                        @endforelse
                                    </select>
                                    
                                </div>
                                <div class="col-md-4 form-group">
                                    <div class="alert alert-warning">
                                        <h3>
                                            <span class="badge badge-info">Total Order : <span id="total_order_ex">{{ $total_po->total_order ?? '0' }}</span></span>
                                            <span class="badge badge-success">Total Received : <span id="total_received_ex">{{ $total_po->total_received ?? '0' }}</span></span>
                                            <span class="badge badge-danger">Total Pending : <span id="total_pending_ex">{{ $total_po->remaining ?? '0' }}</span></span>
                                        </h3>
                                    </div>
                                </div>
                                <div class="col-md-4 ">
                                    <form action="{{route('skuWise.pending')}}" method="post">
                                        @csrf
                                        <button type="submit" class="btn btn-info btn-sm"><i class="fas fa-file-excel"></i> Download Supplier Pending SKU Wise</a>
                                    </form>
                                </div>
                            </div>
                                
                                 <!--style="display:none"-->
                                <div style="display:none">
                                   <form id="pdfPendingOrder" action="{{route('pdf.pending.orders')}}" method="POST">
                                    @csrf
                                    <input type="text" id="supplier_id" name="supplier_id" value="ALL"/>
                                    <input type="text" id="po_id2" name="po_id2" value="ALL"/>
                                    <button class="btn btn-success btn-sm " type="submit" id="makePDF">PDF</button>
                                    <button class="btn btn-success btn-sm " type="button" id="makePrint">Print</button>
                                </form> 
                                </div>
                                
                               
                            {{-- </div> --}}
                            <hr>
                            
                            <div id="editor"></div>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" cellspacing="0" width="100%" id="posts" data-supplier-name=''>
                                    <thead >
                                        <tr class="thead-light">
                                            <!--<th></th>-->
                                            <!--<th></th>-->
                                            <!--<th></th>-->
                                            <th colspan="4" class="text-right">TOTAL</th>
                                            <th id="order_qty"></th>
                                            <th id="receive_qty"></th>
                                            <th id="remaining_qty" colspan="2"></th>
                                        </tr>
                                        <tr class="thead-dark">
                                            
                                            <th>Supplier Name</th>
                                            <th>Assign Date</th>
                                            <th>Product Detail</th>
                                            <th>Product Size</th>
                                            <th>Assigned QTY</th>
                                            <th>Receive QTY</th>
                                            <th>Remaining QTY</th>
                                            <th>Action</th>
                                            
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                            <!--<th></th>-->
                                            <!--<th></th>-->
                                            <!--<th></th>-->
                                            <th colspan="4" class="text-right"></th>
                                            <th></th>
                                            <th></th>
                                            <th colspan="2"></th>
                                        </tr>
                                    </tfoot>
                                </table>
                                
                            </div>
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<!--<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>-->
<!--<script src="https://unpkg.com/jspdf-autotable@3.5.15/dist/jspdf.plugin.autotable.js"></script>-->
<!--<script src="js/jsPDF/dist/jspdf.umd.js"></script>-->



<x-datatable-js type="js"/>

<script>
    $('.select2').select2({
        width:'resolve'
    });
    var date_options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
    var today = new Date().toLocaleDateString('en-UK',date_options);
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});
    
    // window.jsPDF = window.jspdf.jsPDF;
    // $('#custom_pdf').click(function(){
    //     var doc = new jsPDF();
    
    //     var elementHTML = document.querySelector("#posts");
    //     doc.html(elementHTML, {
    //         callback: function(doc) {
    //             // Save the PDF
    //             doc.save('sample-document.pdf');
    //         },
    //         x: 15,
    //         y: 15,
    //         width: 170, //target width in the PDF document
    //         windowWidth: 650 //window width in CSS pixels
    //     });
    // });
    
    
    
    // var doc = new jsPDF('p','pt', 'a4', true);
    // var specialElementHandlers = {
    //     '#editor': function (element, renderer) {
    //         return true;
    //     }
    // };
    
    // $('#tablepdf').click(function () {
    //      doc.autoTable({ html: '#posts' })
    //     setTimeout(function () {
    //             doc.save('sample-file.pdf');
    //         }, 0);
        
    // });

    
       var table = $('#posts').DataTable({
            "processing": true,
            "serverSide": true,
             "pageLength": 50,
             
             @if(in_array(auth()->user()->id,[16,27]))
             lengthMenu: [
                [10, 25, 50,100,500,-1],
                [10, 25, 50,100,500,'ALL'],
            ],
            @else
            lengthMenu: [
                [10, 25, 50,100,500],
                [10, 25, 50,100,500],
            ],
            @endif
            //  fixedHeader: {
            //     header: true,
            //     footer: true
            // },
            "dataSrc": "",
            "ajax":{
                     "url": "{{ route('supplier.retrive') }}",
                    //  "dataType": "json",
                     "type": "POST",
                     data:function(d){
                        d._token= "{{csrf_token()}}";
                        d.supplier_id=$('#supplier').val();
                        d.po_id=$('#po_id').val();
                    },
                   },
            "columnDefs": [
                { "orderable": false, "targets": [6] },
                { "width": "100%", "targets": [2] }
            ],
            initComplete: function () {
                $('.buttons-excel').html('<i class="fas fa-file-excel"></i> Excel').removeClass('dt-button');
                // $('.buttons-pdf').html('<i class="fas fa-file-pdf"></i> Pdf').removeClass('dt-button');
                $('.buttons-print').html('<i class="fas fa-print"></i> Print').removeClass('dt-button');
                $('.buttons-page-length').html('<i class="far fa-file"></i> Page Length').removeClass('dt-button').css('color','white');
                $('.button-page-length').removeClass('dt-button').addClass('btn btn-primary');
                $('.dataTables_paginate > span .paginate_button').addClass('btn btn-primary');
                $('.clpdf').removeClass('dt-button');
                $('.dt-buttons').addClass('ml-5');
                $('.dt-buttons .clpdf').hide();

                var info = $('#posts').DataTable().page.info();
                tot = info.recordsTotal;
                
                if (tot > 0) {
                    $('#posts').DataTable().buttons().enable();
                } else {
                    $('#posts').DataTable().buttons().disable();
                }
                
                


            },
            "drawCallback": function () {
                $('.dataTables_paginate >span .paginate_button').removeClass('paginate_button').addClass('btn btn-primary');
            },
            bSort: false,
            "ordering": false,
            "columns": [
                { "data": "supplier_name","name":"suppliers.supplier_name" },
                { "data": "assign_date","name":"assign_date" },
                { "data": "variation_id","name":"variation_id" },
                { "data": "size","name":"product_size.size" },
                { "data": "receive_qty","name":"assign_quantity.receive_qty" },
                { "data": "receiving_qty","name":"assign_quantity.receiving_qty" },
                { "data": "remaining","name":"remaining" },
                { "data": "action","name":"action" },
            


            ],dom: 'lBfrtip',
            buttons: [
                {   extend: 'excelHtml5', 
                    className: 'btn btn-danger',
                    footer: true,
                    header:false,
                    download: 'open',
                    customize: function ( xlsx ) {
                        var sheet = xlsx.xl.worksheets['sheet1.xml'];
                        //Bold Header Row
                        $('row[r=4] c', sheet).attr( 's', '2' );
                        //Make You Input Cells Bold Too
                        $('c[r=A2]', sheet).attr( 's', '2' );
                        $('c[r=F2]', sheet).attr( 's', '2' );

                    },
                    customizeData: function(data){
                        var desc = [
                            ['',''],
                            ['Supplier Name',$('#posts').attr('data-supplier-name'),'','','','Report Date',today],
                        ];
                        data.body.unshift(data.header)
                        for (var i = 0; i < desc.length; i++) {
                            data.body.unshift(desc[i]);
                        };
                    }
                },
                // {   extend: 'pdfHtml5', 
                //     footer: true,
                //     className: 'btn btn-success',
                //     // download: 'open',
                //     exportOptions: { columns: ':visible',},
                //     messageTop: function(){
                //         return "Supplier Name : " + $('#posts').attr('data-supplier-name')+'                        Report Date : '+ today ;
                //     },
                    
                    
                //  },
                {
                    className: 'btn btn-success clpdf',
                    text: '<i class="fas fa-file-pdf"></i> PDF',
                    action: function ( e, dt, node, config ) {
                        $('#makePDF').click();
                    }
                },
                
                {
                    className: 'btn btn-warning clpdf',
                    text: '<i class="fas fa-print"></i> PO Print',
                    action: function ( e, dt, node, config ) {
                        $('#makePrint').click();
                    }
                },
                
                {   
                    extend: 'print', 
                    className: 'btn btn-info',
                    text: '<i class="fas fa-file-pdf"></i> PDF',
                    footer: true,
                    autoPrint: true,
                    exportOptions: { stripHtml: false, },
                    messageTop: function(){
                        return "Supplier Name : " + $('#posts').attr('data-supplier-name')+'<br>Report Date : '+ today ;
                    },
                },
                // { extend: 'pageLength', className: 'btn btn-primary'},
                
                
 
            
            ],
            "drawCallback": function( settings ) {
                loader('#posts',0);
                
                var info = $('#posts').DataTable().page.info();
                tot = info.recordsTotal;
                
                if (tot > 0) {
                    $('#posts').DataTable().buttons().enable();
                } else {
                    $('#posts').DataTable().buttons().disable();
                }
                
                var check_pdf=0;
                
                $('#posts').on( 'search.dt', function () {
                    var val=$('#posts').DataTable().search();
                    var supplier2=$('#supplier option:selected').val();
                    if(val !=''){
                        
                        if(supplier2!=''){
                            $('.dt-buttons .clpdf').hide();
                        }else{
                            $('.dt-buttons .clpdf').show();
                        }
                        // $('.dt-buttons .clpdf').hide();
                        
                    }else{
                        if(supplier2==''){
                            $('.dt-buttons .clpdf').hide();
                        }else{
                            $('.dt-buttons .clpdf').show();
                        }
                        // $('.dt-buttons .clpdf').show();
                    }
                    
                });
                
                // var supplier2=$('#supplier option:selected').val();
                // if(supplier2==''){
                //     $('.dt-buttons .clpdf').hide();
                // }else{
                //     $('.dt-buttons .clpdf').show();
                // }
               
                
                // $('#posts').on( 'order.dt', function () {
                //     $('.dt-buttons .clpdf').hide();
                // });
                
                // $('#supplier').on('change',function(){
                //      $('.dt-buttons .clpdf').show();
                // })
                
                
            },
            'preDrawCallback': function(settings) {
                loader('#posts');
                
            },
            "footerCallback": function ( row, data, start, end, display ) {
                var api = this.api(), data;
    
                // converting to interger to find total
                var intVal = function ( i ) {
                    return typeof i === 'string' ?
                        i.replace(/[\$,]/g, '')*1 :
                        typeof i === 'number' ?
                            i : 0;
                };
    
                // computing column Total of the complete result 
                var monTotal = api
                    .column( 4 )
                    .data()
                    .reduce( function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0 );
                    
                var tueTotal = api
                        .column( 5 )
                        .data()
                        .reduce( function (a, b) {
                            return intVal(a) + intVal(b);
                        }, 0 );
                        
                    var wedTotal = api
                        .column( 6 )
                        .data()
                        .reduce( function (a, b) {
                            b = b.replace(/<\/?[^>]+(>|$)/g, "");
                            b = b.replace('Cancel Order', "");
                            console.log(b);
                            return intVal(a) + intVal(b);
                        }, 0 );
                                
                    // Update footer by showing the total with the reference of the column index 
                    // $( api.column( 0 ).footer() ).html('');
                    // $( api.column( 1 ).footer() ).html('');
                    // $( api.column( 2 ).footer() ).html('');
                    $( api.column( 3 ).footer() ).html('TOTAL');
                    $( api.column( 4 ).footer() ).html(monTotal);
                    $('#order_qty').text(monTotal);
                    $( api.column( 5 ).footer() ).html(tueTotal);
                    $('#receive_qty').text(tueTotal);
                    $( api.column( 6 ).footer() ).html(wedTotal);
                    $('#remaining_qty').text(wedTotal);
            },
        });
        
        $('#supplier').on('change',function(){
            $('#supplier_name').val($("#supplier option:selected").text());
            $('#posts').attr('data-supplier-name',$("#supplier option:selected").text());
            if($("#supplier option:selected").val() !=""){
                $('#supplier_id').val($("#supplier option:selected").val());    
            }else{
                $('#supplier_id').val('ALL');
            }
            get_po_list();
            
            $('.dt-buttons .clpdf').show();
            if($("#supplier option:selected").val() !=''){
                $('#posts').DataTable().column(0).visible(false); 
            }else{
                $('#posts').DataTable().column(0).visible(true); 
            }
            $('#posts').DataTable().ajax.reload().draw();
            
        });
        
        
        
        
        $('#po_id').on('change',function(){
            var val=$(this).val();
            if(val !=''){
                $('#po_id2').val(val);    
            }else{
                $('#po_id2').val('ALL');
            }
            
            $('#posts').DataTable().ajax.reload().draw();
        });
        
        function get_po_list(){
            $.ajax({
                url:"{{route('supplier.po_list')}}",
                type:'POST',
                data:{
                    _token: "{{csrf_token()}}",
                    supplier_id:$('#supplier').val()
                },
                dataType:'json',
                success:function(data){
                    $('#po_id').html(data.html);
                    $('#po_id2').val('ALL');
                    $('#total_pending_ex').text(data.remaining);
                    $('#total_received_ex').text(data.total_received);
                    $('#total_order_ex').text(data.total_order);
                }
            })
        }
        
        $('#posts').on( 'search.dt', function () {
            var val=$('#posts').DataTable().search();
            
            
        } );
        
        $('#tablepdf').click(function(e){
            e.preventDefault();
            $('#makePDF').click();
        })

        
    

    function get_options(id){
       var val=$('#options_'+id).val();
       if(val=="edit"){
           console.log($('#options_'+id).find(":selected").attr('data-link'));
           window.location.href=$('#options_'+id).find(":selected").attr('data-link');
       }else if(val =='delete'){
           $.ajax({
               url:$('#options_'+id).find(":selected").attr('data-link'),
               type:"POST",
               data:{ _token: "{{csrf_token()}}"},
               success:function(data){
                   if(data){
                    location.reload();
                   }
               }
           })
       }
    }
    
    $('#makePrint').click(function(){
        print_po();
    });
    
    function print_po(){
        
        var formData=$('#pdfPendingOrder').serializeArray();
        formData.push({ name: "is_print", value: "1" });
        // console.log(formData);return;
        var url = '{{route('pdf.pending.orders')}}';
        // url = url.replace(':id',id);
        var w;
        $.ajax({
            url:url,
            type:'POST',
            cache: false,
            datatype: 'json',
            data:formData,
            async: false,
            success:function(data){
                if(data.success==true){
                    
                    w = window.open('about:blank','pos_popup', 'width=900,height=600,menubar=yes,scrollbars=yes,status=no,resizable=yes,screenx=0,screeny=0');
                    w.document.open();
                    w.document.write(data.html);
                    
                    // 
                    
                    w.document.close();
                    setTimeout(function(){ w.print(); }, 2000);
                    
                    // $('#no_of_label').val('');
                    // $('#blister_qty').val('');
                    // $('#blisterModal').modal('hide');
                    
                    // $('<html>').html(data.html).print(); 
                }
            }
        });
    }

    function loader(id,show=1){
        if(show){
            $(id).css({
                'position':'relative',
            });
            $('<div>',{
                class:'loaderShow bg-info'
            }).css({
                'z-index': '1000','position':'absolute','font-size': '12px',
                'top':'5%','left':'50%','padding':'10px','border-radius':'10px'
            }).prependTo(id)
            .html('<i class="fas fa-spinner fa-pulse fa-3x fa-spin" style="color:white"></i><span class="sr-only">Loading...</span>');
        }else{
            $(id+' .loaderShow').remove();
        }
    }
    
    $('#posts').on('click','.switch_supplier',function(){
        var data_row = table.row($(this).closest('tr')).data();
        $('#switchSupplierForm').trigger("reset");
        var url='',img='';
        
        if(data_row.product_url !=''){
            url=data_row.product_url;
            img=' <img src="'+data_row.product_url+'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
        }else{
            url="{{asset('uploads/sku_images')}}/"+data_row.prod_img;
            img='<img src="'+url+'" class="rounded img-thumbnail" alt="Cinque Terre" width="100" height="100">';
        }
               
        var html=`
            <div class="row">
                <div class="col-md-4">
                    <a class="single_image" href="${url}" target="_blank" data-featherlight="image">
                        ${img}
                    </a>
                </div>
                <div class="col-md-8">
                    <strong>${data_row.product_name}</strong><br>
                    <span class="text-success">SKU : <strong>${data_row.variation_design}</strong></span><br>
                    <span class="text-primary">PO ID: <strong>${data_row.po_id}</strong></span><br>
                    <span class="text-text">Supplier Name : <strong>${data_row.supplier_name}</strong></span><br>
                    
                </div>
            </div>`;
        var b=data_row.remaining;
        b = b.replace(/<\/?[^>]+(>|$)/g, "");
        b = b.replace('Cancel Order', "");
        
        $('#data_reason').html(html);
        $('#last_rec').text(b);
        $('.sup_option').show().removeAttr('disabled');
        $('#sup_option_'+data_row.supplier_id).hide().attr('disabled','disabled');
        
        $('#actual_qty').val(b);
        $('#assign_qty').val(b);
        $('#assign_id').val(data_row.id);
        console.log(data_row);
        $('#blisterModal').modal('show');
    });
    
    $(document).on('submit','#switchSupplierForm',function(e){
        e.preventDefault();
        var formdata=$(this).serialize();
        
        var actual_qty=parseInt($('#actual_qty').val());
        var assign_qty=parseInt($('#assign_qty').val());
        if(assign_qty ==0){
            $.toast({
                heading: 'Error',
                text: 'Accept only Numbers not Zero',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            return;
        }
        
        if(assign_qty>actual_qty){
            $.toast({
                heading: 'Error',
                text: 'Assign Qty Greater than Remaining QTY',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
        }else{
            $.ajax({
                url:"{{route('switch.supplier')}}",
                data:formdata,
                type:'POST',
                dataType:'JSON',
                success:function(data){
                    if(data.success==1){
                        $('#blisterModal').modal('hide');
                        $('#switchSupplierForm').trigger("reset");
                        $('#posts').DataTable().ajax.reload().draw();
                    }
                }
            })
            
        }
        
        
    });
    
    $(document).on('click','.cancelled_order',function(){
        var self=$(this);
        var assign_id=self.data('assign_id');
        if(confirm('Are you sure want to Cancel ?')){
            var comments=prompt("Reason");
            if (comments === null) {
                $.toast({
                    heading: 'Error',
                    text: 'Reason is Required',
                    showHideTransition: 'slide',
                    icon: 'error',
                    position: 'top-right',
                });
                return;
            }
            if(comments !=''){
                $.ajax({
                    url:"{{route('supplier.order.cancellation')}}",
                    data:{
                       _token:"{{csrf_token()}}",
                       id:assign_id
                    },
                    dataType:'JSON',
                    success:function(data){
                        if(data.success=='1'){
                            $.toast({
                                heading: 'Success',
                                text: 'Supplier Order Cancel Successfully',
                                showHideTransition: 'slide',
                                icon: 'success',
                                position: 'top-right',
                            });
                            $('#posts').DataTable().ajax.reload().draw();
                            
                        }
                    }
                });
            }else{
                $.toast({
                    heading: 'Error',
                    text: 'Reason is Required',
                    showHideTransition: 'slide',
                    icon: 'error',
                    position: 'top-right',
                });
            }
        }
    });
</script>

    
@endsection