@extends('layouts.app')
@section('title',($order_string =='receiving')?'Drop In Warehouse | Mini Opex':'Complete Orders | Mini Opex')
@section('add_css')
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">




    
@endsection

@section('content')
<!-- modal color -->
<div class="modal fade" id="blisterModal" tabindex="-1" role="dialog" aria-labelledby="blisterModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="blisterModalLabel">Add Blister Quantity</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <span class="text-success col-md-6 mt-2">Receiving Qty:</span>
                    <h1 class="text-lg col-md-6" id="last_rec"></h1>  
                </div>
                
                <hr>
                <div class="form-group ">
                    <label for="text-input" class=" form-control-label">Enter Blister QTY</label>
                    <input type="text" id="blister_qty" name="blister_qty" placeholder="blister_qty" class="form-control" onkeypress="return isNumber(event)">
                    <input type="hidden" id="actual_qty" name="actual_qty" placeholder="blister_qty" class="form-control" readonly>
                    <input type="hidden" id="data_id" name="data_id" placeholder="data_id" class="form-control">
                </div>
                <div class="form-group ">
                    <label for="text-input" class=" form-control-label">No of Labels</label>
                    <input type="text" id="no_of_label" name="no_of_label" placeholder="no_of_label" class="form-control" value="1" onkeypress="return isNumber(event)">
                    <span class="text_danger" id="label_err"></span>
                </div>
                <div class="form-check" id="first_check" style="display: none">
                    <div class="checkbox">
                        <label for="first_agreed_Status" class="form-check-label ">
                            <input type="checkbox" id="first_agreed_Status" name="first_agreed_Status" value="option1" class="form-check-input" value="1">Agreed
                        </label>
                    </div>
                </div>
                
                {{-- <div class="form-group">
                    <label for="comment_box" class=" form-control-label">Comment box </label>
                    <textarea name="first_status_comment" id="first_status_comment" rows="2" placeholder="Comments" class="form-control form-control-sm"></textarea>
                    
                </div> --}}
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="blisterBtn">Print Label</button>
                
                
            </div>
        </div>
    </div>
</div>
<!-- end modal blister -->
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>
                                @if($order_string=='receiving')
                                    Drop In Warehouse
                                @else
                                    Complete Orders
                                @endif
                            </strong> 
                            @can('pending-orders')
                            <a href="{{ route('supplier.retrive')}}" class="btn btn-info btn-sm float-right">View Orders</a>
                                
                            @endcan
                            
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            {{-- <div class="container mb-5" style="border-radius:1px;background-blister:#FFF8DC"> --}}
                                <div class="row mb-2">
                                    <div class="col-md-4 form-group">
                                        <label for="exampleInputName2" class="pr-1  form-control-label">Supplier Name</label>
                                        <select name="supplier" id="supplier" class="form-control select2" style="width: 50%">
                                            <option value="">ALL</option>
                                            @forelse ($suppliers as $supplier)
                                                <option value="{{ $supplier->id }}">{{ $supplier->supplier_name }}</option>
                                            @empty
                                                
                                            @endforelse
                                        </select>
                                        <input type="hidden"  id="supplier_name" value="ALL">
                                    </div>
                                    <div class="col-md-4 form-group">
                                        <label for="exampleInputName2" class="pr-1  form-control-label">PO List</label>
                                        <select name="po_id" id="po_id" class="form-control select2" style="width: 50%">
                                            <option value="">ALL</option>
                                            @forelse ($po_list as $po)
                                                <option value="{{ $po->po_id }}">{{ $po->po_id }}</option>
                                            @empty
                                                
                                            @endforelse
                                        </select>
                                        
                                    </div>
                                </div>
                               
                            {{-- </div> --}}
                            <hr>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" id="posts" cellspacing="0" width="100%">
                                    <thead >
                                        <tr class="thead-light">
                                            <th colspan="3" class="text-right">Total</th>
                                            <th id="order_qty">0</th>
                                            <th id="received_qty">0</th>
                                            @if($order_string=='receiving')
                                            <th colspan="3" id="remaining_qty">0</th>
                                            @endif
    
                                        </tr>
                                        <tr class="thead-dark">
                                            <th>ID</th>
                                            <th>Product Detail</th>
                                            <th>Product Size</th>
                                            <th>Order QTY</th>
                                            <th>Received QTY</th>
                                            @if($order_string=='receiving')
                                            <th>Remaining QTY</th>
                                            <th>Receive QTY</th>
                                            <th>Action</th>
                                            @endif
    
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                            <th colspan="3" class="text-right">Total</th>
                                            <th>0</th>
                                            <th>0</th>
                                            @if($order_string=='receiving')
                                            <th colspan="3">0</th>
                                            @endif
    
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript" src="{{ asset('backend/toast/jquery.toast.min.js') }}"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script>
    var sale_type="{{ $order_string }}";
    var data_col;
    var target;
    var type;
    if(sale_type=='receiving'){
        data_col=[
            { "data": "id","name":"assign_quantity.id" },
            { "data": "variation_id","name":"variation_id" },
            { "data": "size","name":"product_size.size" },
            { "data": "receive_qty","name":"assign_quantity.receive_qty" },//Order QTY
            { "data": "receiving_qty","name":"assign_quantity.receiving_qty" },//Received QTY
            { "data": "remaining","name":"remaining" },//Remaining QTY
            { "data": "receiving_input","name":"receiving_input" },
            { "data": "action","name":"action" }
        ];
        type='1';
        target=[5,6,7];
    }else if(sale_type=='complete'){
        data_col=[
            { "data": "id","name":"assign_quantity.id" },
            { "data": "variation_id","name":"variation_id" },
            { "data": "size","name":"product_size.size" },
            { "data": "receive_qty","name":"assign_quantity.receive_qty" },//Order QTY
            { "data": "receiving_qty","name":"assign_quantity.receiving_qty" },//Received QTY
            // { "data": "action","name":"action" }
        ];
        type='2';
        target=[];
    }


    $('.select2').select2({
        width:'resolve'
    });
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});

    
    var table =$('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "dataSrc": "",
        "ajax":{
                    "url": "{{ route('supplier.receiving.add',$order_string) }}",
                //  "dataType": "json",
                    "type": "POST",
                    data:function(d){
                    d._token= "{{csrf_token()}}";
                    d.type=type;
                    d.supplier_id=$('#supplier').val();
                    d.po_id=$('#po_id').val();
                },
                },
        "columnDefs": [
            { "orderable": false, "targets": target },
             { "width": "100%", "targets": [1] }
        ],
        bSort: false,
        "ordering": false,
        "columns": data_col,
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
 
            // converting to interger to find total
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            var tueTotal = api
                .column( 3 )
                .data()
                .reduce( function (a, b) {
                    // b = b.replace(/<\/?[^>]+(>|$)/g, "");
                    return intVal(a) + intVal(b);
                }, 0 );
                    
            var wedTotal = api
                .column( 4 )
                .data()
                .reduce( function (a, b) {
                    // b = b.replace(/<\/?[^>]+(>|$)/g, "");
                    return intVal(a) + intVal(b);
                }, 0 );
                  @if($order_string=='receiving')  
                var thuTotal = api
                    .column( 5 )
                    .data()
                    .reduce( function (a, b) {
                        // b = b.replace(/<\/?[^>]+(>|$)/g, "");
                        // b = b.replace('Order QTY : ', "");
                        return intVal(a) + intVal(b);
                    }, 0 );
                @endif
                
                // Update footer by showing the total with the reference of the column index 
                $( api.column( 2 ).footer() ).html('TOTAL');
                $( api.column( 3 ).footer() ).html(tueTotal);
                $('#order_qty').text(tueTotal);
                $('#received_qty').text(wedTotal);
                $( api.column( 4 ).footer() ).html(wedTotal);
                @if($order_string=='receiving')
                    $('#remaining_qty').text(thuTotal);
                    $( api.column( 5 ).footer() ).html(thuTotal);
                @endif
        },
    });

    function loader(id,show=1){
        if(show){
            $(id).css({
                'position':'relative',
            });
            $('<div>',{
                class:'loaderShow bg-info'
            }).css({
                'z-index': '1000','position':'absolute','font-size': '12px',
                'top':'5%','left':'50%','padding':'10px','border-radius':'10px'
            }).prependTo(id)
            .html('<i class="fas fa-spinner fa-pulse fa-3x fa-spin" style="color:white"></i><span class="sr-only">Loading...</span>');
        }else{
            $(id+' .loaderShow').remove();
        }
    }

    $('#supplier').on('change',function(){
        // console.log($('#supplier').text());
        get_po_list();
        $('#posts').DataTable().ajax.reload().draw();
    });
    
    $('#po_id').on('change',function(){
        // console.log($('#supplier').text());
        // get_po_list();
        $('#posts').DataTable().ajax.reload().draw();
    });
    
    function get_po_list(){
        $.ajax({
            url:"{{route('supplier.po_list')}}",
            type:'POST',
            data:{
                _token: "{{csrf_token()}}",
                supplier_id:$('#supplier').val(),
                sale_type:sale_type
            },
            dataType:'json',
            success:function(data){
                $('#po_id').html(data.html);
                // $('#po_id2').val('ALL');
            }
        })
        }
        
    $('#posts').on('keypress','.input_rec',function(event){
        if (event.key === "Enter") {
            var data_row = table.row($(this).closest('tr')).data();
        // console.log(data_row);return;
        var val=$('#receiving_qty_'+data_row.id).val().trim();
        var rece_qty;

        if(!/^[0-9]+$/.test(val) || val == 0){
            $('#error_'+data_row.id).text('Input Receive Only Numbers and receive input is not 0');
            $('#error_'+data_row.id).show();
            $.toast({
                heading: 'Error',
                text: 'Input Receive Only Numbers and receive input is not 0',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
        }else{
            rece_qty=parseInt((data_row.receiving_qty =='0')?data_row.receive_qty:data_row.receiving_qty);
            rece_qty=parseInt((data_row.remaining>=rece_qty)?data_row.remaining:rece_qty);
            
            // console.log(rece_qty);return;
            if(val>data_row.remaining){
                $('#error_'+data_row.id).text('Number Exceed from Order Qty');
                $('#error_'+data_row.id).show();
                $.toast({
                    heading: 'Error',
                    text: 'Number Exceed from Order Qty',
                    showHideTransition: 'slide',
                    icon: 'error',
                    position: 'top-right',
                }); 
                return;
            }else{
                $('#error_'+data_row.id).hide();
                loader('#posts');
                $.ajax({
                    url:"{{ route('supplier.receive_input') }}",
                    type:"POST",
                    dataType:'JSON',
                    data:{
                        receive_qty:val,
                        id:data_row.id,
                        old_rec:data_row.receiving_qty,
                        variation_id:$('#variation_id_'+data_row.id).val(),
                        _token: "{{csrf_token()}}"
                    },
                    success:function(data){
                        loader('#posts',0);
                        if(data.response=='1'){
                            $.toast({
                                heading: 'Success',
                                text: 'Received Added Successfully',
                                showHideTransition: 'slide',
                                icon: 'success',
                                position: 'top-right',
                            });
                            
                            // $('#blister_qty').val(data.receive_qty);
                            // $('#last_rec').text(data.receive_qty);
                            // $('#data_id').val(data_row.id);
                            // $('#blisterModal').modal('show');
                            
                            $('#posts').DataTable().ajax.reload().draw();
                            // print_label(data_row);   
                        }else{
                            $.toast({
                                heading: 'Success',
                                text: 'Received Added Successfully',
                                showHideTransition: 'slide',
                                icon: 'success',
                                position: 'top-right',
                            }); 
                            $('#posts').DataTable().ajax.reload().draw(); 
                        }
                    }
                });
            }
            
        }
        }
        
    });

    $('#posts').on('click', 'tbody .received_btn', function () {
        var data_row = table.row($(this).closest('tr')).data();
        // console.log(data_row);return;
        var val=$('#receiving_qty_'+data_row.id).val().trim();
        var rece_qty;

        if(!/^[0-9]+$/.test(val) || val == 0){
            $('#error_'+data_row.id).text('Input Receive Only Numbers and receive input is not 0');
            $('#error_'+data_row.id).show();
            $.toast({
                heading: 'Error',
                text: 'Input Receive Only Numbers and receive input is not 0',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
        }else{
            rece_qty=parseInt((data_row.receiving_qty =='0')?data_row.receive_qty:data_row.receiving_qty);
            rece_qty=parseInt((data_row.remaining>=rece_qty)?data_row.remaining:rece_qty);
            
            // console.log(rece_qty);return;
            if(val>data_row.remaining){
                $('#error_'+data_row.id).text('Number Exceed from Order Qty');
                $('#error_'+data_row.id).show();
                $.toast({
                    heading: 'Error',
                    text: 'Number Exceed from Order Qty',
                    showHideTransition: 'slide',
                    icon: 'error',
                    position: 'top-right',
                }); 
                return;
            }else{
                $('#error_'+data_row.id).hide();
                loader('#posts');
                $.ajax({
                    url:"{{ route('supplier.receive_input') }}",
                    type:"POST",
                    dataType:'JSON',
                    data:{
                        receive_qty:val,
                        id:data_row.id,
                        old_rec:data_row.receiving_qty,
                        variation_id:$('#variation_id_'+data_row.id).val(),
                        _token: "{{csrf_token()}}"
                    },
                    success:function(data){
                        loader('#posts',0);
                        if(data.response=='1'){
                            $.toast({
                                heading: 'Success',
                                text: 'Received Added Successfully',
                                showHideTransition: 'slide',
                                icon: 'success',
                                position: 'top-right',
                            });
                            
                            // $('#blister_qty').val(data.receive_qty);
                            // $('#last_rec').text(data.receive_qty);
                            // $('#data_id').val(data_row.id);
                            // $('#blisterModal').modal('show');
                            
                            $('#posts').DataTable().ajax.reload().draw();
                            // print_label(data_row);   
                        }else{
                            $.toast({
                                heading: 'Success',
                                text: 'Received Added Successfully',
                                showHideTransition: 'slide',
                                icon: 'success',
                                position: 'top-right',
                            }); 
                            $('#posts').DataTable().ajax.reload().draw(); 
                        }
                    }
                });
            }
            
        }

    });

    $('#posts').on('click', 'tbody .print_btn', function () {
        print_label(table.row($(this).closest('tr')).data());

    });

    $('#posts').on('click', 'tbody .blister_btn', function () {
        var data_row=table.row($(this).closest('tr')).data();

        $.ajax({
            url:"{{ route('supplier.last_receiving') }}",
            type:'POST',
            dataType:'JSON',
            data:{
                _token: "{{csrf_token()}}",
                'id' : data_row.id,
                variation_id:$('#variation_id_'+data_row.id).val(),
            },
            success:function(data){
                console.log(data);
                if(data.barcode_id =='0'){
                    $('#blister_qty').val(data.last_receiving);
                    $('#last_rec').text(data.last_receiving);
                    $('#data_id').val(data_row.id);
                    $('#blisterModal').modal('show');
                }else{
                    $.toast({
                        heading: 'Error',
                        text: 'Barcode Already Generated Please Click The Print Label Menu',
                        showHideTransition: 'slide',
                        icon: 'error',
                        position: 'top-right',
                    }); 
                }
                
            }
        });
    });

    $('#blisterBtn').click(function(){
        var id=$('#data_id').val();
        if($('#blister_qty').val() !='' && $('#no_of_label').val() !='' && $('#blister_qty').val() !=0 && $('#no_of_label').val() !=0){
            if($('#no_of_label').val() !=''){
                $('#no_of_label').css({'border-color':''});
            } 

            if($('#blister_qty').val() !=''){
                $('#blister_qty').css({'border-color':''});
            }
            print_label(id);
        }else{
            $.toast({
                heading: 'Error',
                text: 'All Fields are required and Blister and Label not equal to 0',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            if($('#no_of_label').val() =='' || $('#no_of_label').val() =='0'){
                $('#no_of_label').css({'border-color':'red'});
            } 

            if($('#blister_qty').val() =='' || $('#blister_qty').val() =='0'){
                $('#blister_qty').css({'border-color':'red'});
            }

        }
        
    });

    function print_label(id){
        
        var val=$('#blister_qty').val();
        var url = '{{ route("supplier.print.label", ":id") }}';
        url = url.replace(':id',id);
        var w;
        $.ajax({
            url:url,
            type:'POST',
            cache: false,
            datatype: 'json',
            data:{
                receive_qty:val,
                no_of_label:$('#no_of_label').val(),
                _token: "{{csrf_token()}}"
            },
            async: false,
            success:function(data){
                if(data.success==true){
                    
                    w = window.open('about:blank','pos_popup', 'width=900,height=600,menubar=yes,scrollbars=yes,status=no,resizable=yes,screenx=0,screeny=0');
                    w.document.open();
                    w.document.write(data.html);
                    
                    // 
                    
                    w.document.close();
                    setTimeout(function(){ w.print(); }, 2000);
                    
                    $('#no_of_label').val('');
                    $('#blister_qty').val('');
                    $('#blisterModal').modal('hide');
                    
                    // $('<html>').html(data.html).print(); 
                }
            }
        });
    }

     
      
</script>

    
@endsection