@extends('layouts.app')
@section('title','Supplier | Mini Opex')
@section('add_css')
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.6.5/css/buttons.dataTables.min.css"/>


    
@endsection

@section('content')
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Supplier </strong> List
                            
                            
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            {{-- <div class="container mb-5" style="border-radius:1px;background-color:#FFF8DC"> --}}
                                <div class="row form-group mb-5">
                                </div>
                               
                            {{-- </div> --}}
                            {{-- <hr> --}}
                            <div class="table-responsive">
                                <table class="table table-bordered  table-striped" id="posts" cellspacing="0" width="100%">
                                <thead>
                                    <tr class="thead-dark">
                                        <!--<th>ID</th>-->
                                        <th>Assign Date</th>
                                        <th>Product Detail</th>
                                        <th>Product Size</th>
                                        <th>Order QTY</th>
                                        <th>Receive QTY</th>
                                        <th>Remaining QTY</th>
                                        
                                    </tr>
                                </thead>
                            </table>
                            </div>
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>

{{-- <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.5/js/dataTables.buttons.min.js"></script> --}}
{{-- <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script> --}}
{{-- <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script> --}}
{{-- <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script> --}}
{{-- <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.5/js/buttons.html5.min.js"></script> --}}
{{-- <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.1/js/buttons.print.min.js"></script> --}}



<script>
    $('.select2').select2({
        width:'resolve'
    });
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});

    
        $('#posts').DataTable({
            "processing": true,
            "serverSide": true,
            "dataSrc": "",
            "ajax":{
                     "url": "{{ route('supplier.quantity') }}",
                    //  "dataType": "json",
                     "type": "POST",
                     data:function(d){
                        d._token= "{{csrf_token()}}";
                        // d.supplier_id=$('#supplier').val();
                    },
                   },
            "columnDefs": [
                { "orderable": false, "targets": [5] },
                { "searchable": false, "targets": [5] }
            ],
            
            bSort: false,
            "ordering": false,
            "columns": [
                // { "data": "id","name":"assign_quantity.id" },
                { "data": "assign_date","name":"assign_date" },
                { "data": "variation_id","name":"variation_id" },
                { "data": "size","name":"product_size.size" },
                { "data": "receive_qty","name":"assign_quantity.receive_qty" },
                { "data": "receiving_qty","name":"assign_quantity.receiving_qty" },
                { "data": "remaining","name":"remaining" }
            ],
            'preDrawCallback': function(settings) {
                loader('#posts');
            },
            "drawCallback": function( settings ) {
                loader('#posts',0);
            },
        });

        $('#supplier').on('change',function(){
            console.log($('#supplier').text());
            $('#posts').DataTable().ajax.reload().draw();
        })

        
    

    function get_options(id){
       var val=$('#options_'+id).val();
       if(val=="edit"){
           console.log($('#options_'+id).find(":selected").attr('data-link'));
           window.location.href=$('#options_'+id).find(":selected").attr('data-link');
       }else if(val =='delete'){
           $.ajax({
               url:$('#options_'+id).find(":selected").attr('data-link'),
               type:"POST",
               data:{ _token: "{{csrf_token()}}"},
               success:function(data){
                   if(data){
                    location.reload();
                   }
               }
           })
       }
    }
</script>

    
@endsection