@extends('layouts.app')
@section('title','Supplier | Mini Opex')
@section('add_css')
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

    
@endsection

@section('content')
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Supplier </strong> List
                            @can('supplier-create')
                                <a href="{{ route('supplier.add')}}" class="btn btn-info btn-sm float-right">Add New Supplier</a>
                            @endcan
                            
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <div class="table-responsive">
                                <table class="table  table-bordered  table-striped table-earning" id="posts" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Supplier Name</th>
                                        <th>username</th>
                                        <th>Address</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                            </table>
                            </div>
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<!--<script src="//code.jquery.com/jquery-latest.js"></script>-->
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>


<script>
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});
        // $("a .single_image").fancybox();
        $('#posts').DataTable({
            "processing": true,
            "serverSide": true,
            "dataSrc": "",
            "ajax":{
                     "url": "{{ route('supplier.all') }}",
                    //  "dataType": "json",
                     "type": "POST",
                     "data":{ _token: "{{csrf_token()}}"}
                   },
            "columnDefs": [
                { "orderable": false, "targets": [0,2,3] },
                { "orderable": true, "targets": [1] }
            ],
            bSort: false,
            "ordering": false,
            "columns": [
                { "data": "id", "name": "id" },
                { "data": "supplier_name","name": "supplier_name" },
                { "data": "username","name":"username" },
                { "data": "address","name":"address" },
                { "data": "action","name":"action" },

            ],
            "drawCallback": function( settings ) {
                loader('#posts',0);
            },
            'preDrawCallback': function(settings) {
                loader('#posts');
            },
            	 

        });

        
    
    function loader(id,show=1){
        if(show){
            $(id).css({
                'position':'relative',
            });
            $('<div>',{
                class:'loaderShow bg-info'
            }).css({
                'z-index': '1000','position':'absolute','font-size': '12px',
                'top':'5%','left':'50%','padding':'10px','border-radius':'10px'
            }).prependTo(id)
            .html('<i class="fas fa-spinner fa-pulse fa-3x fa-spin" style="color:white"></i><span class="sr-only">Loading...</span>');
        }else{
            $(id+' .loaderShow').remove();
        }
    }
    
    function get_options(id){
       var val=$('#options_'+id).val();
       if(val=="edit"){
           console.log($('#options_'+id).find(":selected").attr('data-link'));
           window.location.href=$('#options_'+id).find(":selected").attr('data-link');
       }else if(val =='delete'){
           $.ajax({
               url:$('#options_'+id).find(":selected").attr('data-link'),
               type:"POST",
               data:{ _token: "{{csrf_token()}}"},
               success:function(data){
                   if(data){
                    location.reload();
                   }
               }
           })
       }
    }
</script>

    
@endsection