@extends('layouts.app')
@section('title','Supplier | Mini Opex')

@section('content')
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Supplier Registion</strong> form
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <form action="{{ route('supplier.add') }}" method="post" enctype="multipart/form-data" class="form-horizontal" id="form_id">
                                @csrf
                                <div class="row form-group ">
                                    <div class="col col-md-3">
                                        <label for="supplier_name" class=" form-control-label">Supplier Name </label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <input type="text" id="supplier_name" name="supplier_name" placeholder="add new supplier" class="form-control">
                                    </div>
                                </div>

                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="username" class=" form-control-label">Username </label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <input type="text" id="username" name="username" placeholder="enter username" class="form-control">
                                        <span id="unameerror" class="text-danger" style="display: none">Username Already Exists</span>
                                    </div>
                                </div>
                                <div class="row form-group ">
                                    <div class="col col-md-3">
                                        <label for="contact_number" class=" form-control-label">Contact Number </label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <input type="text" id="contact_number" name="contact_number" placeholder="contact number " class="form-control">
                                    </div>
                                </div>
                                <div class="row form-group ">
                                    <div class="col col-md-3">
                                        <label for="supplier_email" class=" form-control-label">Supplier Email </label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <input type="email" id="supplier_email" name="supplier_email" placeholder="supplier email" class="form-control">
                                    </div>
                                </div>
                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="text-input" class=" form-control-label">Address </label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <textarea name="supplier_address" id="supplier_address" rows="3" placeholder="Supplier address" class="form-control"></textarea>
                                        
                                    </div>
                                </div>
                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="text-input" class=" form-control-label">Password </label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <input type="text" id="password" name="password" placeholder="password" class="form-control">
                                        
                                    </div>
                                </div>
                                
                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="text-input" class=" form-control-label">Supplier Type </label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <select name="type[]" id="type" class="form-control select2" multiple placeholder="Select type">
                                            <option value="1" selected>Normal Supplier</option>
                                            <option value="2">Raw Supplier</option>
                                        </select>
                                    </div>
                                </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary btn-sm" id="submitbtn">
                                    <i class="fa fa-dot-circle-o"></i> Submit
                                </button>
                                <button type="reset" class="btn btn-danger btn-sm">
                                     <i class="fa fa-ban"></i> Reset
                                </button>
                            </form>
                            </div>
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>


<script>
    $(document).ready(function() {
        

        $('#form_id').validate({
            errorClass:'text-danger',
            success:'text-success',
            ignore: [],
            rules:{
                supplier_name: {
                    required: true
                },
                username:{
                    required:true,
                },
                supplier_address:{
                    required:true
                },
                contact_number:{
                    required:true,
                    phone_number:true

                },
                supplier_email:{
                    required:true,
                    email: true
                },
                password:{
                    required:true,
                    minlength:6
                },
                "type[]": { // Use the exact name attribute of the select
                    required: true
                }
                
                
            },
            messages:{
                supplier_name:{
                    required:"Supplier Name is required"
                },
                username:{
                    required:"Username is required",
                },
                supplier_address:{
                    required:"Supplier address is required"
                },
                contact_number:{
                    required:"Contact Number is required",
                    phone_number:'Please Enter Valid Phone Number'
                },
                supplier_email:{
                    required:"Supplier email is required",
                    email: "Email is not in good formate"
                },
                password:{
                    required:"password is required",
                    minlength:"Password length must be 6 to 8"
                },
                "type[]":{
                    required:"Supplier type is required"
                },
                
            },
            highlight: function(element, errorClass, validClass) {
                $(element).closest('.form-control').addClass('has-warning');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).closest('.form-group').removeClass('has-error');
            },
            errorPlacement: function (error, element) {
                
                if(element.hasClass('select2') && element.next('.select2-container').length) {
                    error.insertAfter(element.next('.select2-container'));
                }else if(element.hasClass('radio') && element.next('label .form-check-label').length) {
                    error.insertAfter(element.next('label .form-check-label'));
                }else{
                    error.insertAfter(element);
                }
            },
            submitHandler: function (form) {
                console.log("Submitted!");
                form.submit();
            }

        });

        $.validator.addMethod('phone_number', function (value) { 
            return /^[\d\(\)\-+]+$/m.test(value); 
        }, 'Please Enter valid Phone Number');

        $('#username').blur(function(){
            var val=$('#username').val();
            if(val !=''){
                $.ajax({
                    url:"{{ route('supplier.check_username') }}",
                    type:'POST',
                    dataType: "html",
                    data:{
                        _token: "{{csrf_token()}}",
                        username:val
                    },
                    success:function(data){
                        console.log(data);
                        if(data ==1){
                            $('#unameerror').show();
                            $('#submitbtn').hide();
                        }else{
                            $('#unameerror').hide();
                            $('#submitbtn').show();
                        }
                    }
                });
            }
        })

        $.validator.addMethod(
            "checkUsername", 
            function(value, element) {
                var response;
                var flag = 0;
                $.ajax({
                    url:"{{ route('supplier.check_username') }}",
                    type:'POST',
                    dataType: "html",
                    data:{
                        _token: "{{csrf_token()}}",
                        username:value
                    },
                    success:function(data){
                        console.log(data);
                        response=(data =='1')? false:true;
                        console.log(response);
                        return response;
                    }
                });
                // console.log(flag);
                // if(flag== 0){
                //     return true;
                // }
                // console.log(response);
                
               
            },
            ""
        );


    });
</script>

    
@endsection