@extends('layouts.app')
@section('title','Items Adjust | Mini Opex')
@section('add_css')
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

@endsection

@section('content')

<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 col-md-12">
                      <div class="d-flex justify-content-center mb-2">
                          @can('launch-list')
                            <a href="{{ route('supplier.images')}}" class="btn btn-primary btn-lg ml-1"><i class="fas fa-star"></i> Articles Launch List</a>
                          @endcan
                          @can('sku-list')
                            <a href="{{ route('show')}}" class="btn btn-secondary btn-lg ml-1"><i class="fas fa-barcode"></i> SKU List</a>
                          @endcan
                          @can('sku-with-design')
                            <a href="{{ route('sku.with.design')}}" class="btn btn-success btn-lg ml-1"><i class="fas fa-paint-brush"></i> SKU With Design</a>
                          @endcan
                          @can('article-list')
                            <a href="{{ route('supplier.articles')}}" class="btn btn-warning btn-lg ml-1"><i class="fas fa-newspaper"></i> Article List</a>
                          @endcan
                          @can('color-list')
                            <a href="{{ route('supplier.colors')}}" class="btn btn-info btn-lg ml-1"><i class="fas fa-eye-dropper"></i> Color List</a>
                          @endcan
                          @can('design-list')
                            <a href="{{ route('supplier.designs')}}" class="btn btn-danger btn-lg ml-1"><i class="fas fa-adjust"></i> Design List</a>
                          @endcan
                      </div>  
                </div>
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Items Adjust </strong> List
                            
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" id="posts" cellspacing="0" width="100%">
                                    <thead class="table-dark" style="color: white">
                                        <tr>
                                            <th>ID</th>
                                            <th>Product Detail</th>
                                            <th>Reason Name</th>
                                            <th>Quantity Remove</th>
                                            <th>Created By</th>
                                            <th>Created Date</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>
<script>
     $('.single_image').featherlight({type: 'image',targetAttr: 'href'});
    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        "dataSrc": "",
        "ajax":{
                    "url": "{{ route('item.adjust') }}",
                //  "dataType": "json",
                    "type": "POST",
                    "data":{ _token: "{{csrf_token()}}"}
                },
        "columnDefs": [
            { "orderable": false, "targets": [] },
        ],
        "order": [[ 0, "desc" ]],
        bSort: false,
        "ordering": true,
        "columns":[
            { "data": "id","name":"item_adjustment.id" },
            { "data": "productDetail","name":"productDetail" },
            { "data": "reason_name","name":"damage_reason.reason_name" },
            { "data": "quantity","name":"item_adjustment.quantity" },
            { "data": "name","name":"users.name" },
            { "data": "created_at","name":"created_at" },
            
        ],
        createdRow: (row, data, dataIndex, cells) => {
            $(cells[2]).html('<span class="text-primary text-sm">'+data.reason_name+'</span>')
        },
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
    });
</script>

    
@endsection