@extends('layouts.app')
@section('title','SKU | Mini Opex')
@section('add_css')
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<style>
    .strikeOut{
        text-decoration:line-through !important;
    }
</style>
    
@endsection
@section('content')
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>SKU Detail Edit</strong> form
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <form action="{{ route('sku.update',$record->id) }}" method="post" enctype="multipart/form-data" class="form-horizontal" id="form_id">
                                @csrf
                                <div class="row form-group ">
                                    <div class="col col-md-3">
                                        <label for="text-input" class=" form-control-label mt-1">Product </label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <input type="text" id="text-input" name="product_name" value="{{ $record->product_name }}" placeholder="product name" class="form-control">
                                    </div>
                                </div>
                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="select" class=" form-control-label mt-1">Team</label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <select name="team" id="team" class="form-control select2">
                                            <option value="">Please select</option>
                                            @forelse ($teams as $team)

                                                <option value="{{ $team->team_code }}" @if($record->team == $team->team_code) {{'selected'}} @endif>{{ $team->team_name }}</option>
                                            @empty
                                                
                                            @endforelse
                                            
                                        </select>
                                    </div>
                                </div>
                                
                                {{-- <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="select" class=" form-control-label">Gender</label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <select name="gender" id="gender" class="form-control select2">
                                            <option value="">Please select</option>
                                            @forelse ($product_gender as $gender)
                                                <option value="{{ $gender->id }}" @if($record->prod_gender == $gender->id) {{'selected'}} @endif>{{ $gender->gender }}</option>
                                            @empty
                                                
                                            @endforelse
                                        </select>
                                    </div>
                                </div> --}}

                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="select" class=" form-control-label mt-1">Article</label>
                                    </div>
                                    <div class="col-12 col-md-3" id="article_type">
                                        <select name="product_type" id="product_type" class="form-control select2">
                                            <option value="">Please select</option>
                                            @forelse ($product_type as $type)
                                                @php
                                                   if($type->article_url !=''){
                                                       $image=$type->article_url;
                                                   }else{
                                                    $image=asset('uploads/article_images/'.$type->article_img);
                                                   }
                                                @endphp
                                                <option 
                                                value="{{ $type->id }}" 
                                                @if($type->status==0) class="strikeOut" disabled @endif
                                                @if($record->prod_type == $type->id) {{'selected'}} @endif

                                                data-img_src="{{ $image }}"
                                                > {{ $type->product_type }}</option>
                                            @empty
                                                
                                            @endforelse
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="select" class=" form-control-label mt-1">Color</label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <select name="color" id="color" class="form-control select2">
                                            <option value="">Please select</option>
                                            @forelse ($color as $color)
                                                <option value="{{ $color->id }}" @if($record->prod_color == $color->id) {{'selected'}} @endif>{{ $color->color}}</option>
                                            @empty
                                                
                                            @endforelse
                                        </select>
                                    </div>
                                </div>
                                
                                
                                {{-- <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label class=" form-control-label">Option</label>
                                    </div>
                                    <div class="col col-md-3">
                                        <div class="form-check">
                                            <div class="radio">
                                                <label for="radio1" class="form-check-label ">
                                                    <input type="radio" id="radio1" name="variation_option" value="1" class="form-check-input variat_option">Master Variation
                                                </label>
                                            </div>
                                            <div class="radio">
                                                <label for="radio2" class="form-check-label ">
                                                     <input type="radio" id="radio2" name="variation_option" value="2" class="form-check-input variat_option">With Variation
                                                </label>
                                             </div>    
                                        </div>
                                    </div>
                                </div> --}}
                                <div class="row form-group "  id="parent_vartion">
                                    <div class="col col-md-3">
                                        <label for="select" class=" form-control-label mt-1">Size</label>
                                    </div>
                                    <div class="col-12 col-md-3 mb-2">
                                        <select name="size" id="size" class="form-control select2">
                                            <option value="">Please select</option>
                                            @forelse ($product_size as $size)
                                                <option value="{{ $size->id }}" @if($record->prod_size == $size->id) {{'selected'}} @endif>{{ $size->size}}</option>
                                            @empty
                                                
                                            @endforelse
                                        </select>
                                    </div>
                                </div>
                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label class=" form-control-label mt-1">Design Option</label>
                                    </div>
                                    <div class="col col-md-3">
                                        <div class="form-check">
                                            <div class="radio">
                                                <label for="design_yes" class="form-check-label ">
                                                    <input type="radio" id="design_yes" name="design_check" @if($record2->prod_design=='1') checked @endif value="1" class="form-check-input design_option">Yes
                                                </label>
                                            </div>
                                            <div class="radio">
                                                <label for="design_no" class="form-check-label ">
                                                     <input type="radio" id="design_no" name="design_check" value="2" class="form-check-input design_option" @if($record2->prod_design=='0') checked @endif>No
                                                </label>
                                                
                                             </div>
                                             <span class="span-next2"></span>    
                                        </div>   
                                    </div>
                                </div>
                                <div id="display_div" @if($record2->prod_design=='0') style="display:none" @endif >
                                    <div class="row form-group">
                                        <div class="col col-md-3">
                                            <label for="select" class=" form-control-label">Design</label>
                                        </div>
                                        <div class="col-12 col-md-3">
                                            <select name="design" id="design" class="form-control select2">
                                                <option value="">Please select</option>
                                                @forelse ($product_design as $design)
                                                    <option value="{{ $design->id }}" @if($design->id ==$record->prod_design) selected @endif>{{ $design->design_title }}</option>
                                                @empty
                                                    
                                                @endforelse
                                            </select>
                                        </div>
                                    </div>
                                    @if($record->product_url !='')
                                    <a class="single_image" href="{{ $record->product_url }}" data-featherlight="image">
                                                <img src="{{ $record->product_url }}" class="rounded" alt="Cinque Terre" width="100" height="100">
                                    </a>
                                    @else
                                    <a class="single_image" href="{{ asset('backend/no_image.png') }}"  data-featherlight="image">
                                        <img src="{{ asset('backend/no_image.png') }}" class="rounded" alt="Cinque Terre" width="100" height="100">
                                    </a>
                                    @endif
                                    <div class="row form-group">
                                        <div class="col col-md-3">
                                            <label for="text-input" class=" form-control-label mt-1">Design Image URL </label>
                                        </div>
                                        <div class="col-12 col-md-3">
                                            <input type="text" id="design_image_url" name="design_image_url" placeholder="Text" class="form-control" value="{{ $record->product_url }}">
                                            
                                        </div>
                                    </div>
                                    
                                </div>
                                
                                
                                @if($record2->product_url !='')
                                <a class="single_image" href="{{ $record2->product_url }}" data-featherlight="image">
                                            <img src="{{ $record2->product_url }}" class="rounded" alt="Cinque Terre" width="100" height="100">
                                </a>
                                @else
                                <a class="single_image" href="{{ asset('uploads/sku_images/'.$record2->prod_img) }}"  data-featherlight="image">
                                    <img src="{{ asset('uploads/sku_images/'.$record2->prod_img) }}" class="rounded" alt="Cinque Terre" width="100" height="100">
                                </a>
                                @endif
                                
                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label class=" form-control-label mt-1">Image Option</label>
                                    </div>
                                    <div class="col col-md-3">
                                        <div class="form-check">
                                            <div class="radio">
                                                <label for="image_upload2" class="form-check-label ">
                                                    <input type="radio" id="image_upload2" name="image_option" value="image_upload" class="form-check-input image_option">Image Upload
                                                </label>
                                            </div>
                                            <div class="radio">
                                                <label for="image_url2" class="form-check-label ">
                                                     <input type="radio" id="image_url2" name="image_option" value="image_url" class="form-check-input image_option">Image URL
                                                </label>
                                             </div>   
                                             <span class="span-next"></span> 
                                        </div>   
                                    </div>
                                </div>
                               
                                <div class="row form-group" style="display: none" id="image_upload">
                                    <div class="col col-md-3">
                                        <label for="file-input" class=" form-control-label mt-1">Image Upload</label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <input type="file" id="file-input" name="file_img" class="form-control-file">
                                    </div>
                                </div>
                                <div class="row form-group" style="display: none" id="image_url">
                                    <div class="col col-md-3">
                                        <label for="text-input" class=" form-control-label mt-1">Image URL </label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <input type="text" id="text-input" name="image_url" placeholder="Text" class="form-control">
                                        
                                    </div>
                                </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary btn-sm">
                                    <i class="fa fa-dot-circle-o"></i> Submit
                                </button>
                                <button type="reset" class="btn btn-danger btn-sm" id="reset">
                                     <i class="fa fa-ban"></i> Reset
                                </button>
                            </form>
                            </div>
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>

<script>

    // $(document).ready(function() {
        $('.select2').select2();
        var options = {
            'templateSelection': custom_template,
            'templateResult': custom_template,
        }

        

        $('#product_type').select2(options);
        $('#article_type .select2-container--default .select2-selection--single').css({'height': '60px'});

        $('#reset').click(function(){
            $( "#form_id" ).validate().resetForm();
            var team="{{ $record->team }}";
            var article="{{  $record->prod_type}}";
            var color="{{ $record->prod_color }}";
            var size="{{ $record->prod_size }}";
            $('#team').val(team).trigger('change');
            $('#product_type').val(article).trigger('change');
            $('#color').val(color).trigger('change');
            $('#size').val(size).trigger('change');
        });
        

        function custom_template(obj){
            var data = $(obj.element).data();
            var text = $(obj.element).text();
            if(data && data['img_src']){
                img_src = data['img_src'];
                if (obj.element && obj.element.classList.contains('strikeOut')) {
                    template = $("<span class='ml-1 mt-1 strikeOut' style='display:inline-block'><img  class='img-thumbnail rounded' src=\"" + img_src + "\" style=\"width:50px;height:50px;\"/><span class='text-sm' style=\"flex: 1;word-wrap: break-word;\">" + text + "</span></span>");
                }else{
                    template = $("<span class='ml-1 mt-1' style='display:inline-block'><img  class='img-thumbnail rounded' src=\"" + img_src + "\" style=\"width:50px;height:50px;\"/><span class='text-sm' style=\"flex: 1;word-wrap: break-word;\">" + text + "</span></span>");

                }
                return template;
            }
        }

        $('.image_option').click(function(){
            var val=$(this).val();
            if(val=='image_upload'){
                $('#image_url').hide();
            }else{
                $('#image_upload').hide();
            }
            $('#'+val).show();
        });
        
        $('.design_option').click(function(){
            var val=$(this).val();
            if(val=='1'){
                $('#display_div').show();
            }else{
                $('#display_div').hide();
            }
        });

        $('.variat_option').click(function(){
            var val=$(this).val();
            if(val ==1){
                $('#parent_vartion').show();
            }else{
                $('#parent_vartion').hide();
                
            }
        });

        $('#form_id').validate({
            errorClass:'text-danger',
            success:'text-success',
            errorElement: 'span',
            rules:{
                product_name: {
                    required: true
                },
                team:{
                    required:true
                },
                product_type:{
                    required:true
                },
                color:{
                    required:true
                },
                image_url:{
                    required:true
                },
                gender:{
                    required:true
                },
                size:{
                    required:true
                },
                
                
            },
            messages:{
                product_name:{
                    required:"Product Name is required"
                },
                team:{
                    required:"team is required"
                },
                image_url:{
                    required:"Image URL is required"
                },
                gender:{
                    required:"Gender is required"
                },
                size:{
                    required:"Product Size is required"
                },
                product_type:{
                    required:"Product type is required"
                },
                color:{
                    required:"Product Color is required"
                },
                
            },
            highlight: function(element, errorClass, validClass) {
                $(element).closest('.form-control').addClass('has-warning');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).closest('.form-group').removeClass('has-error');
            },
            errorPlacement: function (error, element) {
                
                if(element.hasClass('select2') && element.next('.select2-container').length) {
                    error.insertAfter(element.next('.select2-container'));
                }else if(element.attr("name") == "variation_option"){
                    error.insertAfter(".new");
                }else if(element.attr("name") == "image_option"){
                    error.insertAfter(".span-next");
                }else{
                    error.insertAfter(element);
                }
            },
            submitHandler: function (form) {
                console.log("Submitted!");
                form.submit();
            }

        });


    // });
        $('.single_image').featherlight({type: 'image',targetAttr: 'href'});
</script>

    
@endsection