@extends('layouts.app')
@section('title','Design | Mini Opex')
@section('add_css')
<x-datatable-js type="css"/>
    
@endsection

@section('content')
@include('sku.allModal',['htmlType' => '1'])
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12">
                    <div class="card">
                        <div class="card-body text-center">
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-12">
                                    @can('bundle-list')
                                        <a href="{{ route('sku.bundle.list')}}" class="btn btn-dark btn-lg btn-block ml-1 mb-1"><i class="fas fa-box"></i> Bundle List</a>
                                    @endcan
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-12">
                                    @can('sku-with-design')
                                        <a href="{{ route('sku.with.design')}}" class="btn bg-orange text-dark btn-lg btn-block ml-1 mb-1"><i class="fas fa-paint-brush"></i> SKU With Design</a>
                                    @endcan
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-12">
                                    @can('color-list')
                                        <a href="{{ route('supplier.colors')}}" class="btn btn-dark btn-lg btn-block ml-1 mb-1"><i class="fas fa-eye-dropper"></i> Color List</a>
                                    @endcan
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-12 col-md-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Design </strong> List
                            <a href="javascript:;" class="btn btn-dark btn-sm float-right mr-1" id="showDesign"><i class="fas fa-adjust"></i> Add New Design</a>

                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <div class="form-check float-right">
                                <input class="form-check-input" id="discarded_sku" name="discarded_sku" type="checkbox" value="yes"/>
                                <label class="form-check-label" for="discarded_sku">Show Discarded SKU</label>
                            </div>
                            <div class="table-responsive-sm">
                                <table class="table  table-bordered  table-striped table-sm" id="posts" cellspacing="0" width="100%">
                                    <thead class="table-dark" style="color: white">
                                        <tr>
                                            <th>Design Code</th>
                                            <th>Design Image</th>
                                            <th>Design Title</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<x-datatable-js type="js"/>
<script>
        $('#posts').DataTable({
            "processing": true,
            "serverSide": true,
             "pageLength": 50,
            "dataSrc": "",
            "language": {
                "search": "Search Design Titles",
                "lengthMenu":"Show _MENU_ Entries" 
            },
            "ajax":{
                     "url": "{{ route('supplier.designs') }}",
                     "type": "POST",
                     "data":function(d){ 
                         d._token= "{{csrf_token()}}";
                         d.discarded_sku = $('#discarded_sku:checked').val();
                         
                         
                     }
                   },
            "columnDefs": [
                { "orderable": false, "targets": [0,1] },
                { "searchable": false, "targets": [0,1] }
            ],bSort: false,
            "ordering": false,
            "columns": [
                { "data": "design_code","name":"design_code" },
                { "data": "designImg","name":"designImg" },
                { "data": "designDetail","name":"designDetail" },
                { "data": "status","name":"status" },
                { "data": "action","name":"action" },

            ],
            'preDrawCallback': function(settings) {
                loader('#posts');
            },
            "drawCallback": function( settings ) {
                loader('#posts',0);
            }	
            	 

        });

    function get_options(id){
       var val=$('#options_'+id).val();
       if(val=="edit"){
            $.ajax({
                url:"{{ route('sku.design.edit') }}",
                type:'POST',
                dataType:'JSOn',
                data:{
                   id:id,
                   _token: "{{csrf_token()}}"
                },
                success:function(data){
                   modalDesignRefresh(0,data)
                   $('#designModal').modal('show');
                }
            });
           
       }else if(val =='delete'){
          $.ajax({
              url:$('#options_'+id).find(":selected").attr('data-link'),
              type:"POST",
              data:{ _token: "{{csrf_token()}}"},
              success:function(data){
                    if(data){
                        toastMsg('Status Updated Successfully');
                        $('#posts').DataTable().ajax.reload().draw(); 
                    }
              }
          })
       }
    }
    
    $('#discarded_sku').click(function(){
        $('#posts').DataTable().ajax.reload().draw();
    });
    
    @include('sku.allModal',['htmlType' => '2'])

</script>

    
@endsection