@extends('layouts.app')
@section('title','SKU | Mini Opex')
@section('add_css')
<x-datatable-js type="css"/>
@endsection

@section('content')
@include('sku.allModal',['htmlType' => '1'])
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="card">
                        <div class="card-body text-center">
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-12">
                                    @can('article-list')
                                        <a href="{{ route('supplier.articles')}}" class="btn btn-dark btn-lg btn-block ml-1 mb-1"><i class="fas fa-newspaper"></i> Article List</a>
                                    @endcan
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-12">
                                    @can('sku-with-design')
                                        <a href="{{ route('sku.with.design')}}" class="btn bg-orange text-dark btn-lg btn-block ml-1 mb-1"><i class="fas fa-paint-brush"></i> SKU With Design</a>
                                    @endcan
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-12">
                                    @can('design-list')
                                        <a href="{{ route('supplier.designs')}}" class="btn btn-dark btn-lg btn-block ml-1 mb-1"><i class="fas fa-adjust"></i> Design List</a>
                                    @endcan
                                </div>
                            </div>
                        </div>
                    </div>                        
                </div>
                <div class="col-lg-12 col-md-12 col-sm-12 col-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Color </strong> List
                            <a href="javascript:;" class="btn btn-dark btn-sm float-right ml-1" id="showColor">Add New Color </a>&nbsp;
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <div class="table-responsive-sm">
                                <table class="table  table-bordered  table-striped table-sm" id="posts" cellspacing="0" width="100%">
                                    <thead class="table-dark" style="color: white">
                                        <tr>
                                            <th>ID</th>
                                            <th>Color Image</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
                </div>
            
        </div>
        @include('partials.copyrights')
    </div>
    </div>
</div>
@endsection

@section('add_js')
<x-datatable-js type="js"/>
<script>
    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "dataSrc": "",
        "ajax":{
                 "url": "{{ route('supplier.colors') }}",
                 "type": "POST",
                 "data":{ _token: "{{csrf_token()}}"}
               },
        "columnDefs": [
                { "orderable": false, "targets": [2] },
                { "orderable": true, "targets": [1] }
        ],bSort: false,
        "ordering": false,
        "columns": [
            { "data": "id","name":"id" },
            { "data": "colorDetail","name":"colorDetail" },
            { "data": "action","name":"action" },

        ],
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
        "drawCallback": function( settings ) {
            $('.loader').select2();
            loader('#posts',0);
        }	
        	 

    });

    function get_options(id){
       var val=$('#options_'+id).val();
       if(val=="edit"){
           $.ajax({
               url:"{{ route('sku.color.edit') }}",
               type:'POST',
               dataType:'JSOn',
               data:{
                   id:id,
                   _token: "{{csrf_token()}}"
               },
               success:function(data){
                    modalColorRefresh(0,data)
                   $('#colorModal').modal('show');

               }
           });
           
       }else if(val =='delete'){
           $.ajax({
               url:$('#options_'+id).find(":selected").attr('data-link'),
               type:"POST",
               data:{ _token: "{{csrf_token()}}"},
               success:function(data){
                   if(data){
                        toastMsg('Status Updated Successfully');
                        $('#posts').DataTable().ajax.reload().draw(); 
                   }
               }
           })
       }
    }
    
    @include('sku.allModal',['htmlType' => '2'])
    

    
</script>

    
@endsection