@extends('layouts.app')
@section('title','SKU | Mini Opex')
@section('add_css')

@endsection
@section('content')
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-12 text-sm">
                    <div class="card">
                        <form method="post" enctype="multipart/form-data" class="form-horizontal" id="form_id">
                            <div class="card-header">
                                <strong>SKU Detail Edit</strong> form
                            </div>
                            <div class="card-body card-block">
                                @if (session('has_error'))
                                    <div class="alert alert-danger" role="alert">
                                        {{ session('has_error') }}
                                    </div>
                                @endif
                                @if (session('has_success'))
                                    <div class="alert alert-success" role="alert">
                                        {{ session('has_success') }}
                                    </div>
                                @endif
                            
                                @csrf
                                <div class="row">
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                        <div class="row">
                                            <div class="col-lg-6 col-md-6 col-sm-6 col-6">
                                                <h4><label for="text-input" class=" form-control-label mt-1">Group ID : <strong class="text-success">{{$record->group_id}}</strong></label></h4>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-6 col-6">
                                                @php 
                                                    $exp=explode('-',$record->variation_design);
                                                    $alpha=isset($exp[1])?$exp[1]:'';
                                                    
                                                    $designN=isset($exp[1])? '-'.$exp[1]:'';
                                                @endphp
                                                
                                                @if($alpha !='')
                                                    <h4><label for="text-input" class=" form-control-label mt-1">Design Alpha : <strong class="text-success">{{$alpha}}</strong></label></h4>
                                                @endif
                                                
                                            </div>
                                        </div>
                                        <hr>
                                        
                                    </div>
                                    <div class="col-lg-8 col-md-8 col-sm-12 col-12">
                                        <div class="row">
                                            <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                                <div class="form-group">
                                                    <label for="product_name" class=" form-control-label mt-1">Product </label>
                                                    @php 
                                                        $exp=explode('|',$record->product_name);
                                                        $title=$exp[0];
                                                    @endphp
                                                    <input type="text" id="product_name" name="product_name" value="{{ $title }}" placeholder="Men V Neck" class="form-control form-control-sm">
                                                    <input type="hidden" id="change_image_val" name="change_image_val" placeholder="product name" class="form-control form-control-sm" value="0">
                                                    <input type="hidden" id="old_group_id" name="old_group_id" placeholder="product name" class="form-control form-control-sm" value="{{$record->group_id}}">
                                                </div>
                                                
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                                <div class="form-group">
                                                    <label for="team" class=" form-control-label mt-1">Team</label>
                                                    <select name="team" id="team" class="form-control form-control-sm select2">
                                                        <option value="">Please select</option>
                                                        @forelse ($teams as $team)
                                                            <option value="{{ $team->team_code }}" @if($record->team == $team->team_code) {{'selected'}} @endif>{{ $team->team_name }}</option>
                                                        @empty
                                                            
                                                        @endforelse
                                                        
                                                    </select>
                                                </div>
                                            </div>
                                            
                                            <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                                <div class="form-group">
                                                    <label for="select" class=" form-control-label mt-1">Segment <span class="text-danger">*</span></label>
                                                    <select name="segment" id="segment" class="form-control select2 tac">
                                                        <option value="">Please select</option>
                                                        @forelse ($segments as $segment)
                                                            <option value="{{ $segment->id }}" @if($record->segment_id == $segment->id) {{'selected'}} @endif>{{ $segment->name }}</option>
                                                        @empty
                                                            
                                                        @endforelse
                                                        
                                                    </select>
                                                </div>
                                            </div>
                                                
                                            <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                                <div class="form-group">
                                                    <label for="article" class=" form-control-label mt-1">Article <span class="text-danger">*</span></label>
                                                    <select name="article" id="article" class="form-control select2 tac">
                                                        <option value="">Please select</option>
                                                        @forelse ($articles as $article)
                                                            <option value="{{ $article->id }}" @if($record->article_id == $article->id) {{'selected'}} @endif>{{ $article->article }}</option>
                                                        @empty
                                                            
                                                        @endforelse
                                                        
                                                    </select>
                                                </div>
                                            </div>
                                            
                                            <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                                <div class="form-group">
                                                    <label for="color" class=" form-control-label mt-1">Color</label>
                                                    
                                                    <select name="color" id="color" class="form-control select2 tac">
                                                        <option value="">Please select</option>
                                                        @forelse ($color as $color)
                                                            <option value="{{ $color->id }}" @if($record->color_id == $color->id) {{'selected'}} @endif>{{ $color->color}}</option>
                                                        @empty
                                                            
                                                        @endforelse
                                                    </select>
                                                </div>
                                            </div>
                                            
                                            @if(count($product_size)>0)
                                            <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                                <div class="row">
                                                    <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                                                        <br> <br> 
                                                        <div class="form-group">
                                                            <div class="form-check">
                                                                <div class="checkbox">
                                                                    <label for="checkbox1" class="form-check-label ">
                                                                        <input type="checkbox" id="add_new_size" name="add_new_size" value="yes" class="form-check-input">Add New Size
                                                                    </label>
                                                                </div>    
                                                            </div>
                                                        </div>
                                                    
                                                    </div>
                                                    
                                                    <div class="col-lg-6 col-md-6 col-sm-12 col-12" id="parent_vartion" style="display:none;"> 
                                                        <div class="form-group">
                                                            <label for="select" class=" form-control-label mt-1">Size</label>
                                                            <select name="size[]" id="size" class="form-control form-control-sm select2" multiple="multiple">
                                                                @forelse ($product_size as $size)
                                                                    <option value="{{ $size->id }}">{{ $size->size}}</option>
                                                                @empty
                                                                    
                                                                @endforelse
                                                            </select>
                                                        </div>
                                                    
                                                    </div>
                                                </div>
                                            </div>
                                            @endif
                                            
                                            <div class="col-lg-12 col-md-12 col-sm-12 col-12" >
                                                
                                                <div class="row">
                                                    <div class="col-lg-6 col-md-6 col-sm-12 col-12" style="display: none" id="image_option">
                                                        <div class="form-group mt-1">
                                                            <label class=" form-control-label mt-1">Image Option</label><br>
                                                            <div class="form-check-inline form-check">
                                                                <div class="radio ml-3">
                                                                    <label for="image_upload2" class="form-check-label ">
                                                                        <input type="radio" id="image_upload2" name="image_option" value="image_upload" class="form-check-input image_option">Image Upload
                                                                    </label>
                                                                </div>
                                                                <div class="radio  ml-3">
                                                                    <label for="image_url2" class="form-check-label ">
                                                                         <input type="radio" id="image_url2" name="image_option" value="image_url" class="form-check-input image_option" checked>Image URL
                                                                    </label>
                                                                    
                                                                 </div>
                                                                 <span class="span-next"></span>    
                                                            </div> 
                                                        </div>
                                                        
                                                        
                                                    </div>
                                                    
                                                    <div class="col-lg-6 col-md-6 col-sm-12 col-12" style="display: none" id="image_upload">
                                                        <div class="form-group" >
                                                            <label for="file-input" class=" form-control-label mt-1">Image Upload <span class="text-danger">*</span></label>
                                                            <input type="file" id="file-input" name="file_img" class="form-control form-control-sm">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6 col-md-6 col-sm-12 col-12" style="display: none" id="image_url">
                                                        <div class="form-group" >
                                                            <label for="image_urlN" class=" form-control-label mt-1">Image URL <span class="text-danger">*</span></label>
                                                            <input type="text" id="image_urlN" name="image_url" placeholder="https://i.imgur.com/Pp3PuIO.png" class="form-control form-control-sm">
                                                        </div>
                                                    </div>
                                                    
                                                    
                                                    
                                                </div>
                                                
                                                
                                                
                                                
                                            
                                                
                                            
                                            </div>    
                                            <div class="col-lg-12 col-md-12 col-sm-12 col-12" @if($designN =='') style="display:none" @endif>
                                                <hr>
                                                <div class="row">
                                                    <div class="col-lg-6 col-md-6 col-sm-12  col-12">
                                                        <div class="form-group">
                                                            <label class=" form-control-label mt-1">Design Option</label><br>
                                                            <div class="form-check-inline form-check">
                                                                <div class="radio ml-2">
                                                                    <label for="design_yes" class="form-check-label ">
                                                                        <input type="radio" id="design_yes" name="design_check" @if($designN !='') checked @endif value="1" class="form-check-input design_option">Yes
                                                                    </label>
                                                                </div>
                                                                <div class="radio ml-2">
                                                                    <label for="design_no" class="form-check-label ">
                                                                         <input type="radio" id="design_no" name="design_check" value="2" class="form-check-input design_option" @if($record->prod_design=='0') checked @endif>No
                                                                    </label>
                                                                    
                                                                 </div>
                                                                 <span class="span-next2"></span>    
                                                            </div> 
                                                        </div> 
                                                    
                                                    </div>
                                                    <div class="col-lg-6 col-md-6 col-sm-12  col-12">
                                                        <div id="display_div" @if($record->prod_design=='0') style="display:none" @endif >
                                                            <div class="row">
                                                                <div class="col-lg-6 col-md-6 col-sm-12  col-12">
                                                                    <div class="form-group">
                                                                        <label for="select" class=" form-control-label">Design</label>
                                                                        <select name="design" id="design" class="form-control select2 tac">
                                                                            <option value="0">Please select</option>
                                                                            @forelse ($product_design as $design)
                                                                                <option value="{{ $design->id }}" @if($design->id ==$record->prod_design) selected @endif>{{ $design->design_title }}</option>
                                                                            @empty
                                                                                
                                                                            @endforelse
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-6 col-md-6 col-sm-12  col-12">
                                                                    <div class="form-group">
                                                                        <label for="text-input" class=" form-control-label mt-1">Design Image URL </label>
                                                                        <input type="text" id="design_image_url" name="design_image_url" placeholder="Text" class="form-control" value="{{ $record->product_url }}">
                                                                            
                                                                        
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>    
                                                        
                                                            
                                    
                                    
                                    
                                </div>
                                                    </div>
                                                </div>
                                            
                                                
                                                
                                                
                                                
                                            </div>
                                        
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-12 col-12 border-left border-light">
                                            <div id="image_show_div">
                                                <h5 class="text-center font-weight-bold">Raw SKU Detail</h5>
                                                    <div class="row">
                                                        <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                            
                                                        @if($record2->product_url !='')
                                                            <a class="single_image" href="{{ $record2->product_url }}" data-featherlight="image">
                                                                        <img src="{{ $record2->product_url }}" class="img-thumbnail" alt="Cinque Terre" width="70" height="70">
                                                            </a>
                                                        @else
                                                            <a class="single_image" href="{{ asset('uploads/sku_images/'.$record2->prod_img) }}"  data-featherlight="image">
                                                                <img src="{{ asset('uploads/sku_images/'.$record2->prod_img) }}" class="img-thumbnail" alt="Cinque Terre" width="70" height="70">
                                                            </a>
                                                        @endif
                                                        
                                                        @php
                                                            $status='<span class="badge badge-danger">Deactive</span>';
                                                            if($record->prod_status =='1'){
                                                                $status='<span class="badge badge-success">Active</span>';
                                                            }
                                                            
                                                            $exp=explode(', ',$record2->product_name);
                                                            $titleN=$exp[0];
                                                         
                                                            
                                                        @endphp
                                                            
                                                           
                                                            
                                                        </div>
                                                        <div class="col-lg-8 col-md-8 col-sm-8 col-12">
                                                            <ul class="list-group mt-2">
                                                              <li class="list-group-item" id="pinfo">SKU : <strong id="rawSKU">{{$record2->group_id}}</strong><br>Product Name : <strong>{{ $titleN }}</strong><br>{!! $status !!}</li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                    <button type="button" class="btn btn-dark btn-sm mt-2" id="change_image">
                                                        Change Image
                                                    </button>
                                                    <hr>
                                            </div>
                                            <div id="design_show_div">
                                                <h5 class="text-center font-weight-bold">Design SKU Detail</h5>
                                                    <div class="row">
                                                        <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                                            @if($record->product_url !='')
                                                            <a class="single_image" href="{{ $record->product_url }}" data-featherlight="image">
                                                                        <img src="{{ $record->product_url }}" class="img-thumbnail" alt="Cinque Terre" width="70" height="70">
                                                            </a>
                                                            @else
                                                            <a class="single_image" href="{{ asset('backend/no_image.png') }}"  data-featherlight="image">
                                                                <img src="{{ asset('backend/no_image.png') }}" class="img-thumbnail" alt="Cinque Terre" width="70" height="70">
                                                            </a>
                                                            @endif
                                                        </div>
                                                        @php
                                                            $status='<span class="badge badge-danger">Deactive</span>';
                                                            if($record->prod_status =='1'){
                                                                $status='<span class="badge badge-success">Active</span>';
                                                            }
                                                        @endphp
                                                        <div class="col-lg-8 col-md-8 col-sm-8 col-12">
                                                            <ul class="list-group mt-2">
                                                              <li class="list-group-item" id="pdinfo">SKU : <strong id="designSKU">{{$record->group_id.$designN}} </strong><br>Product Name : <strong>{{$title}}</strong><br>{!! $status !!}</li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                
                                            </div>
                                        </div>
                                        <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                            <hr>
                                            <div id="generate_sku" class="mt-2">
                                                
                                                <table class="table table-bordered mt-2">
                                                    <thead class="thead-dark">
                                                        <tr>
                                                            <th>Sno</th>
                                                            <th>SKU</th>
                                                            <th>Product Name</th>
                                                        </tr>
                                                    </thead>
                                                    
                                                    
                                                    
                                                    
                                                    <tbody id="tbodyNew">
                                                        @php
                                                    $sno=1;
                                                    @endphp
                                                    
                                                    @forelse ($allrecords as $k)
                                                        <tr>
                                                            <td>{{$sno}}</td>
                                                            <td>
                                                                <input type="text" class="form-control form-control-sm" value="{{$k->variation_design}}" name="variation_design[]" readonly>
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control form-control-sm jeans_size" id="product_name_{{$k->variation_design}}"  value="{{$k->product_name}}" name="product_name_d[]" readonly>
                                                            </td>
                                                        </tr>
                                                    
                                                        @php
                                                            $sno++;
                                                        @endphp
                                                    @empty
                                                    
                                                    @endforelse
                                                        
                                                    
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    
                                        
                                    </div>
                                </div>
                                
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary btn-sm">
                                    <i class="fa fa-dot-circle-o"></i> Submit
                                </button>
                                <button type="reset" class="btn btn-danger btn-sm" id="reset">
                                     <i class="fa fa-ban"></i> Reset
                                </button>
                            
                            </div>
                        </form>
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>

<script>
        $('#reset').click(function(){
            $( "#form_id" ).validate().resetForm();
            var team="{{ $record->team }}";
            var article="{{  $record->prod_type}}";
            var color="{{ $record->prod_color }}";
            var size="{{ $record->prod_size }}";
            $('#team').val(team).trigger('change');
            $('#product_type').val(article).trigger('change');
            $('#color').val(color).trigger('change');
            $('#size').val(size).trigger('change');
        });
        

        $('.image_option').click(function(){
            var val=$(this).val();
            $("#file-input").val(null);
            $('#image_urlN').val('');
            
            if(val=='image_upload'){
                $('#image_url').hide();
            }else{
                $('#image_upload').hide();
            }
            $('#'+val).show();
        });
        
        $('.design_option').click(function(){
            var val=$(this).val();
            if(val=='1'){
                $('#display_div').show();
            }else{
                $('#display_div').hide();
            }
        });

        $('.variat_option').click(function(){
            var val=$(this).val();
            if(val ==1){
                $('#parent_vartion').show();
            }else{
                $('#parent_vartion').hide();
                
            }
        });

        $('#form_id').validate({
            errorClass:'text-danger',
            success:'text-success',
            errorElement: 'span',
            rules:{
                product_name: {
                    required: true
                },
                team:{
                    required:true
                },
                product_type:{
                    required:true
                },
                color:{
                    required:true
                },
                image_url:{
                    required:true
                },
                gender:{
                    required:true
                },
                size:{
                    required:true
                },
                design:{
                    required:true
                }
                
                
            },
            messages:{
                product_name:{
                    required:"Product Name is required"
                },
                team:{
                    required:"team is required"
                },
                image_url:{
                    required:"Image URL is required"
                },
                gender:{
                    required:"Gender is required"
                },
                size:{
                    required:"Product Size is required"
                },
                product_type:{
                    required:"Product type is required"
                },
                color:{
                    required:"Product Color is required"
                },
                design:{
                    required:"Select Design Other Design Check NO"
                }
                
            },
            highlight: function(element, errorClass, validClass) {
                $(element).closest('.form-control').addClass('has-warning');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).closest('.form-group').removeClass('has-error');
            },
            errorPlacement: function (error, element) {
                
                if(element.hasClass('select2') && element.next('.select2-container').length) {
                    error.insertAfter(element.next('.select2-container'));
                }else if(element.attr("name") == "variation_option"){
                    error.insertAfter(".new");
                }else if(element.attr("name") == "image_option"){
                    error.insertAfter(".span-next");
                }else{
                    error.insertAfter(element);
                }
            },
            submitHandler: function (form) {
                var formData = new FormData(form);
                $.ajax({
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    url: "{{ route('bulk.update.sku',$ids) }}",
                    dataType:'JSON',
                    success: function (data) {
                        if(data.code =='200'){
                            toastMsg(data.message);
                            // $('#reset').click();
                            window.location.href= data.href_url;
                        }
                         
                     }
                });
                return false; // required to block normal submit since you used ajax
            }

        });


        $('#add_new_size').click(function(){
            var self=$(this);
           if(self.is(':checked')){
               $('#parent_vartion').show();
           }else{
               $('#parent_vartion').hide();
           } 
        });
        
        $(document).on('click','#change_image',function(){
            $('#image_option').show();
            $('#image_url').show();
            $('#image_upload').hide(); 
            
            $('#change_image_val').val(1);
            $('#change_image').hide();
        })
        
        $(document).on('change','.tac',function(){
            get_articles();
            text_change();
            size_tr();
        });
        
        function get_articles(){
            var segment=$('#segment option:selected').val();
            var article=$('#article option:selected').val();
            
            
            if(segment !=''){
                $.ajax({
                    url:"{{ route('sku.segment_article') }}",
                    type:"POST",
                    data: {
                        segment_id:segment,
                        article:article,
                        color:'',
                        design:'',
                        _token:"{{csrf_token()}}"
                    },
                    dataType:'JSON',
                    success:function(data){
                        if(data.code=='200'){
                            $('#article').html(data.html);
                        }
                    }
                })
            }
        }
        
        function text_change(){
            var val=$('#product_name').val();
            var color_name=$('#color option:selected').text();
            var jean_size=$('.jeans_size');
            jean_size.each(function() {
                var id=$(this).attr('id');
                var nval=$(this).val();
                var osize=nval.split(', ')[1];
                var pdname=val+' | '+color_name+', '+osize;
                $('#'+id).val(pdname);
            });
        }
        
        $(document).on('input','#product_name',function(){
            var self=$(this);
            text_change();
            size_tr();
        })
        
        $(document).on('click','#add_new_size',function(){
            var self=$(this);
            $('#size').val('').trigger('change');
            size_tr();
        });
        
        function size_tr(){
            $(document).find('.remove_tr').remove();
            
            var group_id="{{$record->group_id}}";
            var design="{{$designN}}";
           
            var tbody=$('#tbodyNew');
           
            var html='';
           
            var val=$('#product_name').val();
            var color_name=$('#color option:selected').text();
           
            var selected_size=$('#size option:selected').each(function(){
               var nval=$(this).val();
               var ntext=$(this).text();
               
               var sku=group_id+nval+design;
               
               var pdname=val+' | '+color_name+', '+ntext;
               
                html+=`<tr class="remove_tr">
                    <td>${nval}</td>
                    <td>
                        <input type="text" class="form-control form-control-sm" value="${sku}" name="variation_design[]" readonly>
                    </td>
                    <td>
                        <input type="text" class="form-control form-control-sm jeans_size" id="product_name_${sku}"  value="${pdname}" name="product_name_d[]" readonly>
                    </td>
                </tr>`;
               
           });
           
           tbody.append(html);
        }
        
        $(document).on('change','#size',function(){
            size_tr();
        });
        
        
</script>

    
@endsection