@extends('layouts.app')
@section('title','Articles | Mini Opex')
@section('add_css')
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">
<x-datatable-js type="css"/>
    
@endsection

@section('content')
<x-article/>
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 col-md-12">
                        <div class="card">
                        <div class="card-body text-center">
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-12">
                                    @can('bundle-list')
                                        <a href="{{ route('sku.bundle.list')}}" class="btn btn-dark btn-lg btn-block ml-1 mb-1"><i class="fas fa-box"></i> Bundle List</a>
                                    @endcan
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-12">
                                    @can('sku-with-design')
                                        <a href="{{ route('sku.with.design')}}" class="btn bg-orange text-dark btn-lg btn-block ml-1 mb-1"><i class="fas fa-paint-brush"></i> SKU With Design</a>
                                    @endcan
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-12">
                                    @can('design-list')
                                        <a href="{{ route('supplier.designs')}}" class="btn btn-dark btn-lg btn-block ml-1 mb-1"><i class="fas fa-adjust"></i> Design List</a>
                                    @endcan
                                </div>
                            </div>
                        </div>
                    </div> 
                      
                </div>
                <div class="col-lg-12 col-sm-12 col-md-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Article </strong> List
                            <a href="javascript:;" class="btn btn-dark btn-sm float-right" data-toggle="modal" data-target="#articleModal" id="showArticle">Add New Articles</a>
                            
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            
                            
                             <div class="container custom_filter pt-3 pb-3 border  rounded mb-2" id="custom_div">
                                <div class="row">
                                    <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label for="segment" class="form-control-label mr-3">Segment</label>
                                            <select name="segment" id="segment" class="form-control select2 segment">
                                                <option value="">Select segment</option>
                                                @forelse ($segments as $segment)
                                                    <option value="{{ $segment->id }}">{{ $segment->name}}</option>
                                                @empty
                                                    
                                                @endforelse
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label for="article" class="form-control-label mr-3">Article</label>
                                            <select name="article" id="article" class="form-control select2 article">
                                                <option value="">Select article</option>
                                                @forelse ($articles as $article)
                                                    <option value="{{ $article->id }}">{{ $article->article}}</option>
                                                @empty
                                                    
                                                @endforelse
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                        <label  class="form-control-label mr-3">&nbsp;</label>
                                        <div class="form-check">
                                            <input class="form-check-input" id="discarded_sku" name="discarded_sku" type="checkbox" value="yes"/>
                                            <label class="form-check-label" for="discarded_sku">With Discarded SKU</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="table-responsive-sm">
                                <table class="table  table-bordered  table-striped table-sm" id="posts" cellspacing="0" width="100%">
                                    <thead class="table-dark" style="color: white">
                                        <tr>
                                            <th>ID</th>
                                            <th>Image</th>
                                            <th>Name</th>
                                            <th>Segment</th>
                                            <th>Article</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<!--<script src="//code.jquery.com/jquery-latest.js"></script>-->
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>

<x-datatable-js type="js"/>

<script>
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});
        // $("a .single_image").fancybox();
        $('#posts').DataTable({
            "processing": true,
            "serverSide": true,
            "dataSrc": "",
            "lengthMenu": [ [10, 25, 50, -1], [10, 25, 50, "All"] ],
            "ajax":{
                     "url": "{{ route('supplier.articles') }}",
                     "type": "POST",
                     "data":function(d){ 
                         d._token= "{{csrf_token()}}";
                         d.discarded_sku = $('#discarded_sku:checked').val();
                         d.article = $('#article option:checked').val();
                         d.segment = $('#segment option:checked').val();
                         
                         
                     }
                   },
            "columnDefs": [
                { "orderable": false, "targets": [1,3] },
                { "searchable": false, "targets": [0,1,2,3,4,5] }
            ],bSort: false,
            "ordering": false,
            dom: 'lBfrtip',
            buttons: [
                {   extend: 'excelHtml5', 
                    className: 'btn btn-danger',
                    footer: true,
                    header:false,
                    download: 'open',
                    exportOptions: {
                modifier: {
                    search: 'none'
                },
                columns: [0,2]
            },
                },
                
                
 
            
            ],
            "columns": [
                { "data": "id","name":"id" },
                { "data": "ProductImg","name":"ProductImg" },
                { "data": "articleDetail","name":"articleDetail" },
                { "data": "segment","name":"segment" },
                { "data": "article","name":"article" },
                { "data": "action","name":"action" },

            ],
            'preDrawCallback': function(settings) {
                loader('#posts');
            },
            "drawCallback": function( settings ) {
                $('.loader').select2();
                loader('#posts',0);
            },
            initComplete: function () {
                $('.buttons-excel').html('<i class="fas fa-file-excel"></i> Excel').removeClass('dt-button').addClass('btn btn-dark btn-sm ml-5');
            },
            	 

        });

    $('#updateBtn').click(function(){
       
        var color_name=$('#article_name').val();
        var file_data = $("#file_img").prop("files")[0]; // Getting the properties of file from file field
        var form_data = new FormData();
        var isalpha = /[^a-zA-Z]/.test(color_name);
        form_data.append("file_img", file_data); // Appending parameter named file with properties of file_field to form_data
        form_data.append("_token", "{{csrf_token()}}");
        form_data.append("articl_name", color_name);
        form_data.append("id", $('#article_id').val());
        form_data.append("article_image_url", $('#article_image_url').val());
        $.ajax({
            url:"{{ route('sku.article.edit') }}",
            type:'POST',
            cache: false,
            contentType: false,
            processData: false,
            data:form_data,
            success:function(data){
                $('#articleModalLabel').text('Add new Article');
                $('#article_name').val('');
                $('#article_image_url').val('');
                $('#file_img').val('');
                $('#updateBtn').hide();
                $('#typeBtn').show();
                $('#articleModal').modal('hide');
                $('#posts').DataTable().ajax.reload().draw(); 

            }
        })
        
        
    });

    $('#showArticle').click(function(){
        $('#articleModalLabel').text('Add new Article');
        $('#article_name').val('');
        $('#article_image_url').val('');
        $('#file_img').val('');
        $('#errortxt').hide();
        $('#updateBtn').hide();
        $('#typeBtn').show();
    })   
    

    function get_options(id){
       var val=$('#options_'+id).val();
       if(val=="edit"){
           $.ajax({
               url:"{{ route('sku.article.edit') }}",
               type:'POST',
               dataType:'JSOn',
               data:{
                   id:id,
                   _token: "{{csrf_token()}}"
               },
               success:function(data){
                   $('#articleModalLabel').text('Update Article');
                   $('#errortxt').hide();
                   $('#article_name').val(data.product_type);
                   $('#article_image_url').val(data.article_url);
                   $('#article_id').val(id);
                   $('#updateBtn').show();
                   $('#typeBtn').hide();
                   $('#articleModal').modal('show');

               }
           });
           
       }else if(val =='delete'){
           $.ajax({
               url:$('#options_'+id).find(":selected").attr('data-link'),
               type:"POST",
               data:{ _token: "{{csrf_token()}}"},
               success:function(data){
                   if(data){
                        $.toast({
                            heading: 'Success',
                            text: 'Status Updated Successfully',
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-center',
                        }); 
                        $('#posts').DataTable().ajax.reload().draw(); 
                   }
               }
           })
       }
    }
    $('#typeBtn').click(function(){
        var color_name=$('#article_name').val();
        var file_data = $("#file_img").prop("files")[0]; // Getting the properties of file from file field
        var form_data = new FormData();
        var isalpha = /[^a-zA-Z]/.test(color_name);
        form_data.append("file_img", file_data); // Appending parameter named file with properties of file_field to form_data
        form_data.append("_token", "{{csrf_token()}}");
        form_data.append("input", color_name);
        form_data.append("type", 2);
        form_data.append("article_image_url", $('#article_image_url').val());



        if(isalpha && $('#article_name').val()!=''){
            $.ajax({
                url:"{{ route('sku.add.new') }}",
                type:"POST",
                cache: false,
                contentType: false,
                processData: false,
                data: form_data,
                success:function(data){
                    if(data !='0'){
                        console.log(data);
                        $.toast({
                            heading: 'Success',
                            text: 'Added in Articles Successfully',
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-right',
                        }); 
                        $("#product_type").append("<option value='"+data+"' selected>"+color_name+"</option>");
                        $('#product_type').trigger('change');
                        $('#file_img').val('');
                        $('#article_image_url').val('');
                        $('#article_name').val('');
                        $('#articleModal').modal('hide'); 
                         $('#posts').DataTable().ajax.reload().draw(); 


                    }else{
                        $.toast({
                            heading: 'Error',
                            text: 'Already Exist in Articles',
                            showHideTransition: 'slide',
                            icon: 'error',
                            position: 'top-right',
                        });  
                    }
                }
            })
        }else{
            $.toast({
                heading: 'Error',
                text: 'Accepts Only Alphabats',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
        }
        
    });

    function ValidateSingleInput(oInput) {
        var _validFileExtensions = [".jpg", ".png", ".jpeg"];
        if (oInput.type == "file") {
            var sFileName = oInput.value;
            if (sFileName.length > 0) {
                var blnValid = false;
                for (var j = 0; j < _validFileExtensions.length; j++) {
                    var sCurExtension = _validFileExtensions[j];
                    if (sFileName.substr(sFileName.length - sCurExtension.length, sCurExtension.length).toLowerCase() == sCurExtension.toLowerCase()) {
                        blnValid = true;
                        break;
                    }
                }
                
                if (!blnValid) {
                    $('#errortxt').show();
                    $('#typeBtn').hide();
                    $('#updateBtn').hide();

                    $.toast({
                        heading: 'Error',
                        text: 'Invalid file,allowed only excel file eg '+_validFileExtensions.join(", "),
                        showHideTransition: 'slide',
                        icon: 'error',
                        position: 'top-right',
                    });
                    // alert("Sorry, " + sFileName + " is invalid, allowed extensions are: " + _validFileExtensions.join(", "));
                    oInput.value = "";
                    return false;
                }else{
                    $('#errortxt').hide();
                    $('#typeBtn').show();
                    $('#updateBtn').show();


                    return true; 
                }
            }
        }
        return true;
    }

    

    $('#discarded_sku').click(function(){
        $('#posts').DataTable().ajax.reload().draw();
    });
    
    $('.select2').on('change',function(){
        get_articles();
        $('#posts').DataTable().ajax.reload().draw();
    })
    
    function get_articles(){
        var segment=$('#segment option:selected').val();
        
        if(segment !=''){
            $.ajax({
                url:"{{ route('sku.segment_article') }}",
                type:"POST",
                data: {
                    segment_id:segment,
                    _token:"{{csrf_token()}}"
                },
                dataType:'JSON',
                success:function(data){
                    if(data.code=='200'){
                        $('#article').html(data.html);
                    }
                }
            })
        }
    }
</script>

    
@endsection