@php
@endphp

@if($htmlType==1)
<div class="modal fade" id="designModal" tabindex="-1" role="dialog" aria-labelledby="articleModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="designModalLabel">Add New Design</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>
                    <div class="form-group ">
                        <label for="design_name" class=" form-control-label">Design Name </label>
                        <input type="text" id="design_name" name="design_name" placeholder="design_name" class="form-control">
                        <input type="hidden" id="design_id" name="design_id" placeholder="design image id" class="form-control">
                        
                    </div>
                    <div class="form-group ">
                        <label for="dfile_img" class=" form-control-label">Design Image </label>
                        <input type="file" id="dfile_img" name="dfile_img"  class="form-control">
                        <span class="text-danger text-sm" id="derrortxt" style="display: none">Please Upload file in correct format eg Image</span>

                    </div>
                </p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="designBtn">Add</button>
                <button type="button" class="btn btn-primary" id="dupdateBtn" style="display: none">Update</button>
            </div>
        </div>
    </div>
</div>
@elseif($htmlType==2)
$('#dupdateBtn').click(function(){
    var color_name=$('#design_name').val();
    var file_data = $("#dfile_img").prop("files")[0];
    var form_data = new FormData();
    var isalpha = /[^a-zA-Z]/.test(color_name);
    form_data.append("dfile_img", file_data);
    form_data.append("_token", "{{csrf_token()}}");
    form_data.append("design_name", color_name);
    form_data.append("id", $('#design_id').val());
    $.ajax({
        url:"{{ route('sku.design.edit') }}",
        type:'POST',
        cache: false,
        contentType: false,
        processData: false,
        data:form_data,
        success:function(data){
            $('#posts').DataTable().ajax.reload().draw();
            toastMsg('Design Updated Successfully');
            $('#designModal').modal('hide');
        }
    })
});
    
function modalDesignRefresh(add=1,data={}){
    $('#derrortxt').hide();
    $('#dfile_img').val('');
    
    if(add){
        $('#designModalLabel').text('Add new Design');
        $('#design_name').val('');
        $('#derrortxt').hide();
        $('#dupdateBtn').hide();
        $('#designBtn').show();
    }else{
        $('#designModalLabel').text('Update Design');
        $('#design_name').val(data.design_title);
        $('#design_id').val(data.id);
        $('#dupdateBtn').show();
        $('#designBtn').hide();
    }
    
}

$('#designBtn').click(function(){
    var file_data = $("#dfile_img").prop("files")[0];
    var form_data = new FormData();
    var isalpha = /[^a-zA-Z]/.test($('#design_name').val());
    form_data.append("dfile_img", file_data);
    form_data.append("_token", "{{csrf_token()}}");
    form_data.append("input", $('#design_name').val());
    if($('#design_name').val()!=''){
        $.ajax({
            url:"{{route('add.design')}}",
            type:'POST',
            cache: false,
            contentType: false,
            processData: false,
            dataType:'JSON',
            data: form_data,
            success:function(data){
                if(data.error !='1'){
                    toastMsg(data.msg);
                    
                    $("#design").append("<option value='"+data.id+"' selected>"+data.text+"</option>");
                    $('#design').trigger('change');
                    modalDesignRefresh();
                    $('#designModal').modal('hide');  
                }else{
                    toastMsg(data.msg,2);
                }
            }
            
        })
    }else{
        toastMsg('Accepts Only Alphabats',2);
    }
    
})

$('#showDesign').click(function(){
    modalDesignRefresh()
    $('#designModal').modal('show');  
});

$(document).on('change','#dfile_img',function(){
    var self=$(this);
    var label=$('#designModalLabel').text();
    
    var btn='#typeBtn';
    if(label =='Update Design'){
        btn='#dupdateBtn';
    }
    
    ValidateSingleInput(this,'#errortxt',btn,'jpg,png,jpeg');
})


@endif
