@extends('layouts.app')
@section('title','Add New Bundle | Mini Opex')
@section('add_css')
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">
<style>
.select_width{
    width:100px !important;
}
.select2-container--default .select2-results__option--highlighted[aria-selected] {
    background: #bfbfbf;
}
@media only screen and (max-width: 768px) {
    .select_width{
        width:200px !important;
    }
    
}
</style>
    
@endsection

@section('content')

<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Add New </strong> Bundle
                            <a href="{{route('sku.bundle.list')}}" class="btn btn-success btn-sm float-right"><i class="fas fa-file-archive"></i> Bundle List</a>
                            <a href="javascript:;" class="btn btn-primary btn-sm float-right mr-1 sub_btn" id="bundle_submit" style="display:none"><i class="fas fa-paper-plane"></i> Bundle Submit</a>
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <form action="{{route('add.new.bundle')}}" id="form_submit" method="post">
                                @csrf
                                <div class="row">
                                    <div class="form-group col-md-4">
                                        <!--onkeypress="return /^[a-zA-Z ]*$/.test(event.key)"-->
                                            <label for="text-input" class=" form-control-label mt-1">Bundle Name </label>
                                            <input type="text" id="bundle_name" name="bundle_name"   placeholder="Men V-Neck Long Sleeves | Set 3 | other, S" class="form-control-sm form-control">
                                            <span id="bundle_error" class="text-danger" style="display:none;">Bundle Accept Only Alphabats</span>
                                    </div>
                                    <div class="form-group col-md-4">
                                        
                                        <label for="select" class=" form-control-label mt-1">Variation Type</label><br>
                                        <div class="form-check-inline form-check">
                                            <label for="with_variation" class="form-check-label mr-2">
                                                <input type="radio" id="with_variation" name="variation_type" value="1" class="form-check-input var_check"> Variation
                                            </label>
                                            <label for="no_variation" class="form-check-label ">
                                                <input type="radio" id="no_variation" name="variation_type" value="2" class="form-check-input var_check"> No Variation
                                            </label>
                                        </div><br>
                                        <span id="var_error" class="text-danger" style="display:none;">Please Select The Variation</span>
                                    </div>
                                    <div class="form-group col-md-4">
                                            <label for="text-input" class=" form-control-label mt-1">Image URL </label>
                                            <input type="text" id="image_url" name="image_url" placeholder="https://m.media-amazon.com/images/I/31ZAzwY5fdL.jpg" class="form-control-sm form-control">
                                            <span id="image_error" class="text-danger" style="display:none;">Image URL is required</span>
                                    </div>
                                </div>
                                <hr>
                                <div class="row" id="variation_append">
                                    <div class="form-group col-md-6" id="variation_1">
                                        <label for="select" class=" form-control-label mr-2">Variation 1</label>
                                        <div class="row">
                                            <div class="col-md-11">
                                                <select class="product_list select_width" name="sku[]" id="var_1"></select> 
                                            </div>
                                           <div class="col-md-1">
                                                <!--<a href="javascript:;" class="btn btn-sm btn-success"><i class="fas fa-plus-circle"></i></a>-->
                                            </div>
                                           
                                        </div>
                                        <span id="error_1" class="text-danger" style="display:none;">Please Select The Variation</span>
                                        
                                    </div>
                                    <div class="form-group col-md-6" id="variation_2">
                                        <label for="select" class=" form-control-label mr-2">Variation 2</label>
                                        <div class="row">
                                            <div class="col-md-11">
                                                <select class="product_list select_width" name="sku[]" id="var_2"></select> 
                                            </div>
                                           <div class="col-md-1">
                                                <a href="javascript:;" class="btn btn-sm btn-success add_button"><i class="fas fa-plus-circle"></i></a>
                                            </div>
                                           
                                        </div>
                                        <span id="error_2" class="text-danger" style="display:none;">Please Select The Variation</span>
                                    </div>
                                </div>
                                <a href="javascript:;" class="btn btn-sm btn-success" id="ok_set" style="display:none"><i class="fas fa-check"></i> OK </a>
                                <hr>
                                <table class="table  table-bordered  table-striped" id="posts" cellspacing="0" width="100%" style="display:none">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th>Bundle Variation</th>
                                            <th>Bundle Name</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody id="bundle_list">
                                        <tr>
                                            <td rowspan="3"></td>
                                        </tr>
                                    </tbody>
                                </table>
                                <button type="submit" class="btn btn-primary btn-sm float-right mr-1 mt-2 sub_btn" style="display:none" id="bundle_submit2" name="bundle_submit" value="bundle_submit"><i class="fas fa-paper-plane"></i> Bundle Submit</button>
                                
                                
                                
                                
                            </form>
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<!--<script src="//code.jquery.com/jquery-latest.js"></script>-->
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>


<script>
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});
    
    $('.product_list').select2({
        placeholder: 'Please Search ......',
        delay: 250,
        width: '500px',
        height:'120px',
        allowClear: true,
        
        'style':{'height':'120px'},
        ajax:{
            url: "{{ route('sku.select.list') }}",
            dataType: 'json',
            type:'POST',
            data: function (params) {
                
                var query = {
                    search: params.term,
                    page: params.page || 1,
                    _token:"{{ csrf_token() }}" 
                }

                

                return query;
            },
            
            cache: true
        },
        minimumInputLength: 1,
        templateResult: formatRepo,
        templateSelection: formatRepo

    });
    $('#variation_1 .select2-container--default .select2-selection--single').css({'height': '110px'});
    $('#variation_2 .select2-container--default .select2-selection--single').css({'height': '110px'});
            
    function formatRepo (repo) {
        if (repo.loading) {
            return repo.text;
        }

        if(typeof repo.product_name === "undefined"){
            return '';
        }

        var href='';
        if(repo.product_url !=''){
            href=repo.product_url;
        }else{
            href="{{ asset('uploads/sku_images/') }}"+repo.prod_img;
        }
        
        var design=repo.design_title;
        if(repo.design_title === null){
            design='No Design';
        }
        
        $product=repo.product_name.split(",");

        var $container=$(`
            <div class="row mt-1 pt-3 pb-3">
                <div class="col-md-2">
                    <img src='`+ href + `' class='rounded mt-2' alt='Cinque Terre' width='50' height='50'/>
                </div>
                <div class="col-md-10">
                    <span style="display: inline-block !important;word-break: break-word !important;">`+$product[0]+`</span><br>
                    <span class="text-success text-sm"> SKU : <strong>`+repo.group_id+`</strong></span><br>
                    <span class="text-info text-sm">Design : <strong>`+design+`</strong></span><br>
                    
                </div>
            </div>
        `);// <span class="text-info text-sm">Size : <strong>`+repo.size+`</strong></span>
        return $container;
    }
    
    var maxField = 10;
    var addButton = $('.add_button'); //Add button selector
    var wrapper = $('#variation_append');
    var x = 2;
    
    //Once add button is clicked
    $(addButton).click(function(e){
        //Check maximum number of input fields
        e.preventDefault();
        if(x < maxField){ 
            x++;
             //Increment field counter
            $(wrapper).append(`<div class="form-group col-md-6" id="variation_${x}">
                        <label for="select" class=" form-control-label mr-2">Variation ${x}</label>
                        <div class="row">
                            <div class="col-md-11">
                                <select class="product_list select_width" name="sku[]" id="var_${x}"></select> 
                            </div>
                           <div class="col-md-1">
                                <a href="javascript:;" class="btn btn-sm btn-danger remove_button"><i class="fas fa-minus-circle"></i></a>
                            </div>
                           
                        </div>
                        <span id="error_${x}" class="text-danger" style="display:none;">Please Select The Variation otherwise remove</span>
                    </div>`); //Add field html
            
            $('#var_'+x).select2({
                placeholder: 'Please Search ......',
                delay: 250,
                width: '500px',
                height:'120px',
                allowClear: true,
                
                'style':{'height':'120px'},
                ajax:{
                    url: "{{ route('sku.select.list') }}",
                    dataType: 'json',
                    type:'POST',
                    data: function (params) {
                        
                        var query = {
                            search: params.term,
                            page: params.page || 1,
                            _token:"{{ csrf_token() }}" 
                        }
        
                        
        
                        return query;
                    },
                    
                    cache: true
                },
                minimumInputLength: 1,
                templateResult: formatRepo,
                templateSelection: formatRepo
        
            });
            $('#variation_'+x+' .select2-container--default .select2-selection--single').css({'height': '110px'});
            
            
            console.log(x);
        }
    });
    
    $(wrapper).on('click', '.remove_button', function(e){
        e.preventDefault();
        $(this).parent().parent().parent().remove(); //Remove field html
        x--; //Decrement field counter
    });
    
    $('#ok_set').click(function(){
       var bundle_name=$('#bundle_name').val();
       var image_url=$('#image_url').val();
       var variation_type=$('input[name="variation_type"]:checked').val();
       
       if(bundle_name=='' || image_url =='' || variation_type==''){
            $.toast({
                heading: 'Error',
                text: 'All fields are required',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            
            return;
       }
       if(variation_type =='1'){
           $('.sub_btn').show();
           loader('#posts');
           $.ajax({
               url:"{{route('sku.get.set_no')}}",
               type:'POST',
               data:{
                   bundle_name:bundle_name,
                   _token:"{{csrf_token()}}"
               },
               dataType:'JSON',
               success:function(data){
                   loader('#posts',0);
                   $('#bundle_list').html(data.html);
                   $('.sub_btn').show();
               }
           })
       }
       
    });
    
    $('#bundle_list').on('click', '.remove_button_tbl', function(e){
        e.preventDefault();
        $(this).closest('tr').remove(); //Remove field html
        x--; //Decrement field counter
    });
    
    $('.var_check').click(function(){
        var val=$('.var_check:checked').val();
        console.log(val);
        if(val =='1'){
            $('#posts').show();
            $('#ok_set').show();
            $('.sub_btn').hide();
        }else{
            $('#posts').hide();
            $('#ok_set').hide();
            $('.sub_btn').show();
        } 
    });
    
    $('#bundle_submit').click(function(){
        $('#bundle_submit2').click();
    });
    
    $('#bundle_submit2').click(function(e){
       e.preventDefault();
       
        var b_list=0;
        var v_list=0;
        var var_list=0;
        var i_list=0;
        
        if($('#bundle_name').val() ==''){
            $('#bundle_error').show();
            b_list=1;
        }else{
            $('#bundle_error').hide();
            b_list=0;
        }
        
        if($('.var_check:checked').length==0){
            v_list=1;
            $('#var_error').show();
        }else{
            v_list=0;
            $('#var_error').hide();
        }
        
        if($('#image_url').val()==''){
           i_list=1; 
           $('#image_error').show();
        }else{
            i_list=0;
            $('#image_error').hide();
        }
        
        $('.product_list').each(function(index,e){
            var id=$(this).attr('id').split("_")[1];
            var id2=$(this).attr('id');
            if($('#'+id2).val() === null){
                var_list=1;
                $('#error_'+id).show();
                
            }else{
                var_list=0;
                $('#error_'+id).hide();
            }
        });
        
        if(b_list==0 && v_list==0 && var_list==0 && i_list==0){
            $('#form_submit').submit();
        }else{
            $.toast({
                heading: 'Error',
                text: 'All fields are required',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
        }
        
        // return false;
    });
    
</script>

    
@endsection