@extends('layouts.app')
@section('title','View Scanned | Mini Opex')
@section('add_css')
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.6.5/css/buttons.dataTables.min.css"/>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<x-datatable-js type="css"/>

{{-- <link rel="stylesheet" href="{{ asset('backend/print.min.css') }}"/> --}}
<style>
.margin{
    margin-left:15%;
}
</style>


    
@endsection

@section('content')
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Scaning</strong>
                            
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped table-earning" id="posts">
                                    <thead>
                                        <tr>
                                            <th>S#</th>
                                            <th>Product</th>
                                            <th>FNSKU</th>
                                            <th>Box#</th>
                                            <th>Expected Qty#</th>
                                            <th>Qty#</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                            <th colspan="4" style="text-align:right;">Total</th>
                                            <th id="QtyExpected">0</th>
                                            <th id="QtyTotalVal">0</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                            
                            <div class="table-responsive mt-3">
                                <table class="table table-bordered table-sm text-sm cart-data-table">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th scope="col">Box#</th>
                                            <th scope="col">Weight</th>
                                            <th scope="col">Length</th>
                                            <th scope="col">Width</th>
                                            <th scope="col">height</th>
                                        </tr>
                                    </thead>
                 
                                    <tbody id="BoxInfoBody">
                                    </tbody>
                                </table>
                            </div>
                            
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>

<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<x-datatable-js type="js"/>

<script>
    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "dataSrc": "",
        "ajax":{
                    "url": "{{ route('shippment.view.scan',$shipment_id) }}",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){ 
                        d._token= "{{csrf_token()}}";
                        d.box=$('#type option:selected').val();
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [5] },
        ],
        bSort: false,
        "ordering": true,
        "columns":[
            { "data": "id","name":"scanning.id" },
            { "data": "product","name":"shipment_info.product" },
            { "data": "fnsku","name":"scanning.fnsku" },
            { "data": "box_id","name":"scanning.box_id" },
            { "data": "expected_qnt","name":"shipment_info.expected_qnt" },
            { "data": "qty","name":"scanning.qty" },
        ],
        initComplete: function () {
            $('#posts_filter input').addClass('form-control-sm');
            $("#posts_filter").append(`
                <select class="float-right form-control-sm ml-1" name="type" id="type">
                    <option value="">Select BOX</option>
                    @foreach($shipment_boxes as $box)
                        <option value="{{ $box->box_id }}">Box -{{ $box->box_id }}</option>
                    @endforeach
                </select>
            `);
            
        },
        "footerCallback": function ( row, data, start, end, display ) {
                var api = this.api(), data;
    
                // converting to interger to find total
                var intVal = function ( i ) {
                    return typeof i === 'string' ?
                        i.replace(/[\$,]/g, '')*1 :
                        typeof i === 'number' ?
                            i : 0;
                };
    
                // computing column Total of the complete result 
                var monTotal = api
                    .column( 4 )
                    .data()
                    .reduce( function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0 );
                    
                var tueTotal = api
                        .column( 5 )
                        .data()
                        .reduce( function (a, b) {
                            return intVal(a) + intVal(b);
                        }, 0 );
                        
                    
                                
                    // Update footer by showing the total with the reference of the column index 
                    $( api.column( 0 ).footer() ).html('');
                    $( api.column( 1 ).footer() ).html('');
                    $( api.column( 2 ).footer() ).html('');
                    $( api.column( 3 ).footer() ).html('TOTAl');
                    $( api.column( 4 ).footer() ).html(monTotal);
                    $( api.column( 5 ).footer() ).html(tueTotal);
                    
            },
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
    });
    
    $('#posts_filter').on('change','#type',function(e){
        e.preventDefault();
        $('#posts').DataTable().ajax.reload().draw();
    })
    
    function BoxInfoData(){
        $(".old-rows-two").remove();
        var shipment_id = "{{$shipment_id}}";
        loader('#ship_scan_form');
        $.ajax({
            type:'post',
            url:"{{route('box.info')}}",
            data:{
                shipment_id:shipment_id,
                _token:"{{csrf_token()}}"
            },
        }).done(function(resp){
            loader('#ship_scan_form',0);
            var html = ``;
            $(resp.data).each(function(index,el){
               html+=`<tr class="old-rows-two">
                <td>Box${el.box_id}</td>
                <td>${el.box_weight}</td>
                <td>${el.box_length}</td>
                <td>${el.box_width}</td>
                <td>${el.box_height}</td>
              </tr>`;
                  
             });
            $("#BoxInfoBody").append(html);
          }).fail(function(resp){
            console.log(resp);
          });
    }
    
    BoxInfoData();

    
        

</script>

    
@endsection