@extends('layouts.app')
@section('title','Shipped List | Mini Opex')
@section('add_css')
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
@endsection

@section('content')

<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Shipped List</strong>
                            
                                
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <div id="showAlert"></div>
                            <div class="container custom_filter bg-light pt-3 pb-2 border  rounded">
                                <div class="row">
                                    <div class="col-12 col-md-4">
                                        <select name="store" id="store_id" class="form-control new_select select2">
                                            <option value="">Select Store</option>
                                            @forelse ($stores as $store)
                                                <option value="{{ $store->id }}">{{ $store->strong_name}}</option>
                                            @empty
                                                
                                            @endforelse
                                        </select>
                                    </div>
                                    <div class="col-12 col-md-4">
                                        <select name="shipment_type" id="shipment_type" class="form-control new_select select2">
                                            <option value="">Select Type</option>
                                            <option value="1">Air Cargo</option>
                                            <option value="2">Sea Cargo</option>
                                        </select>
                                    </div>
                                    <div class="col-12 col-md-4">
                                        <select name="shipment_id" id="shipment_id" class="form-control select2">
                                            <option value="">Select Shipment ID</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="table-responsive mt-2">
                                <table class="table table-bordered table-striped" id="posts" cellspacing="0" width="100%" data-start='' data-end=''>
                                    <thead >
                                        <tr class="thead-light">
                                            <th colspan="2" class="text-right">TOTAL</th>
                                            <th id="order_qty">0</th>
                                        </tr>
                                        <tr class="thead-dark">
                                            <th>Product Image</th>
                                            <th>Product Name</th>
                                            <th>Shipped QTY</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                            <th colspan="2" class="text-right">TOTAL</th>
                                            <th>0</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                                
                            
                            <!--<a href="javascript:;" id="assign_qty2" class="float-right btn btn-success btn-sm ml-1 mt-1"><i class="fas fa-check"></i> Update Quantity</a>-->
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript" src="{{ asset('/backend/toast/jquery.toast.min.js') }}"charset="utf8"></script>
<script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<script>
    var start = moment().subtract(29, 'days');
    var end = moment();
    var today = new Date().toLocaleDateString();


    function cb(start, end) {
        $('#date_picker span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        $("#posts").attr("data-start",start.format('YYYY-MM-DD'));
        $("#posts").attr("data-end",end.format('YYYY-MM-DD'));
        $("#start_date").val(start.format('YYYY-MM-DD'));
        $("#end_date").val(end.format('YYYY-MM-DD'));
    }

    $('#date_picker').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
        'Today': [moment(), moment()],
        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
        'This Month': [moment().startOf('month'), moment().endOf('month')],
        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    }, cb);

    cb(start, end);
    
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});

    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        
        "dataSrc": "",
        "ajax":{
                    "url": "{{ route('shipped.list') }}",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){ 
                        d._token= "{{csrf_token()}}";
                        d.store= $('#store_id option:selected').val();
                        d.shipment_type=$('#shipment_type option:selected').val();
                        d.shipment_id=$('#shipment_id option:selected').val();
                        
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [0,1] },
            // { "width": "5%", "targets": [0] },
        ],
        bSort: false,
        "ordering": false,
        "columns":[
            { "data": "product_img","name":"product_img" },
            { "data": "product_name","name":"product_name" },
            { "data": "shipped_qty","name":"shipped_qty" },
        ],
        // createdRow: (row, data, dataIndex, cells) => {
        //     var status='';
        //     if(data.shipment_type =='1'){
        //         status='<span class="text-primary text-sm">Air Cargo</span>';
        //     }else if(data.shipment_type =='2'){
        //       status='<span class="text-primary text-sm">Sea Cargo</span>'; 
        //     }
        //     $(cells[6]).html(status);
        //     $(cells[4]).addClass('text-success font-weight-bold');
        // },
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
            
            var info = $('#posts').DataTable().page.info();
            tot = info.recordsTotal;
                
            if (tot > 0) {
                $('#export_excel').show();
                $('#download_div').show();
            } else {
                $('#export_excel').hide();
                $('#download_div').hide();
            }
        },
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
 
            // converting to interger to find total
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            
                    
            var wedTotal = api
                .column( 2 )
                .data()
                .reduce( function (a, b) {
                    // b = b.replace(/<\/?[^>]+(>|$)/g, "");
                    return intVal(a) + intVal(b);
                }, 0 );
                    
                $( api.column( 1 ).footer() ).html('TOTAL');
                $('#order_qty').text(wedTotal);
                $( api.column( 2 ).footer() ).html(wedTotal);
        },
    });
    
    $('.select2').on('change',function(){
        var id=$(this).attr('id');
        if($('#store_id option:selected').val() !='' && $('#shipment_type  option:selected').val() !=''){
            
            $('#export_excel').show();
        }else{
            $('#export_excel').hide();
        }
        $('#'+id+'2').val($('#'+id +' option:selected').val());
        $('#posts').DataTable().ajax.reload().draw();
    })
    
    $('#date_check').click(function(){
        if($('#date_check').is(':checked')){
            $('.id_check').prop('checked',true);
            $('#cancellation_btn').show();
            check_variation_design()
        }else{
            $('.id_check').prop('checked',false);
            $('#variation_list').val('');
            $('#cancellation_btn').hide();
        }
    });
    
    $('#search_change').click(function(){
        $('#posts').DataTable().ajax.reload().draw();
    });
    function check_variation_design(){
        var array=[];
        $('.id_check').filter(':checked').filter(function () {
            array.push($(this).val());
        });
        console.log(array.join(","));
        $('#variation_list').val(array.join(","));
    }
    
    $('#posts').on('click','tbody .id_check',function(){
        check_variation_design();
    })
    
    
    $('#posts').on('click','tbody .assign_qty',function(){
        var id=$(this).attr('data-id');
        $.ajax({
            url:"{{route('shipment.send.process')}}",
            type:"POST",
            data:{
                pr_id:$('#pr_id_'+id).val(),
                store_id:$('#store_id_'+id).val(),
                shipment_type:$('#shipment_type_'+id).val(),
                urgent_status:$('#urgent_status_'+id).val(),
                instock:$('#instock_'+id).val(),
                variation_id:$('#variation_id_'+id).val(),
                variation_design:$('#variation_design_'+id).val(),
                filled_qty:$('#filled_qty_'+id).val(),
                approve_qty:$('#approve_qty_'+id).val(),
                _token: "{{csrf_token()}}"
            },
            success:function(data){
                if(data){
                    $.toast({
                        heading: 'Success',
                        text: 'Assign Quantity Successfully',
                        showHideTransition: 'slide',
                        icon: 'success',
                        position: 'top-center',
                    });
                    $('#posts').DataTable().ajax.reload().draw();
                    $('#date_check').prop('checked',false);
                }else{
                    $.toast({
                        heading: 'Error',
                        text: 'Error in Assign Quantity',
                        showHideTransition: 'slide',
                        icon: 'error',
                        position: 'top-center',
                    });
                }
            }
        })
        
    });
    // $('#assign_qty').click(function(){
    //     var reqSupplier=$('.id_check').filter(':checked').length;
    //     if(reqSupplier ==0){
    //         row = $('#posts_wrapper tbody tr:first-child');
    //         $(row).addClass('table-warning');
    //         $.toast({
    //             heading: 'Error',
    //             text: 'Please Enter the Supply',
    //             showHideTransition: 'slide',
    //             icon: 'error',
    //             position: 'top-center',
    //         });
    //         return; 
    //     }
    //     var obj= {};
    //     var array=[];
    //     var id;
    //     var value = $('.id_check').filter(':checked').filter(function () {
    //         id=$(this).attr('id').split("_")[2];
    //         console.log(id);
    //         obj.pr_id=$('#pr_id_'+id).val();
    //         obj.store_id=$('#store_id_'+id).val();
    //         obj.shipment_type=$('#shipment_type_'+id).val();
    //         obj.urgent_status=$('#urgent_status_'+id).val();
    //         obj.instock=$('#instock_'+id).val();
    //         obj.variation_id=$('#variation_id_'+id).val();
    //         obj.variation_design=$('#variation_design_'+id).val();
    //         obj.filled_qty=$('#filled_qty_'+id).val();
    //         obj.approve_qty=$('#approve_qty_'+id).val();
    //         if($('#checkbox_'+id).is(':checked')==true){
    //             obj.checkbox=$('#checkbox_'+id).val();
    //         }else{
    //             obj.checkbox=0;
    //         }
            
    //         obj.id=id;

    //         array.push(obj);
    //         obj={};
            
            
    //         if($('#options_'+id).val() == ''){
    //             $('#error_'+id).show();
                
    //         }else{
    //             $('#error_'+id).hide();
                
                
    //         }
    //         return $('#options_'+id).val() != '';
    //     });
    //     return;
    //     // console.log(array);return;
    //     if (value.length>=0 && (value.length !== reqSupplier)) {
    //         $.toast({
    //             heading: 'Error',
    //             text: 'Please Enter the Supply',
    //             showHideTransition: 'slide',
    //             icon: 'error',
    //             position: 'top-center',
    //         });
    //     } else {
    //         $.ajax({
    //             url:"{{ route('shipment.send.process') }}",
    //             type:"POST",
    //             data:{
    //                 array:array,
    //                 _token: "{{csrf_token()}}"
    //             },
    //             success:function(data){
    //                 if(data){
    //                     $.toast({
    //                         heading: 'Success',
    //                         text: 'Assign Quantity Successfully',
    //                         showHideTransition: 'slide',
    //                         icon: 'success',
    //                         position: 'top-center',
    //                     });
    //                     $('#posts').DataTable().ajax.reload().draw();
    //                     $('#date_check').prop('checked',false);
    //                 }else{
    //                     $.toast({
    //                         heading: 'Error',
    //                         text: 'Error in Assign Quantity',
    //                         showHideTransition: 'slide',
    //                         icon: 'error',
    //                         position: 'top-center',
    //                     });
    //                 }
    //             }
    //         })
    //     }
        
        
    // });
    
    $('#posts').on('input','tbody .input_filled',function(){
        var id=$(this).attr('data-id');
        var instock=parseInt($('#instock2_'+id).text());
        console.log(instock);
        var rec_qty=parseInt($('#filled_qty_'+id).val().trim());
        if(!/^[0-9]+$/.test(rec_qty)){
            $('#error_'+id).text('Receive Quantity Only Numbers');
            $('#error_'+id).show();
            $.toast({
                heading: 'Error',
                text: 'Receive Quantity Only Numbers',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            $('#id_check_'+id).prop('checked',false);
            $('#assign_qty_'+id).hide();
        }else{
            if(rec_qty<=instock){
                $('#id_check_'+id).prop('checked','checked');
                $('#error_'+id).hide();
                $('#assign_qty_'+id).show();
            }else{
                $('#error_'+id).text('Receive Quantity Exceed from InStock');
                $('#error_'+id).show();
                $('#id_check_'+id).prop('checked',false);
                $('#assign_qty_'+id).hide();
                $.toast({
                    heading: 'Error',
                    text: 'Receive Quantity Exceed from InStock',
                    showHideTransition: 'slide',
                    icon: 'error',
                    position: 'top-right',
                }); 
                return;
            }
        }
    });
    
    
    
    $('#assign_qty2').click(function(){
        $('#assign_qty').click();
    })
    
    $('#export_excel').click(function(){
        $("#excel_format").submit();
    })
    
    $('#download_rts_excel').click(function(){
        var store=$('#store_id option:selected').val();
        var shipment_type=$('#shipment_type option:selected').val();
        var url = '{{ route("excel.shipment.ready.order", [":store_id",":shipment_type"]) }}';
        url = url.replace(':store_id',store);
        url = url.replace(':shipment_type',shipment_type);
        
        window.location.href=url;
    });
    
    $(document).on('change','.id_check',function(){
       var self=$(this);
       var checked=self.filter(":checked").length;
    //   alert(self);
       
       if(checked>0){
           $('#cancellation_btn').show();
       }else{
           $('#cancellation_btn').hide();
       }
    });
    
    $('#cancellation_btn').click(function(){
        var self=$(this);
        if(confirm('Are you sure Want to Cancel ?')){
            $('#item_adjust').trigger("reset");
            $('#adjustModal').modal('show');
        }
    });
    
    $('#item_adjust').on('submit',function(e){
        
        
        e.preventDefault();
        var formdata=$(this).serializeArray();
        
        var obj= {};
        var array=[];
        $('.id_check').filter(':checked').filter(function(){
            var idSelf=$(this);
            
            obj.id=idSelf.data('id');
            obj.store_id=$('#store_id option:selected').val();
            obj.shipment_type=$('#shipment_type  option:selected').val();
            obj.variation_design=idSelf.val();
            obj.given_qty=idSelf.data('given_qty');
            
            array.push(obj);
            obj={};
        });
        formdata.push({ name: "variation_list", value: JSON.stringify(array) });
        
        console.log(formdata);
        
        $.ajax({
            url:"{{route('shipment.cancel.ready_to_shipment')}}",
            data:formdata,
            type:'POST',
            dataType:'JSON',
            success:function(data){
                if(data.code='200'){
                    $.toast({
                        heading: 'Success',
                        text: 'Product Cancelled Successfully',
                        showHideTransition: 'slide',
                        icon: 'success',
                        position: 'top-center',
                    });
                    $('#adjustModal').modal('hide');
                    $('#item_adjust').trigger("reset");
                    $('#cancellation_btn').hide();
                    $('#date_check').prop('checked',false);
                    $('#posts').DataTable().ajax.reload().draw();
                }
            }
        })
    });
    
    $(document).on('change','.new_select',function(){
        var store= $('#store_id option:selected').val();
        var shipment_type=$('#shipment_type option:selected').val();
        
        if(store !='' && shipment_type !=''){
            get_shipment_id();
        }
       
       
    });
    
    
    
    function get_shipment_id(){
        $.ajax({
            url:"{{route('get.shippment.id')}}",
            type: "POST",
            data:{
                _token: "{{csrf_token()}}",
                store: $('#store_id option:selected').val(),
                shipment_type:$('#shipment_type option:selected').val(),
            },
            dataType:'JSON',
            success:function(data){
                $("#shipment_id").html(data.html);
            }
        })
    }

    

    

    
    
</script>

    
@endsection