@extends('layouts.app')
@section('title','Start Scan | Mini Opex')
@section('add_css')

<x-datatable-js type="css"/>
@endsection

@section('content')

<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>AWD Scaning</strong>
                            <a href="javascript:;" id="complete_status" class="ml-5 btn btn-dark btn-sm"><i class="fa fa-check"></i> Complete Status</a>
                            <a href="javascript:;" id="upload Excel" class="float-right btn bg-orange text-dark btn-sm btn-box-completed" style="display: none;"><i class="fas fa-box"></i> Add Box</a>
                            
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            
                            <span class="text-dark float-right">Shipment Name : <strong>{{$shipment_id}}</strong></span>
                            <br>
                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <div class="row" id="ship_scan_form">
                                        <div class="col-md-6 hidden-row">
                                            <input type="hidden" class="input-shipment-id" value="{{$shipment_id}}" name="shipment_id" id="shipment_id" />
                                            <input type="text" placeholder="FNSKU" class="form-control form-control-sm fnsku-scanner" name="fnsku_scanner"/>
                                        </div>
                                    </div>
                                    
                                </div>
                                <div class="col-md-12">
                                    <hr>
                                </div>
                                <div class="col-md-12">
                                    <div class="row">
                                        <div class="col-md-8">
                                            <div class="row">
                                                <div class="col-lg-3 col-md-3 col-sm-6 col-6">
                                                    <div class="form-group ">
                                                        <label for="text-input" class=" form-control-label">Box Weight</label>
                                                        <input type="text" id="box_weight" name="box_weight"  class="form-control form-control-sm" readonly>
                                                    </div>
                                                </div>
                                                <div class="col-lg-3 col-md-3 col-sm-6 col-6">
                                                    <div class="form-group ">
                                                        <label for="text-input" class=" form-control-label">Box Length</label>
                                                        <input type="text" id="box_length" name="box_length"  class="form-control form-control-sm" readonly>
                                                    </div>
                                                </div>
                                                <div class="col-lg-3 col-md-3 col-sm-6 col-6">
                                                    <div class="form-group ">
                                                        <label for="text-input" class=" form-control-label">Box Width</label>
                                                        <input type="text" id="box_width" name="box_width"  class="form-control form-control-sm" readonly>
                                                    </div>
                                                </div>
                                                <div class="col-lg-3 col-md-3 col-sm-6 col-6">
                                                    <div class="form-group ">
                                                        <label for="text-input" class=" form-control-label">Box Height</label>
                                                        <input type="text" id="box_height" name="box_height"  class="form-control form-control-sm" readonly>
                                                    </div>
                                                </div>
                                                
                                            </div>
                                            
                                            
                                            <div id="BoxSummaryContainer">
                                                <table class="table table-bordered table-sm text-sm cart-data-table">
                                                <thead class="thead-dark">
                                                    <tr>
                                                        <th scope="col">S#</th>
                                                        <th scope="col">Product</th>
                                                        <th scope="col">FNSKU</th>
                                                        <th scope="col">Expected Qty</th>
                                                        <th scope="col">Qty</th>
                                                        <th scope="col">Boxes</th>
                                                        <th  scope="col">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="CartTableBody"></tbody>
                                                </table>
                                                
                                                <hr />
                                                <table class="table table-bordered table-sm text-sm cart-data-table">
                                                    <thead class="thead-dark">
                                                        <tr>
                                                            <th scope="col">Box#</th>
                                                            <th scope="col">Weight</th>
                                                            <th scope="col">Length</th>
                                                            <th scope="col">Width</th>
                                                            <th scope="col">height</th>
                                                        </tr>
                                                    </thead>
                                 
                                                    <tbody id="BoxInfoBody">
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="border card-custom" style="display:none;">
                                                <center><img class="rounded img-responsive card-img-top" src="#" width="50" height="50" ></center>
                                                <div class="card-body">
                                                    <p class="card-text product-title-custom text-center"></p>
                                                    <p class="card-text current-scanned-fnsku text-center text-primary"></p>
                                                    <p class="card-text" style="text-align: center;">
                                                        Expected Qty (<span style="font-size:30px;font-weight:bold" id="ExpectedQtyText"></span>) &nbsp;&nbsp;&nbsp;
                                                        Expected Box (<span style="font-size:30px;font-weight:bold" id="ExpectedboxText"></span>)</p>
                                                    <div>
                                                        <input type="number" placeholder="Qty" class="txt-qty form-control" />
                                                        <input type="hidden" class="txt-fnsku" value="" />
                                                        <input type="hidden" class="approve_qty" value="" />
                                                        <input type="hidden" class="txt-shipment-id" value="{{$shipment_id}}" />
                                                 
                                                        <center>
                                                            <a href="javascript:;"  class="btn btn-success btn-sm btn-add-qty-in mt-2"><i class="fas fa-plus"></i> Add</a>
                                                  
                                                        </center>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                </div>
                                
                                
                            </div> 
                            
                            
                          </div>  
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')

<x-datatable-js type="js"/>

<script>

    $('.select-box').change(function(){
        $(".hidden-row").show();
        // $(this).attr("disabled",true);
        $('#BoxIdTxt').val($(this).val());
        $(".fnsku-scanner").focus();
        cartTableLoad();
    });
    
    
    
    
    
    $(document).on('change','.fnsku-scanner',function(){
      $(".card-custom").hide();
      var self=$(this);
      self.prop('disabled',true);
      loader('#ship_scan_form');
      var fnsku = $(this).val();
      var link = "{{route('fnsku.scan.awd')}}";
      
      $.ajax({
          type:'POST',
          url:link,
          data:{
              fnsku:fnsku,
              shipment_id:$(document).find('.input-shipment-id').val(),
              _token:"{{csrf_token()}}",
          },
      }).done(function(resp){
          loader('#ship_scan_form',0);
          self.prop('disabled',false);
            $(".fnsku-scanner").val('');
            $(".fnsku-scanner").focus();
          if(resp.code == 200){
             var d = resp.data;
             console.log(d);
             
             
             
            $(".card-img-top").attr("src",d.image);
            $(".product-title-custom").text(d.product_name);
            $(".txt-fnsku").val(fnsku);
            $(".current-scanned-fnsku").text(fnsku);
            $(".card-custom").show();
            $(".fnsku-scanner").val('');
            $(".fnsku-scanner").focus();
            $("#ExpectedQtyText").text(resp.expected_qty);
            $("#ExpectedboxText").text(resp.boxMake);
            
            $('.approve_qty').val(resp.approve_qty);
            
            
            $("input[name=box_weight]").val(resp.boxD.weight);   
            $("input[name=box_length]").val(resp.boxD.length);
            $("input[name=box_width]").val(resp.boxD.width);
            $("input[name=box_height]").val(resp.boxD.height);
        }else if(resp.msg !='' && resp.code == 400){//added by sufian
            $.toast({
                heading: 'Error',
                text: resp.msg,
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-center',
            }); 
        }else{
           $.toast({
                heading: 'Error',
                text: 'Sorry This Fnsku not exist!',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-center',
            });
        }
          console.log(resp);
      }).fail(function(resp){
          console.log(resp);
      });
   });
   
   $(document).on('click','.btn-add-qty-in',function(){
    var link = $(this).attr("data-link");
    
    var qty = parseInt($(".txt-qty").val());
    var shipment_id = $(".txt-shipment-id").val();
    var fnsku = $(".txt-fnsku").val();
    var expected=parseInt($('#ExpectedQtyText').text());
    var approve_qty=parseInt($('.approve_qty').val());
    
    if(qty%approve_qty !=0){
        $.toast({
                heading: 'Error',
                text: 'Box Can\'t Make' ,
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-center',
            });
        return false;
    }
    
    if(qty >expected){
        $.toast({
                heading: 'Error',
                text: 'QTy greater than Expected QTY',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-center',
            });
        return false;
    }
    
    var BoxMake=(qty >0)? (qty/approve_qty): 0;
        
    if(qty > 0){
        loader('.card-custom');
         $.ajax({
            type:'POST',
            url:"{{route('fnsku.add.scan.awd')}}",
            data:{
                shipment_id:shipment_id,
                BoxMake:BoxMake,
                fnsku:fnsku,
                qty:qty,
                box_weight:$("input[name=box_weight]").val(),  
                box_length:$("input[name=box_length]").val(),
                box_width:$("input[name=box_width]").val(),
                box_height:$("input[name=box_height]").val(),
                approve_qty:approve_qty,
                _token:"{{csrf_token()}}"
            },
         }).done(function(resp){
                console.log(resp);
                $(".txt-fnsku").val('');
                $(".txt-qty").val('');
                loader('.card-custom',0);
                $(".card-custom").hide();
                $(".fnsku-scanner").focus();
                cartTableLoad();
                BoxInfoData();
                
                $("input[name=box_weight]").val('');   
                $("input[name=box_length]").val('');
                $("input[name=box_width]").val('');
                $("input[name=box_height]").val('');
         }).fail(function(resp){
                console.log(resp);
         });
              
        }else{
            $.toast({
                heading: 'Error',
                text: 'Qty Must be Greater than zero!',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-center',
            });
            loader('.card-custom',0);
        }
    
        
    });
    
    function cartTableLoad(){
      $(".old-rows").remove();
      var shipment_id = $(".txt-shipment-id").val();
      
      loader('#ship_scan_form');
      $.ajax({
          type:'post',
          url:"{{route('get.cart.data.awd')}}",
          data:{
              shipment_id:shipment_id,
              _token:"{{csrf_token()}}"
          },
      }).done(function(resp){
          loader('#ship_scan_form',0);
          if(resp.code == 200){
              console.log(resp);
              var html = ``;
              var counter = 1;
              var total = 0;
              var exptected = 0;
              console.log(resp.data);
              $(resp.data).each(function(index,el){
                      
                     
                html+=`<tr class="old-rows">
    
                    <td>${counter}</td>
                    <td>
                        <span class="text-primary">${el.product}</span>
                    </td>
                    <td>${el.fnsku}</td>
                    <td>${el.expected_qnt}</td>
                    <td>${el.qty}</td>
                    <td>${el.boxes}</td>
                    <td>
                        <a data-id="${el.fnsku}" data-shipment_id="${shipment_id}" href="javascript:;" class="btn-remove-button btn-sm btn-danger"><i class="fas fa-trash-alt"></i></a>
                    </td>
                </tr>`;
                  total+= parseInt(el.qty);
                  counter++;
                  exptected+= parseInt(el.expected_qnt);
                  
              });
                  
              html+=`<tr class="old-rows">
                        <th colspan="3" scope="col" style="text-align:right">Total</th>
                        <th>${exptected}</th>
                        <th colspan="2"scope="col">${total}</th>
                    </tr>`;
              
                $("#CartTableBody").append(html);
              }
          
      }).fail(function(resp){
          console.log(resp);
          loader('#ship_scan_form',0);
      });
        
    }
    
    function BoxInfoData(){
        $(".old-rows-two").remove();
        var shipment_id = $(".txt-shipment-id").val();
        loader('#ship_scan_form');
        $.ajax({
            type:'post',
            url:"{{route('box.info')}}",
            data:{
                shipment_id:shipment_id,
                _token:"{{csrf_token()}}"
            },
        }).done(function(resp){
            loader('#ship_scan_form',0);
            var html = ``;
            var length=parseInt($(resp.data).length);
            
            if(length > 0){
                 $(resp.data).each(function(index,el){
                   html+=`<tr class="old-rows-two">
                    <td>Box${el.box_id}</td>
                    <td>${el.box_weight}</td>
                    <td>${el.box_length}</td>
                    <td>${el.box_width}</td>
                    <td>${el.box_height}</td>
                  </tr>`;
                      
                 });
            }else{
                html+=`<tr class="old-rows-two">
                    <td colspan="5" class="text-center text-dark">No Box Created</td>
                  </tr>`;
            }
            
           
            $("#BoxInfoBody").append(html);
          }).fail(function(resp){
            console.log(resp);
          });
    }
    
    BoxInfoData();
    cartTableLoad();
    
    $('#complete_status').click(function(){
        var r = confirm("Are you sure you want to Complete?");
        if(r == true){
            $.ajax({
                type:'POST',
                url:'{{route("shipment.complete.status")}}',
                data:{
                    shipment_id:"{{$shipment_id}}",
                    _token:"{{csrf_token()}}"
                },
                dataType:'json',
                success:function(data){
                    if(data.code==200){
                        $.toast({
                            heading: 'Success',
                            text: 'Shippment Scanning Successfully!',
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-center',
                        });
                        
                        setTimeout(function() { 
                            window.close();
                        }, 1000);
                    }
                }
            })
        }
    })
    
    $(document).on('click','.btn-remove-button',function(){
          var self = $(this);
          var id = $(this).attr("data-id");
          var shipment_id=$(this).attr("data-shipment_id");
          var r = confirm("Are you sure you wanna to delete this item?");
          if(r == true){
              
              $.ajax({
                  type:'post',
                  url:"{{route('delete.cart.item.awd')}}",
                  data:{
                      fnsku:id,
                      shipment_id:shipment_id,
                      _token:"{{csrf_token()}}"
                  },
              }).done(function(resp){
                 
                    console.log(resp);
                    self.parent().parent().hide();
                    BoxInfoData();
                    cartTableLoad();
                    $(".fnsku-scanner").val('');
                    $(".fnsku-scanner").focus();
                  $.toast({
                    heading: 'Success',
                    text: 'Record Deleted Successfully!',
                    showHideTransition: 'slide',
                    icon: 'success',
                    position: 'top-center',
                });
                  
                //   alert("Record Deleted Successfully!");
                  
              }).fail(function(resp){
                  
                  console.log(resp);
                  
              });

          }else
          {

              return false;
          }
        
    });
        

</script>

    
@endsection