@extends('layouts.app')
@section('title','Print label | Mini Opex')
@section('add_css')
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.6.5/css/buttons.dataTables.min.css"/>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<x-datatable-js type="css"/>

{{-- <link rel="stylesheet" href="{{ asset('backend/print.min.css') }}"/> --}}
<style>
.margin{
    margin-left:15%;
}
</style>


    
@endsection

@section('content')
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Print Label</strong>
                            
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" id="posts">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th>Product Img</th>
                                            <th>Product Name</th>
                                            <th>FNSKU</th>
                                            <th>ASIN</th>
                                            <th>Expected Qty#</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            
                            
                            
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>


<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<x-datatable-js type="js"/>

<script>
    
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});
    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "dataSrc": "",
        "ajax":{
                    "url": "{{ route('shippment.print.label',$shipment_id) }}",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){ 
                        d._token= "{{csrf_token()}}";
                        d.box=$('#type option:selected').val();
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [5] },
        ],
        bSort: false,
        "ordering": false,
        "columns":[
            
            { "data": "product_img","name":"product_img" },
            { "data": "product_name","name":"product_name" },
            { "data": "fnsku","name":"shipment_info.fnsku" },
            { "data": "prod_asin","name":"c.prod_asin" },
            { "data": "expected_qnt","name":"shipment_info.expected_qnt" },
            { "data": "action","name":"action" },
        ],
        initComplete: function () {
            $('#posts_filter input').addClass('form-control-sm');
        },
        
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
    });
    
    
    
    function BoxInfoData(){
        $(".old-rows-two").remove();
        var shipment_id = "{{$shipment_id}}";
        loader('#ship_scan_form');
        $.ajax({
            type:'post',
            url:"{{route('box.info')}}",
            data:{
                shipment_id:shipment_id,
                _token:"{{csrf_token()}}"
            },
        }).done(function(resp){
            loader('#ship_scan_form',0);
            var html = ``;
            $(resp.data).each(function(index,el){
               html+=`<tr class="old-rows-two">
                <td>Box${el.box_id}</td>
                <td>${el.box_weight}</td>
                <td>${el.box_length}</td>
                <td>${el.box_width}</td>
                <td>${el.box_height}</td>
              </tr>`;
                  
             });
            $("#BoxInfoBody").append(html);
          }).fail(function(resp){
            console.log(resp);
          });
    }
    
    BoxInfoData();
    
    $('#posts').on('click','tbody .print_label',function(){
       var id=$(this).attr('data-id');
       $.ajax({
           url:"{{route('shippment.view.label')}}",
           type:'POST',
           data:{
               _token:"{{csrf_token()}}",
               id:id,
           },
           success:function(data){
               if(data.success==true){
                    var w = window.open('about:blank','pos_popup', 'width=900,height=600,menubar=yes,scrollbars=yes,status=no,resizable=yes,screenx=0,screeny=0');
                    w.document.open();
                    w.document.write(data.html);
                    w.document.close();
                    setTimeout(function(){ w.print(); }, 1000);
                    
                }
           }
       })
    });

    
        

</script>

    
@endsection