@extends('layouts.app')
@section('title',($sale_string=='approve')?'Approve Sale Order | Mini Opex':'Pending Sale Order | Mini Opex')
@section('add_css')
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

@endsection

@section('content')
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <h3 class="title-5 m-b-35"><strong>{{ $sale_string=='approve'? 'Approve Sale Orders':'Pending Sale Orders' }}</strong></h3>
            @if (session('has_error'))
                <div class="alert alert-danger" role="alert">
                    {{ session('has_error') }}
                </div>
            @endif
            @if (session('has_success'))
                <div class="alert alert-success" role="alert">
                    {{ session('has_success') }}
                </div>
            @endif
            <div class="row">
                <div class="col-lg-6 col-sm-6 col-md-6 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>{{ Str::ucfirst($sale_string) }} Sale  </strong>Orders
                            @if($sale_string=='pending')
                            <a href="javascript:;" class="btn btn-success btn-sm float-right show-btn" id="pending" data-id=""><i class="fas fa-check"></i> Approve</a>
                            @endif
                        </div>
                        <div class="card-body card-block">
                            <div class="table-responsive-sm">
                                <table class="table table-bordered table-striped table-responsive table-sm" id="posts" data-id="" >
                                    <thead class="table-dark" style="color: white">
                                        <tr>
                                            @if($sale_string=='pending')
                                                <th><input type="checkbox" name="allcheck" id="allcheck"></th>
                                            @endif
                                            <th>File Name</th>
                                            <th>Store Name</th>
                                            <th>Cargo Select</th>
                                            <th>Total Item</th>
                                            <th>Total Sale QTY</th>
                                            <th>Created Date</th>
                                            <th>Created BY</th>
                                            <th>Action</th>

                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            
                        </div>
                            
                            {{-- <a href="{{ route('create')}}" class="btn btn-info float-left mb-2">Add New Sku</a> --}}
                            
                    </div>
                </div>
                <div class="col-lg-6 col-sm-6 col-md-6 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Sale Orders </strong> Preview
                        </div>
                        <div class="card-body card-block">
                            <div class="table-responsive-sm">
                                <table class="table table-bordered table-striped table-responsive table-sm" id="posts2" data-id="" data-status="">
                                    <thead class="table-dark" style="color: white">
                                        <tr>
                                            <th>Product Image</th>
                                            <th>Product Name</th>
                                            <th>SKU</th>
                                            <th>Sale Order QTY</th>
                                            <th>In Stock</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>

<script>
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});
    var sale_type="{{ $sale_string }}";
    var data_col;
    var target;
    var type;

    if(sale_type =='approve'){
        data_col=[
            { "data": "orignal_name","name":"sale_orders.orignal_name" },
            { "data": "strong_name","name":"store.strong_name" },
            { "data": "cargo_selection","name":"cargo_selection" },
            { "data": "total_items","name":"sale_orders.total_items" },
            { "data": "sale_order_qty","name":"sale_orders.sale_order_qty" },
            { "data": "created_at","name":"created_at" },
            { "data": "name","name":"users.name" },
            { "data": "action","name":"action" },
        ]
        type='1';
        target=[7];
    }else if(sale_type =='pending'){
        data_col=[
            {"data":"checkbox_data","name":"checkbox_data"},
            { "data": "orignal_name","name":"sale_orders.orignal_name" },
            { "data": "strong_name","name":"store.strong_name" },
            { "data": "cargo_selection","name":"cargo_selection" },
            { "data": "total_items","name":"sale_orders.total_items" },
            { "data": "sale_order_qty","name":"sale_orders.sale_order_qty" },
            { "data": "created_at","name":"created_at" },
            { "data": "name","name":"users.name" },
            { "data": "action","name":"action" },
        ]
        type='2';
        target=[0,8];
    }

    var table=$('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        responsive: true,
        
        "dataSrc": "",
        "ajax":{
                    "url": "{{ route('approve.sale.orders',$sale_string) }}",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){
                        d._token="{{csrf_token()}}";
                        d.id=$('#posts').attr('data-id');
                        d.type=type;
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": target },
        ],
        
        bSort: false,
        "ordering": true,
        "columns":data_col,
        "drawCallback": function( settings ) {
            loader('#posts',0);
            var info = $('#posts').DataTable().page.info();
            tot = info.recordsTotal;
            
            if (tot > 0) {
                $('#pending').show();
            } else {
                $('#pending').hide();
            }
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
    });

    var table2=$('#posts2').DataTable({
        "processing": true,
        "serverSide": true,
        responsive: true,
        "dataSrc": "",
        "ajax":{
                    "url": "{{ route('sale.orders.id') }}",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){
                        d._token="{{csrf_token()}}";
                        d.id=$('#posts2').attr('data-id');
                        d.status=$('#posts2').attr('data-status');
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [0,3] },
        ],
        bSort: false,
        "ordering": true,
        "columns":[
            { "data": "product_img","name":"product_img" },
            { "data": "product_name","name":"product_info.product_name" },
            { "data": "variation_id","name":"sale_order_list.variation_id" },
            { "data": "sale_order_id","name":"sale_order_id" },
            { "data": "Quantity","name":"product_info.Quantity" },
        ],
        "drawCallback": function( settings ) {
            loader('#posts2',0);
            
            
            
        },
        'preDrawCallback': function(settings) {
            loader('#posts2');
            
            
        },
    });
    
    var count=$('#posts').DataTable().rows().count();
    

    table.on('click', 'tbody tr', function () {
        var data_row=table.row($(this).closest('tr')).data();
        $('#posts2').attr('data-id',data_row.id);
        $('#posts2').attr('data-status',data_row.status);
        $('#posts2').DataTable().ajax.reload().draw();
    });

    

    $('#allcheck').click(function(){
        if($('#allcheck').is(':checked')){
            $('.allChecked').prop('checked',true);
        }else{
            $('.allChecked').prop('checked',false);
        }
    })

    $('#pending').click(function(){
        var ids = [];
        $(".allChecked:checked").each(function(index,e){
            ids[index] = $(this).val();
        });
        if(ids.length >0){
            $.ajax({
                url:"{{ route('sale.update') }}",
                type:"POST",
                data:{
                    ids:ids,
                    _token:"{{csrf_token()}}",
                    type:'4'
                },
                success:function(data){
                    $.toast({
                        heading: 'Success',
                        text: "Order Approve Successfully",
                        showHideTransition: 'slide',
                        icon: 'success',
                        position: 'top-right',
                    });
                    $('#posts2').attr('data-id','');
                    $('#posts').DataTable().ajax.reload().draw();
                    $('#posts2').DataTable().ajax.reload().draw();

                }
            })
        }else{
            row = $('#posts_wrapper tbody tr:first-child');
            $(row).addClass('table-warning');
            $.toast({
                heading: 'Error',
                text: "Please Select The List",
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
        }
        
    }) 


</script>

    
@endsection