@extends('layouts.app')
@section('title','Create Role | Mini Opex')
@section('add_css')
<style>
input[type="checkbox"][readonly] {
    pointer-events: none;
}
</style>
    
@endsection

@section('content')

<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Roles Registion</strong> form
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <form action="{{ route('roles.store') }}" method="post" enctype="multipart/form-data" class="form-horizontal" id="form_id">
                                @csrf
                                <div class="row form-group ">
                                    <div class="col col-md-3">
                                        <label for="text-input" class=" form-control-label">Role Name </label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <input type="text" id="name" name="name" placeholder="add new role" class="form-control" maxlength="25">
                                    </div>
                                </div>
                                <div class="row form-group">
                                    <div class="col col-md-12">
                                        <label class=" form-control-label">Permission List</label>
                                    </div><br>
                                    @foreach($permission as $value)
                                        @if(!in_array($value->name,['sale-orders','approve-sale-orders','pending-sale-orders']))
                                        <div class="col col-md-3">
                                            <div class="form-check">
                                                
                                                <label for="{{ $value->name  }}" class="form-check-label text-primary">
                                                    @php
                                                        if($value->name =='dashboard' ){
                                                            $checked='checked';
                                                            $readonly='readonly';
                                                        }else{
                                                            $checked='';
                                                            $readonly='';
                                                        }
                                                    @endphp
                                                    
                                                    <input 
                                                        type="checkbox" 
                                                        id="{{ $value->name  }}" 
                                                        name="permission[]" 
                                                        value="{{ $value->id }}" {{ $checked }} 
                                                        {{ $readonly }}
                                                        @if($value->name =='dashboard' ) onclick="return false" @endif 
                                                        class="form-check-input "> 
                                                    {{ str_replace('-',' ',$value->name) }}
                                                </label> &nbsp; 
                                            </div>
                                            
                                        </div>
                                        @endif
                                    @endforeach
                                </div>

                                
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary btn-sm" id="submitbtn">
                                    <i class="fa fa-dot-circle-o"></i> Submit
                                </button>
                                <button type="reset" class="btn btn-danger btn-sm">
                                     <i class="fa fa-ban"></i> Reset
                                </button>
                            </form>
                            </div>
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>


<script>
    $(document).ready(function() {
        

        $('#form_id').validate({
            errorClass:'text-danger',
            success:'text-success',
            rules:{
                supplier_name: {
                    required: true
                },
                username:{
                    required:true,
                },
                supplier_address:{
                    required:true
                },
                password:{
                    required:true,
                    minlength:6
                },
                
                
            },
            messages:{
                supplier_name:{
                    required:"Supplier Name is required"
                },
                username:{
                    required:"Username is required",
                },
                supplier_address:{
                    required:"Supplier address is required"
                },
                password:{
                    required:"password is required",
                    minlength:"Password length must be 6 to 8"
                },
                
            },
            highlight: function(element, errorClass, validClass) {
                $(element).closest('.form-control').addClass('has-warning');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).closest('.form-group').removeClass('has-error');
            },
            errorPlacement: function (error, element) {
                
                if(element.hasClass('select2') && element.next('.select2-container').length) {
                    error.insertAfter(element.next('.select2-container'));
                }else if(element.hasClass('radio') && element.next('label .form-check-label').length) {
                    error.insertAfter(element.next('label .form-check-label'));
                }else{
                    error.insertAfter(element);
                }
            },
            submitHandler: function (form) {
                console.log("Submitted!");
                form.submit();
            }

        });
    });
</script>

    
@endsection