@extends('layouts.app')
@section('title','Raw SKU List | Mini Opex')
@section('add_css')
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
<x-datatable-js type="css"/>
<style>
select {
    font-family: 'FontAwesome', 'Poppins';
    font-weight: normal;
    font-style : normal;
}
</style>

    
@endsection

@section('content')
<
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
                <div class="col-lg-12 col-sm-12 col-md-12 text-sm">
                    
                    <div class="card">
                        
                        <div class="card-header">
                            <strong>Raw-SKU </strong> List
                            @can('add-raw-sku')
                            <a href="{{ route('add_sku')}}" class="btn btn-info btn-sm float-right"><i class="fas fa-barcode"></i> Add New Raw-SKU</a>
                            <a href="javascript:;" class="btn btn-primary btn-sm float-right text-white mr-1" id="custom_filter"><i class="fas fa-filter"></i> Custom Filters</a>
                            @endcan
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <div class="container custom_filter pt-3 pb-3 border  rounded" style="display: none" id="custom_div">
                                <div class="row">
                                    <div class="col-12 col-md-3">
                                        <select name="category" id="category" class="form-control select2 category">
                                            <option value="">Select Category</option>
                                            @forelse ($categories as $category)
                                                <option value="{{ $category->id }}">{{$category->raw_category}}</option>
                                            @empty
                                                
                                            @endforelse
                                        </select>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <select name="unit" id="unit" class="form-control select2 unit">
                                            <option value="">Select Unit</option>
                                            @forelse ($units as $unit)
                                                <option value="{{ $unit->id }}">{{$unit->raw_unit}}</option>
                                            @empty
                                                
                                            @endforelse
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="table-responsive mt-2 table-responsive-data2">
                                <table class="table  table-bordered  table-striped" id="posts" cellspacing="0" width="100%">
                                    <thead class="table-dark" style="color: white">
                                        <tr>
                                            <th>Raw Image</th>
                                            <th>Raw SKU</th>
                                            <th>Raw Name</th>
                                            <th>Stock</th>
                                            <th>Unit Type</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>


<!-- modal color -->
<div class="modal fade" id="editrawskuModal" tabindex="-1" role="dialog" aria-labelledby="editrawskuModal" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editrawskuModal">Edit Raw SKU</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" id="closebtn">
                    <span aria-hidden="true" >&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group ">
                    <form  id="editRawSku">
                        @csrf
                        <input type="hidden" id="raw_sku_id" name="raw_sku_id" >
                    <div class="row form-group ">
                                    <div class="col col-md-3">
                                        <label for="text-input" class=" form-control-label mt-1">Title </label>
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <input type="text" id="product_name" name="product_name" placeholder="product name" class="form-control form-control-sm">
                                    </div>
                                </div>
                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="select" class=" form-control-label mt-1">Category</label>
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <select name="category" id="category_edit" class="form-control tac">
                                            <option value="">Please select</option>
                                            @forelse ($categories as $category)
                                                <option value="{{ $category->id }}-{{$category->raw_category}}">{{$category->raw_category}}</option>
                                            @empty
                                                
                                            @endforelse
                                            
                                        </select>
                                    </div>
                                </div>
                                
                                
                                
                                <div class="row form-group">
                                    <div class="col col-md-3">
                                        <label for="select" class=" form-control-label mt-1">Unit</label>
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <select name="unit" id="unit_edit" class="form-control tac">
                                            <option value="">Please select</option>
                                            @forelse ($units as $unit)
                                                <option value="{{ $unit->id }}-{{$unit->raw_unit}}">{{$unit->raw_unit}}</option>
                                            @empty
                                                
                                            @endforelse
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="row form-group" id="image_upload">
                                    <div class="col col-md-3">
                                        <label for="file-input" class=" form-control-label mt-1">Image Upload</label>
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <input type="file" id="file-input" name="file_img" class="form-control-file">
                                    </div>
                                    <div class="col-12 col-md-6 imgdiv">
                                        
                                    </div>
                                </div>
                                @can('edit-row-quantity')
                                <div class="row form-group ">
                                    <div class="col col-md-3">
                                        <label for="text-input" class=" form-control-label mt-1">Quantity </label>
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <input type="number" id="quantity" min="0" name="quantity" placeholder="0" class="form-control form-control-sm">
                                    </div>
                                </div>
                                @endcan 


                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary" id="adjustBtn">Update</button>
            </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
<x-datatable-js type="js"/>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>


<script>
    var today = new Date().toLocaleDateString();
    $('#select2').select2();
    $('.tac').select2();
    
    function get_options(id) {
        var selectedValue = $('#options_' + id).val();
        console.log('option check')
        $('.imgdiv').empty()
        if (selectedValue === 'edit') {
            console.log('edit check')
            
            let url = "{{ route('editRawSku', ':id') }}";
            url = url.replace(':id', id); 
            $.ajax({
                url:url,
                type:'GET',
                success:function(res){
                    if(res.status == true){
                        $('#raw_sku_id').val(res.data.id)
                        $('#product_name').val(res.data.raw_name)
                        $('#quantity').val(res.data.quantity)
                        
                        var categoryoption = res.data.raw_category_id+'-'+res.data.raw_category_name;
                        $('#category_edit').val(categoryoption).trigger('change');
                        
                        var unitoption = res.data.raw_unit_id+'-'+res.data.raw_unit_name;
                        $('#unit_edit').val(unitoption).trigger('change');
                        
                        var imageurl = '{{asset("/")}}'+res.data.raw_image;
                        
                        $('.imgdiv').append('<img src="'+imageurl+'" style="height:100px">')
                        
                        $('#editrawskuModal').modal('show');
                    }
                }
            })
        }
        else if(selectedValue === 'delete'){
            let url = "{{ route('deleteRawSku', ':id') }}";
            url = url.replace(':id', id); 
            
            console.log('delete check')
            
            if(confirm('Are you sure want to delete ?')){
                $.ajax({
                    url:url,
                    type:'GET',
                    success:function(res){
                        if(res.status == true){
                            $.toast({
                                        heading: 'Success',
                                        text: 'Raw SKU deleted Successfully',
                                        showHideTransition: 'slide',
                                        icon: 'success',
                                        position: 'top-right',
                            }); 
                           $('#posts').DataTable().ajax.reload().draw();
                        }
                    }
                })
            }
            
            
        }
    }

    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});
        // $("a .single_image").fancybox();
        $('#posts').DataTable({
            "processing": true,
            "pageLength": 100,
            "serverSide": true,
            "dataSrc": "",
            "language": {
                "search": "Search Products",
                "lengthMenu":"Show _MENU_ Entries" 
            },
            "ajax":{
                     "url": "{{ route('raw_list') }}",
                    //  "dataType": "json",
                     "type": "POST",
                     "data":function(d){
                        d._token= "{{csrf_token()}}";
                        d.unit=$('#unit').val();
                        d.category=$('#category').val();
                     }
                   },
            "columnDefs": [
                { "orderable": false, "targets": [0,5] },
                { "searchable": false, "targets": [0,5] },
                
            ],
            "order": [[ 1, "ASC" ]],
            bSort: false,
            "ordering": false,
            "columns": [
                { "data": "ProductImg", "name":"ProductImg" },
                { "data": "raw_sku","name":'raw_sku' },
                { "data": "raw_name" ,"name":'raw_name'},
                { "data": "quantity","name":"quantity" },
                { "data": "raw_unit_name","name":"raw_unit_name" },
                { "data": "action","name":"action" },

            ],
            initComplete: function () {
                $('.buttons-excel').html('<i class="fas fa-file-excel"></i> Excel').removeClass('dt-button');
                $('.buttons-pdf').html('<i class="fas fa-file-pdf"></i> Pdf').removeClass('dt-button');
                $('.buttons-print').html('<i class="fas fa-print"></i> Print').removeClass('dt-button');
                $('.buttons-page-length').html('<i class="far fa-file"></i> Page Length').removeClass('dt-button').css('color','white');
                $('.button-page-length').removeClass('dt-button').addClass('btn btn-primary');
                this.api().columns().every(function () {
                    var column = this;
                    var input = document.createElement("input");
                    $(input).appendTo($(column.footer()).empty())
                    .on('change', function () {
                        column.search($(this).val()).draw();
                    });
                });
            },
            // dom: 'Bfrtip',
            // buttons: [
                // {   extend: 'excelHtml5', 
                //     className: 'btn btn-danger',
                //     exportOptions: {
                //         columns: [1,2,3]
                //     },
                    // customize: function ( xlsx ) {
                    //     var sheet = xlsx.xl.worksheets['sheet1.xml'];
                    //     //Bold Header Row
                    //     $('row[r=4] c', sheet).attr( 's', '2' );
                    //     //Make You Input Cells Bold Too
                    //     $('c[r=A2]', sheet).attr( 's', '2' );
                    //     $('c[r=F2]', sheet).attr( 's', '2' );

                    // },
                    // customizeData: function(data){
                    //     var desc = [
                    //         ['',''],
                    //         ['Report Date',today],
                    //     ];
                    //     data.body.unshift(data.header)
                    //     for (var i = 0; i < desc.length; i++) {
                    //         data.body.unshift(desc[i]);
                    //     };
                    // }
                // },
            //     {   extend: 'pdfHtml5', 
            //         footer: false,
            //         className: 'btn btn-success',
            //         exportOptions: {
            //             columns: [1,2,3]
            //         },
            //         // messageTop: function(){
            //         //     return 'Report Date : '+ today ;
            //         // },
                    
                    
            //      },
            //     {   extend: 'print', 
            //         className: 'btn btn-info',
            //         footer: false,
            //         exportOptions: {
            //             columns: [1,2,3]
            //         },
            //         // messageTop: function(){
            //         //     return 'Report Date : '+ today ;
            //         // },
            //     },
            //     { extend: 'pageLength', className: 'btn btn-primary'}
            // ],
            'preDrawCallback': function(settings) {
                loader('#posts');
            },
            "drawCallback": function( settings ) {
                $('.loader').select2();
                loader('#posts',0);
            }	
            	 

        });

        
    $(document).on('submit','#editRawSku',function(e){
        e.preventDefault()
        var formData = new FormData(this)
        $.ajax({
                url:'{{route("updateRawSku")}}',
                type:'POST',
                data:formData,
                processData:false,
                contentType:false,
                cache:false,
                success:function(res){
                    if(res.status == true){
                        $.toast({
                                    heading: 'Success',
                                    text: 'Raw SKU Updated Successfully',
                                    showHideTransition: 'slide',
                                    icon: 'success',
                                    position: 'top-right',
                        }); 
                       $('#editrawskuModal').modal('hide');
                       $('#posts').DataTable().ajax.reload().draw(); 
                    }
                }
            })
    })

    

    $('#custom_filter').click(function(){
        $('#custom_div').toggle();
    });
    
    $('.select2').on('change',function(){
        $('#posts').DataTable().ajax.reload().draw();
    })

    

</script>

    
@endsection